/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.faultSurface.FaultSection;

public class ConnectivityCluster
implements Comparable<ConnectivityCluster> {
    private int numSections;
    private int numRuptures;
    private HashSet<Integer> sectIDs;
    private HashSet<Integer> parentSectIDs;
    public static final Comparator<ConnectivityCluster> sectCountComparator = new Comparator<ConnectivityCluster>(){

        @Override
        public int compare(ConnectivityCluster o1, ConnectivityCluster o2) {
            int cmp = Integer.compare(o1.numSections, o2.numSections);
            if (cmp == 0) {
                cmp = Integer.compare(o1.numRuptures, o2.numRuptures);
            }
            return cmp;
        }
    };
    public static final Comparator<ConnectivityCluster> rupCountComparator = new Comparator<ConnectivityCluster>(){

        @Override
        public int compare(ConnectivityCluster o1, ConnectivityCluster o2) {
            int cmp = Integer.compare(o1.numRuptures, o2.numRuptures);
            if (cmp == 0) {
                cmp = Integer.compare(o1.numSections, o2.numSections);
            }
            return cmp;
        }
    };

    public ConnectivityCluster(int numSections, int numRuptures, HashSet<Integer> sectIDs, HashSet<Integer> parentSectIDs) {
        this.numSections = numSections;
        this.numRuptures = numRuptures;
        this.sectIDs = sectIDs;
        this.parentSectIDs = parentSectIDs;
    }

    private ConnectivityCluster() {
        this.sectIDs = new HashSet();
        this.parentSectIDs = new HashSet();
    }

    public int getNumSections() {
        return this.numSections;
    }

    public int getNumRuptures() {
        return this.numRuptures;
    }

    public boolean containsSect(FaultSection sect) {
        return this.containsSect(sect.getSectionId());
    }

    public boolean containsSect(int sectID) {
        return this.sectIDs.contains(sectID);
    }

    public Set<Integer> getSectIDs() {
        return Collections.unmodifiableSet(this.sectIDs);
    }

    public Set<Integer> getParentSectIDs() {
        return Collections.unmodifiableSet(this.parentSectIDs);
    }

    public static List<ConnectivityCluster> build(FaultSystemRupSet rupSet) {
        return ConnectivityCluster.doBuild(rupSet, null);
    }

    public static List<ConnectivityCluster> buildNonzeroRateClusters(FaultSystemSolution sol) {
        HashSet<Integer> exclusionIndexes = new HashSet<Integer>();
        double[] rates = sol.getRateForAllRups();
        for (int r = 0; r < rates.length; ++r) {
            if (rates[r] != 0.0) continue;
            exclusionIndexes.add(r);
        }
        return ConnectivityCluster.doBuild(sol.getRupSet(), exclusionIndexes);
    }

    public static List<ConnectivityCluster> build(FaultSystemRupSet rupSet, RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel) {
        HashSet<Integer> exclusionIndexes = null;
        if (rupExclusionModel != null) {
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            exclusionIndexes = new HashSet<Integer>();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                if (rupExclusionModel == null || rupExclusionModel.isRupAllowed(cRups.get(r), false)) continue;
                exclusionIndexes.add(r);
            }
        }
        return ConnectivityCluster.doBuild(rupSet, exclusionIndexes);
    }

    private static List<ConnectivityCluster> doBuild(FaultSystemRupSet rupSet, HashSet<Integer> exclusionIndexes) {
        ArrayList<ConnectivityCluster> clusters = new ArrayList<ConnectivityCluster>();
        boolean[] sectsAssigned = new boolean[rupSet.getNumSections()];
        boolean[][] sectCorups = new boolean[rupSet.getNumSections()][rupSet.getNumSections()];
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            if (exclusionIndexes != null && exclusionIndexes.contains(r)) continue;
            List<Integer> sects = rupSet.getSectionsIndicesForRup(r);
            for (int i = 0; i < sects.size(); ++i) {
                int s1 = sects.get(i);
                for (int j = i; j < sects.size(); ++j) {
                    int s2 = sects.get(j);
                    sectCorups[s1][s2] = true;
                    sectCorups[s2][s1] = true;
                }
            }
        }
        for (int s = 0; s < sectCorups.length; ++s) {
            if (sectsAssigned[s]) continue;
            ConnectivityCluster.processClusterRecursive(rupSet, s, clusters.size(), clusters, sectsAssigned, sectCorups);
        }
        int c = clusters.size();
        while (--c >= 0) {
            ConnectivityCluster cluster = (ConnectivityCluster)clusters.get(c);
            BitSet rups = new BitSet(rupSet.getNumRuptures());
            for (int sectID : cluster.sectIDs) {
                FaultSection sect = rupSet.getFaultSectionData(sectID);
                int parentID = sect.getParentSectionId();
                if (parentID >= 0) {
                    cluster.parentSectIDs.add(parentID);
                }
                for (int r : rupSet.getRupturesForSection(sectID)) {
                    if (exclusionIndexes != null && exclusionIndexes.contains(r)) continue;
                    rups.set(r);
                }
            }
            cluster.numRuptures = rups.cardinality();
            if (cluster.numRuptures != 0) continue;
            clusters.remove(c);
        }
        return clusters;
    }

    private static void processClusterRecursive(FaultSystemRupSet rupSet, int sect, int clusterIndex, List<ConnectivityCluster> clusters, boolean[] sectsAssigned, boolean[][] sectCorups) {
        if (sectsAssigned[sect]) {
            return;
        }
        if (clusters.size() == clusterIndex) {
            clusters.add(new ConnectivityCluster());
        }
        ConnectivityCluster curCluster = clusters.get(clusterIndex);
        ++curCluster.numSections;
        curCluster.sectIDs.add(sect);
        sectsAssigned[sect] = true;
        for (int sect2 = 0; sect2 < sectCorups.length; ++sect2) {
            if (!sectCorups[sect][sect2]) continue;
            ConnectivityCluster.processClusterRecursive(rupSet, sect2, clusterIndex, clusters, sectsAssigned, sectCorups);
        }
    }

    @Override
    public int compareTo(ConnectivityCluster o) {
        return sectCountComparator.compare(this, o);
    }

    public String toString() {
        return "ConnectivityCluster[" + this.numSections + " sects (" + this.parentSectIDs.size() + " parents), " + this.numRuptures + " rups]";
    }
}

