/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GeographicMapMaker;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

public class RupSetMapMaker
extends GeographicMapMaker {
    public RupSetMapMaker(FaultSystemRupSet rupSet, Region region) {
        this(rupSet.getFaultSectionDataList(), region);
    }

    public RupSetMapMaker(List<? extends FaultSection> sects, Region region) {
        super(region);
        this.setFaultSections(sects);
    }

    public static void main(String[] args) throws IOException {
        List<GeoJSONFaultSection> sects = GeoJSONFaultReader.readFaultSections(new File("/tmp/GEOLOGIC_sub_sects.geojson"));
        RupSetMapMaker mapMaker = new RupSetMapMaker(sects, RupSetMapMaker.buildBufferedRegion(sects));
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-1.0, 1.0);
        double[] scalars = new double[sects.size()];
        for (int s = 0; s < scalars.length; ++s) {
            scalars[s] = Math.random() < 0.3 ? Double.NaN : 2.0 * Math.random() - 1.0;
        }
        mapMaker.setReverseSort(true);
        mapMaker.plotSectScalars(scalars, cpt, "Label");
        mapMaker.plot(new File("/tmp"), "nan_test", " ");
    }
}

