/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class RuptureConnectionSearch
implements SubModule<FaultSystemRupSet> {
    private FaultSystemRupSet rupSet;
    private SectionDistanceAzimuthCalculator distCalc;
    public static final double MAX_POSSIBLE_JUMP_DEFAULT = 100.0;
    private double maxJumpDist;
    public static final boolean CUMULATIVE_JUMPS_DEFAULT = false;
    private boolean cumulativeJumps;
    private static final Comparator<FaultSection> sectIDcomp = new Comparator<FaultSection>(){

        @Override
        public int compare(FaultSection o1, FaultSection o2) {
            return Integer.compare(o1.getSectionId(), o2.getSectionId());
        }
    };
    private static final DecimalFormat distDF = new DecimalFormat("0.0");

    public RuptureConnectionSearch(FaultSystemRupSet rupSet, SectionDistanceAzimuthCalculator distCalc) {
        this(rupSet, distCalc, 100.0, false);
    }

    public RuptureConnectionSearch(FaultSystemRupSet rupSet, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, boolean cumulativeJumps) {
        this.rupSet = rupSet;
        this.distCalc = distCalc;
        this.maxJumpDist = maxJumpDist;
        this.cumulativeJumps = cumulativeJumps;
    }

    public SectionDistanceAzimuthCalculator getDistAzCalc() {
        return this.distCalc;
    }

    public List<FaultSubsectionCluster> calcClusters(List<? extends FaultSection> sects, boolean debug) {
        ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>();
        HashMap<Integer, ArrayList<FaultSection>> parentsMap = new HashMap<Integer, ArrayList<FaultSection>>();
        for (FaultSection faultSection : sects) {
            Integer parentID = faultSection.getParentSectionId();
            ArrayList<FaultSection> parentSects = (ArrayList<FaultSection>)parentsMap.get(parentID);
            if (parentSects == null) {
                parentSects = new ArrayList<FaultSection>();
                parentsMap.put(parentID, parentSects);
            }
            parentSects.add(faultSection);
        }
        for (List list : parentsMap.values()) {
            Collections.sort(list, sectIDcomp);
            ArrayList<FaultSection> curSects = new ArrayList<FaultSection>();
            int prevID = -2;
            for (int s = 0; s < list.size(); ++s) {
                FaultSection sect = (FaultSection)list.get(s);
                int id = sect.getSectionId();
                if (!curSects.isEmpty() && id != prevID + 1) {
                    clusters.add(new FaultSubsectionCluster(curSects));
                    curSects = new ArrayList();
                }
                curSects.add(sect);
                prevID = id;
            }
            clusters.add(new FaultSubsectionCluster(curSects));
        }
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(sects, clusters, this.distCalc, this.maxJumpDist);
        return connStrat.getClusters();
    }

    private void pathSearch(ClusterPath basePath, PathResult result, boolean debug) {
        Preconditions.checkState((!basePath.isComplete() ? 1 : 0) != 0);
        FaultSubsectionCluster from = basePath.path[basePath.path.length - 1];
        for (FaultSubsectionCluster to : from.getDistSortedConnectedClusters()) {
            if (!basePath.availableClusters.contains(to)) {
                if (!debug) continue;
                System.out.println("\t\t\t\tCan't try because not available: [" + to.parentSectionName + "; " + to.parentSectionID + "]");
                continue;
            }
            ClusterPath path = basePath.take(to);
            if (debug) {
                System.out.println("\t\t\t" + String.valueOf(path));
            }
            if (path.isComplete()) {
                result.addPath(path, debug);
                continue;
            }
            if (result.shortestPaths != null && path.compareTo(result.shortestPaths[0]) > 0) {
                if (!debug) continue;
                System.out.println("\t\t\t\tStopping this search as we're worse than the shortest");
                continue;
            }
            this.pathSearch(path, result, debug);
        }
    }

    public List<Jump> calcRuptureJumps(int rupIndex) {
        return this.calcRuptureJumps(rupIndex, false);
    }

    public List<Jump> calcRuptureJumps(int rupIndex, boolean debug) {
        List<FaultSection> sects = this.rupSet.getFaultSectionDataForRupture(rupIndex);
        if (debug) {
            System.out.println("Building clusters for " + rupIndex);
        }
        List<FaultSubsectionCluster> clusters = this.calcClusters(sects, debug);
        return this.calcRuptureJumps(clusters, debug);
    }

    private static IDPairing jumpPair(Jump jump) {
        int id2;
        int id1 = jump.fromSection.getSectionId();
        if (id1 < (id2 = jump.toSection.getSectionId())) {
            return new IDPairing(id1, id2);
        }
        return new IDPairing(id2, id1);
    }

    public List<Jump> calcRuptureJumps(List<FaultSubsectionCluster> rupClusters, boolean debug) {
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        if (debug) {
            System.out.println("Searching for connections...");
        }
        int numCompletePaths = 0;
        HashSet<IDPairing> uniques = new HashSet<IDPairing>();
        for (int i = 0; i < rupClusters.size(); ++i) {
            FaultSubsectionCluster from = rupClusters.get(i);
            HashSet<FaultSubsectionCluster> availableClusters = new HashSet<FaultSubsectionCluster>(rupClusters);
            availableClusters.remove(from);
            if (debug) {
                System.out.println("\tFrom cluster 0, " + from.parentSectionName);
                System.out.println("\t\tAvailable direct jumps:");
                for (FaultSubsectionCluster to : from.getDistSortedConnectedClusters()) {
                    double minDist = Double.POSITIVE_INFINITY;
                    for (Jump jump : from.getConnectionsTo(to)) {
                        minDist = Math.min(minDist, jump.distance);
                    }
                    System.out.println("\t\t\t[" + to.parentSectionID + "; " + to.parentSectionName + "] R=" + distDF.format(minDist));
                }
            }
            for (int j = i + 1; j < rupClusters.size(); ++j) {
                FaultSubsectionCluster target = rupClusters.get(j);
                ClusterPath basePath = new ClusterPath(from, target, availableClusters);
                if (debug) {
                    System.out.println("\t\tSearching to cluster " + j + ", " + target.parentSectionName);
                }
                PathResult result = new PathResult();
                this.pathSearch(basePath, result, debug);
                ClusterPath[] shortestPaths = result.shortestPaths;
                if (shortestPaths != null) {
                    for (ClusterPath shortest : shortestPaths) {
                        Jump jump = shortest.jumps[0];
                        IDPairing pair = RuptureConnectionSearch.jumpPair(jump);
                        if (!uniques.contains(pair)) {
                            if (jump.fromSection.getSectionId() < jump.toSection.getSectionId()) {
                                jumps.add(jump);
                            } else {
                                jumps.add(jump.reverse());
                            }
                            uniques.add(pair);
                        }
                        if (!debug) continue;
                        System.out.println("\t\t\tShortest path: " + String.valueOf(shortest) + " (of " + result.completePathCount + ")");
                    }
                } else if (debug) {
                    System.out.println("\t\t\tNo valid path found");
                }
                numCompletePaths += result.completePathCount;
            }
        }
        if (debug) {
            System.out.println("Found " + jumps.size() + " connections (searched " + numCompletePaths + " full paths)");
        }
        return jumps;
    }

    public ClusterRupture buildClusterRupture(int rupIndex) {
        return this.buildClusterRupture(rupIndex, false);
    }

    public ClusterRupture buildClusterRupture(int rupIndex, boolean debug) {
        return this.buildClusterRupture(rupIndex, false, debug);
    }

    public ClusterRupture buildClusterRupture(int rupIndex, boolean maintainOrder, boolean debug) {
        List<FaultSection> sects = this.rupSet.getFaultSectionDataForRupture(rupIndex);
        if (debug) {
            System.out.println("Building clusters for " + rupIndex);
        }
        List<FaultSubsectionCluster> rupClusters = this.calcClusters(sects, debug);
        if (debug) {
            System.out.println("\tHave " + rupClusters.size() + " clusters:");
            for (FaultSubsectionCluster cluster : rupClusters) {
                System.out.println("\t\t" + String.valueOf(cluster) + ": " + this.rupSet.getFaultSectionData(cluster.startSect.getSectionId()).getParentSectionName());
            }
        }
        List<Jump> jumps = this.calcRuptureJumps(rupClusters, debug);
        FaultSubsectionCluster startCluster = null;
        if (maintainOrder) {
            FaultSection firstSect = sects.get(0);
            for (FaultSubsectionCluster cluster : rupClusters) {
                if (!cluster.contains(firstSect)) continue;
                startCluster = cluster;
                break;
            }
        }
        return this.buildClusterRupture(rupClusters, jumps, debug, startCluster);
    }

    public ClusterRupture buildClusterRupture(List<FaultSubsectionCluster> rupClusters, List<Jump> jumps, boolean debug) {
        return this.buildClusterRupture(rupClusters, jumps, debug, null);
    }

    public ClusterRupture buildClusterRupture(List<FaultSubsectionCluster> rupClusters, List<Jump> jumps, boolean debug, FaultSubsectionCluster startCluster) {
        HashMultimap jumpsFromMap = HashMultimap.create();
        Collections.sort(jumps, Jump.id_comparator);
        rupClusters = new ArrayList<FaultSubsectionCluster>(rupClusters);
        Collections.sort(rupClusters);
        for (Jump jump : jumps) {
            jumpsFromMap.put((Object)jump.fromCluster, (Object)jump);
            Jump reversed = jump.reverse();
            jumpsFromMap.put((Object)reversed.fromCluster, (Object)reversed);
            if (!debug) continue;
            System.out.println("Available jump: " + String.valueOf(jump));
        }
        if (startCluster == null) {
            if (rupClusters.size() > 1) {
                if (debug) {
                    System.out.println("Calculating cluster isolation scores...");
                }
                double minClusterScore = Double.POSITIVE_INFINITY;
                for (FaultSubsectionCluster cluster : rupClusters) {
                    Preconditions.checkState((!jumpsFromMap.get((Object)cluster).isEmpty() ? 1 : 0) != 0);
                    HashSet<FaultSubsectionCluster> availableClusters = new HashSet<FaultSubsectionCluster>(rupClusters);
                    availableClusters.remove(cluster);
                    double score = this.calcClusterIsolationScore(cluster, availableClusters, (Multimap<FaultSubsectionCluster, Jump>)jumpsFromMap, 1.0);
                    if (debug) {
                        System.out.println("\tCluster " + String.valueOf(cluster) + "\tscore=" + score);
                    }
                    if (score < minClusterScore) {
                        startCluster = cluster;
                        minClusterScore = score;
                        continue;
                    }
                    if (score != minClusterScore) continue;
                    int prevIsolatedSects = RuptureConnectionSearch.calcNumIsolatedEndSubsections(startCluster);
                    int myIsolatedSects = RuptureConnectionSearch.calcNumIsolatedEndSubsections(cluster);
                    if (debug) {
                        System.out.println("\t\tTie. I have " + myIsolatedSects + " isolated sects, prev has " + prevIsolatedSects);
                    }
                    if (myIsolatedSects <= prevIsolatedSects) continue;
                    startCluster = cluster;
                    minClusterScore = score;
                }
                if (debug) {
                    System.out.println("Most isolated cluster: " + String.valueOf(startCluster) + "\tscore=" + minClusterScore);
                }
            } else {
                startCluster = rupClusters.get(0);
            }
        }
        HashSet<FaultSubsectionCluster> availableClusters = new HashSet<FaultSubsectionCluster>(rupClusters);
        if (!startCluster.startSect.equals(startCluster.subSects.get(0))) {
            startCluster = RuptureConnectionSearch.changeStartSection(startCluster, (FaultSection)startCluster.subSects.get(0), availableClusters, (Multimap<FaultSubsectionCluster, Jump>)jumpsFromMap);
        }
        if (rupClusters.size() > 1) {
            Preconditions.checkState((boolean)jumpsFromMap.containsKey((Object)startCluster), (String)"No jumps from starting cluster %s, but have %s clusters in total (%s jumpsFrom)", (Object)startCluster, (Object)rupClusters.size(), (Object)jumpsFromMap.size());
            int minJumpSectIndex = Integer.MAX_VALUE;
            int maxJumpSectIndex = 0;
            for (Jump jump : jumpsFromMap.get((Object)startCluster)) {
                int ind = startCluster.subSects.indexOf((Object)jump.fromSection);
                minJumpSectIndex = Integer.min(minJumpSectIndex, ind);
                maxJumpSectIndex = Integer.max(maxJumpSectIndex, ind);
            }
            if (minJumpSectIndex < startCluster.subSects.size() - (maxJumpSectIndex + 1)) {
                if (debug) {
                    System.out.println("Reversing startCluster as minJumpSectIndex=" + minJumpSectIndex + ", maxJumpSectIndex=" + maxJumpSectIndex + ", and size=" + startCluster.subSects.size());
                }
                startCluster = RuptureConnectionSearch.reverseCluster(startCluster, availableClusters, (Multimap<FaultSubsectionCluster, Jump>)jumpsFromMap);
            }
        }
        Preconditions.checkState((boolean)availableClusters.remove(startCluster));
        ClusterRupture rupture = new ClusterRupture(startCluster);
        rupture = this.buildRupture(rupture, rupture, availableClusters, (Multimap<FaultSubsectionCluster, Jump>)jumpsFromMap, debug);
        if (debug) {
            System.out.println("Final rupture:\n" + String.valueOf(rupture));
            System.out.flush();
        }
        Preconditions.checkState((boolean)availableClusters.isEmpty(), (String)"Didn't use all available clusters when building rupture, have %s left.\n\tRupture: %s\n\tAvailable clusters: %s", (Object)availableClusters.size(), (Object)rupture, availableClusters);
        return rupture;
    }

    private static FaultSubsectionCluster reverseCluster(FaultSubsectionCluster cluster, HashSet<FaultSubsectionCluster> availableClusters, Multimap<FaultSubsectionCluster, Jump> jumpsFromMap) {
        FaultSubsectionCluster reversed = cluster.reversed();
        RuptureConnectionSearch.updateAvaialableClustersJumps(cluster, reversed, availableClusters, jumpsFromMap);
        return reversed;
    }

    private static FaultSubsectionCluster changeStartSection(FaultSubsectionCluster cluster, FaultSection startSect, HashSet<FaultSubsectionCluster> availableClusters, Multimap<FaultSubsectionCluster, Jump> jumpsFromMap) {
        FaultSubsectionCluster revised = new FaultSubsectionCluster((List<? extends FaultSection>)cluster.subSects, startSect, (Collection<FaultSection>)cluster.endSects);
        RuptureConnectionSearch.updateAvaialableClustersJumps(cluster, revised, availableClusters, jumpsFromMap);
        return revised;
    }

    private static void updateAvaialableClustersJumps(FaultSubsectionCluster origCluster, FaultSubsectionCluster revised, HashSet<FaultSubsectionCluster> availableClusters, Multimap<FaultSubsectionCluster, Jump> jumpsFromMap) {
        if (availableClusters.contains(origCluster)) {
            availableClusters.remove(origCluster);
            availableClusters.add(revised);
        }
        if (jumpsFromMap.containsKey((Object)origCluster)) {
            ArrayList origJumps = new ArrayList(jumpsFromMap.get((Object)origCluster));
            jumpsFromMap.removeAll((Object)origCluster);
            jumpsFromMap.putAll((Object)revised, origJumps);
        }
        HashBasedTable replaceTable = HashBasedTable.create();
        for (Map.Entry entry : jumpsFromMap.entries()) {
            Jump newJump;
            Jump jump = (Jump)entry.getValue();
            if (jump.fromCluster == origCluster) {
                newJump = new Jump(jump.fromSection, revised, jump.toSection, jump.toCluster, jump.distance);
                replaceTable.put((Object)((FaultSubsectionCluster)entry.getKey()), (Object)jump, (Object)newJump);
                revised.addConnection(newJump);
                continue;
            }
            if (jump.toCluster != origCluster) continue;
            newJump = new Jump(jump.fromSection, jump.fromCluster, jump.toSection, revised, jump.distance);
            replaceTable.put((Object)((FaultSubsectionCluster)entry.getKey()), (Object)jump, (Object)newJump);
        }
        for (Table.Cell cell : replaceTable.cellSet()) {
            FaultSubsectionCluster fromCluster = (FaultSubsectionCluster)cell.getRowKey();
            Jump oldJump = (Jump)cell.getColumnKey();
            Jump newJump = (Jump)cell.getValue();
            Preconditions.checkNotNull((Object)jumpsFromMap.remove((Object)fromCluster, (Object)oldJump));
            jumpsFromMap.put((Object)fromCluster, (Object)newJump);
        }
    }

    private ClusterRupture buildRupture(ClusterRupture rupture, ClusterRupture currentStrand, HashSet<FaultSubsectionCluster> availableClusters, Multimap<FaultSubsectionCluster, Jump> jumpsFromMap, boolean debug) {
        boolean extended;
        if (debug) {
            System.out.println("Building strand: " + String.valueOf(currentStrand));
        }
        do {
            extended = false;
            FaultSubsectionCluster lastCluster = currentStrand.clusters[currentStrand.clusters.length - 1];
            if (debug) {
                System.out.println("Looking for jumps off of end cluster, from " + String.valueOf(lastCluster) + " with available clusters: " + String.valueOf(availableClusters));
            }
            ArrayList jumpsFromList = new ArrayList(jumpsFromMap.get((Object)lastCluster));
            Collections.sort(jumpsFromList, Jump.dist_comparator);
            for (Jump jump : jumpsFromList) {
                int sectIndex;
                if (!availableClusters.contains(jump.toCluster)) {
                    if (!debug) continue;
                    System.out.println("Skipping jump " + String.valueOf(jump) + " as toCluster not in available set: " + String.valueOf(jump.toCluster));
                    continue;
                }
                for (FaultSubsectionCluster cluster : rupture.clusters) {
                    for (Jump oJump : jumpsFromMap.get((Object)cluster)) {
                        if (oJump.toCluster != jump.toCluster || !(oJump.distance < jump.distance)) continue;
                        if (debug) {
                            System.out.println("Was going to take " + String.valueOf(jump) + ", but will instead take shorter " + String.valueOf(oJump));
                        }
                        jump = oJump;
                    }
                }
                if (debug) {
                    System.out.println("Evaluating jump " + String.valueOf(jump) + " with toCluster=" + String.valueOf(jump.toCluster));
                }
                if ((sectIndex = jump.toCluster.subSects.indexOf((Object)jump.toSection)) > jump.toCluster.subSects.size() - (sectIndex + 1)) {
                    if (debug) {
                        System.out.println("Reversing toCluster with sectIndex=" + sectIndex + " and size=" + jump.toCluster.subSects.size());
                    }
                    FaultSubsectionCluster toCluster = RuptureConnectionSearch.reverseCluster(jump.toCluster, availableClusters, jumpsFromMap);
                    jump = new Jump(jump.fromSection, jump.fromCluster, jump.toSection, toCluster, jump.distance);
                    if (debug) {
                        System.out.println("\tReversed: " + String.valueOf(toCluster));
                    }
                }
                if (!jump.toSection.equals(jump.toCluster.startSect)) {
                    if (debug) {
                        System.out.println("Correcting toSection in toCluster");
                    }
                    FaultSubsectionCluster toCluster = RuptureConnectionSearch.changeStartSection(jump.toCluster, jump.toSection, availableClusters, jumpsFromMap);
                    jump = new Jump(jump.fromSection, jump.fromCluster, jump.toSection, toCluster, jump.distance);
                    if (debug) {
                        System.out.println("\tCorrected: " + String.valueOf(toCluster));
                    }
                }
                availableClusters.remove(jump.toCluster);
                if (debug) {
                    System.out.println("\tTaking jump: " + String.valueOf(jump));
                }
                rupture = rupture.take(this.correctJumpDist(jump));
                currentStrand = this.splaySearchRecursive(rupture, currentStrand.clusters[0]);
                if (debug) {
                    System.out.println("Current strand after jump: " + String.valueOf(currentStrand));
                }
                Preconditions.checkNotNull((Object)currentStrand, (Object)"current strand could not be found after taking jump");
                extended = true;
            }
        } while (extended);
        for (ClusterRupture splay : currentStrand.splays.values()) {
            rupture = this.buildRupture(rupture, splay, availableClusters, jumpsFromMap, debug);
        }
        return rupture;
    }

    private Jump correctJumpDist(Jump jump) {
        double minDist = Double.POSITIVE_INFINITY;
        for (FaultSection s1 : jump.fromCluster.subSects) {
            for (FaultSection s2 : jump.toCluster.subSects) {
                minDist = Double.min(minDist, this.distCalc.getDistance(s1, s2));
            }
        }
        return new Jump(jump.fromSection, jump.fromCluster, jump.toSection, jump.toCluster, minDist);
    }

    private ClusterRupture splaySearchRecursive(ClusterRupture rup, FaultSubsectionCluster firstCluster) {
        if (rup.clusters[0] == firstCluster) {
            return rup;
        }
        for (ClusterRupture splay : rup.splays.values()) {
            ClusterRupture match = this.splaySearchRecursive(splay, firstCluster);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private double calcClusterIsolationScore(FaultSubsectionCluster cluster, HashSet<FaultSubsectionCluster> availableClusters, Multimap<FaultSubsectionCluster, Jump> jumpsFromMap, double penaltyEach) {
        double tot = 0.0;
        for (Jump jump : jumpsFromMap.get((Object)cluster)) {
            if (!availableClusters.contains(jump.toCluster)) continue;
            tot += penaltyEach;
            HashSet<FaultSubsectionCluster> newAvailableClusters = new HashSet<FaultSubsectionCluster>(availableClusters);
            newAvailableClusters.remove(jump.toCluster);
            tot += this.calcClusterIsolationScore(jump.toCluster, newAvailableClusters, jumpsFromMap, 0.1 * penaltyEach);
        }
        return tot;
    }

    private static int calcNumIsolatedEndSubsections(FaultSubsectionCluster cluster) {
        int ind;
        int max = 0;
        int i = 0;
        while (i < cluster.subSects.size() && cluster.getConnections((FaultSection)cluster.subSects.get(i)).isEmpty()) {
            max = i++;
        }
        i = 0;
        while (i < cluster.subSects.size() && cluster.getConnections((FaultSection)cluster.subSects.get(ind = cluster.subSects.size() - 1 - i)).isEmpty()) {
            max = i++;
        }
        return max;
    }

    public void plotConnections(File outputDir, String prefix, int rupIndex) throws IOException {
        this.plotConnections(outputDir, prefix, rupIndex, null, null, null);
    }

    public void plotConnections(File outputDir, String prefix, int rupIndex, ClusterRupture rup) throws IOException {
        this.plotConnections(outputDir, prefix, rupIndex, rup, null, null);
    }

    public void plotConnections(File outputDir, String prefix, int rupIndex, Set<Jump> highlightConn, String highlightName) throws IOException {
        this.plotConnections(outputDir, prefix, rupIndex, null, highlightConn, highlightName);
    }

    public void plotConnections(File outputDir, String prefix, int rupIndex, ClusterRupture rup, Set<Jump> highlightConn, String highlightName) throws IOException {
        List<FaultSection> sects = this.rupSet.getFaultSectionDataForRupture(rupIndex);
        List<FaultSubsectionCluster> clusters = this.calcClusters(sects, false);
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        if (rup == null) {
            rup = this.buildClusterRupture(rupIndex, false);
        }
        for (Jump jump : rup.getJumpsIterable()) {
            jumps.add(jump);
        }
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (FaultSection sect : sects) {
            parentIDs.add(sect.getParentSectionId());
        }
        Color color = Color.GREEN.darker();
        Color highlightColor = Color.RED.darker();
        Color faultColor = Color.DARK_GRAY;
        Color faultOutlineColor = Color.LIGHT_GRAY;
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        ArrayList<Object> funcs = new ArrayList<Object>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        HashMap<Integer, Location> middles = new HashMap<Integer, Location>();
        for (int s = 0; s < sects.size(); ++s) {
            FaultSection sect = sects.get(s);
            RuptureSurface surf = sect.getFaultSurface(1.0);
            DefaultXY_DataSet trace = new DefaultXY_DataSet();
            for (Location location : surf.getEvenlyDiscritizedUpperEdge()) {
                trace.set(location.getLongitude(), location.getLatitude());
            }
            if (sect.getAveDip() != 90.0) {
                DefaultXY_DataSet outline = new DefaultXY_DataSet();
                LocationList locationList = surf.getPerimeter();
                for (Location loc : locationList) {
                    outline.set(loc.getLongitude(), loc.getLatitude());
                }
                Location location = locationList.first();
                outline.set(location.getLongitude(), location.getLatitude());
                funcs.add(0, outline);
                chars.add(0, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, faultOutlineColor));
            }
            middles.put(sect.getSectionId(), GriddedSurfaceUtils.getSurfaceMiddleLoc(surf));
            if (s == 0) {
                trace.setName("Fault Sections");
            }
            funcs.add(trace);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, faultColor));
        }
        boolean first = true;
        double maxDist = 0.0;
        HashSet<Jump> connections = new HashSet<Jump>();
        for (Jump jump : jumps) {
            DefaultXY_DataSet defaultXY_DataSet = new DefaultXY_DataSet();
            maxDist = Math.max(maxDist, jump.distance);
            if (first) {
                defaultXY_DataSet.setName("Connections");
                first = false;
            }
            if (jump.fromSection.getSectionId() < jump.toSection.getSectionId()) {
                connections.add(jump);
            } else {
                connections.add(jump.reverse());
            }
            Location loc1 = (Location)middles.get(jump.fromSection.getSectionId());
            Location loc2 = (Location)middles.get(jump.toSection.getSectionId());
            defaultXY_DataSet.set(loc1.getLongitude(), loc1.getLatitude());
            defaultXY_DataSet.set(loc2.getLongitude(), loc2.getLatitude());
            funcs.add(defaultXY_DataSet);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, color));
        }
        if (highlightConn != null) {
            boolean firstHighlight = true;
            for (Jump jump : connections) {
                if (!highlightConn.contains(jump)) continue;
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                if (firstHighlight) {
                    xy.setName(highlightName);
                    firstHighlight = false;
                }
                Location loc1 = (Location)middles.get(jump.fromSection.getSectionId());
                Location loc2 = (Location)middles.get(jump.toSection.getSectionId());
                xy.set(loc1.getLongitude(), loc1.getLatitude());
                xy.set(loc2.getLongitude(), loc2.getLatitude());
                funcs.add(xy);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, highlightColor));
            }
        }
        for (XY_DataSet xY_DataSet : funcs) {
            for (Point2D pt : xY_DataSet) {
                latTrack.addValue(pt.getY());
                lonTrack.addValue(pt.getX());
            }
        }
        XY_DataSet[] outlines = PoliticalBoundariesData.loadCAOutlines();
        PlotCurveCharacterstics plotCurveCharacterstics = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        for (XY_DataSet outline : outlines) {
            funcs.add(outline);
            chars.add(plotCurveCharacterstics);
        }
        PlotSpec plotSpec = new PlotSpec(funcs, chars, "Rupture " + rupIndex + " Connections", "Longitude", "Latitude");
        plotSpec.setLegendVisible(true);
        Range xRange = new Range(lonTrack.getMin() - 0.5, lonTrack.getMax() + 0.5);
        Range yRange = new Range(latTrack.getMin() - 0.5, latTrack.getMax() + 0.5);
        double annX = xRange.getLowerBound() + 0.975 * xRange.getLength();
        double annYmult = 0.975;
        double deltaAnnYmult = 0.05;
        Font annFont = new Font("SansSerif", 1, 22);
        double annY = yRange.getLowerBound() + annYmult * yRange.getLength();
        XYTextAnnotation cAnn = new XYTextAnnotation(clusters.size() + " clusters on " + parentIDs.size() + " parent sects", annX, annY);
        cAnn.setFont(annFont);
        cAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
        plotSpec.addPlotAnnotation((XYAnnotation)cAnn);
        annY = yRange.getLowerBound() + (annYmult -= deltaAnnYmult) * yRange.getLength();
        XYTextAnnotation jumpAnn = new XYTextAnnotation(connections.size() + " connections (max dist: " + distDF.format(maxDist) + ")", annX, annY);
        jumpAnn.setFont(annFont);
        jumpAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
        plotSpec.addPlotAnnotation((XYAnnotation)jumpAnn);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setBackgroundColor(Color.WHITE);
        gp.drawGraphPanel(plotSpec, false, false, xRange, yRange);
        double len = Math.max(xRange.getLength(), yRange.getLength());
        double tick = len > 6.0 ? 2.0 : (len > 3.0 ? 1.0 : (len > 1.0 ? 0.5 : 0.1));
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(tick);
        tus.add((TickUnit)tu);
        gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
        gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
        File file = new File(outputDir, prefix + ".png");
        System.out.println("writing " + file.getAbsolutePath());
        double aspectRatio = yRange.getLength() / xRange.getLength();
        gp.getChartPanel().setSize(800, 200 + (int)(600.0 * aspectRatio));
        gp.saveAsPNG(file.getAbsolutePath());
    }

    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        File fssFile = new File("/home/kevin/Simulators/catalogs/rundir4983_stitched/fss/rsqsim_sol_m6.5_skip5000_sectArea0.2.zip");
        int[] plotIndexes = new int[]{};
        double debugDist = 30.0;
        double maxPossibleJumpDist = 1000.0;
        File outputDir = new File("/tmp/rup_conn_rsqsim");
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(fssFile);
        SectionDistanceAzimuthCalculator distCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
        RuptureConnectionSearch search = new RuptureConnectionSearch(rupSet, distCalc, maxPossibleJumpDist, false);
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        if (plotIndexes != null && plotIndexes.length > 0) {
            for (int r : plotIndexes) {
                search.plotConnections(outputDir, "rup_" + r, r);
            }
        } else {
            HashSet<IDPairing> allConnections = new HashSet<IDPairing>();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                if (r % 1000 == 0) {
                    System.out.println("Calculating for rupture " + r + "/" + rupSet.getNumRuptures() + " (" + allConnections.size() + " connections found so far)");
                }
                ClusterRupture rup = null;
                try {
                    rup = search.buildClusterRupture(r, false);
                }
                catch (Exception e) {
                    System.out.println("detected an exception with " + r + ", will redo with debugging enabled");
                    System.out.println("Full rupture: " + Joiner.on((String)",").join(rupSet.getSectionsIndicesForRup(r)));
                    rup = search.buildClusterRupture(r, true);
                }
                boolean debug = false;
                for (Jump jump : rup.getJumpsIterable()) {
                    IDPairing pair = RuptureConnectionSearch.jumpPair(jump);
                    if (!allConnections.contains(pair) && jump.distance > debugDist) {
                        System.out.println("Jump " + String.valueOf(jump) + " has dist=" + (float)jump.distance);
                        debug = true;
                    }
                    allConnections.add(pair);
                }
                if (!debug) continue;
                search.plotConnections(outputDir, "rup_" + r, r);
            }
            System.out.println("Found " + allConnections.size() + " total connections");
        }
    }

    @Override
    public String getName() {
        return "Rupture Connection Search";
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        if (this.rupSet != null) {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(parent));
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    @Override
    public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
        if (this.rupSet != null) {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(newParent));
        }
        return new RuptureConnectionSearch(newParent, this.distCalc, this.maxJumpDist, this.cumulativeJumps);
    }

    private class ClusterPath
    implements Comparable<ClusterPath> {
        private final FaultSubsectionCluster start;
        private final FaultSubsectionCluster target;
        private final HashSet<FaultSubsectionCluster> availableClusters;
        private final FaultSubsectionCluster[] path;
        private final Jump[] jumps;
        private final double maxJumpDist;
        private final double cmlJumpDist;

        public ClusterPath(FaultSubsectionCluster start, FaultSubsectionCluster target, HashSet<FaultSubsectionCluster> availableClusters) {
            this(start, target, availableClusters, new FaultSubsectionCluster[]{start}, new Jump[0], 0.0, 0.0);
        }

        public ClusterPath(FaultSubsectionCluster start, FaultSubsectionCluster target, HashSet<FaultSubsectionCluster> availableClusters, FaultSubsectionCluster[] path, Jump[] jumps, double maxJumpDist, double cmlJumpDist) {
            this.start = start;
            this.target = target;
            this.availableClusters = new HashSet<FaultSubsectionCluster>(availableClusters);
            this.path = path;
            Preconditions.checkState((jumps.length == path.length - 1 ? 1 : 0) != 0);
            this.jumps = jumps;
            this.maxJumpDist = maxJumpDist;
            this.cmlJumpDist = cmlJumpDist;
        }

        public ClusterPath take(FaultSubsectionCluster to) {
            Preconditions.checkState((!this.isComplete() ? 1 : 0) != 0);
            HashSet<FaultSubsectionCluster> newAvailClusters = new HashSet<FaultSubsectionCluster>(this.availableClusters);
            Preconditions.checkState((boolean)newAvailClusters.remove(to));
            FaultSubsectionCluster from = this.path[this.path.length - 1];
            FaultSubsectionCluster[] newPath = Arrays.copyOf(this.path, this.path.length + 1);
            newPath[this.path.length] = to;
            Collection<Jump> jumpsTo = from.getConnectionsTo(to);
            Preconditions.checkState((jumpsTo.size() == 1 ? 1 : 0) != 0, (String)"%s paths between cluster pair?", (int)jumpsTo.size());
            Jump jump = jumpsTo.iterator().next();
            Preconditions.checkNotNull((Object)jump);
            Jump[] newJumps = Arrays.copyOf(this.jumps, this.jumps.length + 1);
            newJumps[this.jumps.length] = jump;
            double newMax = Math.max(this.maxJumpDist, jump.distance);
            double newCml = this.cmlJumpDist + jump.distance;
            return new ClusterPath(this.start, this.target, newAvailClusters, newPath, newJumps, newMax, newCml);
        }

        public boolean isComplete() {
            return this.path[this.path.length - 1] == this.target;
        }

        public String toString() {
            Object str = "";
            for (int p = 0; p < this.path.length; ++p) {
                if (p == 0) {
                    str = (String)str + "[";
                } else {
                    Jump jump = this.jumps[p - 1];
                    int exitID = jump.fromSection.getSectionId();
                    int entryID = jump.toSection.getSectionId();
                    str = (String)str + "; " + exitID + "] => [" + entryID + "; R=" + distDF.format(jump.distance) + "; ";
                }
                str = (String)str + this.path[p].parentSectionName;
            }
            str = (String)str + "]";
            str = this.isComplete() ? (String)str + " COMPLETE Rmax=" + distDF.format(this.maxJumpDist) + ", Rcml=" + distDF.format(this.cmlJumpDist) : (String)str + " INCOMPLETE (target: " + this.target.parentSectionName + ") Rmax=" + distDF.format(this.maxJumpDist) + ", Rcml=" + distDF.format(this.cmlJumpDist);
            return str;
        }

        private double maxDistBefore(double maxDist) {
            double curMax = 0.0;
            for (Jump jump : this.jumps) {
                if (jump.distance == maxDist) break;
                curMax = Math.max(curMax, jump.distance);
            }
            return curMax;
        }

        @Override
        public int compareTo(ClusterPath o) {
            if (RuptureConnectionSearch.this.cumulativeJumps) {
                return Double.compare(this.cmlJumpDist, o.cmlJumpDist);
            }
            int cmp = Double.compare(this.maxJumpDist, o.maxJumpDist);
            if (cmp != 0) {
                return cmp;
            }
            double myMaxDist = this.maxJumpDist;
            double oMaxDist = o.maxJumpDist;
            while (myMaxDist > 0.0 || oMaxDist > 0.0) {
                cmp = Double.compare(myMaxDist = this.maxDistBefore(myMaxDist), oMaxDist = o.maxDistBefore(oMaxDist));
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(this.jumps.length, o.jumps.length);
        }
    }

    private class PathResult {
        private ClusterPath[] shortestPaths;
        private int completePathCount = 0;

        private PathResult() {
        }

        private void addPath(ClusterPath path, boolean debug) {
            Preconditions.checkState((boolean)path.isComplete());
            if (this.shortestPaths == null) {
                if (debug) {
                    System.out.println("\t\t\t\tNew shortest (first): " + String.valueOf(path));
                }
                this.shortestPaths = new ClusterPath[]{path};
            } else {
                int cmp = path.compareTo(this.shortestPaths[0]);
                if (cmp < 0) {
                    if (debug) {
                        System.out.println("\t\t\t\tNew shortest (better): " + String.valueOf(path));
                    }
                    this.shortestPaths = new ClusterPath[]{path};
                } else if (cmp == 0) {
                    if (debug) {
                        System.out.println("\t\t\t\tIt's a tie! Additional shortest: " + String.valueOf(path));
                    }
                    this.shortestPaths = Arrays.copyOf(this.shortestPaths, this.shortestPaths.length + 1);
                    this.shortestPaths[this.shortestPaths.length - 1] = path;
                }
            }
            ++this.completePathCount;
        }
    }
}

