/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SlipRateSegmentationConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.MaxJumpDistModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;

public class SegmentationCalculator {
    public static final double[] MIN_MAGS_DEFAULT = new double[]{0.0, 6.5, 7.0, 7.5};
    public static boolean WRITE_PDFS = false;
    private final List<? extends FaultSection> subSects;
    private final FaultSystemSolution sol;
    private final List<ClusterRupture> ruptures;
    private final SectionDistanceAzimuthCalculator distAzCalc;
    private final double[] minMags;
    private SubSectStiffnessCalculator stiffnessCalc;
    private JumpProbabilityCalc detrendProb = new Shaw07JumpDistProb(1.0, 3.0);
    private boolean uniqueDists = true;
    private final double[][] sectParticRates;
    private final Map<Integer, double[]> parentParticRates;
    private final Map<Integer, FaultSubsectionCluster> fullClustersMap;
    private final Table<IDPairing, Jump, JumpRates> parentJumpRateTable;
    private final boolean multipleJumpsPerParent;
    private static final DecimalFormat optionalDigitDF = new DecimalFormat("0.#");
    private static final DecimalFormat oneDigitDF = new DecimalFormat("0.0");
    public static String PASSTHROUGH_LABEL = "Passthrough Rate";
    private int legendFontSize = 18;

    private static double bestDirectionalValue(AggregatedStiffnessCalculator aggCalc, Jump jump) {
        int fromIndex = jump.fromCluster.subSects.indexOf((Object)jump.fromSection);
        Preconditions.checkState((fromIndex >= 0 ? 1 : 0) != 0);
        int toIndex = jump.toCluster.subSects.indexOf((Object)jump.toSection);
        Preconditions.checkState((toIndex >= 0 ? 1 : 0) != 0);
        List<List<FaultSection>> fromOptions = SegmentationCalculator.getDirectionalOptions(jump.fromCluster.subSects, fromIndex);
        List<List<FaultSection>> toOptions = SegmentationCalculator.getDirectionalOptions(jump.toCluster.subSects, toIndex);
        double maxVal = Double.NEGATIVE_INFINITY;
        for (List<FaultSection> fromSects : fromOptions) {
            for (List<FaultSection> toSects : toOptions) {
                maxVal = Math.max(maxVal, aggCalc.calc(fromSects, toSects));
            }
        }
        return maxVal;
    }

    private static List<List<FaultSection>> getDirectionalOptions(List<FaultSection> clusterSects, int startIndex) {
        Preconditions.checkState((startIndex >= 0 ? 1 : 0) != 0);
        ArrayList<List<FaultSection>> ret = new ArrayList<List<FaultSection>>();
        ret.add(clusterSects);
        if (startIndex > 0) {
            ret.add(clusterSects.subList(0, startIndex + 1));
        }
        if (startIndex < clusterSects.size() - 1) {
            ret.add(clusterSects.subList(startIndex, clusterSects.size()));
        }
        Preconditions.checkState((!ret.isEmpty() ? 1 : 0) != 0);
        return ret;
    }

    public SegmentationCalculator(FaultSystemSolution sol, List<ClusterRupture> ruptures, ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        this(sol, ruptures, connStrat, distAzCalc, MIN_MAGS_DEFAULT);
    }

    public SegmentationCalculator(FaultSystemSolution sol, List<ClusterRupture> ruptures, ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc, double[] minMags) {
        this.subSects = sol.getRupSet().getFaultSectionDataList();
        this.sol = sol;
        Preconditions.checkState((sol.getRupSet().getNumRuptures() == ruptures.size() ? 1 : 0) != 0);
        this.ruptures = ruptures;
        this.distAzCalc = distAzCalc;
        this.minMags = minMags;
        this.sectParticRates = new double[this.subSects.size()][minMags.length];
        this.parentParticRates = new HashMap<Integer, double[]>();
        List<FaultSubsectionCluster> clusters = connStrat.getClusters();
        this.fullClustersMap = new HashMap<Integer, FaultSubsectionCluster>();
        for (FaultSubsectionCluster cluster : clusters) {
            this.fullClustersMap.put(cluster.parentSectionID, cluster);
            this.parentParticRates.put(cluster.parentSectionID, new double[minMags.length]);
        }
        double[] mags = sol.getRupSet().getMagForAllRups();
        double[] rates = sol.getRateForAllRups();
        for (int r = 0; r < rates.length; ++r) {
            ClusterRupture rup = ruptures.get(r);
            HashSet<Integer> parentIDs = new HashSet<Integer>();
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                parentIDs.add(cluster.parentSectionID);
                for (FaultSection sect : cluster.subSects) {
                    this.addMagRate(this.sectParticRates[sect.getSectionId()], mags[r], rates[r]);
                }
            }
            for (Integer parentID : parentIDs) {
                this.addMagRate(this.parentParticRates.get(parentID), mags[r], rates[r]);
            }
        }
        JumpingPointRates[] jumpPointRates = new JumpingPointRates[this.subSects.size()];
        this.parentJumpRateTable = HashBasedTable.create();
        for (FaultSubsectionCluster cluster : clusters) {
            for (Jump jump : cluster.getConnections()) {
                IDPairing pair;
                if (this.uniqueDists) {
                    jump = new Jump.UniqueDistJump(jump);
                }
                if (this.parentJumpRateTable.containsRow((Object)(pair = this.pair(jump.fromCluster.parentSectionID, jump.toCluster.parentSectionID)))) continue;
                if (jump.fromCluster.parentSectionID == pair.getID2()) {
                    jump = jump.reverse();
                }
                JumpingPointRates fromRates = this.getBuildJumpPointRates(jumpPointRates, jump.fromSection);
                JumpingPointRates toRates = this.getBuildJumpPointRates(jumpPointRates, jump.toSection);
                JumpRates jumpRates = new JumpRates(fromRates, toRates);
                jumpRates.addAzimuiths(jump, jump.fromCluster, jump.toCluster, 1.0E-16);
                this.parentJumpRateTable.put((Object)pair, (Object)jump, (Object)jumpRates);
            }
        }
        boolean multipleJumpsPerParent = false;
        for (int r = 0; r < rates.length; ++r) {
            ClusterRupture rup = ruptures.get(r);
            for (Jump jump : rup.getJumpsIterable()) {
                IDPairing pair;
                JumpRates jumpRates;
                FaultSection toSect;
                FaultSection fromSect;
                int fromParentID = jump.fromCluster.parentSectionID;
                int toParentID = jump.toCluster.parentSectionID;
                if (fromParentID == toParentID) continue;
                if (fromParentID < toParentID) {
                    fromSect = jump.fromSection;
                    toSect = jump.toSection;
                } else {
                    fromSect = jump.toSection;
                    toSect = jump.fromSection;
                    int tmpID = fromParentID;
                    fromParentID = toParentID;
                    toParentID = tmpID;
                    jump = jump.reverse();
                }
                FaultSubsectionCluster fullFrom = this.fullClustersMap.get(fromParentID);
                FaultSubsectionCluster fullTo = this.fullClustersMap.get(toParentID);
                Jump fullJump = new Jump(fromSect, fullFrom, toSect, fullTo, jump.distance);
                if (this.uniqueDists) {
                    jump = new Jump.UniqueDistJump(jump);
                    fullJump = new Jump.UniqueDistJump(fullJump);
                }
                if ((jumpRates = (JumpRates)this.parentJumpRateTable.get((Object)(pair = this.pair(fromParentID, toParentID)), (Object)fullJump)) == null) {
                    multipleJumpsPerParent = multipleJumpsPerParent || this.parentJumpRateTable.containsRow((Object)pair);
                    JumpingPointRates fromRates = this.getBuildJumpPointRates(jumpPointRates, fromSect);
                    JumpingPointRates toRates = this.getBuildJumpPointRates(jumpPointRates, toSect);
                    jumpRates = new JumpRates(fromRates, toRates);
                    this.parentJumpRateTable.put((Object)pair, (Object)fullJump, (Object)jumpRates);
                }
                jumpRates.addAzimuiths(jump, fullFrom, fullTo, rates[r]);
                jumpRates.addRate(r, jump.distance);
            }
        }
        System.out.println("Processed " + ruptures.size() + " ruptures. Found " + this.parentJumpRateTable.size() + " unique jumps. Multiple jumps per parent pair? " + multipleJumpsPerParent);
        this.multipleJumpsPerParent = multipleJumpsPerParent;
    }

    private SegmentationCalculator(SegmentationCalculator other, Table<IDPairing, Jump, JumpRates> parentJumpRateTable) {
        this.subSects = other.subSects;
        this.sol = other.sol;
        this.ruptures = other.ruptures;
        this.distAzCalc = other.distAzCalc;
        this.minMags = other.minMags;
        this.sectParticRates = other.sectParticRates;
        this.parentParticRates = other.parentParticRates;
        this.fullClustersMap = other.fullClustersMap;
        boolean multipleJumpsPerParent = false;
        for (IDPairing pair : parentJumpRateTable.rowKeySet()) {
            Map map = parentJumpRateTable.row((Object)pair);
            multipleJumpsPerParent = multipleJumpsPerParent || map.size() > 1;
            for (JumpRates jumpRates : map.values()) {
                Preconditions.checkState((jumpRates.magJumpRates.length == this.minMags.length ? 1 : 0) != 0);
            }
        }
        this.parentJumpRateTable = parentJumpRateTable;
        this.multipleJumpsPerParent = multipleJumpsPerParent;
    }

    public Set<Jump> getNonZeroJumps() {
        return this.parentJumpRateTable.columnKeySet();
    }

    private void addMagRate(double[] magRates, double mag, double rate) {
        for (int m = 0; m < this.minMags.length; ++m) {
            if (!(mag >= this.minMags[m])) continue;
            int n = m;
            magRates[n] = magRates[n] + rate;
        }
    }

    private IDPairing pair(int id1, int id2) {
        if (id1 < id2) {
            return new IDPairing(id1, id2);
        }
        return new IDPairing(id2, id1);
    }

    public boolean areMultipleJumpsPerParent() {
        return this.multipleJumpsPerParent;
    }

    private JumpingPointRates getBuildJumpPointRates(JumpingPointRates[] jumpPointRates, FaultSection sect) {
        if (jumpPointRates[sect.getSectionId()] == null) {
            jumpPointRates[sect.getSectionId()] = new JumpingPointRates(sect);
        }
        return jumpPointRates[sect.getSectionId()];
    }

    public SegmentationCalculator combineMultiJumps(boolean highestRate) {
        if (!this.multipleJumpsPerParent) {
            return this;
        }
        FaultSystemRupSet rupSet = this.sol.getRupSet();
        HashBasedTable combinedTable = HashBasedTable.create();
        for (IDPairing pair : this.parentJumpRateTable.rowKeySet()) {
            int rup;
            Map jumpMap = this.parentJumpRateTable.row((Object)pair);
            if (jumpMap.size() < 2) {
                for (Jump jump : jumpMap.keySet()) {
                    combinedTable.put((Object)pair, (Object)jump, (Object)((JumpRates)jumpMap.get(jump)));
                }
                continue;
            }
            Jump bestJump = null;
            JumpRates bestJumpRates = null;
            double[] totRates = new double[this.minMags.length];
            HashSet<Integer> fromRups = new HashSet<Integer>();
            HashSet<Integer> toRups = new HashSet<Integer>();
            HashSet<Integer> jumpRups = new HashSet<Integer>();
            for (Jump jump : jumpMap.keySet()) {
                boolean newBest;
                JumpRates rate = (JumpRates)jumpMap.get(jump);
                boolean bl = newBest = bestJump == null || highestRate && StatUtils.max((double[])rate.magJumpRates) > StatUtils.max((double[])bestJumpRates.magJumpRates) || !highestRate && jump.distance < bestJump.distance;
                if (newBest) {
                    bestJump = jump;
                    bestJumpRates = rate;
                }
                jumpRups.addAll(rate.rupIndexes);
                fromRups.addAll(rupSet.getRupturesForSection(jump.fromSection.getSectionId()));
                toRups.addAll(rupSet.getRupturesForSection(jump.toSection.getSectionId()));
            }
            Iterator<Object> iterator = jumpRups.iterator();
            while (iterator.hasNext()) {
                int rupIndex = (Integer)iterator.next();
                this.addMagRate(totRates, rupSet.getMagForRup(rupIndex), this.sol.getRateForRup(rupIndex));
            }
            double totMaxRate = StatUtils.max((double[])totRates);
            double[] combFromSectRates = new double[this.minMags.length];
            double[] combToSectRates = new double[this.minMags.length];
            Iterator iterator2 = fromRups.iterator();
            while (iterator2.hasNext()) {
                rup = (Integer)iterator2.next();
                this.addMagRate(combFromSectRates, rupSet.getMagForRup(rup), this.sol.getRateForRup(rup));
            }
            iterator2 = toRups.iterator();
            while (iterator2.hasNext()) {
                rup = (Integer)iterator2.next();
                this.addMagRate(combToSectRates, rupSet.getMagForRup(rup), this.sol.getRateForRup(rup));
            }
            double combFromRupSetSlipRate = 0.0;
            double combToRupSetSlipRate = 0.0;
            double combFromSolSlipRate = 0.0;
            double combToSolSlipRate = 0.0;
            double sumRateDist = 0.0;
            double sumRate = 0.0;
            for (Jump jump : jumpMap.keySet()) {
                JumpRates jumpRates = (JumpRates)jumpMap.get(jump);
                double weight = StatUtils.max((double[])jumpRates.magJumpRates) / totMaxRate;
                combFromRupSetSlipRate += jumpRates.fromRates.rupSetSlipRate * weight;
                combToRupSetSlipRate += jumpRates.toRates.rupSetSlipRate * weight;
                combFromSolSlipRate += jumpRates.fromRates.solSlipRate * weight;
                combToSolSlipRate += jumpRates.toRates.solSlipRate * weight;
                sumRateDist += jumpRates.sumRateDist;
                sumRate += jumpRates.sumRate;
            }
            FaultSection fromSect = bestJump.fromSection;
            JumpingPointRates combFromRates = new JumpingPointRates(fromSect, this.parentParticRates.get(fromSect.getParentSectionId()), combFromSectRates, combFromRupSetSlipRate, combFromSolSlipRate);
            FaultSection toSect = bestJump.toSection;
            JumpingPointRates combToRates = new JumpingPointRates(toSect, this.parentParticRates.get(toSect.getParentSectionId()), combToSectRates, combToRupSetSlipRate, combToSolSlipRate);
            JumpRates combJumpRates = new JumpRates(combFromRates, bestJumpRates.fromAzTrack, combToRates, bestJumpRates.toAzTrack, totRates);
            combJumpRates.sumRateDist = sumRateDist;
            combJumpRates.sumRate = sumRate;
            combinedTable.put((Object)pair, (Object)bestJump, (Object)combJumpRates);
        }
        SegmentationCalculator ret = new SegmentationCalculator(this, (Table<IDPairing, Jump, JumpRates>)combinedTable);
        Preconditions.checkState((!ret.multipleJumpsPerParent ? 1 : 0) != 0);
        return ret;
    }

    public static String getMagLabel(double mag) {
        if (mag > 0.0) {
            return "M\u2265" + optionalDigitDF.format(mag);
        }
        return "Supra-Seismogenic";
    }

    public static String getMagPrefix(double mag) {
        if (mag > 0.0) {
            return "m" + oneDigitDF.format(mag);
        }
        return "supra_seis";
    }

    public File[] plotConnectionRates(File outputDir, String prefix, String title) throws IOException {
        return this.plotConnectionRates(outputDir, prefix, title, 800);
    }

    private static CPT getConnectionRateCPT() throws IOException {
        return GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-6.0, -1.0);
    }

    public File[] plotConnectionRates(File outputDir, String prefix, String title, int width) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(this.sol.getRupSet(), RupSetMapMaker.buildBufferedRegion(this.subSects));
        CPT cpt = SegmentationCalculator.getConnectionRateCPT();
        File[] ret = new File[this.minMags.length];
        for (int m = 0; m < this.minMags.length; ++m) {
            plotter.clearJumpScalars();
            ArrayList<Jump> jumps = new ArrayList<Jump>();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
                double val = ((JumpRates)cell.getValue()).magJumpRates[m];
                if (!(val > 0.0)) continue;
                jumps.add((Jump)cell.getColumnKey());
                values.add(Math.log10(val));
            }
            plotter.plotJumpScalars(jumps, values, cpt, "Log10 " + SegmentationCalculator.getMagLabel(this.minMags[m]) + " Connection Rates");
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            plotter.plot(outputDir, myPrefix, title, width);
        }
        return ret;
    }

    public File[] plotConnectionFracts(File outputDir, String prefix, String title) throws IOException {
        return this.plotConnectionFracts(outputDir, prefix, title, 800, null);
    }

    public File[] plotConnectionFracts(File outputDir, String prefix, String title, SlipRateSegmentationConstraint.RateCombiner combiner) throws IOException {
        return this.plotConnectionFracts(outputDir, prefix, title, 800, combiner);
    }

    public static CPT getConnectionFractCPT() throws IOException {
        return GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
    }

    private static CPT getConnectionDiffCPT() throws IOException {
        return GMT_CPT_Files.DIVERGING_VIK_UNIFORM.instance().rescale(-0.5, 0.5);
    }

    private static CPT getConnectionLogRatioCPT() throws IOException {
        return GMT_CPT_Files.DIVERGING_VIK_UNIFORM.instance().rescale(-1.0, 1.0);
    }

    public File[] plotConnectionFracts(File outputDir, String prefix, String title, int width) throws IOException {
        return this.plotConnectionFracts(outputDir, prefix, title, width, null);
    }

    public File[] plotConnectionFracts(File outputDir, String prefix, String title, int width, SlipRateSegmentationConstraint.RateCombiner combiner) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(this.sol.getRupSet(), RupSetMapMaker.buildBufferedRegion(this.subSects));
        CPT cpt = SegmentationCalculator.getConnectionFractCPT();
        File[] ret = new File[this.minMags.length];
        for (int m = 0; m < this.minMags.length; ++m) {
            plotter.clearJumpScalars();
            Object label = PASSTHROUGH_LABEL;
            if (combiner != null || this.minMags[m] > 0.0) {
                label = SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + (String)label;
            }
            if (combiner != null) {
                label = (String)label + " (Rel. " + String.valueOf((Object)combiner) + ")";
            }
            plotter.plotJumpScalars(this.calcJumpPassthroughs(m, combiner == null ? SlipRateSegmentationConstraint.RateCombiner.MIN : combiner), cpt, (String)label);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            plotter.plot(outputDir, myPrefix, title, width);
        }
        return ret;
    }

    public Map<Jump, Double> calcJumpPassthroughs(int magIndex, SlipRateSegmentationConstraint.RateCombiner combiner) {
        HashMap<Jump, Double> ret = new HashMap<Jump, Double>();
        for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
            JumpRates rates = (JumpRates)cell.getValue();
            double jumpRate = rates.magJumpRates[magIndex];
            double fromVal = rates.fromRates.sectRates[magIndex];
            double toVal = rates.toRates.sectRates[magIndex];
            double fract = jumpRate / combiner.combine(fromVal, toVal);
            if (!(fract > 0.0)) continue;
            ret.put((Jump)cell.getColumnKey(), fract);
        }
        return ret;
    }

    public File[] plotConnectionDiffs(File outputDir, String prefix, String title, SlipRateSegmentationConstraint.RateCombiner combiner, SegmentationCalculator compCalc) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(this.sol.getRupSet(), RupSetMapMaker.buildBufferedRegion(this.subSects));
        CPT cpt = SegmentationCalculator.getConnectionDiffCPT();
        File[] ret = new File[this.minMags.length];
        for (int m = 0; m < this.minMags.length; ++m) {
            plotter.clearJumpScalars();
            String label = SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + PASSTHROUGH_LABEL + " Difference";
            Map<Jump, Double> primary = this.calcJumpPassthroughs(m, combiner);
            Map<Jump, Double> comp = compCalc.calcJumpPassthroughs(m, combiner);
            HashSet<Jump> allJumps = new HashSet<Jump>();
            allJumps.addAll(primary.keySet());
            allJumps.addAll(comp.keySet());
            ArrayList<Jump> jumps = new ArrayList<Jump>();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Jump jump : allJumps) {
                Double val1 = primary.get(jump);
                Double val2 = comp.get(jump);
                if (val1 == null) {
                    val1 = 0.0;
                }
                if (val2 == null) {
                    val2 = 0.0;
                }
                jumps.add(jump);
                values.add(val1 - val2);
            }
            plotter.plotJumpScalars(jumps, values, cpt, label);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            plotter.plot(outputDir, myPrefix, title, 800);
        }
        return ret;
    }

    public File[] plotConnectionLogRatios(File outputDir, String prefix, String title, SlipRateSegmentationConstraint.RateCombiner combiner, SegmentationCalculator compCalc) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(this.sol.getRupSet(), RupSetMapMaker.buildBufferedRegion(this.subSects));
        CPT cpt = SegmentationCalculator.getConnectionLogRatioCPT();
        File[] ret = new File[this.minMags.length];
        for (int m = 0; m < this.minMags.length; ++m) {
            plotter.clearJumpScalars();
            String label = "Log10 " + SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + PASSTHROUGH_LABEL + " Ratio";
            Map<Jump, Double> primary = this.calcJumpPassthroughs(m, combiner);
            Map<Jump, Double> comp = compCalc.calcJumpPassthroughs(m, combiner);
            HashSet<Jump> allJumps = new HashSet<Jump>();
            allJumps.addAll(primary.keySet());
            allJumps.addAll(comp.keySet());
            ArrayList<Jump> jumps = new ArrayList<Jump>();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Jump jump : allJumps) {
                Double val1 = primary.get(jump);
                Double val2 = comp.get(jump);
                if (val1 == null) {
                    val1 = 0.0;
                }
                if (val2 == null) {
                    val2 = 0.0;
                }
                jumps.add(jump);
                values.add(Math.log10(val1 / val2));
            }
            plotter.plotJumpScalars(jumps, values, cpt, label);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            plotter.plot(outputDir, myPrefix, title, 800);
        }
        return ret;
    }

    public File[] plotConnectionModelDiffs(File outputDir, String prefix, String title, SlipRateSegmentationConstraint.RateCombiner combiner, JumpProbabilityCalc segModel) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(this.sol.getRupSet(), RupSetMapMaker.buildBufferedRegion(this.subSects));
        CPT cpt = SegmentationCalculator.getConnectionDiffCPT();
        File[] ret = new File[this.minMags.length];
        for (int m = 0; m < this.minMags.length; ++m) {
            plotter.clearJumpScalars();
            String label = SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + PASSTHROUGH_LABEL + " Difference";
            Map<Jump, Double> primary = this.calcJumpPassthroughs(m, combiner);
            ArrayList<Jump> jumps = new ArrayList<Jump>();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Jump jump : primary.keySet()) {
                Double val1 = primary.get(jump);
                double val2 = segModel.calcJumpProbability(null, jump, false);
                if (val1 == null) {
                    val1 = 0.0;
                }
                jumps.add(jump);
                values.add(val1 - val2);
            }
            plotter.plotJumpScalars(jumps, values, cpt, label);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            plotter.plot(outputDir, myPrefix, title, 800);
        }
        return ret;
    }

    public File[] plotConnectionModelLogRatios(File outputDir, String prefix, String title, SlipRateSegmentationConstraint.RateCombiner combiner, JumpProbabilityCalc segModel) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(this.sol.getRupSet(), RupSetMapMaker.buildBufferedRegion(this.subSects));
        CPT cpt = SegmentationCalculator.getConnectionLogRatioCPT();
        File[] ret = new File[this.minMags.length];
        for (int m = 0; m < this.minMags.length; ++m) {
            plotter.clearJumpScalars();
            String label = "Log10 " + SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + PASSTHROUGH_LABEL + " Ratio";
            Map<Jump, Double> primary = this.calcJumpPassthroughs(m, combiner);
            ArrayList<Jump> jumps = new ArrayList<Jump>();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Jump jump : primary.keySet()) {
                Double val1 = primary.get(jump);
                double val2 = segModel.calcJumpProbability(null, jump, false);
                if (val1 == null) {
                    val1 = 0.0;
                }
                jumps.add(jump);
                values.add(Math.log10(val1 / val2));
            }
            plotter.plotJumpScalars(jumps, values, cpt, label);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            plotter.plot(outputDir, myPrefix, title, 800);
        }
        return ret;
    }

    private SubSectStiffnessCalculator getStiffnessCalc() {
        if (this.stiffnessCalc == null) {
            this.stiffnessCalc = new SubSectStiffnessCalculator(this.subSects, 2.0, 30000.0, 30000.0, 0.5, SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP, 1.0);
        }
        return this.stiffnessCalc;
    }

    private Map<Jump, Double> calcJumpScalarValues(Scalars scalar) {
        SubSectStiffnessCalculator stiffnessCalc = this.getStiffnessCalc();
        HashMap<Jump, Double> ret = new HashMap<Jump, Double>();
        int threads = Integer.max(1, Runtime.getRuntime().availableProcessors());
        if (threads > 32) {
            threads = 32;
        }
        if (threads > 8) {
            threads -= 2;
        }
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        ArrayList<Future<ScalarCalcCallable>> futures = new ArrayList<Future<ScalarCalcCallable>>();
        for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
            Jump jump = (Jump)cell.getColumnKey();
            JumpRates rates = (JumpRates)cell.getValue();
            Preconditions.checkState((!ret.containsKey(jump) ? 1 : 0) != 0);
            futures.add(exec.submit(new ScalarCalcCallable(scalar, jump, rates, stiffnessCalc)));
        }
        for (Future future : futures) {
            try {
                ScalarCalcCallable call = (ScalarCalcCallable)future.get();
                ret.put(call.jump, call.value);
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        exec.shutdown();
        return ret;
    }

    public File[] plotFractVsScalars(File outputDir, String prefix, Scalars scalar, boolean logY, SlipRateSegmentationConstraint.RateCombiner ... combiners) throws IOException {
        Preconditions.checkArgument((combiners.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 rate combiner");
        File[] ret = new File[this.minMags.length];
        AbstractXY_DataSet marginalTakenHist = null;
        AbstractXY_DataSet marginalAllHist = null;
        Range xRange = null;
        Range yRange = logY ? new Range(0.001, 1.0) : new Range(0.0, 1.0);
        CPT rateCPT = SegmentationCalculator.getConnectionRateCPT();
        Color outlineColor = new Color(0, 0, 0, 100);
        float scatterWidth = 4.0f;
        Map<Jump, Double> scalarJumpVals = this.calcJumpScalarValues(scalar);
        for (int m = 0; m < this.minMags.length; ++m) {
            DataUtils.MinMaxAveTracker scalarTrack = new DataUtils.MinMaxAveTracker();
            ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
            for (SlipRateSegmentationConstraint.RateCombiner combiner : combiners) {
                int i;
                int i2;
                ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                DefaultXY_DataSet fakeXY = new DefaultXY_DataSet();
                fakeXY.set(0.0, -1.0);
                fakeXY.setName("Connection");
                funcs.add(fakeXY);
                double half = rateCPT.getMinValue() + 0.5 * (rateCPT.getMaxValue() - rateCPT.getMinValue());
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, rateCPT.getColor(half)));
                DefaultXY_DataSet zerosScatter = new DefaultXY_DataSet();
                zerosScatter.setName("Zero-Rate");
                funcs.add(zerosScatter);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, Color.GRAY));
                ArrayList<Double> fracts = new ArrayList<Double>();
                ArrayList<Double> detrendFracts = this.detrendProb == null ? null : new ArrayList<Double>();
                ArrayList<Double> scalarVals = new ArrayList<Double>();
                for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
                    double fract;
                    Jump jump = (Jump)cell.getColumnKey();
                    JumpRates rates = (JumpRates)cell.getValue();
                    double jumpRate = rates.magJumpRates[m];
                    double scalarVal = scalarJumpVals.get(jump);
                    double detrendFract = 0.0;
                    if (jumpRate == 0.0) {
                        fract = 0.0;
                        zerosScatter.set(scalarVal, yRange.getLowerBound());
                    } else {
                        double fromVal = rates.fromRates.sectRates[m];
                        double toVal = rates.toRates.sectRates[m];
                        double rate = combiner.combine(fromVal, toVal);
                        fract = jumpRate / rate;
                        Color c = rateCPT.getColor((float)Math.log10(rate));
                        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 200);
                        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
                        scatter.set(scalarVal, fract);
                        funcs.add(scatter);
                        chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, c));
                        funcs.add(scatter);
                        chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, scatterWidth, outlineColor));
                        if (this.detrendProb != null) {
                            double refProb = this.detrendProb.calcJumpProbability(null, jump, false);
                            detrendFract = Math.min(1.0, fract / refProb);
                        }
                    }
                    scalarTrack.addValue(scalarVal);
                    scalarVals.add(scalarVal);
                    fracts.add(fract);
                    if (this.detrendProb == null) continue;
                    detrendFracts.add(detrendFract);
                }
                if (m == 0) {
                    xRange = scalar.getPlotRange(scalarTrack.getMin(), scalarTrack.getMax());
                    marginalTakenHist = scalar.initHistogram(scalarTrack.getMin(), scalarTrack.getMax());
                    marginalAllHist = new HistogramFunction(((EvenlyDiscretizedFunc)marginalTakenHist).getMinX(), ((EvenlyDiscretizedFunc)marginalTakenHist).getMaxX(), ((EvenlyDiscretizedFunc)marginalTakenHist).size());
                    for (int i3 = 0; i3 < scalarVals.size(); ++i3) {
                        double val = (Double)scalarVals.get(i3);
                        if (!xRange.contains(val)) continue;
                        int ind = ((EvenlyDiscretizedFunc)marginalTakenHist).getClosestXIndex(val);
                        if ((Double)fracts.get(i3) > 0.0) {
                            ((EvenlyDiscretizedFunc)marginalTakenHist).add(ind, 1.0);
                        }
                        ((EvenlyDiscretizedFunc)marginalAllHist).add(ind, 1.0);
                    }
                }
                ArrayList valLists = new ArrayList();
                for (i2 = 0; i2 < ((EvenlyDiscretizedFunc)marginalTakenHist).size(); ++i2) {
                    valLists.add(new ArrayList());
                }
                for (i2 = 0; i2 < fracts.size(); ++i2) {
                    double scalarVal = (Double)scalarVals.get(i2);
                    double fract = (Double)fracts.get(i2);
                    if (!xRange.contains(scalarVal) || !Double.isFinite(fract)) continue;
                    int ind = ((EvenlyDiscretizedFunc)marginalTakenHist).getClosestXIndex(scalarVal);
                    ((List)valLists.get(ind)).add(fract);
                }
                DefaultXY_DataSet binnedMeans = new DefaultXY_DataSet();
                binnedMeans.setName("Mean");
                DefaultXY_DataSet binnedMedians = new DefaultXY_DataSet();
                binnedMedians.setName("Median");
                DefaultXY_DataSet probTaken = new DefaultXY_DataSet();
                probTaken.setName("P(>0)");
                for (i = 0; i < valLists.size(); ++i) {
                    List binnedVals = (List)valLists.get(i);
                    if (binnedVals.isEmpty()) continue;
                    double[] values = Doubles.toArray((Collection)binnedVals);
                    binnedMeans.set(((EvenlyDiscretizedFunc)marginalTakenHist).getX(i), StatUtils.mean((double[])values));
                    binnedMedians.set(((EvenlyDiscretizedFunc)marginalTakenHist).getX(i), DataUtils.median(values));
                    probTaken.set(((EvenlyDiscretizedFunc)marginalTakenHist).getX(i), ((EvenlyDiscretizedFunc)marginalTakenHist).getY(i) / ((EvenlyDiscretizedFunc)marginalAllHist).getY(i));
                }
                if (binnedMeans.size() == 0) {
                    binnedMeans.set(0.0, -1.0);
                    binnedMedians.set(0.0, -1.0);
                }
                if (zerosScatter.size() == 0) {
                    zerosScatter.set(0.0, -1.0);
                }
                funcs.add(binnedMeans);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 10.0f, new Color(0, 0, 0, 150)));
                funcs.add(binnedMedians);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_SQUARE, 10.0f, new Color(0, 0, 150, 150)));
                funcs.add(probTaken);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_TRIANGLE, 6.0f, new Color(150, 0, 0, 150)));
                if (this.detrendProb != null) {
                    valLists = new ArrayList();
                    for (i = 0; i < ((EvenlyDiscretizedFunc)marginalTakenHist).size(); ++i) {
                        valLists.add(new ArrayList());
                    }
                    for (i = 0; i < detrendFracts.size(); ++i) {
                        double scalarVal = (Double)scalarVals.get(i);
                        double fract = (Double)detrendFracts.get(i);
                        if (!xRange.contains(scalarVal) || !Double.isFinite(fract)) continue;
                        int ind = ((EvenlyDiscretizedFunc)marginalTakenHist).getClosestXIndex(scalarVal);
                        ((List)valLists.get(ind)).add(fract);
                    }
                    DefaultXY_DataSet detrendMeans = new DefaultXY_DataSet();
                    detrendMeans.setName("Detrended (" + this.detrendProb.getName() + ") Mean");
                    for (int i4 = 0; i4 < valLists.size(); ++i4) {
                        List binnedVals = (List)valLists.get(i4);
                        if (binnedVals.isEmpty()) continue;
                        double[] values = Doubles.toArray((Collection)binnedVals);
                        detrendMeans.set(((EvenlyDiscretizedFunc)marginalTakenHist).getX(i4), StatUtils.mean((double[])values));
                    }
                    if (detrendMeans.size() == 0) {
                        detrendMeans.set(0.0, -1.0);
                    }
                    if (zerosScatter.size() == 0) {
                        zerosScatter.set(0.0, -1.0);
                    }
                    funcs.add(detrendMeans);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 10.0f, new Color(0, 150, 150, 150)));
                }
                PlotSpec spec = new PlotSpec(funcs, chars, scalar.name + " Dependence", scalar.toString(), PASSTHROUGH_LABEL + " (Rel. " + String.valueOf((Object)combiner) + ")");
                spec.setLegendVisible(specs.isEmpty());
                specs.add(spec);
            }
            ArrayList<Range> xRanges = new ArrayList<Range>();
            xRanges.add(xRange);
            ArrayList<Range> yRanges = new ArrayList<Range>();
            for (int i = 0; i < specs.size(); ++i) {
                yRanges.add(yRange);
            }
            ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            marginalAllHist.setName("All Available Jumps");
            funcs.add(marginalAllHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GRAY));
            marginalTakenHist.setName("Taken Jumps");
            funcs.add(marginalTakenHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GREEN.darker()));
            PlotSpec marginalSpec = new PlotSpec(funcs, chars, scalar.name + " Dependence", scalar.toString(), "Marginal Count");
            marginalSpec.setLegendInset(true);
            marginalSpec.addSubtitle((Title)RupSetMapMaker.buildCPTLegend(rateCPT, "Log10 Rate (Denomiator)"));
            specs.add(marginalSpec);
            double maxMarginal = ((EvenlyDiscretizedFunc)marginalAllHist).getMaxY();
            maxMarginal = logY ? Math.max(10.0, Math.pow(10.0, Math.ceil(Math.log10(maxMarginal)))) : Math.max(10.0, maxMarginal * 1.05);
            yRanges.add(logY ? new Range(1.0, maxMarginal) : new Range(0.0, maxMarginal));
            System.out.println(SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + String.valueOf((Object)scalar) + ": " + String.valueOf(scalarTrack));
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(24);
            gp.setPlotLabelFontSize(24);
            gp.setLegendFontSize(this.legendFontSize);
            gp.setBackgroundColor(Color.WHITE);
            int width = 1000;
            int height = 300 + 400 * specs.size();
            gp.drawGraphPanel(specs, false, logY, xRanges, yRanges);
            int[] weights = new int[specs.size()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = i < specs.size() - 1 ? 5 : 3;
            }
            PlotUtils.setSubPlotWeights(gp, weights);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            gp.getChartPanel().setSize(width, height);
            gp.saveAsPNG(ret[m].getAbsolutePath());
            if (!WRITE_PDFS) continue;
            gp.saveAsPDF(ret[m].getAbsolutePath().replace(".png", ".pdf"));
        }
        return ret;
    }

    public File[][] plotMagScatters(File outputDir, String prefix, boolean logY, SlipRateSegmentationConstraint.RateCombiner ... combiners) throws IOException {
        File[][] ret = new File[this.minMags.length][this.minMags.length];
        for (int m1 = 0; m1 < this.minMags.length; ++m1) {
            for (int m2 = m1 + 1; m2 < this.minMags.length; ++m2) {
                ret[m1][m2] = this.plotMagScatter(outputDir, prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m1]) + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m2]), logY, m1, m2, combiners);
                ret[m2][m1] = ret[m1][m2];
            }
        }
        return ret;
    }

    public File plotMagScatter(File outputDir, String prefix, boolean log, int index1, int index2, SlipRateSegmentationConstraint.RateCombiner ... combiners) throws IOException {
        Range xRange;
        Preconditions.checkArgument((combiners.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 rate combiner");
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        Range yRange = xRange = log ? new Range(0.001, 1.0) : new Range(0.0, 1.0);
        for (SlipRateSegmentationConstraint.RateCombiner combiner : combiners) {
            DefaultXY_DataSet scatter = new DefaultXY_DataSet();
            for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
                Jump jump = (Jump)cell.getColumnKey();
                JumpRates rates = (JumpRates)cell.getValue();
                double jumpRate1 = rates.magJumpRates[index1];
                double fromVal1 = rates.fromRates.sectRates[index1];
                double toVal1 = rates.toRates.sectRates[index1];
                double fract1 = jumpRate1 / combiner.combine(fromVal1, toVal1);
                double jumpRate2 = rates.magJumpRates[index2];
                double fromVal2 = rates.fromRates.sectRates[index2];
                double toVal2 = rates.toRates.sectRates[index2];
                double fract2 = jumpRate2 / combiner.combine(fromVal2, toVal2);
                scatter.set(fract1, fract2);
            }
            ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
            oneToOne.set(xRange.getLowerBound(), xRange.getLowerBound());
            oneToOne.set(xRange.getUpperBound(), xRange.getUpperBound());
            funcs.add(oneToOne);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
            funcs.add(scatter);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, new Color(0, 0, 0, 127)));
            specs.add(new PlotSpec(funcs, chars, SegmentationCalculator.getMagLabel(this.minMags[index1]) + " vs " + SegmentationCalculator.getMagLabel(this.minMags[index2]), SegmentationCalculator.getMagLabel(this.minMags[index1]) + " " + PASSTHROUGH_LABEL, SegmentationCalculator.getMagLabel(this.minMags[index2]) + " " + PASSTHROUGH_LABEL + " (Rel. " + String.valueOf((Object)combiner) + ")"));
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setLegendFontSize(this.legendFontSize);
        gp.setBackgroundColor(Color.WHITE);
        int width = 1000;
        int height = 300 + 400 * specs.size();
        ArrayList<Range> xRanges = new ArrayList<Range>();
        xRanges.add(xRange);
        ArrayList<Range> yRanges = new ArrayList<Range>();
        for (int i = 0; i < specs.size(); ++i) {
            yRanges.add(yRange);
        }
        gp.drawGraphPanel(specs, log, log, xRanges, yRanges);
        File ret = new File(outputDir, prefix + ".png");
        gp.getChartPanel().setSize(width, height);
        gp.saveAsPNG(ret.getAbsolutePath());
        if (WRITE_PDFS) {
            gp.saveAsPDF(ret.getAbsolutePath().replace(".png", ".pdf"));
        }
        return ret;
    }

    public File[][] plotCombinerScatters(File outputDir, String prefix, boolean logY, int magIndex, SlipRateSegmentationConstraint.RateCombiner ... combiners) throws IOException {
        Preconditions.checkState((combiners.length > 1 ? 1 : 0) != 0);
        File[][] ret = new File[combiners.length][combiners.length];
        for (int c1 = 0; c1 < combiners.length; ++c1) {
            for (int c2 = c1 + 1; c2 < combiners.length; ++c2) {
                ret[c1][c2] = this.plotCombinerScatter(outputDir, prefix + "_" + combiners[c1].name() + "_" + combiners[c2].name(), logY, magIndex, combiners[c1], combiners[c2]);
                ret[c2][c1] = ret[c1][c2];
            }
        }
        return ret;
    }

    public File plotCombinerScatter(File outputDir, String prefix, boolean log, int magIndex, SlipRateSegmentationConstraint.RateCombiner combiner1, SlipRateSegmentationConstraint.RateCombiner combiner2) throws IOException {
        Range xRange;
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
            Jump jump = (Jump)cell.getColumnKey();
            JumpRates rates = (JumpRates)cell.getValue();
            double jumpRate = rates.magJumpRates[magIndex];
            double fromVal = rates.fromRates.sectRates[magIndex];
            double toVal = rates.toRates.sectRates[magIndex];
            double fract1 = jumpRate / combiner1.combine(fromVal, toVal);
            double fract2 = jumpRate / combiner2.combine(fromVal, toVal);
            scatter.set(fract1, fract2);
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        Range yRange = xRange = log ? new Range(0.001, 1.0) : new Range(0.0, 1.0);
        DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
        oneToOne.set(xRange.getLowerBound(), xRange.getLowerBound());
        oneToOne.set(xRange.getUpperBound(), xRange.getUpperBound());
        funcs.add(oneToOne);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        funcs.add(scatter);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, new Color(0, 0, 0, 127)));
        PlotSpec spec = new PlotSpec(funcs, chars, SegmentationCalculator.getMagLabel(this.minMags[magIndex]) + " Relative Rate Combiners: " + String.valueOf((Object)combiner1) + " vs " + String.valueOf((Object)combiner2), PASSTHROUGH_LABEL + " (Rel. " + String.valueOf((Object)combiner1) + ")", PASSTHROUGH_LABEL + " (Rel. " + String.valueOf((Object)combiner2) + ")");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setLegendFontSize(this.legendFontSize);
        gp.setBackgroundColor(Color.WHITE);
        int width = 1000;
        int height = 700;
        gp.drawGraphPanel(spec, log, log, xRange, yRange);
        File ret = new File(outputDir, prefix + ".png");
        gp.getChartPanel().setSize(width, height);
        gp.saveAsPNG(ret.getAbsolutePath());
        if (WRITE_PDFS) {
            gp.saveAsPDF(ret.getAbsolutePath().replace(".png", ".pdf"));
        }
        return ret;
    }

    public File[] plotDistDependComparison(File outputDir, String prefix, boolean logY, SlipRateSegmentationConstraint.RateCombiner combiner) throws IOException {
        String title = Scalars.JUMP_DIST.name + " Dependence";
        return this.plotDistDependComparison(outputDir, prefix, logY, combiner, title);
    }

    public File[] plotDistDependComparison(File outputDir, String prefix, boolean logY, SlipRateSegmentationConstraint.RateCombiner combiner, String title) throws IOException {
        File[] ret = new File[this.minMags.length];
        Range xRange = new Range(0.0, 15.0);
        Range yRange = logY ? new Range(0.001, 1.0) : new Range(0.0, 1.0);
        CPT rateCPT = SegmentationCalculator.getConnectionRateCPT();
        Color outlineColor = new Color(0, 0, 0, 100);
        float scatterWidth = 4.0f;
        Scalars scalar = Scalars.JUMP_DIST;
        Object yAxisLabel = PASSTHROUGH_LABEL;
        if (combiner == null) {
            combiner = SlipRateSegmentationConstraint.RateCombiner.MIN;
        } else {
            yAxisLabel = (String)yAxisLabel + " (Rel. " + String.valueOf((Object)combiner) + ")";
        }
        ArrayList<JumpProbabilityCalc.DistDependentJumpProbabilityCalc> comparisons = new ArrayList<JumpProbabilityCalc.DistDependentJumpProbabilityCalc>();
        ArrayList<String> compNames = new ArrayList<String>();
        LogicTreeBranch branch = this.sol.getModule(LogicTreeBranch.class);
        if (branch == null) {
            branch = this.sol.getRupSet().getModule(LogicTreeBranch.class);
        }
        JumpProbabilityCalc.DistDependentJumpProbabilityCalc chosenSegModel = null;
        if (branch != null) {
            SegmentationModelBranchNode segChoice = branch.getValue(SegmentationModelBranchNode.class);
            for (LogicTreeLevel level : branch.getLevels()) {
                Class segClass;
                if (!SegmentationModelBranchNode.class.isAssignableFrom(level.getType()) && !level.getType().equals(SegmentationModelBranchNode.class) || (segClass = level.getType()) == null || !segClass.isEnum() || !SegmentationModelBranchNode.class.isAssignableFrom(segClass)) continue;
                for (SegmentationModelBranchNode option : (SegmentationModelBranchNode[])segClass.getEnumConstants()) {
                    if (!(option.getNodeWeight(branch) > 0.0) && option != segChoice) continue;
                    try {
                        JumpProbabilityCalc model = option.getModel(this.sol.getRupSet(), branch);
                        if (!(model instanceof JumpProbabilityCalc.DistDependentJumpProbabilityCalc)) {
                            model = option.getModel(null, branch);
                        }
                        if (!(model instanceof JumpProbabilityCalc.DistDependentJumpProbabilityCalc)) continue;
                        JumpProbabilityCalc.DistDependentJumpProbabilityCalc distModel = (JumpProbabilityCalc.DistDependentJumpProbabilityCalc)model;
                        if (option == segChoice) {
                            chosenSegModel = distModel;
                        }
                        comparisons.add(distModel);
                        compNames.add(option.getShortName());
                    }
                    catch (Exception model) {
                        // empty catch block
                    }
                }
            }
        }
        if (comparisons.isEmpty()) {
            double[] r0s = new double[]{1.0, 2.0, 3.0, 4.0, 6.0};
            for (UnmodifiableIterator r0 : (UnmodifiableIterator)r0s) {
                Shaw07JumpDistProb comp = new Shaw07JumpDistProb(1.0, (double)r0);
                comparisons.add(comp);
                compNames.add(comp.getName());
            }
        }
        Color[] compColors = new Color[comparisons.size()];
        CPT r0cpt = new CPT(0.0, Double.max(1.0, comparisons.size() - 1), Color.RED, Color.BLUE);
        for (int c = 0; c < compColors.length; ++c) {
            compColors[c] = r0cpt.getColor(c);
        }
        ArrayList<EvenlyDiscretizedFunc> compCurves = new ArrayList<EvenlyDiscretizedFunc>();
        HistogramFunction histXVals = null;
        Map<Jump, Double> scalarJumpVals = this.calcJumpScalarValues(scalar);
        for (int m = 0; m < this.minMags.length; ++m) {
            DataUtils.MinMaxAveTracker scalarTrack = new DataUtils.MinMaxAveTracker();
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            if (m == 0) {
                compCurves = new ArrayList();
                for (int i = 0; i < comparisons.size(); ++i) {
                    JumpProbabilityCalc.DistDependentJumpProbabilityCalc prob = (JumpProbabilityCalc.DistDependentJumpProbabilityCalc)comparisons.get(i);
                    EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(xRange.getLowerBound(), xRange.getUpperBound(), 1000);
                    for (int j = 0; j < func.size(); ++j) {
                        func.set(j, prob.calcJumpProbability(func.getX(j)));
                    }
                    String name = (String)compNames.get(i);
                    if (i > 0) {
                        name = name.replaceAll("Shaw07", "").trim();
                    }
                    func.setName(name);
                    compCurves.add(func);
                }
            }
            XY_DataSet binnedMeans = null;
            XY_DataSet binnedMedians = null;
            CSVFile<String> csv = null;
            if (this.minMags[m] < 10.0) {
                int i;
                DefaultXY_DataSet fakeXY = new DefaultXY_DataSet();
                fakeXY.set(0.0, -1.0);
                fakeXY.setName("Connection");
                funcs.add(fakeXY);
                double half = rateCPT.getMinValue() + 0.5 * (rateCPT.getMaxValue() - rateCPT.getMinValue());
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, rateCPT.getColor(half)));
                DefaultXY_DataSet zerosScatter = new DefaultXY_DataSet();
                zerosScatter.setName("Zero-Rate");
                ArrayList<Double> fracts = new ArrayList<Double>();
                ArrayList<Double> detrendFracts = this.detrendProb == null ? null : new ArrayList<Double>();
                ArrayList<Double> scalarVals = new ArrayList<Double>();
                for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
                    double fract;
                    Jump jump = (Jump)cell.getColumnKey();
                    JumpRates rates = (JumpRates)cell.getValue();
                    double jumpRate = rates.magJumpRates[m];
                    double scalarVal = scalarJumpVals.get(jump);
                    if (jumpRate == 0.0) {
                        fract = 0.0;
                        zerosScatter.set(scalarVal, yRange.getLowerBound());
                    } else {
                        double fromVal = rates.fromRates.sectRates[m];
                        double toVal = rates.toRates.sectRates[m];
                        double rate = combiner.combine(fromVal, toVal);
                        fract = jumpRate / rate;
                        Preconditions.checkState((fract < 1.001 ? 1 : 0) != 0, (String)"Passthrough fraction is >1: %s\n\tjump=%s, fromVal=%s, toVal=%s, jumpRate=%s, combRate[%s]=%s", (Object[])new Object[]{fract, jump, fromVal, toVal, jumpRate, combiner, rate});
                        Color c = rateCPT.getColor((float)Math.log10(rate));
                        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 200);
                        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
                        scatter.set(scalarVal, fract);
                        funcs.add(scatter);
                        chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, c));
                        funcs.add(scatter);
                        chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, scatterWidth, outlineColor));
                        if (this.detrendProb != null) {
                            double refProb = this.detrendProb.calcJumpProbability(null, jump, false);
                            detrendFracts.add(Math.min(1.0, fract / refProb));
                        }
                    }
                    scalarTrack.addValue(scalarVal);
                    scalarVals.add(scalarVal);
                    fracts.add(fract);
                }
                if (m == 0) {
                    histXVals = scalar.initHistogram(scalarTrack.getMin(), scalarTrack.getMax());
                }
                ArrayList valLists = new ArrayList();
                for (i = 0; i < histXVals.size(); ++i) {
                    valLists.add(new ArrayList());
                }
                for (i = 0; i < fracts.size(); ++i) {
                    double scalarVal = (Double)scalarVals.get(i);
                    double fract = (Double)fracts.get(i);
                    if (!xRange.contains(scalarVal) || !Double.isFinite(fract)) continue;
                    int ind = histXVals.getClosestXIndex(scalarVal);
                    ((List)valLists.get(ind)).add(fract);
                }
                binnedMeans = new DefaultXY_DataSet();
                binnedMeans.setName("Mean");
                binnedMedians = new DefaultXY_DataSet();
                binnedMedians.setName("Median");
                csv = new CSVFile<String>(true);
                csv.addLine("Distance Bin Center (km)", "Mean Passthrough Rate", "Median Passthrough Rate");
                for (i = 0; i < valLists.size(); ++i) {
                    List binnedVals = (List)valLists.get(i);
                    if (binnedVals.isEmpty()) continue;
                    double[] values = Doubles.toArray((Collection)binnedVals);
                    double mean = StatUtils.mean((double[])values);
                    double median = DataUtils.median(values);
                    binnedMeans.set(histXVals.getX(i), mean);
                    binnedMedians.set(histXVals.getX(i), median);
                    ArrayList<CallSite> line = new ArrayList<CallSite>();
                    line.add((CallSite)((Object)("" + (float)histXVals.getX(i))));
                    line.add((CallSite)((Object)("" + mean)));
                    line.add((CallSite)((Object)("" + median)));
                    csv.addLine((List<String>)line);
                }
                if (zerosScatter.size() > 1) {
                    funcs.add(zerosScatter);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, Color.GRAY));
                }
            }
            funcs.addAll(compCurves);
            for (int i = 0; i < compColors.length; ++i) {
                if (comparisons.get(i) == chosenSegModel) {
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
                    continue;
                }
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, compColors[i]));
            }
            if (binnedMeans != null) {
                if (binnedMeans.size() > 0) {
                    funcs.add(binnedMeans);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 10.0f, new Color(0, 0, 0, 150)));
                }
                if (binnedMedians.size() > 0) {
                    funcs.add(binnedMedians);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_SQUARE, 10.0f, new Color(0, 0, 150, 150)));
                }
            }
            PlotSpec spec = new PlotSpec(funcs, chars, title, scalar.toString(), (String)yAxisLabel);
            spec.setLegendVisible(true);
            System.out.println(SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + String.valueOf((Object)scalar) + ": " + String.valueOf(scalarTrack));
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(24);
            gp.setAxisLabelFontSize(28);
            gp.setPlotLabelFontSize(28);
            gp.setLegendFontSize(this.legendFontSize);
            gp.setBackgroundColor(Color.WHITE);
            int width = 1000;
            int height = 800;
            gp.drawGraphPanel(spec, false, logY, xRange, yRange);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            gp.getChartPanel().setSize(width, height);
            gp.saveAsPNG(ret[m].getAbsolutePath());
            gp.saveAsPDF(ret[m].getAbsolutePath().replace(".png", ".pdf"));
            if (logY || csv == null) continue;
            csv.writeToFile(new File(outputDir, myPrefix + ".csv"));
        }
        return ret;
    }

    public void setLegendFontSize(int legendFontSize) {
        this.legendFontSize = legendFontSize;
    }

    public File[] plotMaxDistModelsComparison(File outputDir, String prefix, boolean logY, double targetR0, double a, SlipRateSegmentationConstraint.RateCombiner combiner) throws IOException {
        File[] ret = new File[this.minMags.length];
        Range xRange = null;
        Range yRange = logY ? new Range(0.001, 1.0) : new Range(0.0, 1.0);
        Range targetYRange = logY ? new Range(0.1, 10.0) : new Range(0.0, 5.0);
        CPT rateCPT = SegmentationCalculator.getConnectionRateCPT();
        Color outlineColor = new Color(0, 0, 0, 100);
        float scatterWidth = 4.0f;
        DefaultXY_DataSet stairStep = new DefaultXY_DataSet();
        MaxJumpDistModels[] maxDists = MaxJumpDistModels.values();
        double sumWeight = 0.0;
        double prevDist = Double.POSITIVE_INFINITY;
        int i = maxDists.length;
        while (--i >= 0) {
            double myDist = maxDists[i].getMaxDist();
            double weight = maxDists[i].getNodeWeight(null);
            if (sumWeight > 0.0) {
                stairStep.set(prevDist, sumWeight);
                stairStep.set(myDist, sumWeight);
            }
            sumWeight += weight;
            prevDist = myDist;
        }
        stairStep.set(prevDist, sumWeight);
        stairStep.set(0.0, sumWeight);
        EvenlyDiscretizedFunc target = null;
        DefaultXY_DataSet rev = new DefaultXY_DataSet();
        int i2 = stairStep.size();
        while (--i2 >= 0) {
            rev.set(stairStep.get(i2));
        }
        stairStep = rev;
        stairStep.setName("Inv. Cum. Weight");
        Scalars scalar = Scalars.JUMP_DIST;
        EvenlyDiscretizedFunc histXVals = null;
        Map<Jump, Double> scalarJumpVals = this.calcJumpScalarValues(scalar);
        Shaw07JumpDistProb prob = new Shaw07JumpDistProb(a, targetR0);
        for (int m = 0; m < this.minMags.length; ++m) {
            double y5;
            double y4;
            double y3;
            double y2;
            double y1;
            double y;
            double y6;
            int i3;
            DataUtils.MinMaxAveTracker scalarTrack = new DataUtils.MinMaxAveTracker();
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            ArrayList<AbstractXY_DataSet> targetRatioFuncs = new ArrayList<AbstractXY_DataSet>();
            ArrayList<PlotCurveCharacterstics> targetRatioChars = new ArrayList<PlotCurveCharacterstics>();
            DefaultXY_DataSet fakeXY = new DefaultXY_DataSet();
            fakeXY.set(0.0, -1.0);
            fakeXY.setName("Connection");
            funcs.add(fakeXY);
            double half = rateCPT.getMinValue() + 0.5 * (rateCPT.getMaxValue() - rateCPT.getMinValue());
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, rateCPT.getColor(half)));
            targetRatioFuncs.add(fakeXY);
            targetRatioChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, rateCPT.getMaxColor()));
            DefaultXY_DataSet zerosScatter = new DefaultXY_DataSet();
            zerosScatter.setName("Zero-Rate");
            funcs.add(zerosScatter);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, Color.GRAY));
            ArrayList<Double> fracts = new ArrayList<Double>();
            ArrayList<Double> detrendFracts = this.detrendProb == null ? null : new ArrayList<Double>();
            ArrayList<Double> scalarVals = new ArrayList<Double>();
            DefaultXY_DataSet allRatioScatter = new DefaultXY_DataSet();
            for (Table.Cell cell : this.parentJumpRateTable.cellSet()) {
                double fract;
                Jump jump = (Jump)cell.getColumnKey();
                JumpRates rates = (JumpRates)cell.getValue();
                double jumpRate = rates.magJumpRates[m];
                double scalarVal = scalarJumpVals.get(jump);
                if (jumpRate == 0.0) {
                    fract = 0.0;
                    zerosScatter.set(scalarVal, yRange.getLowerBound());
                } else {
                    double refProb;
                    double fromVal = rates.fromRates.sectRates[m];
                    double toVal = rates.toRates.sectRates[m];
                    double rate = combiner.combine(fromVal, toVal);
                    fract = jumpRate / rate;
                    Preconditions.checkState((fract < 1.001 ? 1 : 0) != 0, (String)"Passthrough fraction is >1: %s\n\tjump=%s, fromVal=%s, toVal=%s, jumpRate=%s, combRate[%s]=%s", (Object[])new Object[]{fract, jump, fromVal, toVal, jumpRate, combiner, rate});
                    Color c = rateCPT.getColor((float)Math.log10(rate));
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 200);
                    DefaultXY_DataSet scatter = new DefaultXY_DataSet();
                    scatter.set(scalarVal, fract);
                    funcs.add(scatter);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, c));
                    funcs.add(scatter);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, scatterWidth, outlineColor));
                    if (this.detrendProb != null) {
                        refProb = this.detrendProb.calcJumpProbability(null, jump, false);
                        detrendFracts.add(Math.min(1.0, fract / refProb));
                    }
                    refProb = prob.calcJumpProbability(scalarVal);
                    double ratio = fract / refProb;
                    allRatioScatter.set(scalarVal, ratio);
                    scatter = new DefaultXY_DataSet();
                    scatter.set(scalarVal, ratio);
                    targetRatioFuncs.add(scatter);
                    targetRatioChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, c));
                    targetRatioFuncs.add(scatter);
                    targetRatioChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, scatterWidth, outlineColor));
                }
                scalarTrack.addValue(scalarVal);
                scalarVals.add(scalarVal);
                fracts.add(fract);
            }
            if (m == 0) {
                xRange = scalar.getPlotRange(scalarTrack.getMin(), scalarTrack.getMax());
                target = new EvenlyDiscretizedFunc(xRange.getLowerBound(), xRange.getUpperBound(), 1000);
                for (int j = 0; j < target.size(); ++j) {
                    target.set(j, prob.calcJumpProbability(target.getX(j)));
                }
                target.setName(prob.getName());
                histXVals = scalar.initHistogram(scalarTrack.getMin(), scalarTrack.getMax());
            }
            ArrayList valLists = new ArrayList();
            for (i3 = 0; i3 < histXVals.size(); ++i3) {
                valLists.add(new ArrayList());
            }
            for (i3 = 0; i3 < fracts.size(); ++i3) {
                double scalarVal = (Double)scalarVals.get(i3);
                double fract = (Double)fracts.get(i3);
                if (!xRange.contains(scalarVal) || !Double.isFinite(fract)) continue;
                int ind = histXVals.getClosestXIndex(scalarVal);
                ((List)valLists.get(ind)).add(fract);
            }
            DefaultXY_DataSet binnedMeans = new DefaultXY_DataSet();
            binnedMeans.setName("Mean");
            DefaultXY_DataSet binnedMedians = new DefaultXY_DataSet();
            binnedMedians.setName("Median");
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Distance Bin Center (km)", "Mean Passthrough Rate", "Median Passthrough Rate");
            for (int i4 = 0; i4 < valLists.size(); ++i4) {
                List binnedVals = (List)valLists.get(i4);
                if (binnedVals.isEmpty()) continue;
                double[] values = Doubles.toArray((Collection)binnedVals);
                double mean = StatUtils.mean((double[])values);
                double median = DataUtils.median(values);
                binnedMeans.set(histXVals.getX(i4), mean);
                binnedMedians.set(histXVals.getX(i4), median);
                ArrayList<CallSite> line = new ArrayList<CallSite>();
                line.add((CallSite)((Object)("" + (float)histXVals.getX(i4))));
                line.add((CallSite)((Object)("" + mean)));
                line.add((CallSite)((Object)("" + median)));
                csv.addLine((List<String>)line);
            }
            if (binnedMeans.size() == 0) {
                binnedMeans.set(0.0, -1.0);
                binnedMedians.set(0.0, -1.0);
            }
            if (zerosScatter.size() == 0) {
                zerosScatter.set(0.0, -1.0);
            }
            funcs.add(target);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
            funcs.add(binnedMeans);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 10.0f, new Color(0, 0, 0, 150)));
            funcs.add(binnedMedians);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_SQUARE, 10.0f, new Color(0, 0, 150, 150)));
            funcs.add(stairStep);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, Color.DARK_GRAY));
            PlotSpec spec = new PlotSpec(funcs, chars, scalar.name + " Max-Dist Comparison", scalar.toString(), PASSTHROUGH_LABEL + " (Rel. " + String.valueOf((Object)combiner) + ")");
            spec.setLegendVisible(true);
            System.out.println(SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + String.valueOf((Object)scalar) + ": " + String.valueOf(scalarTrack));
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(24);
            gp.setPlotLabelFontSize(24);
            gp.setLegendFontSize(this.legendFontSize);
            gp.setBackgroundColor(Color.WHITE);
            int width = 1000;
            int height = 800;
            gp.drawGraphPanel(spec, false, logY, xRange, yRange);
            String myPrefix = prefix + "_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            gp.getChartPanel().setSize(width, height);
            gp.saveAsPNG(ret[m].getAbsolutePath());
            if (WRITE_PDFS) {
                gp.saveAsPDF(ret[m].getAbsolutePath().replace(".png", ".pdf"));
            }
            if (!logY) {
                csv.writeToFile(new File(outputDir, myPrefix + ".csv"));
            }
            prevDist = 0.0;
            DefaultXY_DataSet normScatter = new DefaultXY_DataSet();
            DefaultXY_DataSet normNoZeroScatter = new DefaultXY_DataSet();
            DefaultXY_DataSet normAbove1Scatter = new DefaultXY_DataSet();
            double zeroThreshold = 0.05;
            for (MaxJumpDistModels maxDist : MaxJumpDistModels.values()) {
                double dist = maxDist.getMaxDist();
                if ((float)dist < (float)xRange.getUpperBound()) {
                    DefaultXY_DataSet line = new DefaultXY_DataSet();
                    line.set(dist, targetYRange.getLowerBound());
                    line.set(dist, targetYRange.getUpperBound());
                    targetRatioFuncs.add(0, line);
                    targetRatioChars.add(0, new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, Color.DARK_GRAY));
                }
                SimpleRegression regression = new SimpleRegression();
                for (Point2D pt : allRatioScatter) {
                    if (!(pt.getX() >= prevDist) || !(pt.getX() <= dist)) continue;
                    y6 = logY ? Math.log10(pt.getY()) : pt.getY();
                    regression.addData(pt.getX(), y6);
                    double normX = (pt.getX() - prevDist) / (dist - prevDist);
                    normScatter.set(normX, pt.getY());
                    if (pt.getX() >= zeroThreshold) {
                        normNoZeroScatter.set(normX, pt.getY());
                    }
                    if (!(pt.getX() >= 1.0)) continue;
                    normAbove1Scatter.set(normX, pt.getY());
                }
                double intercept = regression.getIntercept();
                double slope = regression.getSlope();
                EvenlyDiscretizedFunc fit = new EvenlyDiscretizedFunc(prevDist, dist, 10);
                for (int i5 = 0; i5 < fit.size(); ++i5) {
                    double x = fit.getX(i5);
                    double y7 = slope * x + intercept;
                    if (logY) {
                        y7 = Math.pow(10.0, y7);
                    }
                    fit.set(x, y7);
                }
                targetRatioFuncs.add(fit);
                targetRatioChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
                if (prevDist == 0.0) {
                    fit.setName("Ordinary Least Squares Regression");
                }
                prevDist = dist;
            }
            spec = new PlotSpec(targetRatioFuncs, targetRatioChars, scalar.name + " Bias", scalar.toString(), "Ratio to Target");
            spec.setLegendVisible(true);
            System.out.println(SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + String.valueOf((Object)scalar) + ": " + String.valueOf(scalarTrack));
            gp.drawGraphPanel(spec, false, logY, xRange, targetYRange);
            myPrefix = prefix + "_ratios_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            gp.getChartPanel().setSize(width, height);
            gp.saveAsPNG(ret[m].getAbsolutePath());
            if (WRITE_PDFS) {
                gp.saveAsPDF(ret[m].getAbsolutePath().replace(".png", ".pdf"));
            }
            funcs = new ArrayList();
            chars = new ArrayList();
            XY_DataSet clone = normScatter.deepClone();
            normScatter.setName("<1 km Points");
            funcs.add(normScatter);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, Color.LIGHT_GRAY));
            normAbove1Scatter.setName(">1 km Points");
            funcs.add(normAbove1Scatter);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, scatterWidth, Color.BLUE.brighter()));
            funcs.add(clone);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, scatterWidth, outlineColor));
            SimpleRegression regression = new SimpleRegression();
            for (Point2D pt : normScatter) {
                double y8 = logY ? Math.log10(pt.getY()) : pt.getY();
                regression.addData(pt.getX(), y8);
            }
            double intercept = regression.getIntercept();
            double slope = regression.getSlope();
            EvenlyDiscretizedFunc fit = new EvenlyDiscretizedFunc(0.0, 1.0, 10);
            for (int i6 = 0; i6 < fit.size(); ++i6) {
                double x = fit.getX(i6);
                y = slope * x + intercept;
                if (logY) {
                    y = Math.pow(10.0, y);
                }
                fit.set(x, y);
            }
            fit.setName("Ordinary Least Squares Regression");
            funcs.add(fit);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
            regression = new SimpleRegression();
            for (Point2D pt : normAbove1Scatter) {
                y6 = logY ? Math.log10(pt.getY()) : pt.getY();
                regression.addData(pt.getX(), y6);
            }
            intercept = regression.getIntercept();
            slope = regression.getSlope();
            fit = new EvenlyDiscretizedFunc(0.0, 1.0, 10);
            for (int i7 = 0; i7 < fit.size(); ++i7) {
                double x = fit.getX(i7);
                y = slope * x + intercept;
                if (logY) {
                    y = Math.pow(10.0, y);
                }
                fit.set(x, y);
            }
            fit.setName(">1 km Regression");
            funcs.add(fit);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GREEN.darker()));
            spec = new PlotSpec(funcs, chars, scalar.name + " Normalized Bias", "Normalized Jump Distance Within Bin", "Ratio to Target");
            spec.setLegendVisible(true);
            DataUtils.MinMaxAveTracker topHalfTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker botHalfTrack = new DataUtils.MinMaxAveTracker();
            for (Point2D pt : normScatter) {
                if (pt.getX() > 0.5) {
                    topHalfTrack.addValue(pt.getY());
                    continue;
                }
                botHalfTrack.addValue(pt.getY());
            }
            DataUtils.MinMaxAveTracker topHalfAbove1Track = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker botHalfAbove1Track = new DataUtils.MinMaxAveTracker();
            for (Point2D pt : normAbove1Scatter) {
                if (pt.getX() > 0.5) {
                    topHalfAbove1Track.addValue(pt.getY());
                    continue;
                }
                botHalfAbove1Track.addValue(pt.getY());
            }
            DataUtils.MinMaxAveTracker topQuarterTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker botQuarterTrack = new DataUtils.MinMaxAveTracker();
            for (Point2D pt : normScatter) {
                if (pt.getX() > 0.75) {
                    topQuarterTrack.addValue(pt.getY());
                    continue;
                }
                if (!(pt.getX() < 0.25)) continue;
                botQuarterTrack.addValue(pt.getY());
            }
            DataUtils.MinMaxAveTracker topQuarterAbove1Track = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker botQuarterAbove1Track = new DataUtils.MinMaxAveTracker();
            for (Point2D pt : normAbove1Scatter) {
                if (pt.getX() > 0.75) {
                    topQuarterAbove1Track.addValue(pt.getY());
                    continue;
                }
                if (!(pt.getX() < 0.25)) continue;
                botQuarterAbove1Track.addValue(pt.getY());
            }
            if (logY) {
                y1 = 9.0;
                y2 = 7.5;
                y3 = 5.8;
                y4 = 4.0;
                y5 = 2.0;
            } else {
                y1 = 4.9;
                y2 = 4.7;
                y3 = 4.5;
                y4 = 4.3;
                y5 = 4.1;
            }
            DecimalFormat df = new DecimalFormat("0.00");
            Font font = new Font("SansSerif", 1, 18);
            XYTextAnnotation ann = new XYTextAnnotation("Gain Factors, Right vs Left", 0.5, y1);
            ann.setFont(font);
            ann.setTextAnchor(TextAnchor.TOP_CENTER);
            spec.addPlotAnnotation((XYAnnotation)ann);
            double halfGain = topHalfTrack.getAverage() / botHalfTrack.getAverage();
            ann = new XYTextAnnotation("Right Half / Left: " + df.format(topHalfTrack.getAverage()) + " / " + df.format(botHalfTrack.getAverage()) + " = " + df.format(halfGain), 0.5, y2);
            ann.setFont(font);
            ann.setTextAnchor(TextAnchor.TOP_CENTER);
            spec.addPlotAnnotation((XYAnnotation)ann);
            double quarterGain = topQuarterTrack.getAverage() / botQuarterTrack.getAverage();
            ann = new XYTextAnnotation("Right Quarter / Left: " + df.format(topQuarterTrack.getAverage()) + " / " + df.format(botQuarterTrack.getAverage()) + " = " + df.format(quarterGain), 0.5, y3);
            ann.setFont(font);
            ann.setTextAnchor(TextAnchor.TOP_CENTER);
            spec.addPlotAnnotation((XYAnnotation)ann);
            halfGain = topHalfAbove1Track.getAverage() / botHalfAbove1Track.getAverage();
            ann = new XYTextAnnotation(">1 km Right Half / Left: " + df.format(topHalfAbove1Track.getAverage()) + " / " + df.format(botHalfAbove1Track.getAverage()) + " = " + df.format(halfGain), 0.5, y4);
            ann.setFont(font);
            ann.setTextAnchor(TextAnchor.TOP_CENTER);
            spec.addPlotAnnotation((XYAnnotation)ann);
            quarterGain = topQuarterAbove1Track.getAverage() / botQuarterAbove1Track.getAverage();
            ann = new XYTextAnnotation(">1 km Right Quarter / Left: " + df.format(topQuarterAbove1Track.getAverage()) + " / " + df.format(botQuarterAbove1Track.getAverage()) + " = " + df.format(quarterGain), 0.5, y5);
            ann.setFont(font);
            ann.setTextAnchor(TextAnchor.TOP_CENTER);
            spec.addPlotAnnotation((XYAnnotation)ann);
            System.out.println(SegmentationCalculator.getMagLabel(this.minMags[m]) + " " + String.valueOf((Object)scalar) + ": " + String.valueOf(scalarTrack));
            gp.drawGraphPanel(spec, false, logY, new Range(0.0, 1.0), targetYRange);
            myPrefix = prefix + "_ratios_norm_" + SegmentationCalculator.getMagPrefix(this.minMags[m]);
            ret[m] = new File(outputDir, myPrefix + ".png");
            gp.getChartPanel().setSize(width, height);
            gp.saveAsPNG(ret[m].getAbsolutePath());
            if (!WRITE_PDFS) continue;
            gp.saveAsPDF(ret[m].getAbsolutePath().replace(".png", ".pdf"));
        }
        return ret;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File inputFile = new File("/tmp/solution.zip");
        FaultSystemSolution sol = FaultSystemSolution.load(inputFile);
        ClusterRuptures cRups = ClusterRuptures.singleStranged(sol.getRupSet());
        PlausibilityConfiguration config = sol.getRupSet().getModule(PlausibilityConfiguration.class);
        ClusterConnectionStrategy connStrat = config.getConnectionStrategy();
        SegmentationCalculator calc = new SegmentationCalculator(sol, cRups.getAll(), connStrat, config.getDistAzCalc(), new double[]{0.0});
        calc = calc.combineMultiJumps(true);
        File outputDir = new File("/tmp");
        calc.plotDistDependComparison(outputDir, "shaw_test", true, SlipRateSegmentationConstraint.RateCombiner.MIN);
    }

    private class JumpingPointRates {
        public final FaultSection sect;
        public final double[] parentSectRates;
        public final double[] sectRates;
        public final double rupSetSlipRate;
        public final double solSlipRate;

        private JumpingPointRates(FaultSection sect) {
            this(sect, segmentationCalculator.parentParticRates.get(sect.getParentSectionId()), segmentationCalculator.sectParticRates[sect.getSectionId()]);
        }

        private JumpingPointRates(FaultSection sect, double[] parentSectRates, double[] sectRates) {
            this.sect = sect;
            this.parentSectRates = parentSectRates;
            this.sectRates = sectRates;
            FaultSystemRupSet rupSet = SegmentationCalculator.this.sol.getRupSet();
            this.rupSetSlipRate = rupSet.getSlipRateForSection(sect.getSectionId());
            this.solSlipRate = rupSet.hasModule(SlipAlongRuptureModel.class) && rupSet.hasModule(AveSlipModule.class) ? rupSet.getModule(SlipAlongRuptureModel.class).calcSlipRateForSects(SegmentationCalculator.this.sol, rupSet.requireModule(AveSlipModule.class))[sect.getSectionId()] : Double.NaN;
        }

        public JumpingPointRates(FaultSection sect, double[] parentSectRates, double[] sectRates, double rupSetSlipRate, double solSlipRate) {
            this.sect = sect;
            this.parentSectRates = parentSectRates;
            this.sectRates = sectRates;
            this.rupSetSlipRate = rupSetSlipRate;
            this.solSlipRate = solSlipRate;
        }
    }

    private class JumpRates {
        public final JumpingPointRates fromRates;
        public final JumpingPointRates toRates;
        public final double[] magJumpRates;
        private double sumRate;
        private double sumRateDist;
        private HashSet<Integer> rupIndexes;
        public final AzTracker fromAzTrack;
        public final AzTracker toAzTrack;

        public JumpRates(JumpingPointRates fromRates, JumpingPointRates toRates) {
            this(fromRates, segmentationCalculator.new AzTracker(), toRates, segmentationCalculator.new AzTracker(), new double[segmentationCalculator.minMags.length]);
        }

        public JumpRates(JumpingPointRates fromRates, AzTracker fromAzTrack, JumpingPointRates toRates, AzTracker toAzTrack, double[] magJumpRates) {
            this.fromRates = fromRates;
            this.fromAzTrack = fromAzTrack;
            this.toRates = toRates;
            this.toAzTrack = toAzTrack;
            this.magJumpRates = magJumpRates;
            this.rupIndexes = new HashSet();
        }

        public void addRate(int rupIndex, double distance) {
            double rate = SegmentationCalculator.this.sol.getRateForRup(rupIndex);
            double mag = SegmentationCalculator.this.sol.getRupSet().getMagForRup(rupIndex);
            this.sumRate += rate;
            this.sumRateDist += rate * distance;
            SegmentationCalculator.this.addMagRate(this.magJumpRates, mag, rate);
            this.rupIndexes.add(rupIndex);
        }

        public double getRateWeightedDistance() {
            return this.sumRateDist / this.sumRate;
        }

        public void addAzimuiths(Jump jump, FaultSubsectionCluster fullFrom, FaultSubsectionCluster fullTo, double rate) {
            Boolean toForward;
            Boolean fromForward = this.calcDirection(jump.fromSection, jump.fromCluster, fullFrom);
            if (fromForward != null) {
                if (fromForward.booleanValue()) {
                    this.fromAzTrack.forwardRate += rate;
                } else {
                    this.fromAzTrack.backwardRate += rate;
                }
            }
            if ((toForward = this.calcDirection(jump.toSection, jump.toCluster, fullTo)) != null) {
                if (toForward.booleanValue()) {
                    this.toAzTrack.forwardRate += rate;
                } else {
                    this.toAzTrack.backwardRate += rate;
                }
            }
        }

        private Boolean calcDirection(FaultSection initialSect, FaultSubsectionCluster jumpCluster, FaultSubsectionCluster fullCluster) {
            int i;
            int ind = fullCluster.subSects.indexOf((Object)initialSect);
            Preconditions.checkState((ind >= 0 ? 1 : 0) != 0);
            int numForward = 0;
            int numBackward = 0;
            for (i = ind + 1; i < fullCluster.subSects.size() && jumpCluster.contains((FaultSection)fullCluster.subSects.get(i)); ++i) {
                ++numForward;
            }
            i = ind;
            while (--i >= 0 && jumpCluster.contains((FaultSection)fullCluster.subSects.get(i))) {
                ++numBackward;
            }
            if (numForward == numBackward) {
                return null;
            }
            return numForward > numBackward;
        }
    }

    private class AzTracker {
        private double forwardRate = 0.0;
        private double backwardRate = 0.0;

        private AzTracker() {
        }
    }

    private class ScalarCalcCallable
    implements Callable<ScalarCalcCallable> {
        private final Scalars scalar;
        private final Jump jump;
        private final JumpRates rates;
        private final SubSectStiffnessCalculator stiffnessCalc;
        private double value;

        public ScalarCalcCallable(Scalars scalar, Jump jump, JumpRates rates, SubSectStiffnessCalculator stiffnessCalc) {
            this.scalar = scalar;
            this.jump = jump;
            this.rates = rates;
            this.stiffnessCalc = stiffnessCalc;
        }

        @Override
        public ScalarCalcCallable call() throws Exception {
            this.value = this.scalar.calc(this.jump, this.rates, SegmentationCalculator.this.distAzCalc, this.stiffnessCalc);
            return this;
        }
    }

    public static enum Scalars {
        JUMP_DIST("Jump Distance", "km"){

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                double rateAvgDist = rates.getRateWeightedDistance();
                if (Double.isFinite(rateAvgDist)) {
                    return rateAvgDist;
                }
                return jump.distance;
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, 15.0);
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                return new HistogramFunction(0.5, 15, 1.0);
            }
        }
        ,
        SLIP_RATE_CHANGE("|Slip Rate Change|", "mm/yr"){

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                return Math.abs(1000.0 * rates.fromRates.rupSetSlipRate - 1000.0 * rates.toRates.rupSetSlipRate);
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, Math.max(50.0, 10.0 * Math.ceil(maxVal / 10.0)));
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                Range range = this.getPlotRange(minVal, maxVal);
                double delta = range.getLength() > 40.0 ? 5.0 : (range.getLength() > 20.0 ? 2.0 : 1.0);
                return HistogramFunction.getEncompassingHistogram(0.0, range.getUpperBound(), delta);
            }
        }
        ,
        MIN_SLIP_RATE("Slip Rate Ratio", "mm/yr"){

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                double slip1 = 1000.0 * rates.fromRates.rupSetSlipRate;
                double slip2 = 1000.0 * rates.toRates.rupSetSlipRate;
                if (slip1 < slip2) {
                    double tmp = slip1;
                    slip1 = slip2;
                    slip2 = tmp;
                }
                return slip1 / slip2;
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(1.0, Math.max(10.0, Math.min(1000.0, 10.0 * Math.ceil(maxVal / 10.0))));
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                Range range = this.getPlotRange(minVal, maxVal);
                double delta = range.getLength() > 200.0 ? 10.0 : (range.getLength() > 50.0 ? 5.0 : (range.getLength() > 20.0 ? 2.0 : 1.0));
                return HistogramFunction.getEncompassingHistogram(0.0, range.getUpperBound(), delta);
            }
        }
        ,
        DIP_CHANGE("|Dip Change|", "degrees"){

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                return Math.abs(jump.fromSection.getAveDip() - jump.toSection.getAveDip());
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, Math.max(60.0, 10.0 * Math.ceil(maxVal / 10.0)));
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                Range range = this.getPlotRange(minVal, maxVal);
                double delta = range.getLength() > 30.0 ? 5.0 : (range.getLength() > 10.0 ? 2.0 : 1.0);
                return HistogramFunction.getEncompassingHistogram(0.0, range.getUpperBound(), delta);
            }
        }
        ,
        RAKE_CHANGE("|Rake Change|", "degrees"){

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                double rakeDiff = Math.abs(rates.fromRates.sect.getAveRake() - rates.toRates.sect.getAveRake());
                if (rakeDiff > 180.0) {
                    rakeDiff = 360.0 - rakeDiff;
                }
                Preconditions.checkState((rakeDiff >= 0.0 ? 1 : 0) != 0);
                return rakeDiff;
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, 180.0);
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                return new HistogramFunction(5.0, 18, 10.0);
            }
        }
        ,
        AZIMUTH_CHANGE("|Azimuth Change|", "degrees"){

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                double az1 = this.calcAzimuth(jump.fromSection, (List<? extends FaultSection>)jump.fromCluster.subSects, rates.fromAzTrack, distAzCalc, true);
                double az2 = this.calcAzimuth(jump.toSection, (List<? extends FaultSection>)jump.toCluster.subSects, rates.toAzTrack, distAzCalc, false);
                return JumpAzimuthChangeFilter.getAzimuthDifference(az1, az2);
            }

            private double calcAzimuth(FaultSection sect, List<? extends FaultSection> subSects, AzTracker azTrack, SectionDistanceAzimuthCalculator distAzCalc, boolean reverse) {
                FaultSection nextSect;
                int ind = subSects.indexOf(sect);
                Preconditions.checkState((ind >= 0 ? 1 : 0) != 0);
                if (azTrack.forwardRate == azTrack.backwardRate) {
                    return Double.NaN;
                }
                if (azTrack.forwardRate > azTrack.backwardRate) {
                    if (ind == subSects.size() - 1) {
                        return Double.NaN;
                    }
                    nextSect = subSects.get(ind + 1);
                } else {
                    if (ind == 0) {
                        return Double.NaN;
                    }
                    nextSect = subSects.get(ind - 1);
                }
                if (reverse) {
                    return distAzCalc.getAzimuth(nextSect, sect);
                }
                return distAzCalc.getAzimuth(sect, nextSect);
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, 180.0);
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                return new HistogramFunction(5.0, 18, 10.0);
            }
        }
        ,
        CFF_FRACT_POSITIVE("Best Directional Fract \u0394CFF>0", null){
            private AggregatedStiffnessCalculator aggCalc = null;

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                if (this.aggCalc == null) {
                    this.aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, false, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.NORM_BY_COUNT);
                }
                return SegmentationCalculator.bestDirectionalValue(this.aggCalc, jump);
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, 1.0);
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                return new HistogramFunction(0.025, 20, 0.05);
            }
        }
        ,
        CFF_FRACT_RPATCH_POSITIVE("Best Directional Fract RPatch \u0394CFF>0", null){
            private AggregatedStiffnessCalculator aggCalc = null;

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                if (this.aggCalc == null) {
                    this.aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.PASSTHROUGH, AggregatedStiffnessCalculator.AggregationMethod.RECEIVER_SUM, AggregatedStiffnessCalculator.AggregationMethod.FRACT_POSITIVE);
                }
                return SegmentationCalculator.bestDirectionalValue(this.aggCalc, jump);
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, 1.0);
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                return new HistogramFunction(0.025, 20, 0.05);
            }
        }
        ,
        CFF_SUM("Best Directional Sum \u0394CFF", "MPa"){
            private AggregatedStiffnessCalculator aggCalc = null;

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                if (this.aggCalc == null) {
                    this.aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, false, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
                }
                return SegmentationCalculator.bestDirectionalValue(this.aggCalc, jump);
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                maxVal = Math.min(100.0, Math.pow(10.0, Math.ceil(Math.log10(maxVal))));
                minVal = minVal > 0.0 ? 0.0 : -Math.min(100.0, Math.pow(10.0, Math.ceil(Math.log10(-minVal))));
                return new Range(minVal, maxVal);
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                Range range = this.getPlotRange(minVal, maxVal);
                double delta = range.getLength() >= 100.0 ? 5.0 : (range.getLength() >= 10.0 ? 1.0 : (range.getLength() >= 5.0 ? 0.5 : 0.1));
                return HistogramFunction.getEncompassingHistogram(range.getLowerBound(), range.getUpperBound(), delta);
            }
        }
        ,
        CFF_MAX("Max \u0394CFF", "MPa"){
            private AggregatedStiffnessCalculator aggCalc = null;

            @Override
            public double calc(Jump jump, JumpRates rates, SectionDistanceAzimuthCalculator distAzCalc, SubSectStiffnessCalculator stiffnessCalc) {
                if (this.aggCalc == null) {
                    this.aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, false, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.MAX, AggregatedStiffnessCalculator.AggregationMethod.MAX, AggregatedStiffnessCalculator.AggregationMethod.MAX);
                }
                return Math.max(this.aggCalc.calc((Collection<? extends FaultSection>)jump.fromCluster.subSects, (Collection<? extends FaultSection>)jump.toCluster.subSects), this.aggCalc.calc((Collection<? extends FaultSection>)jump.toCluster.subSects, (Collection<? extends FaultSection>)jump.fromCluster.subSects));
            }

            @Override
            public Range getPlotRange(double minVal, double maxVal) {
                return new Range(0.0, Math.min(100.0, 10.0 * Math.ceil(0.1 * maxVal)));
            }

            @Override
            public HistogramFunction initHistogram(double minVal, double maxVal) {
                Range range = this.getPlotRange(minVal, maxVal);
                double delta = range.getLength() >= 100.0 ? 5.0 : (range.getLength() >= 50.0 ? 2.0 : (range.getLength() >= 10.0 ? 1.0 : (range.getLength() >= 5.0 ? 0.5 : 0.1)));
                return HistogramFunction.getEncompassingHistogram(0.0, range.getUpperBound(), delta);
            }
        };

        private String name;
        private String units;

        private Scalars(String name, String units) {
            this.name = name;
            this.units = units;
        }

        public abstract double calc(Jump var1, JumpRates var2, SectionDistanceAzimuthCalculator var3, SubSectStiffnessCalculator var4);

        public abstract Range getPlotRange(double var1, double var3);

        public abstract HistogramFunction initHistogram(double var1, double var3);

        public String toString() {
            Object ret = this.name;
            if (this.units != null && !this.units.isEmpty()) {
                ret = (String)ret + " (" + this.units + ")";
            }
            return ret;
        }
    }
}

