/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectIDRange;
import org.opensha.sha.faultSurface.FaultSection;

public class UniqueRupture {
    private final SectIDRange[] ranges;
    private int size;
    private static final Comparator<SectIDRange> containsCompare = new Comparator<SectIDRange>(){

        @Override
        public int compare(SectIDRange o1, SectIDRange o2) {
            if (o1.size() == 1 && o2.contains(o1.getStartID()) || o2.size() == 1 && o1.contains(o2.getStartID())) {
                return 0;
            }
            return Integer.compare(o1.getStartID(), o2.getStartID());
        }
    };
    private int hashCode = -1;

    public static UniqueRupture forIDs(Collection<Integer> sectIDs) {
        return new Builder().add(sectIDs).build();
    }

    public static UniqueRupture forSects(Collection<? extends FaultSection> sects) {
        ArrayList<Integer> ids = new ArrayList<Integer>(sects.size());
        for (FaultSection faultSection : sects) {
            ids.add(faultSection.getSectionId());
        }
        return new Builder().add(ids).build();
    }

    public static UniqueRupture forClusters(FaultSubsectionCluster ... clusters) {
        Builder builder = new Builder();
        for (FaultSubsectionCluster cluster : clusters) {
            for (SectIDRange range : cluster.unique.ranges) {
                builder.add(range);
            }
        }
        return builder.build();
    }

    public static UniqueRupture add(UniqueRupture ... uniques) {
        Builder builder = new Builder();
        for (UniqueRupture unique : uniques) {
            for (SectIDRange range : unique.ranges) {
                builder.add(range);
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private UniqueRupture(SectIDRange[] ranges, int size) {
        this.ranges = ranges;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int id) {
        if (this.ranges.length == 0) {
            return false;
        }
        if (this.ranges.length == 1) {
            return this.ranges[0].contains(id);
        }
        int index = Arrays.binarySearch(this.ranges, SectIDRange.build(id, id), containsCompare);
        return index >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.hashCode == -1) {
            UniqueRupture uniqueRupture = this;
            synchronized (uniqueRupture) {
                if (this.hashCode == -1) {
                    int prime = 31;
                    int result = 1;
                    for (SectIDRange range : this.ranges) {
                        result = 31 * result + (range == null ? 0 : range.hashCode());
                    }
                    this.hashCode = result;
                }
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueRupture other = (UniqueRupture)obj;
        if (this.size != other.size) {
            return false;
        }
        return !(this.ranges == null ? other.ranges != null : !Arrays.equals(this.ranges, other.ranges));
    }

    public SectIDRange[] getRanges() {
        return Arrays.copyOf(this.ranges, this.ranges.length);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("UniqueRupture(size=" + this.size + "): ");
        for (int i = 0; i < this.ranges.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.ranges[i]);
        }
        return str.toString();
    }

    public static class Builder {
        private List<SectIDRange> list = new ArrayList<SectIDRange>();
        private int size = 0;

        private Builder() {
        }

        private int insertionIndex(SectIDRange range) {
            int index = Collections.binarySearch(this.list, range);
            if (index < 0) {
                index = -(index + 1);
            }
            return index;
        }

        private boolean contiguous(List<Integer> ids, boolean increasing) {
            if (increasing) {
                int prev = ids.get(0);
                for (int i = 1; i < ids.size(); ++i) {
                    int cur = ids.get(i);
                    if (cur != prev + 1) {
                        return false;
                    }
                    prev = cur;
                }
                return true;
            }
            int prev = ids.get(0);
            for (int i = 1; i < ids.size(); ++i) {
                int cur = ids.get(i);
                if (cur != prev - 1) {
                    return false;
                }
                prev = cur;
            }
            return true;
        }

        public Builder add(Collection<Integer> ids) {
            if (ids.size() == 1) {
                int id = ids.iterator().next();
                this.add(SectIDRange.build(id, id));
                return this;
            }
            if (ids instanceof List) {
                List list = (List)ids;
                int first = (Integer)list.get(0);
                int lastIndex = list.size() - 1;
                int last = (Integer)list.get(lastIndex);
                if (last == first + lastIndex && this.contiguous(list, true)) {
                    this.add(SectIDRange.build(first, last));
                    return this;
                }
                if (first == last + lastIndex && this.contiguous(list, false)) {
                    this.add(SectIDRange.build(last, first));
                    return this;
                }
            }
            int rangeStartID = Integer.MIN_VALUE;
            int rangeEndID = -2;
            boolean backwards = false;
            for (int id : ids) {
                if (id == rangeEndID + 1 && !backwards) {
                    ++rangeEndID;
                    continue;
                }
                if (id == rangeEndID - 1 && backwards) {
                    --rangeEndID;
                    continue;
                }
                if (id == rangeStartID - 1 && rangeStartID == rangeEndID) {
                    backwards = true;
                    --rangeEndID;
                    continue;
                }
                if (rangeStartID != Integer.MIN_VALUE) {
                    if (backwards) {
                        this.add(SectIDRange.build(rangeEndID, rangeStartID));
                    } else {
                        this.add(SectIDRange.build(rangeStartID, rangeEndID));
                    }
                }
                rangeStartID = id;
                rangeEndID = id;
                backwards = false;
            }
            if (rangeStartID != Integer.MIN_VALUE) {
                if (backwards) {
                    this.add(SectIDRange.build(rangeEndID, rangeStartID));
                } else {
                    this.add(SectIDRange.build(rangeStartID, rangeEndID));
                }
            }
            Preconditions.checkState((ids.size() == this.size ? 1 : 0) != 0, (String)"Size mismatch, duplicates? Expected %s, have %s", (int)ids.size(), (int)this.size);
            return this;
        }

        public Builder add(SectIDRange range) {
            if (this.list.isEmpty()) {
                this.list.add(range);
                this.size += range.size();
                return this;
            }
            int index = this.insertionIndex(range);
            int sizeAdd = range.size();
            if (index > 0) {
                SectIDRange before = this.list.get(index - 1);
                Preconditions.checkState((range.getStartID() > before.getEndID() ? 1 : 0) != 0, (String)"Overlappping ID ranges detected: %s %s", (Object)before, (Object)range);
                if (range.getStartID() == before.getEndID() + 1) {
                    this.list.remove(index - 1);
                    --index;
                    range = SectIDRange.build(before.getStartID(), range.getEndID());
                }
            }
            if (index < this.list.size()) {
                SectIDRange after = this.list.get(index);
                Preconditions.checkState((range.getEndID() < after.getStartID() ? 1 : 0) != 0, (String)"Overlappping ID ranges detected: %s %s", (Object)range, (Object)after);
                if (range.getEndID() == after.getStartID() - 1) {
                    this.list.remove(index);
                    range = SectIDRange.build(range.getStartID(), after.getEndID());
                }
            }
            this.list.add(index, range);
            this.size += sizeAdd;
            return this;
        }

        public UniqueRupture build() {
            return new UniqueRupture(this.list.toArray(new SectIDRange[this.list.size()]), this.size);
        }
    }
}

