/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.treeCombiners;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.treeCombiner.AbstractLogicTreeCombiner;
import org.opensha.commons.logicTree.treeCombiner.LogicTreeCombinationProcessor;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.util.TectonicRegionType;

public class SolutionLogicTreeCombinationProcessor
implements LogicTreeCombinationProcessor {
    private SolutionLogicTree outerSLT;
    private SolutionLogicTree innerSLT;
    private File outputSLTFile;
    private boolean outerSuppliesSols;
    private boolean innerSuppliesSols;
    private AbstractLogicTreeCombiner.LogicTreeCombinationContext treeCombination;
    private Map<LogicTreeBranch<?>, FaultSystemSolution> innerSols;
    private SolutionLogicTree.FileBuilder combTreeWriter;
    private boolean serializeGridded;
    private CompletableFuture<FaultSystemSolution> nextOuterSolLoadFuture = null;
    private LogicTreeBranch<?> prevOuter = null;
    private FaultSystemSolution prevOuterSol = null;
    private CompletableFuture<Void> writeSLTFuture = null;
    private Stopwatch writeWatch = Stopwatch.createUnstarted();
    private ExecutorService ioExec;

    public SolutionLogicTreeCombinationProcessor(SolutionLogicTree outerSLT, SolutionLogicTree innerSLT, File outputSLTFile, boolean outerSuppliesSols, boolean innerSuppliesSols, boolean serializeGridded) {
        this.outerSLT = outerSLT;
        this.innerSLT = innerSLT;
        this.outputSLTFile = outputSLTFile;
        this.outerSuppliesSols = outerSuppliesSols;
        this.innerSuppliesSols = innerSuppliesSols;
        this.serializeGridded = serializeGridded;
    }

    @Override
    public String getName() {
        return "Solution Logic Tree";
    }

    @Override
    public void init(AbstractLogicTreeCombiner.LogicTreeCombinationContext treeCombination, ExecutorService exec, ExecutorService ioExec) throws IOException {
        this.treeCombination = treeCombination;
        this.ioExec = ioExec;
        this.combTreeWriter = new SolutionLogicTree.FileBuilder(this.outputSLTFile);
        Preconditions.checkState((boolean)treeCombination.averageAcrossLevels.isEmpty(), (Object)"Averaging not yet supported");
        if (treeCombination.numPairwiseSamples < 1 && this.innerSuppliesSols) {
            System.out.println("Pre-loading " + treeCombination.innerTree.size() + " inner solutions");
            this.innerSols = new HashMap();
            for (LogicTreeBranch<?> branch : treeCombination.innerTree) {
                this.innerSols.put(branch, this.innerSLT.forBranch(branch));
            }
        } else {
            this.innerSols = null;
        }
        this.combTreeWriter.setSerializeGridded(this.serializeGridded);
        this.combTreeWriter.setWeightProv(new BranchWeightProvider.OriginalWeights());
        if (this.outerSuppliesSols) {
            this.nextOuterSolLoadFuture = SolutionLogicTreeCombinationProcessor.solLoadFuture(this.outerSLT, treeCombination.combBranchesOuterPortion.get(0), ioExec);
        }
    }

    @Override
    public void processBranch(final LogicTreeBranch<?> combBranch, int combBranchIndex, double combBranchWeight, LogicTreeBranch<?> outerBranch, int outerBranchIndex, LogicTreeBranch<?> innerBranch, int innerBranchIndex) throws IOException {
        FaultSystemSolution outerSol;
        if (this.outerSuppliesSols) {
            if (this.prevOuter == null || !outerBranch.equals(this.prevOuter)) {
                outerSol = this.nextOuterSolLoadFuture.join();
                for (int m = combBranchIndex + 1; m < this.treeCombination.combTree.size(); ++m) {
                    LogicTreeBranch<?> nextOuter = this.treeCombination.combBranchesOuterPortion.get(m);
                    if (nextOuter == outerBranch) continue;
                    this.nextOuterSolLoadFuture = SolutionLogicTreeCombinationProcessor.solLoadFuture(this.outerSLT, nextOuter, this.ioExec);
                    break;
                }
            } else {
                outerSol = this.prevOuterSol;
            }
        } else {
            outerSol = null;
        }
        Preconditions.checkState((this.outerSuppliesSols || this.innerSuppliesSols ? 1 : 0) != 0);
        FaultSystemSolution innerSol = null;
        if (this.innerSuppliesSols) {
            innerSol = this.innerSols == null ? this.innerSLT.forBranch(innerBranch) : this.innerSols.get(innerBranch);
        }
        final FaultSystemSolution combSol = innerSol != null && outerSol != null ? SolutionLogicTreeCombinationProcessor.combineSols(outerSol, innerSol) : (innerSol != null ? innerSol : outerSol);
        if (this.writeSLTFuture != null) {
            this.writeWatch.start();
            this.writeSLTFuture.join();
            this.writeWatch.stop();
        }
        this.writeSLTFuture = CompletableFuture.runAsync(new Runnable(){
            final /* synthetic */ SolutionLogicTreeCombinationProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.combTreeWriter.solution(combSol, combBranch);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }, this.ioExec);
        this.prevOuter = outerBranch;
        this.prevOuterSol = outerSol;
    }

    @Override
    public void close() throws IOException {
        System.out.println("Finalizing SLT file");
        this.writeWatch.start();
        this.writeSLTFuture.join();
        this.writeWatch.stop();
        this.combTreeWriter.build();
    }

    @Override
    public String getTimeBreakdownString(Stopwatch overallWatch) {
        return "Blocking writes:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.writeWatch, overallWatch);
    }

    private static CompletableFuture<FaultSystemSolution> solLoadFuture(final SolutionLogicTree slt, final LogicTreeBranch<?> branch, ExecutorService ioExec) {
        return CompletableFuture.supplyAsync(new Supplier<FaultSystemSolution>(){

            @Override
            public FaultSystemSolution get() {
                try {
                    return slt.forBranch(branch);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }, ioExec);
    }

    public static FaultSystemSolution combineSols(FaultSystemSolution innerSol, FaultSystemSolution outerSol) {
        return SolutionLogicTreeCombinationProcessor.combineSols(innerSol, outerSol, false);
    }

    public static FaultSystemSolution combineSols(FaultSystemSolution innerSol, FaultSystemSolution outerSol, boolean clusterRups) {
        int totNumSects = 0;
        int totNumRups = 0;
        for (boolean outer : new boolean[]{false, true}) {
            FaultSystemSolution sol = outer ? outerSol : innerSol;
            FaultSystemRupSet rupSet = sol.getRupSet();
            totNumSects += rupSet.getNumSections();
            totNumRups += rupSet.getNumRuptures();
        }
        ArrayList<FaultSection> mergedSects = new ArrayList<FaultSection>(totNumSects);
        ArrayList<List<Integer>> sectionForRups = new ArrayList<List<Integer>>(totNumRups);
        double[] mags = new double[totNumRups];
        double[] rakes = new double[totNumRups];
        double[] rupAreas = new double[totNumRups];
        double[] rupLengths = new double[totNumRups];
        double[] rates = new double[totNumRups];
        TectonicRegionType[] trts = new TectonicRegionType[totNumRups];
        int sectIndex = 0;
        int rupIndex = 0;
        ArrayList<ClusterRupture> cRups = clusterRups ? new ArrayList<ClusterRupture>() : null;
        HashMap<Integer, Integer> outerSectMappings = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> innerSectMappings = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> outerRupMappings = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> innerRupMappings = new HashMap<Integer, Integer>();
        for (boolean outer : new boolean[]{false, true}) {
            RupSetTectonicRegimes myTRTs;
            FaultSystemSolution sol = outer ? outerSol : innerSol;
            FaultSystemRupSet rupSet = sol.getRupSet();
            int[] sectMappings = new int[rupSet.getNumSections()];
            for (int s = 0; s < sectMappings.length; ++s) {
                FaultSection sect = rupSet.getFaultSectionData(s);
                sect = sect.clone();
                sectMappings[s] = sectIndex;
                sect.setSectionId(sectIndex);
                if (outer) {
                    outerSectMappings.put(s, sectIndex);
                } else {
                    innerSectMappings.put(s, sectIndex);
                }
                mergedSects.add(sect);
                ++sectIndex;
            }
            RupSetTectonicRegimes rupSetTectonicRegimes = myTRTs = trts == null ? null : rupSet.getModule(RupSetTectonicRegimes.class);
            if (myTRTs == null) {
                trts = null;
            }
            ClusterRuptures myCrups = null;
            if (clusterRups) {
                myCrups = rupSet.requireModule(ClusterRuptures.class);
            }
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                List<Integer> prevSectIDs = rupSet.getSectionsIndicesForRup(r);
                ArrayList<Integer> newSectIDs = new ArrayList<Integer>(prevSectIDs.size());
                for (int s : prevSectIDs) {
                    newSectIDs.add(sectMappings[s]);
                }
                sectionForRups.add(newSectIDs);
                mags[rupIndex] = rupSet.getMagForRup(r);
                rakes[rupIndex] = rupSet.getAveRakeForRup(r);
                rupAreas[rupIndex] = rupSet.getAreaForRup(r);
                rupLengths[rupIndex] = rupSet.getLengthForRup(r);
                rates[rupIndex] = sol.getRateForRup(r);
                if (trts != null) {
                    trts[rupIndex] = myTRTs.get(r);
                }
                if (clusterRups) {
                    cRups.add(myCrups.get(r));
                }
                if (outer) {
                    outerRupMappings.put(r, rupIndex);
                } else {
                    innerRupMappings.put(r, rupIndex);
                }
                ++rupIndex;
            }
        }
        FaultSystemRupSet mergedRupSet = new FaultSystemRupSet(mergedSects, sectionForRups, mags, rakes, rupAreas, rupLengths);
        if (clusterRups) {
            mergedRupSet.addModule(ClusterRuptures.instance(mergedRupSet, cRups, false));
        }
        if (trts != null) {
            mergedRupSet.addModule(new RupSetTectonicRegimes(mergedRupSet, trts));
        }
        mergedRupSet.addModule(new CombinedRupSetMappings(innerSectMappings, outerSectMappings, innerRupMappings, outerRupMappings));
        return new FaultSystemSolution(mergedRupSet, rates);
    }

    public static class CombinedRupSetMappings
    implements OpenSHA_Module {
        private Map<Integer, Integer> innerSectMappings;
        private Map<Integer, Integer> outerSectMappings;
        private Map<Integer, Integer> innerRupMappings;
        private Map<Integer, Integer> outerRupMappings;

        public CombinedRupSetMappings(Map<Integer, Integer> innerSectMappings, Map<Integer, Integer> outerSectMappings, Map<Integer, Integer> innerRupMappings, Map<Integer, Integer> outerRupMappings) {
            this.innerSectMappings = innerSectMappings;
            this.outerSectMappings = outerSectMappings;
            this.innerRupMappings = innerRupMappings;
            this.outerRupMappings = outerRupMappings;
        }

        public Map<Integer, Integer> getInnerSectMappings() {
            return Collections.unmodifiableMap(this.innerSectMappings);
        }

        public Map<Integer, Integer> getOuterSectMappings() {
            return Collections.unmodifiableMap(this.outerSectMappings);
        }

        public Map<Integer, Integer> getInnerRupMappings() {
            return Collections.unmodifiableMap(this.innerRupMappings);
        }

        public Map<Integer, Integer> getOuterRupMappings() {
            return Collections.unmodifiableMap(this.outerRupMappings);
        }

        public int getCombinedSectIDForInner(int origInnerSectID) {
            return this.innerSectMappings.get(origInnerSectID);
        }

        public int getCombinedSectIDForOuter(int origOuterSectID) {
            return this.outerSectMappings.get(origOuterSectID);
        }

        public int getCombinedRupIDForInner(int origInnerRupID) {
            return this.innerRupMappings.get(origInnerRupID);
        }

        public int getCombinedRupIDForOuter(int origOuterRupID) {
            return this.outerRupMappings.get(origOuterRupID);
        }

        @Override
        public String getName() {
            return "Combined Rup Set Mappings";
        }
    }
}

