/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.faultSurface.FaultSection;

public class MergedSolutionCreator {
    public static FaultSystemSolution merge(List<FaultSystemSolution> sols) {
        return MergedSolutionCreator.merge(sols.toArray(new FaultSystemSolution[0]));
    }

    public static FaultSystemSolution merge(FaultSystemSolution ... sols) {
        Preconditions.checkState((sols.length > 1 ? 1 : 0) != 0, (Object)"Need at least 2 solutions to merge");
        int totNumSects = 0;
        int totNumRups = 0;
        for (int i = 0; i < sols.length; ++i) {
            FaultSystemSolution sol = sols[i];
            FaultSystemRupSet rupSet = sol.getRupSet();
            System.out.println("RupSet " + i + " has " + rupSet.getNumSections() + " sects, " + rupSet.getNumRuptures() + " rups");
            totNumSects += rupSet.getNumSections();
            totNumRups += rupSet.getNumRuptures();
            if (!sol.hasAvailableModule(GridSourceProvider.class)) continue;
            System.err.println("WARNING: this does not yet merge grid source providers");
        }
        System.out.println("Total: " + totNumSects + " sects, " + totNumRups + " rups");
        ArrayList<FaultSection> mergedSects = new ArrayList<FaultSection>(totNumSects);
        ArrayList<List<Integer>> sectionForRups = new ArrayList<List<Integer>>(totNumSects);
        double[] mags = new double[totNumRups];
        double[] rakes = new double[totNumRups];
        double[] rupAreas = new double[totNumRups];
        double[] rupLengths = new double[totNumRups];
        double[] rates = new double[totNumRups];
        int sectIndex = 0;
        int rupIndex = 0;
        HashMap<Integer, String> prevParents = new HashMap<Integer, String>();
        for (FaultSystemSolution sol : sols) {
            FaultSystemRupSet rupSet = sol.getRupSet();
            int[] sectMappings = new int[rupSet.getNumSections()];
            System.out.println("Merging sol with " + rupSet.getNumSections() + " sects and " + rupSet.getNumRuptures() + " rups");
            HashMap<Integer, String> newParents = new HashMap<Integer, String>();
            for (int s = 0; s < sectMappings.length; ++s) {
                FaultSection sect = rupSet.getFaultSectionData(s);
                if (sect.getParentSectionId() >= 0) {
                    newParents.put(sect.getParentSectionId(), sect.getParentSectionName());
                }
                sect = sect.clone();
                sectMappings[s] = sectIndex;
                sect.setSectionId(sectIndex);
                mergedSects.add(sect);
                ++sectIndex;
            }
            Iterator s = newParents.keySet().iterator();
            while (s.hasNext()) {
                int parentID = (Integer)s.next();
                if (prevParents.containsKey(parentID)) {
                    System.err.println("WARNING: multiple solutions use the same parent section id (" + parentID + "): " + (String)prevParents.get(parentID) + " and " + (String)newParents.get(parentID));
                    continue;
                }
                prevParents.put(parentID, (String)newParents.get(parentID));
            }
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                List<Integer> prevSectIDs = rupSet.getSectionsIndicesForRup(r);
                ArrayList<Integer> newSectIDs = new ArrayList<Integer>(prevSectIDs.size());
                for (int s2 : prevSectIDs) {
                    newSectIDs.add(sectMappings[s2]);
                }
                sectionForRups.add(newSectIDs);
                mags[rupIndex] = rupSet.getMagForRup(r);
                rakes[rupIndex] = rupSet.getAveRakeForRup(r);
                rupAreas[rupIndex] = rupSet.getAreaForRup(r);
                rupAreas[rupIndex] = rupSet.getLengthForRup(r);
                rates[rupIndex] = sol.getRateForRup(r);
                ++rupIndex;
            }
        }
        FaultSystemRupSet mergedRupSet = new FaultSystemRupSet(mergedSects, sectionForRups, mags, rakes, rupAreas, rupLengths);
        return new FaultSystemSolution(mergedRupSet, rates);
    }
}

