/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.util.TectonicRegionType;

public class SolutionDisaggConsolidator
implements UnaryOperator<List<DisaggregationSourceRuptureInfo>> {
    public static final String NAME_SINGLE_GRIDDED_SOURCES = "Gridded Sources";
    public static final String PREFIX_TRT_GRIDDED_SOURCES = "Gridded Sources, ";
    private BaseFaultSystemSolutionERF erf;
    private boolean participation;

    public SolutionDisaggConsolidator(BaseFaultSystemSolutionERF erf) {
        this(erf, true);
    }

    public SolutionDisaggConsolidator(BaseFaultSystemSolutionERF erf, boolean participation) {
        this.erf = erf;
        this.participation = participation;
    }

    @Override
    public List<DisaggregationSourceRuptureInfo> apply(List<DisaggregationSourceRuptureInfo> input) {
        final FaultSystemRupSet rupSet = this.erf.getSolution().getRupSet();
        int numFSS = this.erf.getNumFaultSystemSources();
        HashMap parentSectContribs = new HashMap();
        HashMap<Integer, String> parentNames = new HashMap<Integer, String>();
        HashMap noParentSectContribs = new HashMap();
        EnumMap<TectonicRegionType, ArrayList<DisaggregationSourceRuptureInfo>> trtGridSourceContribs = new EnumMap<TectonicRegionType, ArrayList<DisaggregationSourceRuptureInfo>>(TectonicRegionType.class);
        final double duration = this.participation ? Double.NaN : this.erf.getTimeSpan().getDuration();
        HashMap<Integer, List> nucleationContributions = null;
        if (!this.participation) {
            HashMap nucleationRescaleFutures = new HashMap();
            for (final DisaggregationSourceRuptureInfo contrib : input) {
                final int sourceID = contrib.getId();
                if (sourceID >= numFSS) continue;
                nucleationRescaleFutures.put(sourceID, CompletableFuture.supplyAsync(new Supplier<List<DisaggregationSourceRuptureInfo>>(){
                    final /* synthetic */ SolutionDisaggConsolidator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public List<DisaggregationSourceRuptureInfo> get() {
                        double rupArea = 0.0;
                        int fssIndex = this.this$0.erf.getFltSysRupIndexForSource(sourceID);
                        int numSects = 0;
                        for (int s : rupSet.getSectionsIndicesForRup(fssIndex)) {
                            rupArea += rupSet.getAreaForSection(s);
                            ++numSects;
                        }
                        ArrayList<DisaggregationSourceRuptureInfo> ret = new ArrayList<DisaggregationSourceRuptureInfo>(numSects);
                        for (FaultSection sect : rupSet.getFaultSectionDataForRupture(fssIndex)) {
                            double sectArea = rupSet.getAreaForSection(sect.getSectionId());
                            double nuclFract = sectArea / rupArea;
                            if (nuclFract > 1.0 && nuclFract > 1.001) {
                                nuclFract = 1.0;
                            }
                            Preconditions.checkState(((float)nuclFract <= 1.0f ? 1 : 0) != 0, (String)"Nucleation fraction = %s / %s = %s for %s. %s", (Object[])new Object[]{Float.valueOf((float)sectArea), Float.valueOf((float)rupArea), Float.valueOf((float)nuclFract), contrib.getId(), contrib.getName()});
                            if ((float)nuclFract == 1.0f) {
                                ret.add(contrib);
                                continue;
                            }
                            ret.add(contrib.getScaled(nuclFract, duration));
                        }
                        return ret;
                    }
                }));
            }
            nucleationContributions = new HashMap<Integer, List>();
            for (Integer sourceID : nucleationRescaleFutures.keySet()) {
                nucleationContributions.put(sourceID, (List)((CompletableFuture)nucleationRescaleFutures.get(sourceID)).join());
            }
        }
        for (DisaggregationSourceRuptureInfo contrib : input) {
            int sourceID = contrib.getId();
            if (sourceID < numFSS) {
                int prevParent = -1;
                int fssIndex = this.erf.getFltSysRupIndexForSource(sourceID);
                List nuclContribs = this.participation ? null : (List)nucleationContributions.get(sourceID);
                List<FaultSection> sects = rupSet.getFaultSectionDataForRupture(fssIndex);
                for (int s = 0; s < sects.size(); ++s) {
                    FaultSection sect = sects.get(s);
                    DisaggregationSourceRuptureInfo sectContrib = this.participation ? contrib : (DisaggregationSourceRuptureInfo)nuclContribs.get(s);
                    int parentID = sect.getParentSectionId();
                    if (parentID < 0) {
                        if (!noParentSectContribs.containsKey(sect.getSectionId())) {
                            noParentSectContribs.put(sect.getSectionId(), new ArrayList());
                        }
                        ((List)noParentSectContribs.get(sect.getSectionId())).add(sectContrib);
                    } else if (parentID != prevParent) {
                        ArrayList<DisaggregationSourceRuptureInfo> parentContribs = (ArrayList<DisaggregationSourceRuptureInfo>)parentSectContribs.get(parentID);
                        if (parentContribs == null) {
                            parentContribs = new ArrayList<DisaggregationSourceRuptureInfo>();
                            parentSectContribs.put(parentID, parentContribs);
                            parentNames.put(parentID, sect.getParentSectionName());
                        } else if (this.participation && parentSectContribs.get(parentSectContribs.size() - 1) == sectContrib) continue;
                        parentContribs.add(sectContrib);
                    }
                    prevParent = sect.getParentSectionId();
                }
                continue;
            }
            TectonicRegionType trt = contrib.getSource().getTectonicRegionType();
            ArrayList<DisaggregationSourceRuptureInfo> gridSourceContribs = (ArrayList<DisaggregationSourceRuptureInfo>)trtGridSourceContribs.get(trt);
            if (gridSourceContribs == null) {
                gridSourceContribs = new ArrayList<DisaggregationSourceRuptureInfo>();
                trtGridSourceContribs.put(trt, gridSourceContribs);
            }
            gridSourceContribs.add(contrib);
        }
        ArrayList<DisaggregationSourceRuptureInfo> ret = new ArrayList<DisaggregationSourceRuptureInfo>();
        Iterator<DisaggregationSourceRuptureInfo> iterator = parentSectContribs.keySet().iterator();
        while (iterator.hasNext()) {
            int parentID = (Integer)((Object)iterator.next());
            ret.add(DisaggregationSourceRuptureInfo.consolidate((Collection)parentSectContribs.get(parentID), parentID, (String)parentNames.get(parentID)));
        }
        iterator = noParentSectContribs.keySet().iterator();
        while (iterator.hasNext()) {
            int sectID = (Integer)((Object)iterator.next());
            ret.add(DisaggregationSourceRuptureInfo.consolidate((Collection)noParentSectContribs.get(sectID), sectID, rupSet.getFaultSectionData(sectID).getName()));
        }
        if (!trtGridSourceContribs.isEmpty()) {
            for (TectonicRegionType trt : trtGridSourceContribs.keySet()) {
                List gridSourceContribs = (List)trtGridSourceContribs.get(trt);
                if (trtGridSourceContribs.size() == 1) {
                    ret.add(DisaggregationSourceRuptureInfo.consolidate(gridSourceContribs, -1, NAME_SINGLE_GRIDDED_SOURCES));
                    continue;
                }
                ret.add(DisaggregationSourceRuptureInfo.consolidate(gridSourceContribs, -1, PREFIX_TRT_GRIDDED_SOURCES + String.valueOf(trt)));
            }
        }
        return ret;
    }
}

