/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.util.TectonicRegionType;

public class SolutionDisaggSourceTypeConsolidator
implements UnaryOperator<List<DisaggregationSourceRuptureInfo>> {
    public static final String NAME_ALL_FAULT_SOURCES = "All Fault Sources";
    public static final String PREFIX_TRT_FAULT_SOURCES = "Fault Sources, ";
    public static final String NAME_ALL_GRIDDED_SOURCES = "All Gridded Sources";
    public static final String PREFIX_TRT_GRIDDED_SOURCES = "Gridded Sources, ";
    private BaseFaultSystemSolutionERF erf;

    public SolutionDisaggSourceTypeConsolidator(BaseFaultSystemSolutionERF erf) {
        this.erf = erf;
    }

    @Override
    public List<DisaggregationSourceRuptureInfo> apply(List<DisaggregationSourceRuptureInfo> input) {
        List contribList;
        int numFSS = this.erf.getNumFaultSystemSources();
        ArrayList<DisaggregationSourceRuptureInfo> faultSourceContribs = new ArrayList<DisaggregationSourceRuptureInfo>();
        ArrayList<DisaggregationSourceRuptureInfo> gridSourceContribs = new ArrayList<DisaggregationSourceRuptureInfo>();
        EnumMap<TectonicRegionType, ArrayList<DisaggregationSourceRuptureInfo>> trtFaultSourceContribs = new EnumMap<TectonicRegionType, ArrayList<DisaggregationSourceRuptureInfo>>(TectonicRegionType.class);
        EnumMap<TectonicRegionType, ArrayList<DisaggregationSourceRuptureInfo>> trtGridSourceContribs = new EnumMap<TectonicRegionType, ArrayList<DisaggregationSourceRuptureInfo>>(TectonicRegionType.class);
        for (DisaggregationSourceRuptureInfo contrib : input) {
            int sourceID = contrib.getId();
            TectonicRegionType trt = contrib.getSource().getTectonicRegionType();
            if (sourceID < numFSS) {
                faultSourceContribs.add(contrib);
                ArrayList<DisaggregationSourceRuptureInfo> myFaultSourceContribs = (ArrayList<DisaggregationSourceRuptureInfo>)trtFaultSourceContribs.get(trt);
                if (myFaultSourceContribs == null) {
                    myFaultSourceContribs = new ArrayList<DisaggregationSourceRuptureInfo>();
                    trtFaultSourceContribs.put(trt, myFaultSourceContribs);
                }
                myFaultSourceContribs.add(contrib);
                continue;
            }
            gridSourceContribs.add(contrib);
            ArrayList<DisaggregationSourceRuptureInfo> myGridSourceContribs = (ArrayList<DisaggregationSourceRuptureInfo>)trtGridSourceContribs.get(trt);
            if (myGridSourceContribs == null) {
                myGridSourceContribs = new ArrayList<DisaggregationSourceRuptureInfo>();
                trtGridSourceContribs.put(trt, myGridSourceContribs);
            }
            myGridSourceContribs.add(contrib);
        }
        ArrayList<DisaggregationSourceRuptureInfo> ret = new ArrayList<DisaggregationSourceRuptureInfo>();
        if (!faultSourceContribs.isEmpty()) {
            ret.add(DisaggregationSourceRuptureInfo.consolidate(faultSourceContribs, -1, NAME_ALL_FAULT_SOURCES));
        }
        if (trtFaultSourceContribs.size() > 1) {
            for (TectonicRegionType trt : trtFaultSourceContribs.keySet()) {
                contribList = (List)trtFaultSourceContribs.get(trt);
                ret.add(DisaggregationSourceRuptureInfo.consolidate(contribList, -1, PREFIX_TRT_FAULT_SOURCES + String.valueOf(trt)));
            }
        }
        if (!gridSourceContribs.isEmpty()) {
            ret.add(DisaggregationSourceRuptureInfo.consolidate(gridSourceContribs, -1, NAME_ALL_GRIDDED_SOURCES));
        }
        if (trtGridSourceContribs.size() > 1) {
            for (TectonicRegionType trt : trtGridSourceContribs.keySet()) {
                contribList = (List)trtGridSourceContribs.get(trt);
                ret.add(DisaggregationSourceRuptureInfo.consolidate(contribList, -1, PREFIX_TRT_GRIDDED_SOURCES + String.valueOf(trt)));
            }
        }
        return ret;
    }
}

