/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.Interpolate;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;

public class SubSectionPolygonBuilder {
    private static final double BUF = 100.0;
    public static final String SECT_POLY_DIRECTION_PROP_NAME = "SectPolyDir";
    private static final double TOL = 1.0E-9;

    public static void buildSubsectionPolygons(List<? extends FaultSection> subSects, Region polygon) {
        SubSectionPolygonBuilder.buildSubsectionPolygons(subSects, polygon, true);
    }

    public static void buildSubsectionPolygons(List<? extends FaultSection> subSects, Region polygon, boolean shear) {
        if (subSects.size() == 1) {
            subSects.get(0).setZonePolygon(polygon);
        }
        Preconditions.checkState((subSects.size() > 0 ? 1 : 0) != 0);
        int iters = shear ? 2 : 1;
        for (int iter = 0; iter < iters; ++iter) {
            int i;
            Area area = polygon.getShape();
            ArrayList<Area> subSectAreas = new ArrayList<Area>();
            double[] shearAngles = null;
            if (iter > 0) {
                double firstAngle = Double.NaN;
                double lastAngle = Double.NaN;
                for (boolean first : new boolean[]{true, false}) {
                    double angle;
                    FaultSection sect = first ? subSects.get(0) : subSects.get(subSects.size() - 1);
                    double sectLen = sect.getTraceLength();
                    FaultTrace trace = sect.getFaultTrace();
                    double traceAz = trace.getStrikeDirection();
                    Location middleTraceLoc = new Location(0.5 * (trace.first().getLatitude() + trace.last().getLatitude()), 0.5 * (trace.first().getLongitude() + trace.last().getLongitude()));
                    Region curPoly = sect.getZonePolygon();
                    double minWidth = 0.5 * sectLen;
                    double leftWidth = Double.NaN;
                    double rightWidth = Double.NaN;
                    double leftDist = Double.NaN;
                    double rightDist = Double.NaN;
                    for (boolean left : new boolean[]{true, false}) {
                        double dist;
                        double width;
                        double perpAz = left ? traceAz - 90.0 : traceAz + 90.0;
                        Location perpLoc = LocationUtils.location(middleTraceLoc, Math.toRadians(perpAz), 100.0);
                        FaultTrace perpLine = new FaultTrace(null);
                        perpLine.add(middleTraceLoc);
                        perpLine.add(perpLoc);
                        perpLine = FaultUtils.resampleTrace(perpLine, 1000);
                        int lastInsideIndex = -1;
                        for (int p = 0; p < perpLine.size(); ++p) {
                            if (!curPoly.contains((Location)perpLine.get(p))) continue;
                            lastInsideIndex = p;
                        }
                        if (lastInsideIndex <= 1) {
                            width = sectLen;
                            dist = 0.0;
                        } else {
                            int middleInsideIndex = lastInsideIndex > 4 ? (int)(3.0 * (double)lastInsideIndex / 4.0 + 0.5) : lastInsideIndex / 2;
                            Location middleInsideLoc = (Location)perpLine.get(middleInsideIndex);
                            FaultTrace parallelLine = new FaultTrace(null);
                            Location startLoc = LocationUtils.location(middleInsideLoc, Math.toRadians(traceAz + 180.0), 100.0);
                            parallelLine.add(startLoc);
                            Location endLoc = LocationUtils.location(middleInsideLoc, Math.toRadians(traceAz), 100.0);
                            parallelLine.add(endLoc);
                            parallelLine = FaultUtils.resampleTrace(parallelLine, 1000);
                            Location firstInside = null;
                            Location lastInside = null;
                            for (Location loc : parallelLine) {
                                if (!curPoly.contains(loc)) continue;
                                if (firstInside == null) {
                                    firstInside = loc;
                                }
                                lastInside = loc;
                            }
                            if (firstInside == null || firstInside == lastInside) {
                                width = minWidth;
                                dist = 0.0;
                            } else {
                                width = Math.max(minWidth, LocationUtils.horzDistanceFast(firstInside, lastInside));
                                dist = LocationUtils.linearDistanceFast(middleInsideLoc, middleTraceLoc);
                            }
                        }
                        if (left) {
                            leftWidth = width;
                            leftDist = dist;
                            continue;
                        }
                        rightWidth = width;
                        rightDist = dist;
                    }
                    double delta = Math.abs(leftWidth - rightWidth);
                    double sumDist = leftDist + rightDist;
                    if (sumDist > 0.0 && delta > 0.01) {
                        angle = Math.abs(Math.toDegrees(Math.atan(delta / sumDist)));
                        angle = Math.min(angle, 22.5);
                        if (leftWidth > rightWidth) {
                            if (first) {
                                angle = -angle;
                            }
                        } else if (!first) {
                            angle = -angle;
                        }
                    } else {
                        angle = 0.0;
                    }
                    if (first) {
                        firstAngle = angle;
                        continue;
                    }
                    lastAngle = angle;
                }
                shearAngles = new double[subSects.size()];
                for (int i2 = 0; i2 < shearAngles.length; ++i2) {
                    shearAngles[i2] = Interpolate.findY(0.0, firstAngle, shearAngles.length - 1, lastAngle, i2);
                    FaultSection sect = subSects.get(i2);
                    if (!(sect instanceof GeoJSONFaultSection)) continue;
                    ((GeoJSONFaultSection)sect).getProperties().set(SECT_POLY_DIRECTION_PROP_NAME, (double)sect.getDipDirection() + shearAngles[i2]);
                }
            }
            for (i = 0; i < subSects.size(); ++i) {
                Area leftover;
                FaultSection ss1 = subSects.get(i);
                Area subSectArea = null;
                if (i == subSects.size() - 1) {
                    if (area.isSingular()) {
                        subSectArea = area;
                    } else {
                        List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(area);
                        for (LocationList locs : locLists) {
                            Area polyPart = new Area(locs.toPath());
                            FaultTrace trace = ss1.getFaultTrace();
                            if (SubSectionPolygonBuilder.intersects(trace, polyPart)) {
                                if (subSectArea == null) {
                                    subSectArea = area;
                                    continue;
                                }
                                subSectArea.add(area);
                                if (subSectArea.isSingular()) continue;
                                subSectArea = SubSectionPolygonBuilder.hardMerge(subSectArea);
                                continue;
                            }
                            leftover = polyPart;
                            Area prev = (Area)subSectAreas.get(i - 1);
                            if (prev == null) {
                                prev = leftover;
                            } else {
                                prev.add(leftover);
                            }
                            prev = SubSectionPolygonBuilder.cleanBorder(prev);
                            if (!prev.isSingular()) {
                                prev = SubSectionPolygonBuilder.hardMerge(prev);
                            }
                            if (prev == null) {
                                System.out.println("merge problem last segment");
                            }
                            subSectAreas.set(i - 1, prev);
                        }
                    }
                    subSectAreas.add(subSectArea);
                    break;
                }
                FaultSection ss2 = subSects.get(i + 1);
                double shearAngle = 0.0;
                if (shearAngles != null) {
                    shearAngle = 0.5 * (shearAngles[i] + shearAngles[i + 1]);
                }
                LocationList envelope = SubSectionPolygonBuilder.createSubSecEnvelope(ss1, ss2, shearAngle);
                Area envPoly = new Area(envelope.toPath());
                subSectArea = (Area)area.clone();
                subSectArea.intersect(envPoly);
                if (subSectArea.isEmpty()) {
                    subSectAreas.add(null);
                    continue;
                }
                subSectArea = SubSectionPolygonBuilder.cleanBorder(subSectArea);
                leftover = null;
                if (!subSectArea.isSingular()) {
                    List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(subSectArea);
                    subSectArea = null;
                    for (LocationList locs : locLists) {
                        Area polyPart = new Area(locs.toPath());
                        FaultTrace trace = ss1.getFaultTrace();
                        if (SubSectionPolygonBuilder.intersects(trace, polyPart)) {
                            if (subSectArea == null) {
                                subSectArea = polyPart;
                                continue;
                            }
                            subSectArea.add(polyPart);
                            if (subSectArea.isSingular()) continue;
                            subSectArea = SubSectionPolygonBuilder.hardMerge(subSectArea);
                            continue;
                        }
                        leftover = polyPart;
                    }
                }
                area.subtract(envPoly);
                area = SubSectionPolygonBuilder.cleanBorder(area);
                if (leftover != null) {
                    Area fCopy = (Area)area.clone();
                    fCopy.add(leftover);
                    fCopy = SubSectionPolygonBuilder.cleanBorder(fCopy);
                    if (!fCopy.isSingular()) {
                        if ((fCopy = SubSectionPolygonBuilder.hardMerge(fCopy)) == null) {
                            Area prev = (Area)subSectAreas.get(i - 1);
                            prev.add(leftover);
                            prev = SubSectionPolygonBuilder.cleanBorder(prev);
                            if (!prev.isSingular()) {
                                prev = SubSectionPolygonBuilder.hardMerge(prev);
                            }
                            if (prev == null) {
                                System.out.println("merge problem");
                            }
                            subSectAreas.set(i - 1, prev);
                        } else {
                            area = fCopy;
                        }
                    } else {
                        area = fCopy;
                    }
                }
                subSectAreas.add(subSectArea);
            }
            Preconditions.checkState((subSectAreas.size() == subSects.size() ? 1 : 0) != 0);
            for (i = 0; i < subSects.size(); ++i) {
                FaultSection subSect = subSects.get(i);
                Area subSectArea = (Area)subSectAreas.get(i);
                if (subSectArea == null) {
                    subSect.setZonePolygon(null);
                    continue;
                }
                subSect.setZonePolygon(SubSectionPolygonBuilder.areaToRegion(SubSectionPolygonBuilder.cleanBorder(subSectArea)));
            }
        }
    }

    private static LocationList createSubSecEnvelope(FaultSection sec1, FaultSection sec2, double shearAngle) {
        FaultTrace t1 = sec1.getFaultTrace();
        FaultTrace t2 = sec2.getFaultTrace();
        Location p1 = (Location)t1.get(t1.size() - 2);
        Location p2 = (Location)t1.get(t1.size() - 1);
        Preconditions.checkState((boolean)p2.equals(t2.get(0)));
        LocationVector vBackAz = LocationUtils.vector(p2, p1);
        vBackAz.setHorzDistance(100.0);
        LocationVector vBisect = new LocationVector();
        double polyDipDir = (double)sec1.getDipDirection() + shearAngle;
        vBisect.setAzimuth(polyDipDir);
        vBisect.setHorzDistance(100.0);
        LocationList locs = new LocationList();
        Location util = LocationUtils.location(p2, vBisect);
        locs.add(util);
        locs.add(0, LocationUtils.location(util, vBackAz));
        locs.add(p2);
        vBisect.reverse();
        util = LocationUtils.location(p2, vBisect);
        locs.add(util);
        locs.add(LocationUtils.location(util, vBackAz));
        return locs;
    }

    static Area cleanBorder(Area area) {
        List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(area);
        locLists = SubSectionPolygonBuilder.pruneEmpties(locLists);
        locLists = SubSectionPolygonBuilder.removeDupes(locLists);
        Area areaOut = new Area();
        for (LocationList areaLocs : locLists) {
            areaOut.add(new Area(areaLocs.toPath()));
        }
        return areaOut;
    }

    private static List<LocationList> pruneEmpties(List<LocationList> locLists) {
        ArrayList newLocLists = Lists.newArrayList();
        for (LocationList locs : locLists) {
            if (SubSectionPolygonBuilder.isEmptyPoly(locs)) continue;
            newLocLists.add(locs);
        }
        return newLocLists;
    }

    private static List<LocationList> removeDupes(List<LocationList> locLists) {
        ArrayList newLocLists = Lists.newArrayList();
        for (LocationList locs : locLists) {
            newLocLists.add(SubSectionPolygonBuilder.removeDupes(locs));
        }
        return newLocLists;
    }

    private static LocationList removeDupes(LocationList locs) {
        LocationList newLocs = new LocationList();
        for (Location loc : locs) {
            SubSectionPolygonBuilder.validateLoc(newLocs, loc);
        }
        return newLocs;
    }

    private static boolean isEmptyPoly(LocationList locs) {
        Location start = (Location)locs.get(0);
        for (Location loc : locs) {
            if (SubSectionPolygonBuilder.areSimilar(start, loc)) continue;
            return false;
        }
        return true;
    }

    private static void validateLoc(LocationList locs, Location loc) {
        for (Location p : locs) {
            if (!SubSectionPolygonBuilder.areSimilar(p, loc)) continue;
            return;
        }
        locs.add(loc);
    }

    private static boolean areSimilar(Location p1, Location p2) {
        if (!Precision.equals((double)p1.getLatitude(), (double)p2.getLatitude(), (double)1.0E-9)) {
            return false;
        }
        if (!Precision.equals((double)p1.getLongitude(), (double)p2.getLongitude(), (double)1.0E-9)) {
            return false;
        }
        return Precision.equals((double)p1.getDepth(), (double)p2.getDepth(), (double)1.0E-9);
    }

    private static Area hardMerge(Area area) {
        List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(area);
        Preconditions.checkArgument((locLists.size() == 2 ? 1 : 0) != 0);
        Area a1 = new Area(locLists.get(0).toPath());
        Area a2 = new Area(locLists.get(1).toPath());
        return SubSectionPolygonBuilder.shiftMerge(a1, a2);
    }

    private static Area shiftMerge(Area a1, Area a2) {
        Preconditions.checkArgument((boolean)a1.isSingular());
        Preconditions.checkArgument((!a1.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)a2.isSingular());
        Preconditions.checkArgument((!a2.isEmpty() ? 1 : 0) != 0);
        LocationList locsToShift = SubSectionPolygonBuilder.areaToLocLists(a2).get(0);
        LocationList shiftedLocs = null;
        Area merged = (Area)a1.clone();
        shiftedLocs = SubSectionPolygonBuilder.shiftEW(locsToShift, 1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        shiftedLocs = SubSectionPolygonBuilder.shiftNS(locsToShift, -1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        shiftedLocs = SubSectionPolygonBuilder.shiftEW(locsToShift, -1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        shiftedLocs = SubSectionPolygonBuilder.shiftNS(locsToShift, 1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        return null;
    }

    private static LocationList shiftEW(LocationList locs, double shift) {
        LocationList locsOut = new LocationList();
        for (Location loc : locs) {
            Location shiftedLoc = new Location(loc.getLatitude(), loc.getLongitude() + shift);
            locsOut.add(shiftedLoc);
        }
        return locsOut;
    }

    private static LocationList shiftNS(LocationList locs, double shift) {
        LocationList locsOut = new LocationList();
        for (Location loc : locs) {
            Location shiftedLoc = new Location(loc.getLatitude() + shift, loc.getLongitude());
            locsOut.add(shiftedLoc);
        }
        return locsOut;
    }

    static Region areaToRegion(Area area) {
        List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(area);
        Preconditions.checkState((locLists.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 location list, have %s", (int)locLists.size());
        return new Region(locLists.get(0), null);
    }

    private static boolean intersects(FaultTrace trace, Area poly) {
        for (Location loc : trace) {
            if (!poly.contains(loc.getLongitude(), loc.getLatitude())) continue;
            return true;
        }
        return false;
    }

    static List<LocationList> areaToLocLists(Area area) {
        ArrayList locLists = Lists.newArrayList();
        LocationList locs = null;
        double[] vertex = new double[6];
        PathIterator pi = area.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(vertex);
            double lon = vertex[0];
            double lat = vertex[1];
            if (type == 0) {
                locs = new LocationList();
                locLists.add(locs);
                locs.add(new Location(lat, lon));
            } else if (type == 1) {
                locs.add(new Location(lat, lon));
            }
            pi.next();
        }
        return locLists;
    }

    private static Area merge(Area zone, Area dd) {
        Area area = new Area();
        if (zone != null) {
            area.add(zone);
        }
        if (dd != null) {
            area.add(dd);
        }
        return area.isEmpty() ? null : area;
    }

    private static Area createDownDipPoly(FaultSection f) {
        RuptureSurface surf = f.getFaultSurface(1.0, false, false);
        LocationList perimeter = surf.getPerimeter();
        return new Area(perimeter.toPath());
    }

    private static Area removeNests(Area area) {
        if (area == null) {
            return null;
        }
        if (area.isSingular()) {
            return area;
        }
        List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(area);
        Preconditions.checkArgument((locLists.size() > 1 ? 1 : 0) != 0);
        Area a = new Area();
        for (LocationList locs : locLists) {
            Area toAdd = new Area(locs.toPath());
            a.add(toAdd);
        }
        a = SubSectionPolygonBuilder.cleanBorder(a);
        return a;
    }

    static double getExtent(Area area) {
        List<LocationList> locLists = SubSectionPolygonBuilder.areaToLocLists(area);
        double total = 0.0;
        for (LocationList locs : locLists) {
            total += SubSectionPolygonBuilder.getExtent(locs);
        }
        return total;
    }

    private static double getExtent(LocationList locs) {
        Area area = new Area(locs.toPath());
        Rectangle2D rRect = area.getBounds2D();
        Location origin = new Location(rRect.getCenterY(), rRect.getCenterX());
        ArrayList xs = Lists.newArrayList();
        ArrayList ys = Lists.newArrayList();
        for (Location loc : locs) {
            LocationVector v = LocationUtils.vector(origin, loc);
            double az = v.getAzimuthRad();
            double d = v.getHorzDistance();
            xs.add(Math.sin(az) * d);
            ys.add(Math.cos(az) * d);
        }
        xs.add((Double)xs.get(0));
        ys.add((Double)ys.get(0));
        return SubSectionPolygonBuilder.computeArea(Doubles.toArray((Collection)xs), Doubles.toArray((Collection)ys));
    }

    private static double computeArea(double[] xs, double[] ys) {
        SubSectionPolygonBuilder.positivize(xs);
        SubSectionPolygonBuilder.positivize(ys);
        double area = 0.0;
        for (int i = 0; i < xs.length - 1; ++i) {
            area += xs[i] * ys[i + 1] - xs[i + 1] * ys[i];
        }
        return Math.abs(area) / 2.0;
    }

    private static void positivize(double[] v) {
        double min = Doubles.min((double[])v);
        if (min >= 0.0) {
            return;
        }
        DataUtils.add(Math.abs(min), v);
    }
}

