/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.griddedForecast;

import java.io.Serializable;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class MagFreqDistsForFocalMechs
implements Serializable {
    protected IncrementalMagFreqDist[] magFreqDist = null;
    protected FocalMechanism[] focalMechanism = null;

    public MagFreqDistsForFocalMechs(IncrementalMagFreqDist[] magDist) {
        this.magFreqDist = magDist;
        this.focalMechanism = null;
    }

    public MagFreqDistsForFocalMechs(IncrementalMagFreqDist magDist) {
        this.magFreqDist = new IncrementalMagFreqDist[1];
        this.magFreqDist[0] = magDist;
        this.focalMechanism = null;
    }

    public MagFreqDistsForFocalMechs(IncrementalMagFreqDist[] magDist, FocalMechanism[] focalMechanism) {
        this.magFreqDist = magDist;
        this.focalMechanism = focalMechanism;
        if (magDist.length != focalMechanism.length) {
            throw new RuntimeException("Error - array lengths differ");
        }
    }

    public MagFreqDistsForFocalMechs(IncrementalMagFreqDist magDist, FocalMechanism focalMechanism) {
        IncrementalMagFreqDist[] magDistArray = new IncrementalMagFreqDist[]{magDist};
        FocalMechanism[] focalMechanismArray = new FocalMechanism[]{focalMechanism};
        this.magFreqDist = magDistArray;
        this.focalMechanism = focalMechanismArray;
    }

    public MagFreqDistsForFocalMechs(IncrementalMagFreqDist magDist, FocalMechanism[] focalMechanism, double[] wt) {
        if (wt.length != focalMechanism.length) {
            throw new RuntimeException("Error - array lengths differ");
        }
        this.focalMechanism = focalMechanism;
        this.magFreqDist = new IncrementalMagFreqDist[focalMechanism.length];
        double totRate = magDist.getTotalIncrRate();
        for (int i = 0; i < focalMechanism.length; ++i) {
            IncrementalMagFreqDist newMagDist = magDist.deepClone();
            newMagDist.scaleToCumRate(0, totRate * wt[i]);
            this.magFreqDist[i] = newMagDist;
        }
    }

    public FocalMechanism[] getFocalMechanismList() {
        return this.focalMechanism;
    }

    public IncrementalMagFreqDist[] getMagFreqDistList() {
        return this.magFreqDist;
    }

    public int getNumMagFreqDists() {
        return this.magFreqDist.length;
    }

    public int getNumFocalMechs() {
        return this.focalMechanism.length;
    }

    public IncrementalMagFreqDist getMagFreqDist(int index) {
        return this.magFreqDist[index];
    }

    public FocalMechanism getFocalMech(int index) {
        return this.focalMechanism[index];
    }

    public IncrementalMagFreqDist getFirstMagFreqDist() {
        return this.magFreqDist[0];
    }

    public FocalMechanism getFirstFocalMech() {
        return this.focalMechanism[0];
    }
}

