/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.PointSurface;

public class ObsEqkRupture
extends EqkRupture
implements Serializable {
    protected String eventId;
    protected long originTimeInMillis;

    public ObsEqkRupture() {
    }

    public ObsEqkRupture(String eventId, long originTimeInMillis, Location hypoLoc, double mag) {
        super(mag, 0.0, null, hypoLoc);
        PointSurface surface = new PointSurface(hypoLoc);
        this.setRuptureSurface(surface);
        this.eventId = eventId;
        this.originTimeInMillis = originTimeInMillis;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public GregorianCalendar getOriginTimeCal() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(this.originTimeInMillis);
        return cal;
    }

    public void setOriginTimeCal(GregorianCalendar origTimeCal) {
        this.originTimeInMillis = origTimeCal.getTimeInMillis();
    }

    public long getOriginTime() {
        return this.originTimeInMillis;
    }

    public void setOriginTime(long originTimeInMillis) {
        this.originTimeInMillis = originTimeInMillis;
    }

    public boolean equalsObsEqkRupEvent(ObsEqkRupture obsRupEvent) {
        return this.eventId.equals(obsRupEvent.getEventId()) && this.getMag() == obsRupEvent.getMag();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObsEqkRupture) {
            return this.equalsObsEqkRupEvent((ObsEqkRupture)obj);
        }
        return false;
    }

    @Override
    public String getInfo() {
        Object obsEqkInfo = super.getInfo();
        obsEqkInfo = (String)obsEqkInfo + "EventId =" + this.eventId + "\n";
        obsEqkInfo = (String)obsEqkInfo + "OriginTimeInMillis =" + this.originTimeInMillis + "\n";
        return obsEqkInfo;
    }

    public Object clone() {
        ObsEqkRupture eqkEventClone = new ObsEqkRupture();
        eqkEventClone.setEventId(this.eventId);
        eqkEventClone.setMag(this.mag);
        eqkEventClone.setRuptureSurface(this.getRuptureSurface());
        eqkEventClone.setHypocenterLocation(this.hypocenterLocation);
        eqkEventClone.setOriginTime(this.originTimeInMillis);
        eqkEventClone.setAveRake(this.aveRake);
        return eqkEventClone;
    }
}

