/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class USGS_NSHMP_CatalogParser {
    public static ObsEqkRupList loadCatalog(File file) throws IOException {
        ObsEqkRupList rups = new ObsEqkRupList();
        BufferedReader in = new BufferedReader(new FileReader(file));
        boolean startID = true;
        int eventID = -1;
        while (in.ready()) {
            String line = in.readLine();
            line = line.trim();
            line = line.replaceAll("\t", " ");
            while (line.contains("  ")) {
                line = line.replaceAll("  ", " ");
            }
            String[] split = line.split(" ");
            double mag = Double.parseDouble(split[0]);
            double longitude = Double.parseDouble(split[1]);
            double latitude = Double.parseDouble(split[2]);
            double depth = Double.parseDouble(split[3]);
            int year = Integer.parseInt(split[4]);
            int month = Integer.parseInt(split[5]);
            int date = Integer.parseInt(split[6]);
            int hourOfDay = Integer.parseInt(split[7]);
            int minute = Integer.parseInt(split[8]);
            double second = Double.parseDouble(split[9]);
            double mag_expected = Double.parseDouble(split[11]);
            double n_star = Double.parseDouble(split[12]);
            if (Double.isNaN(depth) || depth < 0.0) {
                depth = 0.0;
            }
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT-0:00"));
            cal.clear();
            cal.set(year, month - 1, date, hourOfDay, minute, (int)second);
            Location hypoLoc = new Location(latitude, longitude, depth);
            rups.add(new ObsEqkRupture("" + ++eventID, cal.getTimeInMillis(), hypoLoc, mag));
        }
        in.close();
        return rups;
    }

    public static void main(String[] args) throws IOException {
        File file = new File("/Users/field/MiscDocs/MuellerGK_FortranCode/wmm.c2");
        ObsEqkRupList rupList = USGS_NSHMP_CatalogParser.loadCatalog(file);
        for (ObsEqkRupture obsEqkRupture : rupList) {
        }
        System.out.println("numEvents = " + rupList.size());
    }
}

