/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.PEER_testsMagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.SimpleFaultParameter;

public class FloatingPoissonFaultERF
extends AbstractERF {
    private static String C = new String("FloatingPoissonFaultERF");
    private boolean D = false;
    public static final String NAME = "Floating Poisson Fault ERF";
    private FloatingPoissonFaultSource source;
    public static final String MAG_DIST_PARAM_NAME = "Mag Freq Dist";
    public static final String FAULT_PARAM_NAME = "Fault Parameter";
    public static final String OFFSET_PARAM_NAME = "Rupture Offset";
    private static final String OFFSET_PARAM_INFO = "The amount floating ruptures are offset along the fault";
    private static final String OFFSET_PARAM_UNITS = "km";
    private static final double OFFSET_PARAM_MIN = 0.01;
    private static final double OFFSET_PARAM_MAX = 100.0;
    private Double OFFSET_PARAM_DEFAULT = 1.0;
    public static final String MAG_SCALING_REL_PARAM_NAME = "Mag-Scaling Relationship";
    private static final String MAG_SCALING_REL_PARAM_INFO = "Relationship to use for Area(Mag) or Area(Length) calculations";
    private ArrayList magScalingRelOptions;
    public static final String SIGMA_PARAM_NAME = "Mag Scaling Sigma";
    private static final String SIGMA_PARAM_INFO = "The standard deviation of the Area(mag) or Length(M) relationship";
    private Double SIGMA_PARAM_MIN = 0.0;
    private Double SIGMA_PARAM_MAX = 1.0;
    private Double SIGMA_PARAM_DEFAULT = 0.0;
    public static final String ASPECT_RATIO_PARAM_NAME = "Rupture Aspect Ratio";
    private static final String ASPECT_RATIO_PARAM_INFO = "The ratio of rupture length to rupture width";
    private Double ASPECT_RATIO_PARAM_MIN = Double.MIN_VALUE;
    private Double ASPECT_RATIO_PARAM_MAX = Double.MAX_VALUE;
    private Double ASPECT_RATIO_PARAM_DEFAULT = 1.0;
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = -180.0;
    private Double RAKE_PARAM_MAX = 180.0;
    private Double RAKE_PARAM_DEFAULT = 0.0;
    public static final String MIN_MAG_PARAM_NAME = "Min Mag";
    private static final String MIN_MAG_PARAM_INFO = "The minimum mag to be considered from the mag freq dist";
    private Double MIN_MAG_PARAM_MIN = 0.0;
    private Double MIN_MAG_PARAM_MAX = 10.0;
    private Double MIN_MAG_PARAM_DEFAULT = 5.0;
    public static final String FLOATER_TYPE_PARAM_NAME = "Floater Type";
    public static final String FLOATER_TYPE_FULL_DDW = "Only along strike ( rupture full DDW)";
    public static final String FLOATER_TYPE_ALONG_STRIKE_AND_DOWNDIP = "Along strike and down dip";
    public static final String FLOATER_TYPE_CENTERED_DOWNDIP = "Along strike & centered down dip";
    public static final String FLOATER_TYPE_PARAM_DEFAULT = "Along strike and down dip";
    public static final String MAX_FLOAT_MAG_PARAM_NAME = "Max Floater Mag";
    private static final String MAX_FLOAT_MAG_PARAM_INFO = "This forces full-fault rupture for mags greater than or equal to this value";
    private Double MAX_FLOAT_MAG_PARAM_MIN = 0.0;
    private Double MAX_FLOAT_MAG_PARAM_MAX = 10.0;
    private Double MAX_FLOAT_MAG_PARAM_DEFAULT = 10.0;
    MagFreqDistParameter magDistParam;
    SimpleFaultParameter faultParam;
    DoubleParameter rupOffsetParam;
    StringParameter magScalingRelParam;
    DoubleParameter sigmaParam;
    DoubleParameter aspectRatioParam;
    DoubleParameter rakeParam;
    DoubleParameter minMagParam;
    StringParameter floaterTypeParam;
    DoubleParameter maxFloatMagParam;

    public FloatingPoissonFaultERF() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        ArrayList<String> supportedMagDists = new ArrayList<String>();
        supportedMagDists.add(GaussianMagFreqDist.NAME);
        supportedMagDists.add(SingleMagFreqDist.NAME);
        supportedMagDists.add(GutenbergRichterMagFreqDist.NAME);
        supportedMagDists.add(YC_1985_CharMagFreqDist.NAME);
        supportedMagDists.add(SummedMagFreqDist.NAME);
        supportedMagDists.add(ArbIncrementalMagFreqDist.NAME);
        this.magDistParam = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, supportedMagDists);
        this.faultParam = new SimpleFaultParameter(FAULT_PARAM_NAME);
        this.rupOffsetParam = new DoubleParameter(OFFSET_PARAM_NAME, 0.01, 100.0, OFFSET_PARAM_UNITS, this.OFFSET_PARAM_DEFAULT);
        this.rupOffsetParam.setInfo(OFFSET_PARAM_INFO);
        this.magScalingRelOptions = new ArrayList();
        this.magScalingRelOptions.add("Wells & Coppersmith (1994)");
        this.magScalingRelOptions.add("W&C 1994 Mag-Length Rel.");
        this.magScalingRelOptions.add("PEER Tests Mag-Area Rel.");
        this.magScalingRelParam = new StringParameter(MAG_SCALING_REL_PARAM_NAME, this.magScalingRelOptions, "Wells & Coppersmith (1994)");
        this.magScalingRelParam.setInfo(MAG_SCALING_REL_PARAM_INFO);
        this.sigmaParam = new DoubleParameter(SIGMA_PARAM_NAME, this.SIGMA_PARAM_MIN, this.SIGMA_PARAM_MAX, this.SIGMA_PARAM_DEFAULT);
        this.sigmaParam.setInfo(SIGMA_PARAM_INFO);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, RAKE_PARAM_UNITS, this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.aspectRatioParam = new DoubleParameter(ASPECT_RATIO_PARAM_NAME, this.ASPECT_RATIO_PARAM_MIN, this.ASPECT_RATIO_PARAM_MAX, this.ASPECT_RATIO_PARAM_DEFAULT);
        this.aspectRatioParam.setInfo(ASPECT_RATIO_PARAM_INFO);
        this.minMagParam = new DoubleParameter(MIN_MAG_PARAM_NAME, this.MIN_MAG_PARAM_MIN, this.MIN_MAG_PARAM_MAX, this.MIN_MAG_PARAM_DEFAULT);
        this.minMagParam.setInfo(MIN_MAG_PARAM_INFO);
        this.maxFloatMagParam = new DoubleParameter(MAX_FLOAT_MAG_PARAM_NAME, this.MAX_FLOAT_MAG_PARAM_MIN, this.MAX_FLOAT_MAG_PARAM_MAX, this.MAX_FLOAT_MAG_PARAM_DEFAULT);
        this.maxFloatMagParam.setInfo(MAX_FLOAT_MAG_PARAM_INFO);
        ArrayList<String> floaterTypes = new ArrayList<String>();
        floaterTypes.add(FLOATER_TYPE_FULL_DDW);
        floaterTypes.add("Along strike and down dip");
        floaterTypes.add(FLOATER_TYPE_CENTERED_DOWNDIP);
        this.floaterTypeParam = new StringParameter(FLOATER_TYPE_PARAM_NAME, floaterTypes, "Along strike and down dip");
        this.adjustableParams.addParameter(this.rupOffsetParam);
        this.adjustableParams.addParameter(this.magScalingRelParam);
        this.adjustableParams.addParameter(this.sigmaParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.aspectRatioParam);
        this.adjustableParams.addParameter(this.minMagParam);
        this.adjustableParams.addParameter(this.faultParam);
        this.adjustableParams.addParameter(this.magDistParam);
        this.adjustableParams.addParameter(this.floaterTypeParam);
        this.adjustableParams.addParameter(this.maxFloatMagParam);
        this.rupOffsetParam.addParameterChangeListener(this);
        this.magScalingRelParam.addParameterChangeListener(this);
        this.sigmaParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.aspectRatioParam.addParameterChangeListener(this);
        this.minMagParam.addParameterChangeListener(this);
        this.faultParam.addParameterChangeListener(this);
        this.magDistParam.addParameterChangeListener(this);
        this.floaterTypeParam.addParameterChangeListener(this);
        this.maxFloatMagParam.addParameterChangeListener(this);
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            String magScalingRelString = (String)this.magScalingRelParam.getValue();
            if (this.D) {
                System.out.println(S + "  " + magScalingRelString);
            }
            MagScalingRelationship magScalingRel = magScalingRelString.equals("Wells & Coppersmith (1994)") ? new WC1994_MagAreaRelationship() : (magScalingRelString.equals("W&C 1994 Mag-Length Rel.") ? new WC1994_MagLengthRelationship() : new PEER_testsMagAreaRelationship());
            if (this.D) {
                System.out.println(S + "  " + magScalingRel.getName());
            }
            String floatType = (String)this.floaterTypeParam.getValue();
            int floatTypeFlag = -1;
            floatTypeFlag = floatType.equals(FLOATER_TYPE_FULL_DDW) ? 0 : (floatType.equals("Along strike and down dip") ? 1 : 2);
            this.source = new FloatingPoissonFaultSource((IncrementalMagFreqDist)this.magDistParam.getValue(), (AbstractEvenlyGriddedSurfaceWithSubsets)this.faultParam.getValue(), magScalingRel, (Double)this.sigmaParam.getValue(), (Double)this.aspectRatioParam.getValue(), (Double)this.rupOffsetParam.getValue(), (Double)this.rakeParam.getValue(), this.timeSpan.getDuration(), (Double)this.minMagParam.getValue(), floatTypeFlag, (Double)this.maxFloatMagParam.getValue());
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    @Override
    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<FloatingPoissonFaultSource> v = new ArrayList<FloatingPoissonFaultSource>();
        v.add(this.source);
        return v;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

