/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.NewZealand;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.HanksBakun2002_MagAreaRel;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public class NewZealandERF2010
extends AbstractERF {
    private static String C = new String("NewZealand_ERF_2010");
    private boolean D = false;
    public static final String NAME = new String("NewZealand_ERF_2010");
    private static final String FAULT_SOURCE_FILENAME = "/data/erf/new_zealand_2010/NZ_FLTmodel_2010.txt";
    private static final String BG_FILE_NAME = "/data/erf/new_zealand_2010/NZBCK211_OpenSHA.txt";
    private static final double MIN_MAG = 5.0;
    private static final double MAX_MAG = 9.0;
    private static final int NUM_MAGS = 41;
    private static final double magIncrement = 0.1;
    private static final double DEFAULT_GRID_SPACING = 1.0;
    public static final String FAULT_AND_BACK_SEIS_NAME = new String("Background and Fault Seismicity");
    public static final String FAULT_AND_BACK_SEIS = new String("Fault and Background Sources");
    public static final String FAULT_SEIS_ONLY = new String("Fault Sources Only");
    public static final String BACK_SEIS_ONLY = new String("Background Sources Only");
    private StringParameter backSeisParam;
    public static final String EPISTEMIC_PARAM_NAME = "Consider Epistemic Uncertainties";
    private static final String EPISTEMIC_PARAM_INFO = "Consideration of Epistemic Uncertainties";
    private static final Boolean EPISTEMIC_PARAM_DEFAULT = false;
    private BooleanParameter epistemicParam;
    public static final String EPISTEMIC_GEOMETRY_PARAM_NAME = "Epistemic Uncertainties in fault length, depth";
    private static final String EPISTEMIC_GEOMETRY_PARAM_INFO = "Epistemic Uncertainties in fault length, depth";
    private static final Boolean EPISTEMIC_GEOMETRY_PARAM_DEFAULT = false;
    private BooleanParameter epistemicGeometryParam;
    public static final String EPISTEMIC_DIP_PARAM_NAME = "Epistemic Uncertainties in fault dip";
    private static final String EPISTEMIC_DIP_PARAM_INFO = "Epistemic Uncertainties in fault dip";
    private static final Boolean EPISTEMIC_DIP_PARAM_DEFAULT = false;
    private BooleanParameter epistemicDipParam;
    public static final String EPISTEMIC_SLIP_PARAM_NAME = "Epistemic Uncertainties in fault slip rate and coupling";
    private static final String EPISTEMIC_SLIP_PARAM_INFO = "Epistemic Uncertainties in fault slip rate and coupling";
    private static final Boolean EPISTEMIC_SLIP_PARAM_DEFAULT = false;
    private BooleanParameter epistemicSlipParam;
    public static final String EPISTEMIC_MAGSCALING_PARAM_NAME = "Epistemic Uncertainties in Magnitude Scaling Relations";
    private static final String EPISTEMIC_MAGSCALING_PARAM_INFO = "Epistemic Uncertainties in Magnitude Scaling Relations";
    private static final Boolean EPISTEMIC_MAGSCALING_PARAM_DEFAULT = false;
    private BooleanParameter epistemicMagScalingParam;
    public static final String EPISTEMIC_MAGSCALINGCORRELATION_PARAM_NAME = "Correlation of Epistemic Uncertainties in Mw Scaling on faults";
    private static final String EPISTEMIC_MAGSCALINGCORRELATION_PARAM_INFO = "Correlation of Epistemic Uncertainties in Mw Scaling on faults";
    private static final double EPISTEMIC_MAGSCALINGCORRELATION_PARAM_DEFAULT = 0.5;
    private DoubleParameter epistemicMagScalingCorrelationParam;
    public static final String EPISTEMIC_MAGSCALINGPROPORTION_PARAM_NAME = "Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)";
    private static final String EPISTEMIC_MAGSCALINGPROPORTION_PARAM_INFO = "Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)";
    private static final double EPISTEMIC_MAGSCALINGPROPORTION_PARAM_DEFAULT = 0.5;
    private DoubleParameter epistemicMagScalingUncertaintyProportionParam;
    private int numBkSources = 0;
    private ArrayList<String> bkSourceNames = new ArrayList();
    private ArrayList<String> bkSourceTectonicTypes = new ArrayList();
    private ArrayList<Location> bkSourceLocation = new ArrayList();
    private ArrayList<GriddedRegion> bkSourceRegion = new ArrayList();
    private ArrayList<Double> bkBValMeans = new ArrayList();
    private ArrayList<Double> bkBValSigmas = new ArrayList();
    private ArrayList<Double> bkMoRateMeans = new ArrayList();
    private ArrayList<Double> bkMoRateSigmas = new ArrayList();
    private ArrayList<Double> bkMMaxMeans = new ArrayList();
    private ArrayList<Double> bkMMaxSigmas = new ArrayList();
    private ArrayList<Double> bkMMins = new ArrayList();
    private ArrayList<IncrementalMagFreqDist> bkMagFD = new ArrayList();
    private ArrayList<Double> bkRake = new ArrayList();
    private ArrayList<Double> bkDip = new ArrayList();
    private ArrayList<ProbEqkSource> allSources = new ArrayList();
    private GutenbergRichterMagFreqDist backgroundMagDist;
    private GriddedRegion backgroundRegion;
    private ArrayList<String> sourceNames = new ArrayList();
    private ArrayList<String> sourceTectonicTypes = new ArrayList();
    private ArrayList<String> sourceFaultTypes = new ArrayList();
    private ArrayList<Double> sourceLengthMeans = new ArrayList();
    private ArrayList<Double> sourceLengthSigmas = new ArrayList();
    private ArrayList<Double> sourceDipMeans = new ArrayList();
    private ArrayList<Double> sourceDipSigmas = new ArrayList();
    private ArrayList<Double> sourceDipDirs = new ArrayList();
    private ArrayList<Double> sourceRakes = new ArrayList();
    private ArrayList<Double> sourceTopMeans = new ArrayList();
    private ArrayList<Double> sourceTopMins = new ArrayList();
    private ArrayList<Double> sourceTopMaxs = new ArrayList();
    private ArrayList<Double> sourceBottomMeans = new ArrayList();
    private ArrayList<Double> sourceBottomSigmas = new ArrayList();
    private ArrayList<Double> sourceSlipRateMeans = new ArrayList();
    private ArrayList<Double> sourceSlipRateSigmas = new ArrayList();
    private ArrayList<Double> sourceCouplingCoeffMeans = new ArrayList();
    private ArrayList<Double> sourceCouplingCoeffSigmas = new ArrayList();
    private ArrayList<Double> sourceMedianMags = new ArrayList();
    private ArrayList<Double> sourceMedianAnnualRates = new ArrayList();
    private ArrayList<TectonicRegionType> tectonicRegionTypes;
    private static final String ACTIVE_SHALLOW = "ACTIVE_SHALLOW";
    private static final String SUBDUCTION_INTERFACE = "SUBDUCTION_INTERFACE";
    private static final String SUBDUCTION_SLAB = "SUBDUCTION_SLAB";
    private static final String VOLCANIC = "VOLCANIC";
    private int numActiveShallow = 0;
    private int numSubSlab = 0;
    private int numSubInterface = 0;
    private int numVolcanic = 0;
    private static final String OTHER_CRUSTAL_FAULTING = "OTHER_CRUSTAL_FAULTING";
    private static final String PLATE_BOUNDARY = "PLATE_BOUNDARY";
    private static final String NORMAL_FAULTING = "NORMAL_FAULTING";
    private static final HanksBakun2002_MagAreaRel hanksBakunMwAreaScaling = new HanksBakun2002_MagAreaRel();
    private ArrayList<EvenlyGriddedSurface> sourceGriddedSurface = new ArrayList();
    private static final double mu = 3.0 * Math.pow(10.0, 10.0);

    public NewZealandERF2010() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.timeSpan.setDuration(1.0);
        this.createFaultSurfaces();
        this.createBackRegion();
        this.initAdjParams();
        this.createParamList();
        this.makeTectonicRegionList();
    }

    private void initAdjParams() {
        ArrayList<String> backSeisOptionsStrings = new ArrayList<String>();
        backSeisOptionsStrings.add(FAULT_AND_BACK_SEIS);
        backSeisOptionsStrings.add(FAULT_SEIS_ONLY);
        backSeisOptionsStrings.add(BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(FAULT_AND_BACK_SEIS_NAME, backSeisOptionsStrings, FAULT_AND_BACK_SEIS);
        this.backSeisParam.addParameterChangeListener(this);
        this.epistemicParam = new BooleanParameter(EPISTEMIC_PARAM_NAME, EPISTEMIC_PARAM_DEFAULT);
        this.epistemicParam.setInfo(EPISTEMIC_PARAM_INFO);
        this.epistemicParam.addParameterChangeListener(this);
        this.epistemicGeometryParam = new BooleanParameter("Epistemic Uncertainties in fault length, depth", EPISTEMIC_GEOMETRY_PARAM_DEFAULT);
        this.epistemicGeometryParam.setInfo("Epistemic Uncertainties in fault length, depth");
        this.epistemicGeometryParam.addParameterChangeListener(this);
        this.epistemicDipParam = new BooleanParameter("Epistemic Uncertainties in fault dip", EPISTEMIC_DIP_PARAM_DEFAULT);
        this.epistemicDipParam.setInfo("Epistemic Uncertainties in fault dip");
        this.epistemicDipParam.addParameterChangeListener(this);
        this.epistemicSlipParam = new BooleanParameter("Epistemic Uncertainties in fault slip rate and coupling", EPISTEMIC_SLIP_PARAM_DEFAULT);
        this.epistemicSlipParam.setInfo("Epistemic Uncertainties in fault slip rate and coupling");
        this.epistemicSlipParam.addParameterChangeListener(this);
        this.epistemicMagScalingParam = new BooleanParameter("Epistemic Uncertainties in Magnitude Scaling Relations", EPISTEMIC_MAGSCALING_PARAM_DEFAULT);
        this.epistemicMagScalingParam.setInfo("Epistemic Uncertainties in Magnitude Scaling Relations");
        this.epistemicMagScalingParam.addParameterChangeListener(this);
        this.epistemicMagScalingCorrelationParam = new DoubleParameter("Correlation of Epistemic Uncertainties in Mw Scaling on faults", EPISTEMIC_MAGSCALINGCORRELATION_PARAM_DEFAULT);
        this.epistemicMagScalingCorrelationParam.setInfo("Correlation of Epistemic Uncertainties in Mw Scaling on faults");
        this.epistemicMagScalingCorrelationParam.addParameterChangeListener(this);
        this.epistemicMagScalingUncertaintyProportionParam = new DoubleParameter("Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)", EPISTEMIC_MAGSCALINGPROPORTION_PARAM_DEFAULT);
        this.epistemicMagScalingUncertaintyProportionParam.setInfo("Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)");
        this.epistemicMagScalingUncertaintyProportionParam.addParameterChangeListener(this);
    }

    public void setAdjParams(ParameterList adjParamVals) {
        ListIterator<String> it = adjParamVals.getParameterNamesIterator();
        while (it.hasNext()) {
            AbstractParameter Param;
            Object paramValueToSet;
            String paramName = (String)it.next();
            if (paramName.equalsIgnoreCase(FAULT_AND_BACK_SEIS_NAME)) {
                paramValueToSet = (String)adjParamVals.getValue(paramName);
                Param = (StringParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase(EPISTEMIC_PARAM_NAME)) {
                paramValueToSet = (Boolean)adjParamVals.getValue(paramName);
                Param = (BooleanParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase(EPISTEMIC_PARAM_NAME)) {
                paramValueToSet = (Boolean)adjParamVals.getValue(paramName);
                Param = (BooleanParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase("Epistemic Uncertainties in fault length, depth")) {
                paramValueToSet = (Boolean)adjParamVals.getValue(paramName);
                Param = (BooleanParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase("Epistemic Uncertainties in fault dip")) {
                paramValueToSet = (Boolean)adjParamVals.getValue(paramName);
                Param = (BooleanParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase("Epistemic Uncertainties in fault slip rate and coupling")) {
                paramValueToSet = (Boolean)adjParamVals.getValue(paramName);
                Param = (BooleanParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase("Epistemic Uncertainties in Magnitude Scaling Relations")) {
                paramValueToSet = (Boolean)adjParamVals.getValue(paramName);
                Param = (BooleanParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (paramName.equalsIgnoreCase("Correlation of Epistemic Uncertainties in Mw Scaling on faults")) {
                paramValueToSet = (Double)adjParamVals.getValue(paramName);
                Param = (DoubleParameter)this.adjustableParams.getParameter(paramName);
                Param.setValue(paramValueToSet);
                continue;
            }
            if (!paramName.equalsIgnoreCase("Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)")) continue;
            paramValueToSet = (Double)adjParamVals.getValue(paramName);
            Param = (DoubleParameter)this.adjustableParams.getParameter(paramName);
            Param.setValue(paramValueToSet);
        }
    }

    private void createBackRegion() {
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(BG_FILE_NAME);
            int size = fileLines.size();
            int j = 4;
            String sourceName = fileLines.get(j);
            StringTokenizer st = new StringTokenizer(sourceName);
            String srcCode = st.nextToken();
            int srcCodeLength = srcCode.length();
            String sourceNameString = sourceName.substring(srcCodeLength);
            for (int i = 5; i < size; ++i) {
                ++this.numBkSources;
                String magDistInfo = fileLines.get(i);
                st = new StringTokenizer(magDistInfo);
                double aVal = Double.parseDouble(st.nextToken().trim());
                double bVal = Double.parseDouble(st.nextToken().trim());
                double minMag = Double.parseDouble(st.nextToken().trim());
                double maxMag = Double.parseDouble(st.nextToken().trim());
                int numMag = Integer.parseInt(st.nextToken().trim());
                double totCumRate = Double.parseDouble(st.nextToken().trim());
                double lat = Double.parseDouble(st.nextToken().trim());
                double lon = Double.parseDouble(st.nextToken().trim());
                if (lon > 180.0) {
                    lon -= 360.0;
                }
                double depth = Double.parseDouble(st.nextToken().trim());
                double rake = Double.parseDouble(st.nextToken().trim());
                double dip = Double.parseDouble(st.nextToken().trim());
                String tectonicType = st.nextToken();
                GutenbergRichterMagFreqDist backgroundMagDist = new GutenbergRichterMagFreqDist(bVal, totCumRate, minMag, maxMag, numMag);
                Location bckLocation = new Location(lat, lon, depth);
                this.bkSourceNames.add("backgroundSource" + this.numBkSources);
                this.bkSourceTectonicTypes.add(tectonicType);
                this.incrementTectonicTypeCounters(tectonicType);
                this.bkSourceLocation.add(bckLocation);
                this.bkMagFD.add(backgroundMagDist);
                this.bkRake.add(rake);
                this.bkDip.add(dip);
                this.bkMMins.add(minMag);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mkBackRegion() {
        for (int srcIndex = 0; srcIndex < this.bkSourceNames.size(); ++srcIndex) {
            PointSource.PoissonPointSource rupSource = ((PointSource.PoissonBuilder)((PointSource.PoissonBuilder)PointSource.poissonBuilder(this.bkSourceLocation.get(srcIndex)).tectonicRegionType(NewZealandERF2010.trtForType(this.bkSourceTectonicTypes.get(srcIndex)))).truePointSources(0.0)).forMFDAndFocalMech(this.bkMagFD.get(srcIndex).getAboveMagnitude(this.bkMMins.get(srcIndex)), new FocalMechanism(Double.NaN, this.bkDip.get(srcIndex), this.bkRake.get(srcIndex))).duration(this.timeSpan.getDuration()).build();
            this.allSources.add(rupSource);
        }
    }

    private void createFaultSurfaces() {
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(FAULT_SOURCE_FILENAME);
            int size = fileLines.size();
            for (int i = 15; i < size; ++i) {
                String sourceName = fileLines.get(i);
                if (sourceName.trim().equals("")) continue;
                StringTokenizer st = new StringTokenizer(sourceName);
                String srcCode = st.nextToken();
                String sourceTectFltType = fileLines.get(++i);
                st = new StringTokenizer(sourceTectFltType);
                String tectonicType = st.nextToken();
                String faultType = st.nextToken();
                String sourceLengthInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceLengthInfo);
                double lengthMean = Double.parseDouble(st.nextToken().trim());
                double lengthSigma = Double.parseDouble(st.nextToken().trim());
                String sourceDipInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceDipInfo);
                double dipMean = Double.parseDouble(st.nextToken().trim());
                double dipSigma = Double.parseDouble(st.nextToken().trim());
                String sourceDipDirInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceDipDirInfo);
                double dipDir = Double.parseDouble(st.nextToken().trim());
                String sourceRakeInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceRakeInfo);
                double rake = Double.parseDouble(st.nextToken().trim());
                String sourceBottomInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceBottomInfo);
                double bottomMean = Double.parseDouble(st.nextToken().trim());
                double bottomSigma = Double.parseDouble(st.nextToken().trim());
                String sourceTopInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceTopInfo);
                double topMean = Double.parseDouble(st.nextToken().trim());
                double topMin = Double.parseDouble(st.nextToken().trim());
                double topMax = Double.parseDouble(st.nextToken().trim());
                String sourceSlipRateInfo = fileLines.get(++i);
                st = new StringTokenizer(sourceSlipRateInfo);
                double slipRateMean = Double.parseDouble(st.nextToken().trim());
                double slipRateSigma = Double.parseDouble(st.nextToken().trim());
                String couplingCoeffInfo = fileLines.get(++i);
                st = new StringTokenizer(couplingCoeffInfo);
                double couplingCoeffMean = Double.parseDouble(st.nextToken().trim());
                double couplingCoeffSigma = Double.parseDouble(st.nextToken().trim());
                String medianMwRivalues = fileLines.get(++i);
                st = new StringTokenizer(medianMwRivalues);
                double medianMag = Double.parseDouble(st.nextToken().trim());
                double medianRI = Double.parseDouble(st.nextToken().trim());
                double medianAnnualRate = 1.0 / medianRI;
                String numSourceLoc = fileLines.get(++i);
                st = new StringTokenizer(numSourceLoc);
                int numSourceLocations = Integer.parseInt(st.nextToken().trim());
                FaultTrace fltTrace = new FaultTrace(srcCode);
                int numLinesDone = i++;
                while (i <= numLinesDone + numSourceLocations) {
                    String location = fileLines.get(i);
                    st = new StringTokenizer(location);
                    double lon = Double.parseDouble(st.nextToken().trim());
                    double lat = Double.parseDouble(st.nextToken().trim());
                    fltTrace.add(new Location(lat, lon));
                    ++i;
                }
                StirlingGriddedSurface surface = new StirlingGriddedSurface(fltTrace, dipMean, topMean, bottomMean, 1.0, dipDir);
                this.sourceNames.add(srcCode);
                this.sourceTectonicTypes.add(tectonicType);
                this.incrementTectonicTypeCounters(tectonicType);
                this.sourceFaultTypes.add(faultType);
                this.sourceLengthMeans.add(lengthMean);
                this.sourceLengthSigmas.add(lengthSigma);
                this.sourceDipMeans.add(dipMean);
                this.sourceDipSigmas.add(dipSigma);
                this.sourceDipDirs.add(dipDir);
                this.sourceRakes.add(rake);
                this.sourceDipMeans.add(dipMean);
                this.sourceDipSigmas.add(dipSigma);
                this.sourceTopMeans.add(topMean);
                this.sourceTopMins.add(topMin);
                this.sourceTopMaxs.add(topMax);
                this.sourceBottomMeans.add(bottomMean);
                this.sourceBottomSigmas.add(bottomSigma);
                this.sourceSlipRateMeans.add(slipRateMean);
                this.sourceSlipRateSigmas.add(slipRateSigma);
                this.sourceCouplingCoeffMeans.add(couplingCoeffMean);
                this.sourceCouplingCoeffSigmas.add(couplingCoeffSigma);
                this.sourceMedianMags.add(medianMag);
                this.sourceMedianAnnualRates.add(medianAnnualRate);
                this.sourceGriddedSurface.add(surface);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mkFaultSources() {
        NormalEstimate zrand = new NormalEstimate(0.0, 1.0, -2.0, 2.0);
        double z_plateBoundary = zrand.getRandomValue();
        double z_otherCrustal = zrand.getRandomValue();
        double z_subductionInterface = zrand.getRandomValue();
        double z_volcanic = zrand.getRandomValue();
        for (int srcIndex = 0; srcIndex < this.sourceNames.size(); ++srcIndex) {
            double momentRate;
            double meanMag_epistemic;
            double sigmaMag_aleatory;
            EvenlyGriddedSurface surface = this.sourceGriddedSurface.get(srcIndex);
            String tectType = this.sourceTectonicTypes.get(srcIndex);
            String fltType = this.sourceFaultTypes.get(srcIndex);
            Boolean epiConsider = (Boolean)this.epistemicParam.getValue();
            Boolean epiGeometry = (Boolean)this.epistemicGeometryParam.getValue();
            Boolean epiDip = (Boolean)this.epistemicDipParam.getValue();
            Boolean epiSlip = (Boolean)this.epistemicSlipParam.getValue();
            Boolean epiMagScaling = (Boolean)this.epistemicMagScalingParam.getValue();
            Double epiMagScalingCorrelation = (Double)this.epistemicMagScalingCorrelationParam.getValue();
            Double epiMagScalingUncertaintyProportion = (Double)this.epistemicMagScalingUncertaintyProportionParam.getValue();
            if (epiConsider.booleanValue()) {
                double sigmaMag_epistemic;
                double z_faultType;
                double sigmaMag;
                double meanMag;
                double meanFltLength = this.sourceLengthMeans.get(srcIndex);
                double sigmaFltLength = this.sourceLengthSigmas.get(srcIndex);
                double z_fltLength = zrand.getRandomValue();
                double length = epiGeometry != false ? meanFltLength + sigmaFltLength * z_fltLength : meanFltLength;
                double meanFltTop = this.sourceTopMeans.get(srcIndex);
                double minFltTop = this.sourceTopMins.get(srcIndex);
                double maxFltTop = this.sourceTopMins.get(srcIndex);
                double top = epiGeometry != false ? minFltTop + (maxFltTop - minFltTop) * Math.random() : meanFltTop;
                double meanFltBottom = this.sourceBottomMeans.get(srcIndex);
                double sigmaFltBottom = this.sourceBottomSigmas.get(srcIndex);
                double z_fltBottom = zrand.getRandomValue();
                double bottom = epiGeometry != false ? meanFltBottom + sigmaFltBottom * z_fltBottom : meanFltBottom;
                double meanFltDip = this.sourceDipMeans.get(srcIndex);
                double sigmaFltDip = this.sourceDipSigmas.get(srcIndex);
                double z_fltDip = zrand.getRandomValue();
                double dip = epiDip != false ? meanFltDip + sigmaFltDip * z_fltDip : meanFltDip;
                double meanFltSlipRate = this.sourceSlipRateMeans.get(srcIndex);
                double sigmaFltSlipRate = this.sourceSlipRateSigmas.get(srcIndex);
                double z_slipRate = zrand.getRandomValue();
                double sliprate = epiSlip != false ? meanFltSlipRate + sigmaFltSlipRate * z_slipRate : meanFltSlipRate;
                double meanCouplingCoeff = this.sourceCouplingCoeffMeans.get(srcIndex);
                double sigmaCouplingCoeff = this.sourceCouplingCoeffSigmas.get(srcIndex);
                double z_couplingCoeff = zrand.getRandomValue();
                double coupCoeff = epiSlip != false ? meanCouplingCoeff + sigmaCouplingCoeff * z_couplingCoeff : meanCouplingCoeff;
                double faultWidth = (bottom - top) / Math.sin(dip * Math.PI / 180.0);
                double faultArea = faultWidth * length;
                if (tectType.equals(ACTIVE_SHALLOW)) {
                    if (fltType.equals(PLATE_BOUNDARY)) {
                        meanMag = hanksBakunMwAreaScaling.getMedianMag(faultArea);
                        sigmaMag = 0.22;
                        z_faultType = z_plateBoundary;
                    } else if (fltType.equals(OTHER_CRUSTAL_FAULTING)) {
                        meanMag = 4.18 + 0.6666666666666666 * Math.log10(faultWidth) + 1.3333333333333333 * Math.log10(length);
                        sigmaMag = 0.18;
                        z_faultType = z_otherCrustal;
                    } else {
                        if (!fltType.equals(NORMAL_FAULTING)) throw new RuntimeException("The fault type is not supported");
                        meanMag = 3.39 + 1.3333333333333333 * Math.log10(faultArea);
                        sigmaMag = 0.195;
                        z_faultType = z_volcanic;
                    }
                } else if (tectType.equals(VOLCANIC)) {
                    meanMag = 3.39 + 1.3333333333333333 * Math.log10(faultArea);
                    sigmaMag = 0.195;
                    z_faultType = z_volcanic;
                } else {
                    if (!tectType.equals(SUBDUCTION_INTERFACE)) throw new RuntimeException("The tectonic region type is not supported");
                    meanMag = 4.441 + 0.846 * Math.log10(faultArea);
                    sigmaMag = 0.286;
                    z_faultType = z_subductionInterface;
                }
                if (epiMagScaling.booleanValue()) {
                    sigmaMag_epistemic = sigmaMag * Math.sqrt(epiMagScalingUncertaintyProportion);
                    sigmaMag_aleatory = sigmaMag * Math.sqrt(1.0 - epiMagScalingUncertaintyProportion);
                    if (sigmaMag_aleatory < 0.01) {
                        sigmaMag_aleatory = 0.01;
                    }
                } else {
                    sigmaMag_epistemic = 0.0;
                    sigmaMag_aleatory = 0.01;
                }
                double z_fault = zrand.getRandomValue();
                double rho = epiMagScalingCorrelation;
                meanMag_epistemic = meanMag + sigmaMag_epistemic * (Math.sqrt(rho) * z_faultType + Math.sqrt(1.0 - rho) * z_fault);
                momentRate = mu * faultArea * (sliprate * 1000.0) * coupCoeff;
            } else {
                meanMag_epistemic = this.sourceMedianMags.get(srcIndex);
                meanMag_epistemic = (double)Math.round(meanMag_epistemic / 0.1) * 0.1;
                sigmaMag_aleatory = 0.01;
                double meanAnnualRate = this.sourceMedianAnnualRates.get(srcIndex);
                double meanMomentMag = Math.pow(10.0, 9.05 + 1.5 * meanMag_epistemic);
                momentRate = meanAnnualRate * meanMomentMag;
            }
            GaussianMagFreqDist magDist = new GaussianMagFreqDist(5.0, 9.0, 41, meanMag_epistemic, sigmaMag_aleatory, momentRate);
            FaultRuptureSource rupSource = new FaultRuptureSource(magDist, (RuptureSurface)surface, (double)this.sourceRakes.get(srcIndex), this.timeSpan.getDuration());
            rupSource.setName(this.sourceNames.get(srcIndex));
            this.setTectonicTypeOfSource(rupSource, tectType);
            this.allSources.add(rupSource);
        }
    }

    public void incrementTectonicTypeCounters(String tectType) {
        if (tectType.equals(ACTIVE_SHALLOW)) {
            ++this.numActiveShallow;
        } else if (tectType.equals(VOLCANIC)) {
            ++this.numVolcanic;
        } else if (tectType.equals(SUBDUCTION_INTERFACE)) {
            ++this.numSubInterface;
        } else if (tectType.equals(SUBDUCTION_SLAB)) {
            ++this.numSubSlab;
        } else {
            throw new RuntimeException("The tectonic region type is not supported");
        }
    }

    private static TectonicRegionType trtForType(String tectType) {
        if (tectType.equals(ACTIVE_SHALLOW)) {
            return TectonicRegionType.ACTIVE_SHALLOW;
        }
        if (tectType.equals(VOLCANIC)) {
            return TectonicRegionType.VOLCANIC;
        }
        if (tectType.equals(SUBDUCTION_INTERFACE)) {
            return TectonicRegionType.SUBDUCTION_INTERFACE;
        }
        if (tectType.equals(SUBDUCTION_SLAB)) {
            return TectonicRegionType.SUBDUCTION_SLAB;
        }
        throw new RuntimeException("The tectonic region type is not supported");
    }

    public void setTectonicTypeOfSource(ProbEqkSource rupSource, String tectType) {
        rupSource.setTectonicRegionType(NewZealandERF2010.trtForType(tectType));
    }

    public void makeTectonicRegionList() {
        this.tectonicRegionTypes = new ArrayList();
        if (this.numActiveShallow > 0) {
            this.tectonicRegionTypes.add(TectonicRegionType.ACTIVE_SHALLOW);
        }
        if (this.numVolcanic > 0) {
            this.tectonicRegionTypes.add(TectonicRegionType.VOLCANIC);
        }
        if (this.numSubSlab > 0) {
            this.tectonicRegionTypes.add(TectonicRegionType.SUBDUCTION_SLAB);
        }
        if (this.numSubInterface > 0) {
            this.tectonicRegionTypes.add(TectonicRegionType.SUBDUCTION_INTERFACE);
        }
    }

    public ArrayList<TectonicRegionType> getTectonicRegionTypes() {
        return this.tectonicRegionTypes;
    }

    protected void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.backSeisParam);
        this.adjustableParams.addParameter(this.epistemicParam);
        if (((Boolean)this.epistemicParam.getValue()).booleanValue()) {
            this.adjustableParams.addParameter(this.epistemicGeometryParam);
            this.adjustableParams.addParameter(this.epistemicDipParam);
            this.adjustableParams.addParameter(this.epistemicSlipParam);
            this.adjustableParams.addParameter(this.epistemicMagScalingParam);
            if (((Boolean)this.epistemicMagScalingParam.getValue()).booleanValue()) {
                this.adjustableParams.addParameter(this.epistemicMagScalingCorrelationParam);
                this.adjustableParams.addParameter(this.epistemicMagScalingUncertaintyProportionParam);
            }
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
        this.createParamList();
    }

    @Override
    public int getNumSources() {
        return this.allSources.size();
    }

    @Override
    public ProbEqkSource getSource(int source) {
        return this.allSources.get(source);
    }

    public ArrayList getSourceList() {
        return this.allSources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        this.allSources = new ArrayList();
        String faltBkgSeisVal = (String)this.backSeisParam.getValue();
        if (faltBkgSeisVal.equals(FAULT_AND_BACK_SEIS)) {
            this.mkFaultSources();
            this.mkBackRegion();
        } else if (faltBkgSeisVal.equals(FAULT_SEIS_ONLY)) {
            this.mkFaultSources();
        } else if (faltBkgSeisVal.equals(BACK_SEIS_ONLY)) {
            this.mkBackRegion();
        }
        this.makeTectonicRegionList();
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        return this.tectonicRegionTypes;
    }

    public static void main(String[] args) {
        NewZealandERF2010 nzerf = new NewZealandERF2010();
        nzerf.parameterChangeFlag = true;
        nzerf.updateForecast();
    }
}

