/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;

public class PEER_AreaForecast
extends AbstractERF {
    private static String C = new String("PEER_AreaForecast");
    private boolean D = false;
    public static final String NAME = "PEER Area Forecast";
    private GutenbergRichterMagFreqDist dist_GR;
    private PointSource.PoissonPointSource pointPoissonEqkSource;
    private static final double LAT_TOP = 38.901;
    private static final double LAT_BOTTOM = 37.099;
    private static final double LAT_CENTER = 38.0;
    private static final double LONG_LEFT = -123.138;
    private static final double LONG_RIGHT = -120.862;
    private static final double LONG_CENTER = -122.0;
    private static final double MAX_DISTANCE = 100.0;
    public static final String GRID_PARAM_NAME = "Area Grid Spacing";
    public static final String GRID_PARAM_UNITS = "km";
    private static final double GRID_PARAM_MIN = 0.001;
    private static final double GRID_PARAM_MAX = 100.0;
    public static final String DEPTH_LOWER_PARAM_NAME = "Lower Seis Depth";
    public static final String DEPTH_UPPER_PARAM_NAME = "Upper Seis Depth";
    public static final String DEPTH_PARAM_UNITS = "km";
    private static final double DEPTH_PARAM_MIN = 0.0;
    private static final double DEPTH_PARAM_MAX = 30.0;
    private static final Double DEPTH_PARAM_DEFAULT = 5.0;
    public static final String MAG_DIST_PARAM_NAME = "Mag Dist";
    public static final String RAKE_PARAM_NAME = "Ave Rake";
    public static final String RAKE_PARAM_UNITS = "degrees";
    private static final Double RAKE_PARAM_DEFAULT = 0.0;
    private static final double RAKE_PARAM_MIN = -180.0;
    private static final double RAKE_PARAM_MAX = 180.0;
    public static final String DIP_PARAM_NAME = "Ave Dip";
    public static final String DIP_PARAM_UNITS = "degrees";
    private static final Double DIP_PARAM_DEFAULT = 90.0;
    private static final double DIP_PARAM_MIN = 0.0;
    private static final double DIP_PARAM_MAX = 90.0;
    private Double DEFAULT_GRID_VAL = 1.0;
    private LocationList locationList;
    DoubleParameter gridParam = new DoubleParameter("Area Grid Spacing", 0.001, 100.0, "km", this.DEFAULT_GRID_VAL);
    DoubleParameter depthLowerParam = new DoubleParameter("Lower Seis Depth", 0.0, 30.0, "km", DEPTH_PARAM_DEFAULT);
    DoubleParameter depthUpperParam = new DoubleParameter("Upper Seis Depth", 0.0, 30.0, "km", DEPTH_PARAM_DEFAULT);
    DoubleParameter rakeParam = new DoubleParameter("Ave Rake", -180.0, 180.0, "degrees", RAKE_PARAM_DEFAULT);
    DoubleParameter dipParam = new DoubleParameter("Ave Dip", 0.0, 90.0, "degrees", DIP_PARAM_DEFAULT);
    ArrayList supportedMagDists = new ArrayList();
    MagFreqDistParameter magDistParam;
    private IncrementalMagFreqDist dist;
    private double rake;
    private double dip;

    public PEER_AreaForecast() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.adjustableParams.addParameter(this.gridParam);
        this.adjustableParams.addParameter(this.depthLowerParam);
        this.adjustableParams.addParameter(this.depthUpperParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.dipParam);
        this.supportedMagDists.add(GutenbergRichterMagFreqDist.NAME);
        this.magDistParam = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, this.supportedMagDists);
        this.adjustableParams.addParameter(this.magDistParam);
        this.gridParam.addParameterChangeListener(this);
        this.depthLowerParam.addParameterChangeListener(this);
        this.depthUpperParam.addParameterChangeListener(this);
        this.magDistParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            if (this.magDistParam.getValue() == null) {
                throw new RuntimeException("Magnitude Distribution is null");
            }
            double gridSpacing = (Double)this.gridParam.getValue();
            double depthLower = (Double)this.depthLowerParam.getValue();
            double depthUpper = (Double)this.depthUpperParam.getValue();
            if (depthUpper > depthLower) {
                throw new RuntimeException("Upper Seis Depth must be \u2264 Lower Seis Depth");
            }
            Location gridCenter = new Location(38.0, -122.0);
            double latDiff = GeoTools.degreesLatPerKm(gridCenter) * gridSpacing;
            double longDiff = GeoTools.degreesLonPerKm(gridCenter) * gridSpacing;
            this.locationList = new LocationList();
            for (double lat = 38.901; lat >= 37.099; lat -= latDiff) {
                for (double lon = -123.138; lon <= -120.862; lon += longDiff) {
                    Location location = new Location(38.0, -122.0);
                    Location location2 = new Location(lat, lon);
                    if (!(LocationUtils.horzDistance(location, location2) <= 100.0)) continue;
                    for (double depth = depthUpper; depth <= depthLower; depth += gridSpacing) {
                        this.locationList.add(new Location(lat, lon, depth));
                    }
                }
            }
            int numLocs = this.locationList.size();
            this.dist_GR = (GutenbergRichterMagFreqDist)this.magDistParam.getValue();
            this.dist = new IncrementalMagFreqDist(this.dist_GR.getMinX(), this.dist_GR.getMaxX(), this.dist_GR.size());
            for (int i = 0; i < this.dist.size(); ++i) {
                this.dist.set(i, this.dist_GR.getY(i) / (double)numLocs);
            }
            this.rake = (Double)this.rakeParam.getValue();
            this.dip = (Double)this.dipParam.getValue();
            if (this.D) {
                System.out.println(C + " updateForecast(): rake=" + this.pointPoissonEqkSource.getRupture(0).getAveRake() + "; dip=" + this.pointPoissonEqkSource.getRupture(0).getRuptureSurface().getAveDip());
            }
        }
        this.parameterChangeFlag = false;
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        this.pointPoissonEqkSource = ((PointSource.PoissonBuilder)PointSource.poissonBuilder((Location)this.locationList.get(iSource)).truePointSources()).forMFDAndFocalMech(this.dist, new FocalMechanism(Double.NaN, this.dip, this.rake)).duration(this.timeSpan.getDuration()).build();
        this.pointPoissonEqkSource.setDuration(this.timeSpan.getDuration());
        if (this.D) {
            System.out.println(iSource + "th source location: " + ((Location)this.locationList.get(iSource)).toString() + "; numRups=" + this.pointPoissonEqkSource.getNumRuptures());
        }
        if (this.D) {
            System.out.println("                     rake=" + this.pointPoissonEqkSource.getRupture(0).getAveRake() + "; dip=" + this.pointPoissonEqkSource.getRupture(0).getRuptureSurface().getAveDip());
        }
        return this.pointPoissonEqkSource;
    }

    @Override
    public int getNumSources() {
        return this.locationList.size();
    }

    public ArrayList getSourceList() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

