/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_NonPlanarFaultForecast;

public class PEER_LogicTreeERF_List
extends AbstractEpistemicListERF {
    public static String C = "PEER_LogicTreeERF_List";
    public static String NAME = new String("PEER Logic Tree ERF List");
    private double SLIP_RATE_1 = 0.1;
    private double SLIP_RATE_2 = 2.0;
    private double SLIP_RATE_3 = 5.0;
    private double MAG_1 = 7.15;
    private double MAG_2 = 6.45;
    private double REL_WEIGHT_1 = 0.1;
    private double REL_WEIGHT_2 = 0.3;
    public static final String GRID_PARAM_NAME = "Fault Grid Spacing";
    private Double DEFAULT_GRID_VAL = 1.0;
    public static final String GRID_PARAM_UNITS = "kms";
    private static final double GRID_PARAM_MIN = 0.001;
    private static final double GRID_PARAM_MAX = 1000.0;
    public static final String OFFSET_PARAM_NAME = "Offset";
    private Double DEFAULT_OFFSET_VAL = 1.0;
    public static final String OFFSET_PARAM_UNITS = "kms";
    private static final double OFFSET_PARAM_MIN = 0.01;
    private static final double OFFSET_PARAM_MAX = 10000.0;
    public static final String SIGMA_PARAM_NAME = "Mag Length Sigma";
    private double SIGMA_PARAM_MIN = 0.0;
    private double SIGMA_PARAM_MAX = 1.0;
    public Double DEFAULT_SIGMA_VAL = 0.0;
    public static final String FAULT_MODEL_NAME = new String("Fault Model");
    public static final String FAULT_MODEL_FRANKEL = new String("Frankel's");
    public static final String FAULT_MODEL_STIRLING = new String("Stirling's");
    protected DoubleParameter gridParam = new DoubleParameter("Fault Grid Spacing", 0.001, 1000.0, "kms", this.DEFAULT_GRID_VAL);
    protected DoubleParameter offsetParam = new DoubleParameter("Offset", 0.01, 10000.0, "kms", this.DEFAULT_OFFSET_VAL);
    protected DoubleParameter lengthSigmaParam = new DoubleParameter("Mag Length Sigma", this.SIGMA_PARAM_MIN, this.SIGMA_PARAM_MAX, this.DEFAULT_SIGMA_VAL);
    private ArrayList faultModelNamesStrings = new ArrayList();
    protected StringParameter faultModelParam;

    public PEER_LogicTreeERF_List() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.faultModelNamesStrings.add(FAULT_MODEL_FRANKEL);
        this.faultModelNamesStrings.add(FAULT_MODEL_STIRLING);
        this.faultModelParam = new StringParameter(FAULT_MODEL_NAME, this.faultModelNamesStrings, (String)this.faultModelNamesStrings.get(0));
        this.adjustableParams.addParameter(this.gridParam);
        this.adjustableParams.addParameter(this.offsetParam);
        this.adjustableParams.addParameter(this.lengthSigmaParam);
        this.adjustableParams.addParameter(this.faultModelParam);
        this.gridParam.addParameterChangeListener(this);
        this.offsetParam.addParameterChangeListener(this);
        this.lengthSigmaParam.addParameterChangeListener(this);
        this.faultModelParam.addParameterChangeListener(this);
        this.addERF(this.createERF(PEER_NonPlanarFaultForecast.SEGMENTATION_NO, this.SLIP_RATE_1, this.MAG_1), this.REL_WEIGHT_1);
        this.addERF(this.createERF(PEER_NonPlanarFaultForecast.SEGMENTATION_NO, this.SLIP_RATE_2, this.MAG_1), this.REL_WEIGHT_2);
        this.addERF(this.createERF(PEER_NonPlanarFaultForecast.SEGMENTATION_NO, this.SLIP_RATE_3, this.MAG_1), this.REL_WEIGHT_1);
        this.addERF(this.createERF(PEER_NonPlanarFaultForecast.SEGMENTATION_YES, this.SLIP_RATE_1, this.MAG_2), this.REL_WEIGHT_1);
        this.addERF(this.createERF(PEER_NonPlanarFaultForecast.SEGMENTATION_YES, this.SLIP_RATE_2, this.MAG_2), this.REL_WEIGHT_2);
        this.addERF(this.createERF(PEER_NonPlanarFaultForecast.SEGMENTATION_YES, this.SLIP_RATE_3, this.MAG_2), this.REL_WEIGHT_1);
    }

    protected AbstractERF createERF(String segmentation, double slipRate, double magUpper) {
        PEER_NonPlanarFaultForecast forecast = new PEER_NonPlanarFaultForecast();
        forecast.getParameter(PEER_NonPlanarFaultForecast.SEGMENTATION_NAME).setValue(segmentation);
        forecast.getParameter("Slip Rate").setValue(slipRate);
        forecast.getParameter(PEER_NonPlanarFaultForecast.GR_MAG_UPPER).setValue(magUpper);
        forecast.getParameter(PEER_NonPlanarFaultForecast.DIP_DIRECTION_NAME).setValue(PEER_NonPlanarFaultForecast.DIP_DIRECTION_EAST);
        return forecast;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            int num = this.getNumERFs();
            for (int i = 0; i < num; ++i) {
                AbstractERF eqkRupForecast = (AbstractERF)this.getERF(i);
                eqkRupForecast.getParameter(GRID_PARAM_NAME).setValue(this.gridParam.getValue());
                eqkRupForecast.getParameter(OFFSET_PARAM_NAME).setValue(this.offsetParam.getValue());
                eqkRupForecast.getParameter(SIGMA_PARAM_NAME).setValue(this.lengthSigmaParam.getValue());
                eqkRupForecast.getParameter(FAULT_MODEL_NAME).setValue(this.faultModelParam.getValue());
                eqkRupForecast.getTimeSpan().setDuration(this.timeSpan.getDuration());
                eqkRupForecast.updateForecast();
            }
        }
        this.parameterChangeFlag = false;
    }
}

