/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;

@Deprecated
public class Point2MultVertSS_FaultSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("Point2MultVertSS_FaultSource");
    private boolean D = false;
    double rupLength;
    double upperSeisDepth;
    double lowerSeisDepth;
    private Location loc;
    private ArrayList faultTraces = new ArrayList();
    private FrankelGriddedSurface frankelFaultSurface;
    private double magnitude;
    private double normalizedProbability;

    public Point2MultVertSS_FaultSource(double lat, double lon, double magnitude, double probability, MagScalingRelationship magScalingRel, double upperSeisDepth, double lowerSeisDepth, double maxRupOffset, double deltaStrike) {
        this.magnitude = magnitude;
        this.isPoissonian = false;
        this.upperSeisDepth = upperSeisDepth;
        this.lowerSeisDepth = lowerSeisDepth;
        if (magScalingRel instanceof MagAreaRelationship) {
            this.rupLength = magScalingRel.getMedianScale(magnitude) / (lowerSeisDepth - upperSeisDepth);
        } else if (magScalingRel instanceof MagLengthRelationship) {
            this.rupLength = magScalingRel.getMedianScale(magnitude);
        } else {
            throw new RuntimeException("bad type of MagScalingRelationship");
        }
        this.loc = new Location(lat, lon, 0.0);
        this.mkFaultTraces(this.loc, this.rupLength, maxRupOffset, deltaStrike);
        if (this.D) {
            System.out.println("num ruptures=" + this.faultTraces.size());
        }
        this.normalizedProbability = probability / (double)this.faultTraces.size();
        if (this.D) {
            System.out.println("prob=" + this.normalizedProbability);
        }
    }

    private void mkFaultTraces(Location loc, double rupLength, double maxDeltaRupOffset, double deltaStrike) {
        int numRupAlong = (int)(rupLength / maxDeltaRupOffset) + 2;
        double deltaRupOffset = rupLength / (double)(numRupAlong - 1);
        int numStrikes = (int)(180.0 / deltaStrike);
        if (this.D) {
            System.out.println("rupLength=" + rupLength + "; maxDeltaRupOffset=" + maxDeltaRupOffset + ";  numRupAlong=" + numRupAlong + ";  deltaRupOffset=" + deltaRupOffset);
        }
        if (this.D) {
            System.out.println("lon1\tlat1\tlon2\tlat2\tstike\toffSet");
        }
        for (double strike = 0.0; strike < 180.0; strike += deltaStrike) {
            for (double offSet = 0.0; offSet < rupLength + deltaRupOffset / 2.0; offSet += deltaRupOffset) {
                LocationVector dir = new LocationVector(strike, offSet, 0.0);
                Location loc1 = LocationUtils.location(loc, dir);
                dir = new LocationVector(strike + 180.0, rupLength - offSet, 0.0);
                Location loc2 = LocationUtils.location(loc, dir);
                FaultTrace fltTrace = new FaultTrace(null);
                fltTrace.add(loc1);
                fltTrace.add(loc2);
                this.faultTraces.add(fltTrace);
            }
        }
    }

    @Override
    public int getNumRuptures() {
        return this.faultTraces.size();
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        ProbEqkRupture probEqkRupture = new ProbEqkRupture();
        probEqkRupture.setAveRake(0.0);
        probEqkRupture.setMag(this.magnitude);
        probEqkRupture.setRuptureSurface(this.getRuptureSurface(nthRupture));
        probEqkRupture.setProbability(this.normalizedProbability);
        return probEqkRupture;
    }

    private AbstractEvenlyGriddedSurface getRuptureSurface(int nthRupture) {
        this.frankelFaultSurface = new FrankelGriddedSurface((FaultTrace)this.faultTraces.get(nthRupture), 90.0, this.upperSeisDepth, this.lowerSeisDepth, 1.0);
        return this.frankelFaultSurface;
    }

    @Override
    public LocationList getAllSourceLocs() {
        int numRuptures = this.getNumRuptures();
        LocationList locList = new LocationList();
        for (int i = 0; i < numRuptures; ++i) {
            LocationList rupLocList = this.getRuptureSurface(i).getEvenlyDiscritizedListOfLocsOnSurface();
            for (int j = 0; j < rupLocList.size(); ++j) {
                locList.add((Location)rupLocList.get(j));
            }
        }
        return locList;
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        throw new RuntimeException("method not supported (not sure what to return)");
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistance(site.getLocation(), this.loc) - this.rupLength;
    }

    @Override
    public String getName() {
        return C;
    }

    public static void main(String[] args) {
        WC1994_MagLengthRelationship magLengthRel = new WC1994_MagLengthRelationship();
        WC1994_MagAreaRelationship magAreaRel = new WC1994_MagAreaRelationship();
        double mag = 7.0;
        System.out.println("Length(mag)=" + magLengthRel.getMedianScale(mag) + ";  Area(mag)=" + magAreaRel.getMedianScale(mag));
        Point2MultVertSS_FaultSource src = new Point2MultVertSS_FaultSource(34.0, -118.0, mag, 1.0, magLengthRel, 0.0, 10.0, 2.0, 5.0);
        System.out.println("numRuptures=" + src.getNumRuptures());
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            int n = ((EvenlyGriddedSurface)src.getRupture(r).getRuptureSurface()).getNumCols() - 1;
        }
    }
}

