/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.griddedForecast.MagFreqDistsForFocalMechs;
import org.opensha.sha.earthquake.rupForecastImpl.PointToFiniteSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@Deprecated
public class PoissonAreaSource
extends PointToFiniteSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String C = new String("PoissonAreaSource");
    private static String NAME = "Poisson Area Source";
    private boolean D = false;
    Region reg;
    double gridResolution;
    GriddedRegion gridReg;
    boolean pointSources = false;
    double[] nodeWeights;

    public PoissonAreaSource(Region reg, double gridResolution, MagFreqDistsForFocalMechs magFreqDistsForFocalMechs, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double duration, double minMag) {
        this.magFreqDists = magFreqDistsForFocalMechs.getMagFreqDistList();
        this.focalMechanisms = magFreqDistsForFocalMechs.getFocalMechanismList();
        this.aveRupTopVersusMag = aveRupTopVersusMag;
        this.duration = duration;
        this.minMag = minMag;
        this.reg = reg;
        this.isPoissonian = true;
        this.pointSources = true;
        this.checkFocalMechs();
        this.maxLength = 0.0;
        this.gridReg = new GriddedRegion(reg, gridResolution, null);
        this.numRuptures = this.computeNumRuptures() * this.gridReg.getNodeCount();
    }

    private void computeNodeWeights() {
        int i;
        int numPts = this.gridReg.getNodeCount();
        this.nodeWeights = new double[numPts];
        double tot = 0.0;
        for (i = 0; i < numPts; ++i) {
            double latitude = this.gridReg.locationForIndex(i).getLatitude();
            this.nodeWeights[i] = Math.cos(latitude * Math.PI / 180.0);
            tot += this.nodeWeights[i];
        }
        i = 0;
        while (i < numPts) {
            int n = i++;
            this.nodeWeights[n] = this.nodeWeights[n] / tot;
        }
    }

    private void checkFocalMechs() {
        if (this.focalMechanisms == null) {
            this.focalMechanisms = new FocalMechanism[this.magFreqDists.length];
            for (int i = 0; i < this.magFreqDists.length; ++i) {
                this.focalMechanisms[i] = new FocalMechanism(Double.NaN, 90.0, 0.0);
            }
        }
    }

    private void mkAllRuptures() {
        this.probEqkRuptureList = new ArrayList();
        this.rates = new ArrayList();
        this.computeNodeWeights();
        if (this.pointSources) {
            for (int j = 0; j < this.gridReg.getNodeCount(); ++j) {
                Location loc = (Location)this.gridReg.getNodeList().get(j);
                for (int k = 0; k < this.magFreqDists.length; ++k) {
                    IncrementalMagFreqDist mfd = this.magFreqDists[k];
                    for (int w = 0; w < mfd.size(); ++w) {
                        double mag = mfd.getX(w);
                        double rate = mfd.getY(w) * this.nodeWeights[j];
                        double prob = 1.0 - Math.exp(-this.duration * rate);
                        if (!(mag >= this.minMag) || !(prob > 0.0)) continue;
                        ProbEqkRupture rup = new ProbEqkRupture();
                        rup.setMag(mag);
                        rup.setProbability(prob);
                        rup.setAveRake(this.focalMechanisms[k].getRake());
                        if (mag < this.aveRupTopVersusMag.getMinX() || mag > this.aveRupTopVersusMag.getMaxX()) {
                            throw new RuntimeException("aveRupTopVersusMag x-axis range not wide enough");
                        }
                        double depth = this.aveRupTopVersusMag.getClosestYtoX(mag);
                        Location finalLoc = new Location(loc.getLatitude(), loc.getLongitude(), depth);
                        rup.setPointSurface(finalLoc, this.focalMechanisms[k].getDip());
                        this.probEqkRuptureList.add(rup);
                        this.rates.add(rate);
                    }
                }
            }
        } else {
            for (int j = 0; j < this.gridReg.getNodeCount(); ++j) {
                this.location = (Location)this.gridReg.getNodeList().get(j);
                if (this.numStrikes == -1) {
                    for (int i = 0; i < this.magFreqDists.length; ++i) {
                        this.mkAndAddRuptures(this.location, this.magFreqDists[i], this.focalMechanisms[i], this.aveRupTopVersusMag, this.magScalingRel, this.lowerSeisDepth, this.duration, this.minMag, this.nodeWeights[j]);
                    }
                    continue;
                }
                double deltaStrike = 180 / this.numStrikes;
                double[] strike = new double[this.numStrikes];
                for (int n = 0; n < this.numStrikes; ++n) {
                    strike[n] = this.firstStrike + (double)n * deltaStrike;
                }
                double weight = this.nodeWeights[j] / (double)this.numStrikes;
                for (int i = 0; i < this.magFreqDists.length; ++i) {
                    FocalMechanism focalMech = this.focalMechanisms[i].copy();
                    for (int s = 0; s < this.numStrikes; ++s) {
                        focalMech.setStrike(strike[s]);
                        this.mkAndAddRuptures(this.location, this.magFreqDists[i], focalMech, this.aveRupTopVersusMag, this.magScalingRel, this.lowerSeisDepth, this.duration, this.minMag, weight);
                    }
                }
            }
        }
        if (this.numRuptures != this.probEqkRuptureList.size()) {
            throw new RuntimeException("Error in computing number of ruptures");
        }
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        if (this.probEqkRuptureList == null) {
            this.mkAllRuptures();
        }
        return (ProbEqkRupture)this.probEqkRuptureList.get(nthRupture);
    }

    public PoissonAreaSource(Region reg, double gridResolution, MagFreqDistsForFocalMechs magFreqDistsForFocalMechs, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double defaultHypoDepth, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag) {
        this(reg, gridResolution, magFreqDistsForFocalMechs, aveRupTopVersusMag, magScalingRel, lowerSeisDepth, duration, minMag, -1, Double.NaN);
    }

    public PoissonAreaSource(Region reg, double gridResolution, MagFreqDistsForFocalMechs magFreqDistsForFocalMechs, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, MagScalingRelationship magScalingRel, double lowerSeisDepth, double duration, double minMag, int numStrikes, double firstStrike) {
        this.reg = reg;
        this.magFreqDists = magFreqDistsForFocalMechs.getMagFreqDistList();
        this.focalMechanisms = magFreqDistsForFocalMechs.getFocalMechanismList();
        this.aveRupTopVersusMag = aveRupTopVersusMag;
        this.magScalingRel = magScalingRel;
        this.lowerSeisDepth = lowerSeisDepth;
        this.duration = duration;
        this.minMag = minMag;
        this.numStrikes = numStrikes;
        this.firstStrike = firstStrike;
        this.isPoissonian = true;
        this.checkFocalMechs();
        this.maxLength = this.computeMaxLength();
        this.gridReg = new GriddedRegion(reg, gridResolution, null);
        this.numRuptures = this.computeNumRuptures() * this.gridReg.getNodeCount();
    }

    public Region getRegion() {
        return this.reg;
    }

    @Override
    public double getMinDistance(Site site) {
        double dist = this.reg.distanceToLocation(site.getLocation()) - this.maxLength / 2.0;
        if (dist < 0.0) {
            dist = 0.0;
        }
        return dist;
    }
}

