/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.SimpleFaultParameter;

public class PoissonFaultERF
extends AbstractERF {
    private static String C = new String("PoissonFaultERF");
    private boolean D = false;
    public static final String NAME = "Poisson Fault ERF";
    private FaultRuptureSource source;
    public static final String MAG_DIST_PARAM_NAME = "Mag Freq Dist";
    public static final String FAULT_PARAM_NAME = "Fault Parameter";
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = -180.0;
    private Double RAKE_PARAM_MAX = 180.0;
    private Double RAKE_PARAM_DEFAULT = 0.0;
    MagFreqDistParameter magDistParam;
    SimpleFaultParameter faultParam;
    DoubleParameter rakeParam;

    public PoissonFaultERF() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        ArrayList<String> supportedMagDists = new ArrayList<String>();
        supportedMagDists.add(GaussianMagFreqDist.NAME);
        supportedMagDists.add(SingleMagFreqDist.NAME);
        supportedMagDists.add(GutenbergRichterMagFreqDist.NAME);
        supportedMagDists.add(SummedMagFreqDist.NAME);
        this.magDistParam = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, supportedMagDists);
        this.faultParam = new SimpleFaultParameter(FAULT_PARAM_NAME);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, RAKE_PARAM_UNITS, this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.faultParam);
        this.adjustableParams.addParameter(this.magDistParam);
        this.rakeParam.addParameterChangeListener(this);
        this.faultParam.addParameterChangeListener(this);
        this.magDistParam.addParameterChangeListener(this);
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            this.source = new FaultRuptureSource((IncrementalMagFreqDist)this.magDistParam.getValue(), (RuptureSurface)((AbstractEvenlyGriddedSurfaceWithSubsets)this.faultParam.getValue()), (double)((Double)this.rakeParam.getValue()), this.timeSpan.getDuration());
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    @Override
    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<FaultRuptureSource> v = new ArrayList<FaultRuptureSource>();
        v.add(this.source);
        return v;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

