/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;

public class GenPredErrAnalysisTool {
    private UCERF2 ucerf2;
    private Parameter magAreaRelParam;
    private Parameter slipModelParam;
    private ParameterListParameter segmentedRupModelParam;
    private ParameterList adjustableParams;
    private ArrayList aFaultSourceGenerators;
    private A_FaultsFetcher aFaultsFetcher;
    private ArrayList magAreaOptions;
    private ArrayList slipModelOptions;

    public GenPredErrAnalysisTool(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
        this.adjustableParams = ucerf2.getAdjustableParameterList();
        this.magAreaRelParam = ucerf2.getParameter("Mag-Area Relationship");
        this.segmentedRupModelParam = (ParameterListParameter)ucerf2.getParameter("Segmented A-Fault Solution Types");
        this.slipModelParam = ucerf2.getParameter("A-Fault Slip Model");
        this.aFaultsFetcher = ucerf2.getA_FaultsFetcher();
        this.magAreaOptions = ((StringConstraint)this.magAreaRelParam.getConstraint()).getAllowedStrings();
        this.slipModelOptions = ((StringConstraint)this.slipModelParam.getConstraint()).getAllowedStrings();
    }

    public void writeResults(String outFileName) {
        try {
            FileWriter fw = new FileWriter(outFileName);
            DecimalFormat formatter = new DecimalFormat("0.000E0");
            String[] models = new String[]{"Geological Insight", "Min Rate", "Max Rate"};
            for (int irup = 0; irup < 3; ++irup) {
                ListIterator it = this.segmentedRupModelParam.getParametersIterator();
                while (it.hasNext()) {
                    StringParameter param = (StringParameter)it.next();
                    ArrayList<String> allowedVals = param.getAllowedStrings();
                    param.setValue(allowedVals.get(irup));
                }
                for (int imag = 0; imag < this.magAreaOptions.size(); ++imag) {
                    for (int islip = 0; islip < this.slipModelOptions.size(); ++islip) {
                        A_FaultSegmentedSourceGenerator source;
                        int i;
                        this.magAreaRelParam.setValue(this.magAreaOptions.get(imag));
                        this.slipModelParam.setValue(this.slipModelOptions.get(islip));
                        fw.write(String.valueOf(this.magAreaRelParam.getValue()) + "\t" + String.valueOf(this.slipModelParam.getValue()) + "\t" + models[irup] + "\n");
                        System.out.println(String.valueOf(this.magAreaRelParam.getValue()) + "\t" + String.valueOf(this.slipModelParam.getValue()) + "\t" + models[irup] + "\n");
                        double aPrioriWt = 0.0;
                        this.ucerf2.setParameter("Wt On A-Priori Rates", aPrioriWt);
                        this.ucerf2.updateForecast();
                        this.aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
                        fw.write("\t");
                        for (i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
                            source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
                            fw.write(source.getFaultSegmentData().getFaultName() + "\t");
                        }
                        fw.write("\n" + aPrioriWt + "\t");
                        for (i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
                            source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
                            fw.write(formatter.format(source.getNonNormA_PrioriModelError()) + "\t\t");
                        }
                        fw.write("\n");
                        for (int pow = -20; pow < 16; ++pow) {
                            aPrioriWt = Math.pow(10.0, pow);
                            fw.write("1E" + pow + "\t");
                            this.ucerf2.setParameter("Wt On A-Priori Rates", aPrioriWt);
                            this.ucerf2.updateForecast();
                            this.aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
                            for (int i2 = 0; i2 < this.aFaultSourceGenerators.size(); ++i2) {
                                A_FaultSegmentedSourceGenerator source2 = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i2);
                                fw.write(formatter.format(source2.getNonNormA_PrioriModelError()) + "\t\t");
                            }
                            fw.write("\n");
                        }
                    }
                }
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeAllStableRanges(String outFileName) {
        try {
            FileWriter fw = new FileWriter(outFileName);
            String[] models = new String[]{"Geological Insight", "Min Rate", "Max Rate"};
            for (int irup = 0; irup < 3; ++irup) {
                ListIterator it = this.segmentedRupModelParam.getParametersIterator();
                while (it.hasNext()) {
                    StringParameter param = (StringParameter)it.next();
                    ArrayList<String> allowedVals = param.getAllowedStrings();
                    param.setValue(allowedVals.get(irup));
                }
                for (int imag = 0; imag < this.magAreaOptions.size(); ++imag) {
                    for (int islip = 0; islip < this.slipModelOptions.size(); ++islip) {
                        this.magAreaRelParam.setValue(this.magAreaOptions.get(imag));
                        this.slipModelParam.setValue(this.slipModelOptions.get(islip));
                        String outPutString = String.valueOf(this.magAreaRelParam.getValue()) + ";" + String.valueOf(this.slipModelParam.getValue()) + ";" + models[irup] + "\t";
                        outPutString = outPutString + this.findStableRange();
                        System.out.println(outPutString);
                        fw.write(outPutString + "\n");
                    }
                }
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String findStableRange() {
        double fractChange;
        double newError;
        double tol = 1.0E-5;
        boolean deBug = false;
        boolean noChange = true;
        int pow = 10;
        int minPow = -20;
        double aPrioriWt = Math.pow(10.0, pow);
        this.ucerf2.setParameter("Wt On A-Priori Rates", aPrioriWt);
        this.ucerf2.updateForecast();
        double lastError = this.ucerf2.getNonNormalizedA_PrioriRateErr();
        if (deBug) {
            System.out.println(pow + "\t" + lastError);
        }
        while (noChange && pow >= minPow) {
            aPrioriWt = Math.pow(10.0, --pow);
            this.ucerf2.setParameter("Wt On A-Priori Rates", aPrioriWt);
            this.ucerf2.updateForecast();
            newError = this.ucerf2.getNonNormalizedA_PrioriRateErr();
            fractChange = Math.abs((lastError - newError) / lastError);
            noChange = fractChange < tol;
            lastError = newError;
            if (!deBug) continue;
            System.out.println(pow + "\t" + lastError + "\t" + fractChange);
        }
        int pow1 = pow + 1;
        if (deBug) {
            System.out.println("Power at end of 1st stable region = " + pow1);
        }
        while (!noChange && pow >= minPow) {
            aPrioriWt = Math.pow(10.0, --pow);
            this.ucerf2.setParameter("Wt On A-Priori Rates", aPrioriWt);
            this.ucerf2.updateForecast();
            newError = this.ucerf2.getNonNormalizedA_PrioriRateErr();
            fractChange = Math.abs((lastError - newError) / lastError);
            noChange = fractChange < tol;
            lastError = newError;
            if (!deBug) continue;
            System.out.println(pow + "\t" + lastError + "\t" + fractChange);
        }
        int pow2 = pow + 1;
        if (deBug) {
            System.out.println("Power at beginning of 2nd stable region =" + pow2);
        }
        while (noChange && pow >= minPow) {
            aPrioriWt = Math.pow(10.0, --pow);
            this.ucerf2.setParameter("Wt On A-Priori Rates", aPrioriWt);
            this.ucerf2.updateForecast();
            newError = this.ucerf2.getNonNormalizedA_PrioriRateErr();
            fractChange = Math.abs((lastError - newError) / lastError);
            noChange = fractChange < tol;
            lastError = newError;
            if (!deBug) continue;
            System.out.println(pow + "\t" + lastError + "\t" + fractChange);
        }
        int pow3 = pow + 1;
        if (deBug) {
            System.out.println("Power at end of 2nd stable region =" + pow3);
        }
        return new String(pow1 + "\t" + pow2 + "\t" + pow3);
    }

    public static void main(String[] args) {
        UCERF2 ucerf2 = new UCERF2();
        GenPredErrAnalysisTool analysisTool = new GenPredErrAnalysisTool(ucerf2);
        analysisTool.writeResults("PredErrAnalysisResults1.txt");
        analysisTool.writeAllStableRanges("PredErrStableRangeAnalysis1.txt");
        ucerf2.setParameter("Relative Wt On Segment Rates", 1.0);
        analysisTool.writeAllStableRanges("PredErrStableRangeAnalysis2.txt");
        analysisTool.writeResults("PredErrAnalysisResults2.txt");
    }
}

