/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileWriter;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.RELM_ERF_ToGriddedHypoMagFreqDistForecast;

public class GenerateFilesForHypoRatesMaps {
    public static void main(String[] args) {
        int duration = 30;
        String probModel = "Poisson";
        CaliforniaRegions.RELM_TESTING_GRIDDED evenlyGriddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        System.out.println("UCERF2");
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Rupture Offset", 10.0);
        meanUCERF2.getParameter("Probability Model").setValue(probModel);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        meanUCERF2.getTimeSpan().setDuration(duration);
        meanUCERF2.updateForecast();
        double minMag = 5.0;
        double maxMag = 9.0;
        int numMag = 41;
        RELM_ERF_ToGriddedHypoMagFreqDistForecast griddedHypoMagFeqDistForecast1 = new RELM_ERF_ToGriddedHypoMagFreqDistForecast(meanUCERF2, evenlyGriddedRegion, minMag, maxMag, numMag, duration);
        GenerateFilesForHypoRatesMaps.generateNedsBulgeFiles("UCERF2", griddedHypoMagFeqDistForecast1);
        System.out.println("NSHMP02");
        Frankel02_AdjustableEqkRupForecast nshmp2002 = new Frankel02_AdjustableEqkRupForecast();
        nshmp2002.setParameter("Rupture Offset", 10.0);
        nshmp2002.setParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME, Frankel02_AdjustableEqkRupForecast.BACK_SEIS_INCLUDE);
        nshmp2002.setParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME, Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_POINT);
        nshmp2002.getTimeSpan().setDuration(duration);
        nshmp2002.updateForecast();
        RELM_ERF_ToGriddedHypoMagFreqDistForecast griddedHypoMagFeqDistForecast2 = new RELM_ERF_ToGriddedHypoMagFreqDistForecast(nshmp2002, evenlyGriddedRegion, minMag, maxMag, numMag, duration);
        GenerateFilesForHypoRatesMaps.generateNedsBulgeFiles("NSHMP2002", griddedHypoMagFeqDistForecast2);
        GenerateFilesForHypoRatesMaps.generateRatioFiles("UCERF2", griddedHypoMagFeqDistForecast1, griddedHypoMagFeqDistForecast2);
    }

    public static void generateRatioFiles(String fileNamePrefix, RELM_ERF_ToGriddedHypoMagFreqDistForecast griddedHypoMagFeqDistForecast1, RELM_ERF_ToGriddedHypoMagFreqDistForecast griddedHypoMagFeqDistForecast2) {
        try {
            FileWriter fwRatio5 = new FileWriter(fileNamePrefix + "_UCERF2_NSHMP2002_Ratio5.txt");
            FileWriter fwRatio6_5 = new FileWriter(fileNamePrefix + "_UCERF2_NSHMP2002_Ratio6_5.txt");
            int numLocs = griddedHypoMagFeqDistForecast1.getNumHypoLocs();
            for (int i = 0; i < numLocs; ++i) {
                HypoMagFreqDistAtLoc mfdAtLoc1 = griddedHypoMagFeqDistForecast1.getHypoMagFreqDistAtLoc(i);
                EvenlyDiscretizedFunc cumDist1 = mfdAtLoc1.getFirstMagFreqDist().getCumRateDist();
                HypoMagFreqDistAtLoc mfdAtLoc2 = griddedHypoMagFeqDistForecast2.getHypoMagFreqDistAtLoc(i);
                EvenlyDiscretizedFunc cumDist2 = mfdAtLoc2.getFirstMagFreqDist().getCumRateDist();
                Location loc = mfdAtLoc1.getLocation();
                double val1 = cumDist1.getInterpolatedY(5.0);
                double val2 = cumDist2.getInterpolatedY(5.0);
                double ratio = 0.0;
                if (val2 != 0.0) {
                    ratio = val1 / val2;
                }
                fwRatio5.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)ratio + "\n");
                val1 = cumDist1.getInterpolatedY(6.5);
                val2 = cumDist2.getInterpolatedY(6.5);
                ratio = 0.0;
                if (val2 != 0.0) {
                    ratio = val1 / val2;
                }
                fwRatio6_5.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)ratio + "\n");
            }
            fwRatio5.close();
            fwRatio6_5.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateNedsBulgeFiles(String fileNamePrefix, RELM_ERF_ToGriddedHypoMagFreqDistForecast griddedHypoMagFeqDistForecast) {
        try {
            FileWriter fwPred5 = new FileWriter(fileNamePrefix + "_Pred5.txt");
            FileWriter fwPred6_5 = new FileWriter(fileNamePrefix + "_Pred6_5.txt");
            FileWriter fwExtrap6_5 = new FileWriter(fileNamePrefix + "_Extrap6_5.txt");
            FileWriter fwRatio = new FileWriter(fileNamePrefix + "_PredExp6_5Ratio.txt");
            double totRate = 0.0;
            double multiFactor = Math.pow(10.0, -1.2000000000000002);
            int numLocs = griddedHypoMagFeqDistForecast.getNumHypoLocs();
            for (int i = 0; i < numLocs; ++i) {
                HypoMagFreqDistAtLoc mfdAtLoc = griddedHypoMagFeqDistForecast.getHypoMagFreqDistAtLoc(i);
                Location loc = mfdAtLoc.getLocation();
                EvenlyDiscretizedFunc cumDist = mfdAtLoc.getFirstMagFreqDist().getCumRateDist();
                totRate += cumDist.getY(0);
                double pred5 = cumDist.getInterpolatedY(5.0);
                double pred6_5 = cumDist.getInterpolatedY(6.5);
                double extrap6_5 = pred5 * multiFactor;
                double ratio = extrap6_5 != 0.0 ? pred6_5 / extrap6_5 : 0.0;
                fwPred5.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)pred5 + "\n");
                fwPred6_5.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)pred6_5 + "\n");
                fwExtrap6_5.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)extrap6_5 + "\n");
                fwRatio.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)ratio + "\n");
            }
            fwPred5.close();
            fwPred6_5.close();
            fwExtrap6_5.close();
            fwRatio.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

