/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.util.ArrayList;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.LogicTreeMFDsPlotter;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class NoCalSoCalMFDsPlotter
extends LogicTreeMFDsPlotter {
    private static final String NO_CAL_PATH = "data/logicTreeMFDs/NoCal/";
    private static final String SO_CAL_PATH = "data/logicTreeMFDs/SoCal/";
    private static final double MIN_MAG = 5.0;
    private static final double MAX_MAG = 8.899999999999999;
    private static final int NUM_MAG = UCERF2.NUM_MAG;
    private Region region;
    IncrementalMagFreqDist aFaultsMFD;
    IncrementalMagFreqDist bFaultsMFD;
    IncrementalMagFreqDist nonCA_B_FaultsMFD;
    IncrementalMagFreqDist cZonesMFD;
    IncrementalMagFreqDist bckMFD;

    public NoCalSoCalMFDsPlotter(Region region) {
        this.region = region;
    }

    @Override
    protected IncrementalMagFreqDist getTotal_A_FaultsMFD(UCERF2 ucerf2) {
        this.aFaultsMFD = new IncrementalMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        ucerf2.getTotal_A_FaultsProb(this.aFaultsMFD, this.region);
        this.convertProbToPoissonRates(this.aFaultsMFD, ucerf2.getTimeSpan().getDuration());
        return this.aFaultsMFD;
    }

    @Override
    protected IncrementalMagFreqDist getTotal_B_FaultsCharMFD(UCERF2 ucerf2) {
        this.bFaultsMFD = new IncrementalMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        ucerf2.getTotal_B_FaultsProb(this.bFaultsMFD, this.region);
        this.convertProbToPoissonRates(this.bFaultsMFD, ucerf2.getTimeSpan().getDuration());
        return this.bFaultsMFD;
    }

    @Override
    protected IncrementalMagFreqDist getTotal_B_FaultsGR_MFD(UCERF2 ucerf2) {
        IncrementalMagFreqDist cumMFD = new IncrementalMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        return cumMFD;
    }

    @Override
    protected IncrementalMagFreqDist getTotal_NonCA_B_FaultsMFD(UCERF2 ucerf2) {
        this.nonCA_B_FaultsMFD = new IncrementalMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        ucerf2.getTotal_NonCA_B_FaultsProb(this.nonCA_B_FaultsMFD, this.region);
        this.convertProbToPoissonRates(this.nonCA_B_FaultsMFD, ucerf2.getTimeSpan().getDuration());
        return this.nonCA_B_FaultsMFD;
    }

    @Override
    protected IncrementalMagFreqDist getTotalMFD(UCERF2 ucerf2) {
        SummedMagFreqDist totMFD = new SummedMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        totMFD.addIncrementalMagFreqDist(this.aFaultsMFD);
        totMFD.addIncrementalMagFreqDist(this.bFaultsMFD);
        totMFD.addIncrementalMagFreqDist(this.nonCA_B_FaultsMFD);
        totMFD.addIncrementalMagFreqDist(this.getTotal_BackgroundMFD(ucerf2));
        totMFD.addIncrementalMagFreqDist(this.getTotal_C_ZoneMFD(ucerf2));
        return totMFD;
    }

    @Override
    protected ArrayList<EvenlyDiscretizedFunc> getObsCumMFD(UCERF2 ucerf2) {
        if (this.region instanceof CaliforniaRegions.RELM_NOCAL_GRIDDED) {
            return ucerf2.getObsCumNoCalMFD();
        }
        if (this.region instanceof CaliforniaRegions.RELM_SOCAL_GRIDDED) {
            return ucerf2.getObsCumSoCalMFD();
        }
        if (this.region == null) {
            return super.getObsCumMFD(ucerf2);
        }
        throw new RuntimeException("Unsupported region");
    }

    @Override
    protected IncrementalMagFreqDist getTotal_C_ZoneMFD(UCERF2 ucerf2) {
        if (this.cZonesMFD == null) {
            this.cZonesMFD = new IncrementalMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
            ucerf2.getTotal_C_ZoneProb(this.cZonesMFD, this.region);
            this.convertProbToPoissonRates(this.cZonesMFD, ucerf2.getTimeSpan().getDuration());
        }
        return this.cZonesMFD;
    }

    @Override
    protected IncrementalMagFreqDist getTotal_BackgroundMFD(UCERF2 ucerf2) {
        if (this.bckMFD == null) {
            this.bckMFD = new IncrementalMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
            ucerf2.getTotal_BackgroundMFD(this.bckMFD, this.region);
        }
        return this.bckMFD;
    }

    @Override
    protected ArrayList<ArbitrarilyDiscretizedFunc> getObsIncrMFD(UCERF2 ucerf2) {
        if (this.region instanceof CaliforniaRegions.RELM_NOCAL_GRIDDED) {
            return ucerf2.getObsIncrNoCalMFD();
        }
        if (this.region instanceof CaliforniaRegions.RELM_SOCAL_GRIDDED) {
            return ucerf2.getObsIncrSoCalMFD();
        }
        throw new RuntimeException("Unsupported region");
    }

    private void convertProbToPoissonRates(IncrementalMagFreqDist cumMFD, double duration) {
        for (int i = 0; i < cumMFD.size(); ++i) {
            cumMFD.set(i, -Math.log(1.0 - cumMFD.getY(i)) / duration);
        }
    }

    private void plotCumMFDs(String path) {
        this.readMFDsFromFile(path + "A_Faults_MFDs.txt", this.aFaultMFDsList, false);
        this.readMFDsFromFile(path + "B_FaultsCharMFDs.txt", this.bFaultCharMFDsList, false);
        this.readMFDsFromFile(path + "B_FaultsGR_MFDs.txt", this.bFaultGRMFDsList, false);
        this.readMFDsFromFile(path + "Non_CA_B_Faults_MFDs.txt", this.nonCA_B_FaultsMFDsList, false);
        this.readMFDsFromFile(path + "TotMFDs.txt", this.totMFDsList, false);
        this.ucerf2.updateForecast();
        IncrementalMagFreqDist bckMFD = this.getTotal_BackgroundMFD(this.ucerf2);
        IncrementalMagFreqDist cZonesMFD = this.getTotal_C_ZoneMFD(this.ucerf2);
        this.funcs = new ArrayList();
        this.plottingFeaturesList = new ArrayList();
        SummedMagFreqDist avgAFaultMFD = new SummedMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        SummedMagFreqDist avgBFaultCharMFD = new SummedMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        SummedMagFreqDist avgBFaultGRMFD = new SummedMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        SummedMagFreqDist avgNonCA_B_FaultsMFD = new SummedMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        SummedMagFreqDist avgTotMFD = new SummedMagFreqDist(5.0, 8.899999999999999, NUM_MAG);
        this.doWeightedSum(null, null, avgAFaultMFD, avgBFaultCharMFD, avgBFaultGRMFD, avgNonCA_B_FaultsMFD, avgTotMFD);
        this.addToFuncList(avgAFaultMFD, "Average A-Fault MFD", this.PLOT_CHAR1);
        this.addToFuncList(avgBFaultCharMFD, "Average  B-Fault MFD", this.PLOT_CHAR3);
        this.addToFuncList(avgNonCA_B_FaultsMFD, "Average Non-CA B-Fault MFD", this.PLOT_CHAR10);
        this.addToFuncList(bckMFD, "Average Background MFD", this.PLOT_CHAR5);
        this.addToFuncList(cZonesMFD, "Average C-Zones MFD", this.PLOT_CHAR6);
        ArrayList<EvenlyDiscretizedFunc> obsMFD = this.getObsCumMFD(this.ucerf2);
        String metadata = "Average Total MFD, M6.5 Cum Ratio = " + avgTotMFD.getCumRate(6.5) / obsMFD.get(0).getY(6.5);
        this.addToFuncList(avgTotMFD, metadata, this.PLOT_CHAR4);
        this.funcs.add(obsMFD.get(0));
        this.plottingFeaturesList.add(this.PLOT_CHAR7);
        this.funcs.addAll(obsMFD);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        GraphWindow graphWindow = new GraphWindow(this.funcs, "Mag Freq Dist", this.plottingFeaturesList);
        graphWindow.setVisible(true);
    }

    @Override
    protected double getCumRateAt6_5(IncrementalMagFreqDist mfd) {
        return mfd.getCumRate(6.5);
    }

    private void addToFuncList(IncrementalMagFreqDist mfd, String metadata, PlotCurveCharacterstics curveCharateristic) {
        mfd.setInfo(metadata);
        this.funcs.add(mfd);
        this.plottingFeaturesList.add(curveCharateristic);
    }

    @Override
    protected double getMinMag() {
        return 5.0;
    }

    @Override
    protected double getMaxMag() {
        return 8.899999999999999;
    }

    @Override
    protected int getNumMags() {
        return NUM_MAG;
    }

    public static void main(String[] args) {
        NoCalSoCalMFDsPlotter plotter = new NoCalSoCalMFDsPlotter(new CaliforniaRegions.RELM_NOCAL_GRIDDED());
        plotter.plotCumMFDs(NO_CAL_PATH);
    }
}

