/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.util.ArrayList;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.calc.ERF2GriddedSeisRatesCalc;
import org.opensha.sha.earthquake.griddedForecast.GriddedHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class RELM_ERF_ToGriddedHypoMagFreqDistForecast
extends GriddedHypoMagFreqDistForecast {
    private AbstractERF eqkRupForecast;
    private HypoMagFreqDistAtLoc[] magFreqDistForLocations;

    public RELM_ERF_ToGriddedHypoMagFreqDistForecast(AbstractERF eqkRupForecast, GriddedRegion griddedRegion, double minMag, double maxMag, int numMagBins, double duration) {
        this.eqkRupForecast = eqkRupForecast;
        this.setRegion(griddedRegion);
        ERF2GriddedSeisRatesCalc erfToGriddedSeisRatesCalc = new ERF2GriddedSeisRatesCalc();
        ArrayList incrementalMFD_List = erfToGriddedSeisRatesCalc.calcMFD_ForGriddedRegion(minMag, maxMag, numMagBins, eqkRupForecast, this.getRegion(), duration);
        this.magFreqDistForLocations = new HypoMagFreqDistAtLoc[this.getNumHypoLocs()];
        for (int i = 0; i < this.magFreqDistForLocations.length; ++i) {
            IncrementalMagFreqDist[] magFreqDistArray = new IncrementalMagFreqDist[]{(IncrementalMagFreqDist)incrementalMFD_List.get(i)};
            magFreqDistArray[0].set(0, magFreqDistArray[0].getIncrRate(1) * 1.2);
            this.magFreqDistForLocations[i] = new HypoMagFreqDistAtLoc(magFreqDistArray, griddedRegion.locationForIndex(i));
        }
    }

    @Override
    public HypoMagFreqDistAtLoc getHypoMagFreqDistAtLoc(int ithLocation) {
        return this.magFreqDistForLocations[ithLocation];
    }
}

