/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ParamOptions;

public class WriteTimeDepUnsegmentedProbAndGain {
    private static final String PATH = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/analysis/files/";
    private static final String README_TEXT = "This Excel spreadsheet tabulates Rupture Probability, Rupture Prob for Mag\u22656.7,  andRupture Gain (each on a different sheet) for all Type-A fault (including unsegmented models, which is why segment  rates are not listed) and for various logic-tree branches. The exact parameter settings for each logic-tree branch are listed in the \"Parameter Settings\" sheet, where those that vary between branches are in bold typeface.  The total aggregated rupture probability for each fault is given at the bottom of the list for each fault. The third-to-last column gives the weighted average value (over all logic tree branches), where the weights are given on row 154 on the rupture-related sheets (or row 31 if only unsegmented branches are used).  The last two columns give the Min and Max, respectively, among all the logic-tree branches. \"Gain\" is defined as the ratio of the probability to the Poisson probability.  Note that the weighted averages for the gains are the individual ratios averaged, which is not the same as the weight-averaged probability divided by the weight-averaged Poisson probability (the latter is more correct).";
    private ArrayList<String> paramNames;
    private ArrayList<ParamOptions> paramValues;
    private int lastParamIndex;
    private UCERF2 ucerf2;
    private HSSFSheet rupProbSheet;
    private HSSFSheet rupGainSheet;
    private HSSFSheet rupProbSheet67;
    private HSSFSheet adjustableParamsSheet;
    private HSSFSheet readmeSheet;
    private int loginTreeBranchIndex;
    private ArrayList<String> adjustableParamNames;
    private ArrayList<Double> rupProbWtAve;
    private ArrayList<Double> rupProbMin;
    private ArrayList<Double> rupProbMax;
    private ArrayList<Double> rupProbWtAve67;
    private ArrayList<Double> rupProbMin67;
    private ArrayList<Double> rupProbMax67;
    private ArrayList<Double> rupGainWtAve;
    private ArrayList<Double> rupGainMin;
    private ArrayList<Double> rupGainMax;
    private ArrayList<Integer> unsegRowIndex;
    private ArrayList<Integer> unsegWtAvgListIndex;
    private HSSFCellStyle boldStyle;
    private static double DURATION;
    private static String PROB_MODEL_VAL;
    private String FILENAME;
    private double MAG_67 = 6.7;
    private String[] fltNames;

    public WriteTimeDepUnsegmentedProbAndGain() {
        this(new UCERF2());
    }

    public WriteTimeDepUnsegmentedProbAndGain(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
        this.fillAdjustableParams();
        PROB_MODEL_VAL = "Poisson";
        ucerf2.getParameter("A-Fault Solution Type").setValue("Unsegmented Model");
        DURATION = 30.0;
        this.FILENAME = "UnsegmentedRupProbs_Pois_30yr.xls";
        PROB_MODEL_VAL = "Poisson";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "UnsegmentedRupProbs_Pois_5yr.xls";
        PROB_MODEL_VAL = "Poisson";
        this.makeExcelSheet(ucerf2);
        DURATION = 30.0;
        this.FILENAME = "UnsegmentedRupProbs_Empirical_30yr.xls";
        PROB_MODEL_VAL = "Empirical";
        this.makeExcelSheet(ucerf2);
        DURATION = 5.0;
        this.FILENAME = "UnsegmentedRupProbs_Empirical_5yr.xls";
        PROB_MODEL_VAL = "Empirical";
        this.makeExcelSheet(ucerf2);
        this.paramNames.add("A-Fault Solution Type");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("Segmented Model", 0.9);
        options.addValueWeight("Unsegmented Model", 0.1);
        this.paramValues.add(options);
        this.paramNames.add("Wt On A-Priori Rates");
        options = new ParamOptions();
        options.addValueWeight(1.0E-4, 0.5);
        options.addValueWeight(1.0E10, 0.5);
        this.paramValues.add(options);
        this.paramNames.add("Probability Model");
        options = new ParamOptions();
        options.addValueWeight("Empirical", 0.3);
        options.addValueWeight("BPT", 0.7);
        this.paramValues.add(options);
        this.paramNames.add("Aperiodicity");
        options = new ParamOptions();
        options.addValueWeight(0.3, 0.2);
        options.addValueWeight(0.5, 0.5);
        options.addValueWeight(0.7, 0.3);
        this.paramValues.add(options);
        PROB_MODEL_VAL = "BPT";
        DURATION = 5.0;
        this.FILENAME = "RupProbs_AllFinalModels_5yr.xls";
        this.makeExcelSheet(ucerf2);
        PROB_MODEL_VAL = "BPT";
        DURATION = 30.0;
        this.FILENAME = "RupProbs_AllFinalModels_30yr.xls";
        this.makeExcelSheet(ucerf2);
    }

    private void makeExcelSheet(UCERF2 ucerf2) {
        Parameter param;
        System.out.println(this.FILENAME);
        this.loginTreeBranchIndex = 0;
        this.lastParamIndex = this.paramNames.size() - 1;
        HSSFWorkbook wb = new HSSFWorkbook();
        this.readmeSheet = wb.createSheet("README");
        this.adjustableParamsSheet = wb.createSheet("Parameter Settings");
        this.rupProbSheet = wb.createSheet("Rupture Probability");
        this.rupProbSheet67 = wb.createSheet("Rup Prob for Mag>6.7");
        this.rupGainSheet = wb.createSheet("Rupture Gain");
        ucerf2.getParameter("Probability Model").setValue(PROB_MODEL_VAL);
        ucerf2.getTimeSpan().setDuration(DURATION);
        ParameterList adjustableParams = ucerf2.getAdjustableParameterList();
        ListIterator<Parameter<?>> it = adjustableParams.getParametersIterator();
        this.adjustableParamNames = new ArrayList();
        while (it.hasNext()) {
            param = (Parameter)it.next();
            this.adjustableParamNames.add(param.getName());
        }
        it = ucerf2.getTimeSpan().getAdjustableParams().getParametersIterator();
        while (it.hasNext()) {
            param = (Parameter)it.next();
            this.adjustableParamNames.add(param.getName());
        }
        HSSFFont boldFont = wb.createFont();
        boldFont.setBoldweight((short)700);
        this.boldStyle = wb.createCellStyle();
        this.boldStyle.setFont(boldFont);
        this.calcLogicTreeBranch(0, 1.0);
        this.writeWeightAvMinMaxCols();
        this.readmeSheet.setColumnWidth(0, -14336);
        HSSFCellStyle wrapCellStyle = wb.createCellStyle();
        wrapCellStyle.setWrapText(true);
        this.readmeSheet.createRow(0).createCell(0).setCellStyle(wrapCellStyle);
        this.readmeSheet.getRow(0).getCell(0).setCellValue(README_TEXT);
        try {
            FileOutputStream fileOut = new FileOutputStream(PATH + this.FILENAME);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeWeightAvMinMaxCols() {
        int rupRowIndex = 0;
        int colIndex = this.loginTreeBranchIndex + 1;
        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Weighted Average");
        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue("Min");
        this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue("Max");
        ++rupRowIndex;
        ++rupRowIndex;
        int totRupsIndex = 0;
        boolean onlyUnsegmented = true;
        if (this.paramNames.contains("A-Fault Solution Type")) {
            onlyUnsegmented = false;
        }
        this.ucerf2.getParameter("A-Fault Solution Type").setValue("Segmented Model");
        this.ucerf2.updateForecast();
        ArrayList aFaultGenerators = this.ucerf2.get_A_FaultSourceGenerators();
        int fltGenIndex = 0;
        while (fltGenIndex < aFaultGenerators.size()) {
            A_FaultSegmentedSourceGenerator sourceGen = (A_FaultSegmentedSourceGenerator)aFaultGenerators.get(fltGenIndex);
            int numRups = sourceGen.getNumRupSources();
            if (onlyUnsegmented) {
                numRups = 0;
            }
            ++rupRowIndex;
            int rupIndex = 0;
            while (rupIndex < numRups) {
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve.get(totRupsIndex).doubleValue());
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin.get(totRupsIndex).doubleValue());
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax.get(totRupsIndex).doubleValue());
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve67.get(totRupsIndex).doubleValue());
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin67.get(totRupsIndex).doubleValue());
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax67.get(totRupsIndex).doubleValue());
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupGainWtAve.get(totRupsIndex).doubleValue());
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupGainMin.get(totRupsIndex).doubleValue());
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupGainMax.get(totRupsIndex).doubleValue());
                ++rupRowIndex;
                ++rupIndex;
                ++totRupsIndex;
            }
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve.get(totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin.get(totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve67.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin67.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax67.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupGainWtAve.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupGainMin.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupGainMax.get(totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(++rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve.get(++totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin.get(totRupsIndex).doubleValue());
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupProbWtAve67.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupProbMin67.get(totRupsIndex).doubleValue());
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupProbMax67.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.rupGainWtAve.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 1))).setCellValue(this.rupGainMin.get(totRupsIndex).doubleValue());
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)(colIndex + 2))).setCellValue(this.rupGainMax.get(totRupsIndex).doubleValue());
            ++totRupsIndex;
            ++rupRowIndex;
            ++fltGenIndex;
            ++rupRowIndex;
        }
        if (onlyUnsegmented) {
            this.ucerf2.getParameter("A-Fault Solution Type").setValue("Unsegmented Model");
        }
    }

    private void fillAdjustableParams() {
        this.paramNames = new ArrayList();
        this.paramValues = new ArrayList();
        this.paramNames.add("Deformation Model");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("D2.1", 0.5);
        options.addValueWeight("D2.2", 0.2);
        options.addValueWeight("D2.3", 0.3);
        this.paramValues.add(options);
        this.paramNames.add("Mag-Area Relationship");
        options = new ParamOptions();
        options.addValueWeight("Ellsworth-B (WGCEP, 2002, Eq 4.5b)", 0.5);
        options.addValueWeight("Hanks & Bakun (2002)", 0.5);
        this.paramValues.add(options);
    }

    private void calcLogicTreeBranch(int paramIndex, double weight) {
        ParamOptions options = this.paramValues.get(paramIndex);
        String paramName = this.paramNames.get(paramIndex);
        int numValues = options.getNumValues();
        for (int i = 0; i < numValues; ++i) {
            double newWt;
            if (this.ucerf2.getAdjustableParameterList().containsParameter(paramName)) {
                this.ucerf2.getParameter(paramName).setValue(options.getValue(i));
                newWt = weight * options.getWeight(i);
                if (paramName.equalsIgnoreCase("Wt On A-Priori Rates")) {
                    Parameter param = this.ucerf2.getParameter("Wt On A-Priori Rates");
                    if ((Double)param.getValue() == 1.0E10) {
                        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(0.0);
                        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(0.0);
                    } else {
                        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(UCERF2.MIN_A_FAULT_RATE_1_DEFAULT);
                        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(UCERF2.MIN_A_FAULT_RATE_2_DEFAULT);
                    }
                }
                if (paramName.equalsIgnoreCase("Probability Model") && this.ucerf2.getParameter("A-Fault Solution Type").getValue().equals("Unsegmented Model") && options.getValue(i).equals("BPT")) {
                    this.ucerf2.getParameter("Probability Model").setValue("Poisson");
                }
            } else if (i == 0) {
                newWt = weight;
            } else {
                return;
            }
            if (paramIndex == this.lastParamIndex) {
                int colIndex;
                int rupRowIndex;
                System.out.println("Doing run:" + (this.loginTreeBranchIndex + 1));
                this.ucerf2.getTimeSpan().setDuration(DURATION);
                this.ucerf2.updateForecast();
                ArrayList aFaultsList = this.ucerf2.get_A_FaultSourceGenerators();
                if (this.loginTreeBranchIndex == 0) {
                    this.rupProbWtAve = new ArrayList();
                    this.rupProbMin = new ArrayList();
                    this.rupProbMax = new ArrayList();
                    this.rupProbWtAve67 = new ArrayList();
                    this.rupProbMin67 = new ArrayList();
                    this.rupProbMax67 = new ArrayList();
                    this.rupGainWtAve = new ArrayList();
                    this.rupGainMin = new ArrayList();
                    this.rupGainMax = new ArrayList();
                    this.unsegRowIndex = new ArrayList();
                    this.unsegWtAvgListIndex = new ArrayList();
                    rupRowIndex = 0;
                    colIndex = this.loginTreeBranchIndex;
                    this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Rupture Name");
                    this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Rupture Name");
                    this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Rupture Name");
                    ++rupRowIndex;
                    ++rupRowIndex;
                    rupRowIndex = this.ucerf2.getParameter("A-Fault Solution Type").getValue().equals("Segmented Model") ? this.doFirstBranchWhenSegmented(aFaultsList, rupRowIndex, colIndex) : this.doFirstBranchWhenUnsegmented(rupRowIndex, colIndex);
                    this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch Weight");
                    HSSFRow row = this.adjustableParamsSheet.createRow(0);
                    row.createCell(0).setCellValue("Parameters");
                    for (int p = 1; p <= this.adjustableParamNames.size(); ++p) {
                        String adjParamName = this.adjustableParamNames.get(p - 1);
                        HSSFCell cell = this.adjustableParamsSheet.createRow(p).createCell(0);
                        if (this.paramNames.contains(adjParamName) || adjParamName.equalsIgnoreCase("Min Fraction for Unknown Ruptures") || adjParamName.equalsIgnoreCase("Min Fraction for Unlikely Ruptures")) {
                            cell.setCellStyle(this.boldStyle);
                        }
                        cell.setCellValue(adjParamName);
                    }
                }
                rupRowIndex = 0;
                colIndex = ++this.loginTreeBranchIndex;
                this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                this.adjustableParamsSheet.createRow(0).createCell((int)((short)colIndex)).setCellValue("Branch " + this.loginTreeBranchIndex);
                ++rupRowIndex;
                ++rupRowIndex;
                rupRowIndex = this.ucerf2.getParameter("A-Fault Solution Type").getValue().equals("Segmented Model") ? this.doForSegmented(aFaultsList, newWt, rupRowIndex, colIndex) : this.doForUnsegmented(aFaultsList, newWt, colIndex);
                this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(newWt);
                ParameterList paramList = this.ucerf2.getAdjustableParameterList();
                ParameterList timeSpanParamList = this.ucerf2.getTimeSpan().getAdjustableParams();
                for (int p = 1; p <= this.adjustableParamNames.size(); ++p) {
                    String parameterName = this.adjustableParamNames.get(p - 1);
                    if (paramList.containsParameter(parameterName)) {
                        HSSFCell cell = this.adjustableParamsSheet.getRow(p).createCell((int)((short)this.loginTreeBranchIndex));
                        if (this.paramNames.contains(parameterName) || parameterName.equalsIgnoreCase("Min Fraction for Unknown Ruptures") || parameterName.equalsIgnoreCase("Min Fraction for Unlikely Ruptures")) {
                            cell.setCellStyle(this.boldStyle);
                        }
                        cell.setCellValue(paramList.getValue(parameterName).toString());
                        continue;
                    }
                    if (!timeSpanParamList.containsParameter(parameterName)) continue;
                    this.adjustableParamsSheet.getRow(p).createCell((int)((short)this.loginTreeBranchIndex)).setCellValue(timeSpanParamList.getValue(parameterName).toString());
                }
                continue;
            }
            this.calcLogicTreeBranch(paramIndex + 1, newWt);
        }
    }

    private int doFirstBranchWhenSegmented(ArrayList aFaultsList, int rupRowIndex, int colIndex) {
        ArrayList aFaultGenerators = aFaultsList;
        this.fltNames = new String[aFaultGenerators.size()];
        int fltGenIndex = 0;
        while (fltGenIndex < aFaultGenerators.size()) {
            A_FaultSegmentedSourceGenerator sourceGen = (A_FaultSegmentedSourceGenerator)aFaultGenerators.get(fltGenIndex);
            this.fltNames[fltGenIndex] = sourceGen.getFaultSegmentData().getFaultName();
            this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getFaultSegmentData().getFaultName());
            int numRups = sourceGen.getNumRupSources();
            ++rupRowIndex;
            for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getLongRupName(rupIndex));
                this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getLongRupName(rupIndex));
                this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(sourceGen.getLongRupName(rupIndex));
                this.rupProbWtAve.add(0.0);
                this.rupProbMin.add((Double)Double.MAX_VALUE);
                this.rupProbMax.add(0.0);
                this.rupProbWtAve67.add(0.0);
                this.rupProbMin67.add((Double)Double.MAX_VALUE);
                this.rupProbMax67.add(0.0);
                this.rupGainWtAve.add(0.0);
                this.rupGainMin.add((Double)Double.MAX_VALUE);
                this.rupGainMax.add(0.0);
                ++rupRowIndex;
            }
            this.unsegRowIndex.add(rupRowIndex);
            this.unsegWtAvgListIndex.add(this.rupProbWtAve.size());
            this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Unsegmented");
            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Unsegmented");
            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Unsegmented");
            this.rupProbWtAve.add(0.0);
            this.rupProbMin.add((Double)Double.MAX_VALUE);
            this.rupProbMax.add(0.0);
            this.rupProbWtAve67.add(0.0);
            this.rupProbMin67.add((Double)Double.MAX_VALUE);
            this.rupProbMax67.add(0.0);
            this.rupGainWtAve.add(0.0);
            this.rupGainMin.add((Double)Double.MAX_VALUE);
            this.rupGainMax.add(0.0);
            this.rupProbSheet.createRow(++rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Probability");
            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Probability");
            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Gain");
            this.rupProbWtAve.add(0.0);
            this.rupProbMin.add((Double)Double.MAX_VALUE);
            this.rupProbMax.add(0.0);
            this.rupProbWtAve67.add(0.0);
            this.rupProbMin67.add((Double)Double.MAX_VALUE);
            this.rupProbMax67.add(0.0);
            this.rupGainWtAve.add(0.0);
            this.rupGainMin.add((Double)Double.MAX_VALUE);
            this.rupGainMax.add(0.0);
            ++rupRowIndex;
            ++fltGenIndex;
            ++rupRowIndex;
        }
        return rupRowIndex;
    }

    private int doFirstBranchWhenUnsegmented(int rupRowIndex, int colIndex) {
        String[] aFaultNames = new String[]{"Elsinore", "Garlock", "San Jacinto", "N. San Andreas", "S. San Andreas", "Hayward-Rodgers Creek", "Calaveras"};
        this.fltNames = aFaultNames;
        int fltGenIndex = 0;
        while (fltGenIndex < this.fltNames.length) {
            this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.fltNames[fltGenIndex]);
            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.fltNames[fltGenIndex]);
            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(this.fltNames[fltGenIndex]);
            this.unsegRowIndex.add(++rupRowIndex);
            this.unsegWtAvgListIndex.add(this.rupProbWtAve.size());
            this.rupProbSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Unsegmented");
            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Unsegmented");
            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Unsegmented");
            this.rupProbWtAve.add(0.0);
            this.rupProbMin.add((Double)Double.MAX_VALUE);
            this.rupProbMax.add(0.0);
            this.rupProbWtAve67.add(0.0);
            this.rupProbMin67.add((Double)Double.MAX_VALUE);
            this.rupProbMax67.add(0.0);
            this.rupGainWtAve.add(0.0);
            this.rupGainMin.add((Double)Double.MAX_VALUE);
            this.rupGainMax.add(0.0);
            this.rupProbSheet.createRow(++rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Probability");
            this.rupProbSheet67.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Probability");
            this.rupGainSheet.createRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue("Total Gain");
            this.rupProbWtAve.add(0.0);
            this.rupProbMin.add((Double)Double.MAX_VALUE);
            this.rupProbMax.add(0.0);
            this.rupProbWtAve67.add(0.0);
            this.rupProbMin67.add((Double)Double.MAX_VALUE);
            this.rupProbMax67.add(0.0);
            this.rupGainWtAve.add(0.0);
            this.rupGainMin.add((Double)Double.MAX_VALUE);
            this.rupGainMax.add(0.0);
            ++rupRowIndex;
            ++fltGenIndex;
            ++rupRowIndex;
        }
        return rupRowIndex;
    }

    private int doForSegmented(ArrayList<A_FaultSegmentedSourceGenerator> aFaultGenerators, double newWt, int rupRowIndex, int colIndex) {
        int totRupsIndex = 0;
        int fltGenIndex = 0;
        while (fltGenIndex < aFaultGenerators.size()) {
            double rupGain;
            double rupProb67;
            double rupProb;
            A_FaultSegmentedSourceGenerator sourceGen = aFaultGenerators.get(fltGenIndex);
            int numRups = sourceGen.getNumRupSources();
            ++rupRowIndex;
            int rupIndex = 0;
            while (rupIndex < numRups) {
                rupProb = sourceGen.getRupSourceProb(rupIndex);
                this.rupProbWtAve.set(totRupsIndex, this.rupProbWtAve.get(totRupsIndex) + newWt * rupProb);
                if (this.rupProbMin.get(totRupsIndex) > rupProb) {
                    this.rupProbMin.set(totRupsIndex, rupProb);
                }
                if (this.rupProbMax.get(totRupsIndex) < rupProb) {
                    this.rupProbMax.set(totRupsIndex, rupProb);
                }
                this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb);
                rupProb67 = sourceGen.getRupSourceProbAboveMag(rupIndex, this.MAG_67);
                this.rupProbWtAve67.set(totRupsIndex, this.rupProbWtAve67.get(totRupsIndex) + newWt * rupProb67);
                if (this.rupProbMin67.get(totRupsIndex) > rupProb67) {
                    this.rupProbMin67.set(totRupsIndex, rupProb67);
                }
                if (this.rupProbMax67.get(totRupsIndex) < rupProb67) {
                    this.rupProbMax67.set(totRupsIndex, rupProb67);
                }
                this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb67);
                rupGain = sourceGen.getRupSourcProbGain(rupIndex);
                this.rupGainWtAve.set(totRupsIndex, this.rupGainWtAve.get(totRupsIndex) + newWt * rupGain);
                if (this.rupGainMin.get(totRupsIndex) > rupGain) {
                    this.rupGainMin.set(totRupsIndex, rupGain);
                }
                if (this.rupGainMax.get(totRupsIndex) < rupGain) {
                    this.rupGainMax.set(totRupsIndex, rupGain);
                }
                this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupGain);
                ++rupRowIndex;
                ++rupIndex;
                ++totRupsIndex;
            }
            ++rupRowIndex;
            rupProb = sourceGen.getTotFaultProb();
            this.rupProbWtAve.set(++totRupsIndex, this.rupProbWtAve.get(totRupsIndex) + newWt * rupProb);
            if (this.rupProbMin.get(totRupsIndex) > rupProb) {
                this.rupProbMin.set(totRupsIndex, rupProb);
            }
            if (this.rupProbMax.get(totRupsIndex) < rupProb) {
                this.rupProbMax.set(totRupsIndex, rupProb);
            }
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb);
            rupProb67 = sourceGen.getTotFaultProb(this.MAG_67);
            this.rupProbWtAve67.set(totRupsIndex, this.rupProbWtAve67.get(totRupsIndex) + newWt * rupProb67);
            if (this.rupProbMin67.get(totRupsIndex) > rupProb67) {
                this.rupProbMin67.set(totRupsIndex, rupProb67);
            }
            if (this.rupProbMax67.get(totRupsIndex) < rupProb67) {
                this.rupProbMax67.set(totRupsIndex, rupProb67);
            }
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb67);
            rupGain = sourceGen.getTotFaultProbGain();
            this.rupGainWtAve.set(totRupsIndex, this.rupGainWtAve.get(totRupsIndex) + newWt * rupGain);
            if (this.rupGainMin.get(totRupsIndex) > rupGain) {
                this.rupGainMin.set(totRupsIndex, rupGain);
            }
            if (this.rupGainMax.get(totRupsIndex) < rupGain) {
                this.rupGainMax.set(totRupsIndex, rupGain);
            }
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupGain);
            ++totRupsIndex;
            ++rupRowIndex;
            ++fltGenIndex;
            ++rupRowIndex;
        }
        return rupRowIndex;
    }

    private int doForUnsegmented(ArrayList<UnsegmentedSource> unsegmentedSourceList, double newWt, int colIndex) {
        int rupRowIndex = 0;
        for (int fltGenIndex = 0; fltGenIndex < this.fltNames.length; ++fltGenIndex) {
            double rupGain;
            double rupProb67;
            double rupProb;
            rupRowIndex = this.unsegRowIndex.get(fltGenIndex);
            int wtAveIndex = this.unsegWtAvgListIndex.get(fltGenIndex);
            if (this.fltNames[fltGenIndex].equals("San Jacinto")) {
                UnsegmentedSource unsegmentedSource1 = this.getUnsegmentedSource("San Jacinto (SB to C)", unsegmentedSourceList);
                UnsegmentedSource unsegmentedSource2 = this.getUnsegmentedSource("San Jacinto (CC to SM)", unsegmentedSourceList);
                double rupProb1 = unsegmentedSource1.computeTotalProb();
                double rupProb2 = unsegmentedSource2.computeTotalProb();
                rupProb = 1.0 - (1.0 - rupProb1) * (1.0 - rupProb2);
                double rupProb67_1 = unsegmentedSource1.computeTotalProbAbove(this.MAG_67);
                double rupProb67_2 = unsegmentedSource2.computeTotalProbAbove(this.MAG_67);
                rupProb67 = 1.0 - (1.0 - rupProb67_1) * (1.0 - rupProb67_2);
                double rupGain1 = unsegmentedSource1.getSourceGain();
                double rupGain2 = unsegmentedSource2.getSourceGain();
                rupGain = rupProb / (1.0 - (1.0 - rupProb1 / rupGain1) * (1.0 - rupProb2 / rupGain2));
            } else {
                UnsegmentedSource unsegmentedSource = this.getUnsegmentedSource(this.fltNames[fltGenIndex], unsegmentedSourceList);
                rupProb = unsegmentedSource.computeTotalProb();
                rupProb67 = unsegmentedSource.computeTotalProbAbove(this.MAG_67);
                rupGain = unsegmentedSource.getSourceGain();
            }
            this.rupProbWtAve.set(wtAveIndex, this.rupProbWtAve.get(wtAveIndex) + newWt * rupProb);
            if (this.rupProbMin.get(wtAveIndex) > rupProb) {
                this.rupProbMin.set(wtAveIndex, rupProb);
            }
            if (this.rupProbMax.get(wtAveIndex) < rupProb) {
                this.rupProbMax.set(wtAveIndex, rupProb);
            }
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb);
            this.rupProbWtAve67.set(wtAveIndex, this.rupProbWtAve67.get(wtAveIndex) + newWt * rupProb67);
            if (this.rupProbMin67.get(wtAveIndex) > rupProb67) {
                this.rupProbMin67.set(wtAveIndex, rupProb67);
            }
            if (this.rupProbMax67.get(wtAveIndex) < rupProb67) {
                this.rupProbMax67.set(wtAveIndex, rupProb67);
            }
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb67);
            this.rupGainWtAve.set(wtAveIndex, this.rupGainWtAve.get(wtAveIndex) + newWt * rupGain);
            if (this.rupGainMin.get(wtAveIndex) > rupGain) {
                this.rupGainMin.set(wtAveIndex, rupGain);
            }
            if (this.rupGainMax.get(wtAveIndex) < rupGain) {
                this.rupGainMax.set(wtAveIndex, rupGain);
            }
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupGain);
            ++rupRowIndex;
            this.rupProbWtAve.set(++wtAveIndex, this.rupProbWtAve.get(wtAveIndex) + newWt * rupProb);
            if (this.rupProbMin.get(wtAveIndex) > rupProb) {
                this.rupProbMin.set(wtAveIndex, rupProb);
            }
            if (this.rupProbMax.get(wtAveIndex) < rupProb) {
                this.rupProbMax.set(wtAveIndex, rupProb);
            }
            this.rupProbSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb);
            this.rupProbWtAve67.set(wtAveIndex, this.rupProbWtAve67.get(wtAveIndex) + newWt * rupProb67);
            if (this.rupProbMin67.get(wtAveIndex) > rupProb67) {
                this.rupProbMin67.set(wtAveIndex, rupProb67);
            }
            if (this.rupProbMax67.get(wtAveIndex) < rupProb67) {
                this.rupProbMax67.set(wtAveIndex, rupProb67);
            }
            this.rupProbSheet67.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupProb67);
            this.rupGainWtAve.set(wtAveIndex, this.rupGainWtAve.get(wtAveIndex) + newWt * rupGain);
            if (this.rupGainMin.get(wtAveIndex) > rupGain) {
                this.rupGainMin.set(wtAveIndex, rupGain);
            }
            if (this.rupGainMax.get(wtAveIndex) < rupGain) {
                this.rupGainMax.set(wtAveIndex, rupGain);
            }
            this.rupGainSheet.getRow(rupRowIndex).createCell((int)((short)colIndex)).setCellValue(rupGain);
        }
        return rupRowIndex + 2;
    }

    private UnsegmentedSource getUnsegmentedSource(String srcName, ArrayList<UnsegmentedSource> srcList) {
        for (int i = 0; i < srcList.size(); ++i) {
            if (!srcList.get(i).getFaultSegmentData().getFaultName().equals(srcName)) continue;
            return srcList.get(i);
        }
        return null;
    }

    public static void main(String[] args) {
        WriteTimeDepUnsegmentedProbAndGain rupProbWriter = new WriteTimeDepUnsegmentedProbAndGain();
    }
}

