/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

public class PrefFaultSectionDataFinal
implements Serializable {
    private ArrayList<FaultSectionPrefData> faultSectionsList;
    private ArrayList<FaultSectionPrefData> dbFaultSectionsList = new ArrayList();
    private HashMap indexForID_Map;
    private HashMap dbMap;
    private static final String XML_DATA_FILENAME = "PrefFaultSectionData.xml";
    int numSections = 0;
    ArrayList<Integer> faultNums = new ArrayList();

    public PrefFaultSectionDataFinal() {
        this.readFaultSectionDataFromXML();
    }

    private void test() {
        System.out.println("TESTING!");
        for (Integer num : this.faultNums) {
            int i = num;
            FaultSectionPrefData dbFault = this.dbFaultSectionsList.get((Integer)this.dbMap.get(i));
            FaultSectionPrefData fileFault = this.faultSectionsList.get((Integer)this.dbMap.get(i));
            if (dbFault.getSectionId() != fileFault.getSectionId()) {
                System.out.println("ERROR: Id's not equal!");
            }
            if (dbFault.getAseismicSlipFactor() != fileFault.getAseismicSlipFactor()) {
                System.out.println("ERROR: Test Failed 1");
            }
            if (dbFault.getAveDip() != fileFault.getAveDip()) {
                System.out.println("ERROR: Test Failed 2");
            }
            if (dbFault.getAveLowerDepth() != fileFault.getAveLowerDepth()) {
                System.out.println("ERROR: Test Failed 4");
            }
            if (dbFault.getOrigAveUpperDepth() != fileFault.getOrigAveUpperDepth()) {
                System.out.println("ERROR: Test Failed 6");
            }
            if (dbFault.getDipDirection() != fileFault.getDipDirection()) {
                System.out.println("ERROR: Test Failed 7");
            }
            if (dbFault.getSectionId() != fileFault.getSectionId()) {
                System.out.println("ERROR: Test Failed 9");
            }
            if (!dbFault.getSectionName().equals(fileFault.getSectionName())) {
                System.out.println("ERROR: Test Failed 10");
            }
            if (dbFault.getTraceLength() != fileFault.getTraceLength()) {
                System.out.println("ERROR: Test Failed 12");
            }
            if (dbFault.getOrigDownDipWidth() != fileFault.getOrigDownDipWidth()) {
                System.out.println("ERROR: Test Failed 13");
            }
            if (dbFault.getOrigSlipRateStdDev() != fileFault.getOrigSlipRateStdDev()) {
                System.out.println("ERROR: Test Failed 14");
            }
            FaultTrace dbTrace = dbFault.getFaultTrace();
            FaultTrace fileTrace = fileFault.getFaultTrace();
            for (int j = 0; j < dbTrace.getNumLocations(); ++j) {
                Location fileLoc;
                Location dbLoc = (Location)dbTrace.get(j);
                if (dbLoc.equals(fileLoc = (Location)fileTrace.get(j))) continue;
                System.out.println("Loc on fault trace is bad!");
                System.out.println(dbLoc);
                System.out.println(fileLoc);
            }
        }
    }

    private void writeFaultSectionDataFromDatabaseTo_XML() {
        PrefFaultSectionDataDB_DAO faultSectionDAO = new PrefFaultSectionDataDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
        ArrayList<FaultSectionPrefData> faultSectionDataListFromDatabase = faultSectionDAO.getAllFaultSectionPrefData();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("PrefFaultSectionData");
        this.indexForID_Map = new HashMap();
        this.dbMap = new HashMap();
        for (int i = 0; i < faultSectionDataListFromDatabase.size(); ++i) {
            FaultSectionPrefData fspd = faultSectionDataListFromDatabase.get(i);
            root = fspd.toXMLMetadata(root);
            this.indexForID_Map.put(fspd.getSectionId(), i);
            this.dbMap.put(fspd.getSectionId(), i);
            this.faultNums.add(fspd.getSectionId());
            this.dbFaultSectionsList.add(fspd);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            System.out.println("Writing Pref Fault Section Data to PrefFaultSectionData.xml");
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(XML_DATA_FILENAME), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.faultSectionsList = faultSectionDataListFromDatabase;
    }

    private void readFaultSectionDataFromXML() {
        SAXReader reader = new SAXReader();
        this.faultSectionsList = new ArrayList();
        this.indexForID_Map = new HashMap();
        try {
            URL xmlURL = PrefFaultSectionDataFinal.class.getResource("/data/erf/ucerf2/finalReferenceFaultParamDb/PrefFaultSectionData.xml");
            Document document = reader.read(xmlURL);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                FaultSectionPrefData data = FaultSectionPrefData.fromXMLMetadata(el);
                FaultTrace trace = data.getFaultTrace();
                for (int i = 0; i < trace.size(); ++i) {
                    trace.set(i, Location.backwardsCompatible((Location)trace.get(i)));
                }
                this.faultSectionsList.add(data);
            }
            for (int i = 0; i < this.faultSectionsList.size(); ++i) {
                FaultSectionPrefData fspd = this.faultSectionsList.get(i);
                this.indexForID_Map.put(fspd.getSectionId(), i);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public ArrayList getAllFaultSectionPrefData() {
        return this.faultSectionsList;
    }

    public FaultSectionPrefData getFaultSectionPrefData(int faultSectionId) {
        int index = (Integer)this.indexForID_Map.get(faultSectionId);
        return this.faultSectionsList.get(index);
    }

    public static void main(String[] args) {
        PrefFaultSectionDataFinal test = new PrefFaultSectionDataFinal();
        ArrayList junk = test.getAllFaultSectionPrefData();
        FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)junk.get(5);
        int id = faultSectionPrefData.getSectionId();
        System.out.println(id);
        FaultSectionPrefData faultSectionPrefData2 = test.getFaultSectionPrefData(id);
        System.out.println(faultSectionPrefData2.getSectionId());
        test.test();
    }
}

