/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.ListIterator;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.oldClasses.UCERF2_Final_RelativeLocation;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class Point2Vert_FaultPoisSource
extends PointSource.PoissonPointSource
implements Serializable {
    public static boolean DUPLICATE_PT_SRC_FOR_CROSSHAIR = true;
    private static String C = new String("Point2Vert_FaultPoisSource");
    private String name = C;
    private boolean D = false;
    private IncrementalMagFreqDist magFreqDist;
    private static final double aveDip = 90.0;
    private MagLengthRelationship magLengthRelationship;
    private double magCutOff;
    private FrankelGriddedSurface finiteFaultSurface1;
    private FrankelGriddedSurface finiteFaultSurface2;
    private double strike;
    private Location loc;
    private boolean isCrossHair = false;
    private static final MagLengthRelationship WC94 = new WC1994_MagLengthRelationship();

    public Point2Vert_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double magCutOff, double fracStrikeSlip, double fracNormal, double fracReverse, WeightedList<PointSourceDistanceCorrection> distCorrs) {
        super(loc, TECTONIC_REGION_TYPE_DEFAULT, duration, null, distCorrs);
        this.magCutOff = magCutOff;
        if (this.D) {
            System.out.println("magCutOff=" + magCutOff);
            System.out.println("num pts in magFreqDist=" + magFreqDist.size());
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, fracStrikeSlip, fracNormal, fracReverse);
    }

    public Point2Vert_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double magCutOff, double fracStrikeSlip, double fracNormal, double fracReverse, boolean isCrossHair, WeightedList<PointSourceDistanceCorrection> distCorrs) {
        super(loc, TECTONIC_REGION_TYPE_DEFAULT, duration, null, distCorrs);
        this.magCutOff = magCutOff;
        this.isCrossHair = isCrossHair;
        this.setAll(loc, magFreqDist, magLengthRelationship, fracStrikeSlip, fracNormal, fracReverse);
    }

    public void setAll(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double fracStrikeSlip, double fracNormal, double fracReverse) {
        double strike = (Math.random() - 0.5) * 180.0;
        if (strike < 0.0) {
            strike += 360.0;
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, fracStrikeSlip, fracNormal, fracReverse);
    }

    public void setAll(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double fracStrikeSlip, double fracNormal, double fracReverse) {
        if (this.D) {
            System.out.println("strike=" + strike);
        }
        this.strike = strike;
        this.loc = loc;
        this.magFreqDist = magFreqDist;
        this.magLengthRelationship = magLengthRelationship;
        double sum = fracNormal + fracReverse + fracStrikeSlip;
        if (Math.abs(1.0 - sum) > 1.0E-5) {
            throw new RuntimeException("fractions must sum to 1.0: " + sum);
        }
        HashMap<FocalMechanism, Double> mechWeights = new HashMap<FocalMechanism, Double>();
        if (fracStrikeSlip > 0.0) {
            mechWeights.put(FocalMech.STRIKE_SLIP.mechanism, fracStrikeSlip);
        }
        if (fracNormal > 0.0) {
            mechWeights.put(FocalMech.NORMAL.mechanism, fracNormal);
        }
        if (fracReverse > 0.0) {
            mechWeights.put(FocalMech.REVERSE.mechanism, fracReverse);
        }
        SurfaceGenerator surfGen = new SurfaceGenerator();
        this.setData(Point2Vert_FaultPoisSource.dataForMFDs(loc, magFreqDist, mechWeights, surfGen));
    }

    private void checkInitSurfaces() {
        double depth = 1.0;
        double maxMag = this.magFreqDist.getX(this.magFreqDist.size() - 1);
        if (maxMag > this.magCutOff && this.finiteFaultSurface1 == null) {
            double halfLength = this.magLengthRelationship.getMedianLength(maxMag) / 2.0;
            if (this.isCrossHair) {
                this.strike = 0.0;
            }
            Location loc1 = LocationUtils.location(this.loc, Math.toRadians(this.strike + 180.0), halfLength);
            Location loc2 = LocationUtils.location(this.loc, Math.toRadians(this.strike), halfLength);
            FaultTrace fault = new FaultTrace("");
            fault.add(loc1);
            fault.add(loc2);
            this.finiteFaultSurface1 = new FrankelGriddedSurface(fault, 90.0, depth, depth, 1.0);
            if (this.isCrossHair) {
                this.strike = 90.0;
                loc1 = LocationUtils.location(this.loc, Math.toRadians(this.strike + 180.0), halfLength);
                loc2 = LocationUtils.location(this.loc, Math.toRadians(this.strike), halfLength);
                fault = new FaultTrace("");
                fault.add(loc1);
                fault.add(loc2);
                this.finiteFaultSurface2 = new FrankelGriddedSurface(fault, 90.0, depth, depth, 1.0);
            }
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        this.checkInitSurfaces();
        if (this.finiteFaultSurface1 != null) {
            locList = this.finiteFaultSurface1.getEvenlyDiscritizedListOfLocsOnSurface();
        }
        if (this.finiteFaultSurface2 != null) {
            ListIterator<Location> it = this.finiteFaultSurface2.getLocationsIterator();
            while (it.hasNext()) {
                locList.add((Location)it.next());
            }
        }
        locList.add(this.loc);
        return locList;
    }

    @Override
    public RuptureSurface getSourceSurface() {
        PointSurface newPtSurface = new PointSurface(this.loc);
        newPtSurface.setDepth(1.0);
        return newPtSurface;
    }

    @Override
    public double getMinDistance(Site site) {
        return UCERF2_Final_RelativeLocation.getHorzDistance(site.getLocation(), this.loc);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void main(String[] args) {
        Location loc = new Location(34.0, -118.0, 0.0);
        GutenbergRichterMagFreqDist dist = new GutenbergRichterMagFreqDist(5.0, 16, 0.2, 1.0E17, 0.9);
        WC1994_MagLengthRelationship wc_rel = new WC1994_MagLengthRelationship();
        double fracStrikeSlip = 0.3333333333333333;
        double fracNormal = 0.3333333333333333;
        double fracReverse = 0.3333333333333333;
        double duration = 1.0;
        Point2Vert_FaultPoisSource src = new Point2Vert_FaultPoisSource(loc, (IncrementalMagFreqDist)dist, (MagLengthRelationship)wc_rel, duration, 6.0, fracStrikeSlip, fracNormal, fracReverse, false, null);
        System.out.println("num rups =" + src.getNumRuptures() + "\ttotProb=" + src.computeTotalProb());
        System.out.println("Rupture mags and end locs:");
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            System.out.println(r + "\t" + (float)rup.getMag() + "\t" + rup.getAveRake() + "\t" + rup.getProbability());
        }
    }

    public boolean isCrossHair() {
        return this.isCrossHair;
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    private double calcWidth(double mag, double depth, double dip) {
        double length = WC94.getMedianLength(mag);
        double aspectWidth = length / 1.5;
        double ddWidth = (14.0 - depth) / Math.sin(dip * GeoTools.TO_RAD);
        return Math.min(aspectWidth, ddWidth);
    }

    private class SurfaceGenerator
    implements PointSource.FocalMechRuptureSurfaceBuilder {
        private SurfaceGenerator() {
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface) {
            return null;
        }

        @Override
        public int getNumSurfaces(double magnitude, FocalMech mech) {
            if (Point2Vert_FaultPoisSource.this.isCrossHair) {
                if (DUPLICATE_PT_SRC_FOR_CROSSHAIR || magnitude > Point2Vert_FaultPoisSource.this.magCutOff) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }

        @Override
        public RuptureSurface getSurface(Location sourceLoc, double magnitude, FocalMech mech, int surfaceIndex) {
            double depth;
            Preconditions.checkState((surfaceIndex == 0 || Point2Vert_FaultPoisSource.this.isCrossHair && surfaceIndex == 1 ? 1 : 0) != 0);
            double d = depth = magnitude <= 6.5 ? 5.0 : 1.0;
            if (magnitude <= Point2Vert_FaultPoisSource.this.magCutOff) {
                PointSurface ptSurface = new PointSurface(Location.backwardsCompatible(Point2Vert_FaultPoisSource.this.loc.getLatitude(), Point2Vert_FaultPoisSource.this.loc.getLongitude(), depth));
                ptSurface.setAveStrike(Point2Vert_FaultPoisSource.this.strike);
                ptSurface.setAveDip(mech.dip());
                double width = Point2Vert_FaultPoisSource.this.calcWidth(magnitude, depth, mech.dip());
                ptSurface.setAveWidth(width);
                return ptSurface;
            }
            Point2Vert_FaultPoisSource.this.checkInitSurfaces();
            FrankelGriddedSurface finiteFault = surfaceIndex == 1 ? Point2Vert_FaultPoisSource.this.finiteFaultSurface2 : Point2Vert_FaultPoisSource.this.finiteFaultSurface1;
            if (finiteFault.getLocation(0, 0).getDepth() != depth) {
                finiteFault = finiteFault.deepCopyOverrideDepth(depth);
            }
            if ((float)magnitude == (float)Point2Vert_FaultPoisSource.this.magFreqDist.getMaxX()) {
                return finiteFault;
            }
            double rupLen = Point2Vert_FaultPoisSource.this.magLengthRelationship.getMedianLength(magnitude);
            double startPoint = (double)finiteFault.getNumCols() / 2.0 - 0.5 - rupLen / 2.0;
            int cols = Math.round((float)rupLen + 1.0f);
            int startCol = Math.round((float)startPoint);
            GriddedSubsetSurface rupSurf = new GriddedSubsetSurface(1, cols, 0, startCol, finiteFault);
            return rupSurf;
        }

        @Override
        public double getSurfaceWeight(double magnitude, FocalMech mech, int surfaceIndex) {
            Preconditions.checkState((surfaceIndex == 0 || Point2Vert_FaultPoisSource.this.isCrossHair && surfaceIndex == 1 ? 1 : 0) != 0);
            return Point2Vert_FaultPoisSource.this.isCrossHair ? 0.5 : 1.0;
        }

        @Override
        public boolean isSurfaceFinite(double magnitude, FocalMech mech, int surfaceIndex) {
            Preconditions.checkState((surfaceIndex == 0 || Point2Vert_FaultPoisSource.this.isCrossHair && surfaceIndex == 1 ? 1 : 0) != 0);
            return magnitude > Point2Vert_FaultPoisSource.this.magCutOff;
        }
    }
}

