/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.gui.HazardCurveApplication;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBean;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.infoTools.ExceptionWindow;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class CEA_HazardCurveLocalModeApp
extends HazardCurveApplication {
    protected static final String appURL = "http://www.opensha.org/applications/hazCurvApp/HazardCurveApp.jar";

    public CEA_HazardCurveLocalModeApp(String appShortName) {
        super(appShortName);
    }

    public static ApplicationVersion getAppVersion() {
        return new ApplicationVersion(1, 0, 0);
    }

    protected void checkAppVersion() {
    }

    @Override
    protected void initERF_GuiBean() {
        if (this.erfGuiBean == null) {
            try {
                this.erfGuiBean = new ERF_GuiBean(ERF_Ref.UCERF_2, ERF_Ref.WGCEP_UCERF_1, ERF_Ref.FRANKEL_02);
                this.erfGuiBean.getParameter("Eqk Rup Forecast").addParameterChangeListener(this);
            }
            catch (InvocationTargetException e) {
                ExceptionWindow bugWindow = new ExceptionWindow((Component)this, e.getStackTrace(), "Problem occured during initialization the ERF's. All parameters are set to default.");
                bugWindow.setVisible(true);
                bugWindow.pack();
            }
        } else {
            boolean isCustomRupture = this.erfRupSelectorGuiBean.isCustomRuptureSelected();
            if (!isCustomRupture) {
                ERF eqkRupForecast = this.erfRupSelectorGuiBean.getSelectedEqkRupForecastModel();
                this.erfGuiBean.setERF(eqkRupForecast);
            }
        }
    }

    @Override
    protected void initERFSelector_GuiBean() {
        BaseERF erf = null;
        try {
            erf = this.erfGuiBean.getSelectedERF();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        if (this.erfRupSelectorGuiBean == null) {
            try {
                this.erfRupSelectorGuiBean = new EqkRupSelectorGuiBean(erf, ERF_Ref.FRANKEL_ADJUSTABLE_96, ERF_Ref.UCERF_2, ERF_Ref.WGCEP_UCERF_1);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Connection to ERF's failed");
            }
        } else {
            this.erfRupSelectorGuiBean.setEqkRupForecastModel(erf);
        }
    }

    @Override
    protected void createCalcInstance() {
        try {
            if (this.calc == null) {
                this.calc = new HazardCurveCalculator();
            }
            if (this.disaggregationFlag && this.disaggCalc == null) {
                this.disaggCalc = new DisaggregationCalculator();
            }
        }
        catch (Exception e) {
            ExceptionWindow bugWindow = new ExceptionWindow((Component)this, e.getStackTrace(), this.getParametersInfoAsString());
            bugWindow.setVisible(true);
            bugWindow.pack();
        }
    }

    @Override
    protected void initControlList() {
        this.controlComboBox.addItem("Select");
        this.controlComboBox.addItem("Disaggregation");
        this.controlComboBox.addItem("Calculation Settings");
        this.controlComboBox.addItem("Sites of Interest");
        this.controlComboBox.addItem("Set Site Params from Web Services");
        this.controlComboBox.addItem("Set X values for Hazard Curve Calc.");
        this.controlComboBox.addItem("Set new dataset plotting option");
        this.controlComboBox.addItem("Set external XY dataset");
    }

    @Override
    protected void initIMR_GuiBean() {
        List<AttenuationRelationship> imrs = AttenRelRef.instanceList(null, true, AttenRelRef.BA_2008, AttenRelRef.CB_2008, AttenRelRef.BJF_1997, AttenRelRef.AS_1997, AttenRelRef.CAMPBELL_1997, AttenRelRef.SADIGH_1997, AttenRelRef.FIELD_2000);
        for (ScalarIMR scalarIMR : imrs) {
            scalarIMR.setParamDefaults();
        }
        this.imrGuiBean = new IMR_MultiGuiBean(imrs);
        this.imrGuiBean.addIMRChangeListener(this);
    }

    public static void main(String[] args) {
        CEA_HazardCurveLocalModeApp applet = new CEA_HazardCurveLocalModeApp("HazardCurveLocal");
        applet.checkAppVersion();
        applet.init();
        applet.setTitle("CEA Hazard Curve Calculator (" + String.valueOf(CEA_HazardCurveLocalModeApp.getAppVersion()) + ")");
        applet.setVisible(true);
    }
}

