/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

class C_ZonesDataTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Name", "Rate (M>=5)", "Rate (M>=6.5)", "Moment Rate"};
    private ArrayList<IncrementalMagFreqDist> cZonesMFD_List;
    private static final DecimalFormat MOMENT_FORMAT = new DecimalFormat("0.000E0");
    private static final DecimalFormat RATE_FORMAT = new DecimalFormat("0.00000");

    public C_ZonesDataTableModel() {
        this(null);
    }

    public C_ZonesDataTableModel(ArrayList<IncrementalMagFreqDist> cZonesMFD_List) {
        this.setMFD_List(cZonesMFD_List);
    }

    public void setMFD_List(ArrayList<IncrementalMagFreqDist> cZonesMFD_List) {
        this.cZonesMFD_List = cZonesMFD_List;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return columnNames[index];
    }

    @Override
    public int getRowCount() {
        if (this.cZonesMFD_List == null) {
            return 0;
        }
        return this.cZonesMFD_List.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IncrementalMagFreqDist mfd = this.cZonesMFD_List.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return mfd.getName();
            }
            case 1: {
                return RATE_FORMAT.format(mfd.getCumRate(5.05));
            }
            case 2: {
                return RATE_FORMAT.format(mfd.getCumRate(6.55));
            }
            case 3: {
                return MOMENT_FORMAT.format(mfd.getTotalMomentRate());
            }
        }
        return "";
    }
}

