/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.CreateHistogramsFromSegSlipRateFile;

public class CreateHistogramsFromSegRecurIntvFile {
    private static final String X_AXIS_LABEL = "Ratio of Mean Recur Intv and Calculated Recur Intv";
    private static final String Y_AXIS_LABEL = "Count";
    private static final String PLOT_LABEL = "Recurrence Interval Ratio";
    private static final String[] names = new String[]{"Mean Recurrence Interval", "Min Recurrence Interval", "Max Recurrence Interval", "Characteristic", "Ellsworth-A_UniformBoxcar", "Ellsworth-A_WGCEP-2002", "Ellsworth-A_Tapered", "Ellsworth-B_UniformBoxcar", "Ellsworth-B_WGCEP-2002", "Ellsworth-B_Tapered", "Hanks & Bakun (2002)_UniformBoxcar", "Hanks & Bakun (2002)_WGCEP-2002", "Hanks & Bakun (2002)_Tapered", "Somerville (2006)_UniformBoxcar", "Somerville (2006)_WGCEP-2002", "Somerville (2006)_Tapered"};

    public static void createHistogramPlots(String masterDirName, String excelSheetName) {
        try {
            String dirName = masterDirName + "/A_FaultSegRecurIntvHistograms_2_1/";
            File file = new File(dirName);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
            for (int k = 3; k < names.length; ++k) {
                EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, 3.5, 36);
                func.setTolerance(func.getDelta());
                func.setName(names[k]);
                funcList.add(func);
            }
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheetName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                String sheetName = wb.getSheetName(i);
                int lastIndex = sheet.getLastRowNum();
                for (int r = 3; r <= lastIndex; ++r) {
                    HSSFRow row = sheet.getRow(r);
                    HSSFCell cell = null;
                    String rupName = "";
                    if (row != null) {
                        cell = row.getCell(0);
                    }
                    if (cell != null) {
                        rupName = cell.getStringCellValue().trim();
                    }
                    if (row == null || cell == null || cell.getCellType() == 3 || rupName.equalsIgnoreCase("")) {
                        r += 4;
                        continue;
                    }
                    double mean = Double.NaN;
                    cell = row.getCell(1);
                    if (cell == null) continue;
                    mean = cell.getNumericCellValue();
                    for (int col = 4; col <= 16; ++col) {
                        double ratio = row.getCell((int)((short)col)).getNumericCellValue() / mean;
                        EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)funcList.get(col - 4);
                        int xIndex = func.getXIndex(ratio);
                        func.add(xIndex, 1.0);
                    }
                }
            }
            int k = 3;
            int i = 0;
            while (k < names.length) {
                ArrayList list = new ArrayList();
                list.add(funcList.get(i));
                CreateHistogramsFromSegSlipRateFile plot = new CreateHistogramsFromSegSlipRateFile(list, X_AXIS_LABEL, Y_AXIS_LABEL);
                GraphWindow graphWindow = new GraphWindow(list, PLOT_LABEL, plot.getPlottingFeatures());
                graphWindow.setTitle(names[k]);
                graphWindow.setVisible(true);
                graphWindow.saveAsPDF(dirName + "/" + names[k] + ".pdf");
                ++k;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createHistogramPlots(String masterDirName, String excelSheetName, String faultName, String segName) {
        try {
            String dirName = masterDirName + "/" + faultName + "_" + segName + "/";
            File file = new File(dirName);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.2, 2.5, 24);
            func.setTolerance(func.getDelta());
            func.setName(faultName + "_" + segName);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheetName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                String sheetName = wb.getSheetName(i);
                if (faultName != null && !faultName.equalsIgnoreCase(sheetName)) continue;
                int lastIndex = sheet.getLastRowNum();
                for (int r = 3; r <= lastIndex; ++r) {
                    HSSFRow row = sheet.getRow(r);
                    HSSFCell cell = null;
                    String rupName = "";
                    if (row != null) {
                        cell = row.getCell(0);
                    }
                    if (cell != null) {
                        rupName = cell.getStringCellValue().trim();
                    }
                    if (segName != null && !rupName.equalsIgnoreCase(segName)) continue;
                    if (row == null || cell == null || cell.getCellType() == 3 || rupName.equalsIgnoreCase("")) {
                        r += 4;
                        continue;
                    }
                    double mean = Double.NaN;
                    cell = row.getCell(1);
                    if (cell == null) continue;
                    mean = cell.getNumericCellValue();
                    for (int col = 4; col <= 16; ++col) {
                        double ratio = row.getCell((int)((short)col)).getNumericCellValue() / mean;
                        int xIndex = func.getXIndex(ratio);
                        func.add(xIndex, 1.0);
                    }
                }
            }
            ArrayList<EvenlyDiscretizedFunc> list = new ArrayList<EvenlyDiscretizedFunc>();
            list.add(func);
            CreateHistogramsFromSegSlipRateFile plot = new CreateHistogramsFromSegSlipRateFile(list, X_AXIS_LABEL, Y_AXIS_LABEL);
            GraphWindow graphWindow = new GraphWindow(list, PLOT_LABEL, plot.getPlottingFeatures());
            graphWindow.setPlotLabel(PLOT_LABEL);
            graphWindow.setTitle(segName);
            graphWindow.setVisible(true);
            graphWindow.saveAsPDF(dirName + "/" + segName + ".pdf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

