/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.CreateHistogramsFromSegRecurIntvFile;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.CreateHistogramsFromSegSlipRateFile;

public class FaultSegmentSelector
extends JFrame
implements ParameterChangeListener,
ActionListener {
    private static final String FAULT_NAME_PARAM_NAME = "Fault Name";
    private static final String SEGMENT_NAME_PARAM_NAME = "Segment Name";
    private JButton okButton = new JButton("OK");
    private StringParameter faultNameParameter;
    private StringParameter segmentNameParameter;
    private HashMap<String, FaultSegmentData> faultSegmentDataList;
    private ConstrainedStringParameterEditor segmentNameParameterEditor;
    private String dirName;
    private String excelSheetName;
    private static final String TITLE = "Select Segment";
    private boolean isDeleteExcelSheet = false;
    private boolean isRecurIntvPlots = true;

    public FaultSegmentSelector(ArrayList aFaultSourceList, String dirName, String excelSheetName, boolean isRecurIntvPlots) {
        this.dirName = dirName;
        this.isRecurIntvPlots = isRecurIntvPlots;
        this.excelSheetName = excelSheetName;
        this.faultSegmentDataList = new HashMap();
        for (int i = 0; i < aFaultSourceList.size(); ++i) {
            FaultSegmentData faultSegmentData = ((A_FaultSegmentedSourceGenerator)aFaultSourceList.get(i)).getFaultSegmentData();
            this.faultSegmentDataList.put(faultSegmentData.getFaultName(), faultSegmentData);
        }
        this.createGUI();
        this.setTitle(TITLE);
        this.setLocationRelativeTo(null);
        this.pack();
        this.show();
    }

    public void deleteExcelSheet(boolean isDelete) {
        this.isDeleteExcelSheet = isDelete;
    }

    private void createGUI() {
        ArrayList<String> faultNames = new ArrayList<String>();
        Iterator<String> it = this.faultSegmentDataList.keySet().iterator();
        while (it.hasNext()) {
            faultNames.add(it.next());
        }
        this.faultNameParameter = new StringParameter(FAULT_NAME_PARAM_NAME, faultNames, (String)faultNames.get(0));
        this.faultNameParameter.addParameterChangeListener(this);
        ConstrainedStringParameterEditor faultNameParamEditor = new ConstrainedStringParameterEditor(this.faultNameParameter);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)faultNameParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setSegmentNames((String)this.faultNameParameter.getValue());
        container.add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(this);
    }

    private void setSegmentNames(String faultName) {
        if (this.segmentNameParameterEditor != null) {
            this.getContentPane().remove(this.segmentNameParameterEditor);
        }
        FaultSegmentData faultSegmentData = this.faultSegmentDataList.get(faultName);
        ArrayList<String> segNames = new ArrayList<String>();
        for (int i = 0; i < faultSegmentData.getNumSegments(); ++i) {
            segNames.add(faultSegmentData.getSegmentName(i));
        }
        this.segmentNameParameter = new StringParameter(SEGMENT_NAME_PARAM_NAME, segNames, (String)segNames.get(0));
        this.segmentNameParameterEditor = new ConstrainedStringParameterEditor(this.segmentNameParameter);
        this.getContentPane().add((Component)this.segmentNameParameterEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
        this.repaint();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.setSegmentNames((String)this.faultNameParameter.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String faultName = (String)this.faultNameParameter.getValue();
        String segName = (String)this.segmentNameParameter.getValue();
        if (this.isRecurIntvPlots) {
            CreateHistogramsFromSegRecurIntvFile.createHistogramPlots(this.dirName, this.excelSheetName, faultName, segName);
        } else {
            CreateHistogramsFromSegSlipRateFile.createHistogramPlots(this.dirName, this.excelSheetName, faultName, segName);
        }
        if (this.isDeleteExcelSheet) {
            new File(this.excelSheetName).delete();
        }
        this.dispose();
    }
}

