/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.text.DecimalFormat;
import javax.swing.table.AbstractTableModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;

class RuptureTableModel
extends AbstractTableModel {
    public static final String[] columnNames = new String[]{"Rup Index", "Area (sq km)", "Mean Mag", "Final Rate", "A Priori Rate", "Moment Rate", "Rup Prob", "Rup Gain", "Short Name", "Long Name"};
    private static final DecimalFormat AREA_LENGTH_FORMAT = new DecimalFormat("0.#");
    private static final DecimalFormat MAG_FORMAT = new DecimalFormat("0.00");
    private static final DecimalFormat RATE_FORMAT = new DecimalFormat("0.000E0");
    private static final DecimalFormat MOMENT_FORMAT = new DecimalFormat("0.000E0");
    private A_FaultSegmentedSourceGenerator aFaultSegmentedSource;

    public RuptureTableModel() {
        this(null);
    }

    public RuptureTableModel(A_FaultSegmentedSourceGenerator aFaultSegmentedSource) {
        this.setFaultSegmentedSource(aFaultSegmentedSource);
    }

    public void setFaultSegmentedSource(A_FaultSegmentedSourceGenerator aFaultSegmentedSource) {
        this.aFaultSegmentedSource = aFaultSegmentedSource;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return columnNames[index];
    }

    @Override
    public int getRowCount() {
        if (this.aFaultSegmentedSource == null) {
            return 0;
        }
        return this.aFaultSegmentedSource.getNumRupSources() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.aFaultSegmentedSource == null) {
            return "";
        }
        if (rowIndex == this.aFaultSegmentedSource.getNumRupSources()) {
            return this.getTotal(columnIndex);
        }
        switch (columnIndex) {
            case 0: {
                return "" + (rowIndex + 1);
            }
            case 1: {
                return AREA_LENGTH_FORMAT.format(this.aFaultSegmentedSource.getRupArea(rowIndex) / 1000000.0);
            }
            case 2: {
                return MAG_FORMAT.format(this.aFaultSegmentedSource.getRupMeanMag(rowIndex));
            }
            case 3: {
                return RATE_FORMAT.format(this.aFaultSegmentedSource.getRupRate(rowIndex));
            }
            case 4: {
                return RATE_FORMAT.format(this.aFaultSegmentedSource.getAPrioriRupRate(rowIndex));
            }
            case 5: {
                return MOMENT_FORMAT.format(this.aFaultSegmentedSource.getRupMoRate(rowIndex));
            }
            case 6: {
                return MOMENT_FORMAT.format(this.aFaultSegmentedSource.getRupSourceProb(rowIndex));
            }
            case 7: {
                return MAG_FORMAT.format(this.aFaultSegmentedSource.getRupSourcProbGain(rowIndex));
            }
            case 8: {
                return this.aFaultSegmentedSource.getShortRupName(rowIndex);
            }
            case 9: {
                return this.aFaultSegmentedSource.getLongRupName(rowIndex);
            }
        }
        return "";
    }

    private String getTotal(int colIndex) {
        double totalRate = 0.0;
        switch (colIndex) {
            case 0: {
                return "Total";
            }
            case 3: {
                for (int i = 0; i < this.aFaultSegmentedSource.getNumRupSources(); ++i) {
                    totalRate += this.aFaultSegmentedSource.getRupRate(i);
                }
                return RATE_FORMAT.format(totalRate);
            }
            case 4: {
                for (int i = 0; i < this.aFaultSegmentedSource.getNumRupSources(); ++i) {
                    totalRate += this.aFaultSegmentedSource.getAPrioriRupRate(i);
                }
                return RATE_FORMAT.format(totalRate);
            }
            case 5: {
                if (this.aFaultSegmentedSource == null) break;
                return MOMENT_FORMAT.format(this.aFaultSegmentedSource.getTotalMoRateFromRups());
            }
        }
        return "";
    }
}

