/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.EventRates;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.SegRateConstraint;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.FaultSectionTableModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.SegmentDataTableModel;

public class SegmentDataPanel
extends JPanel
implements ActionListener {
    private SegmentDataTableModel segmentTableModel = new SegmentDataTableModel();
    private FaultSectionTableModel faultSectionTableModel = new FaultSectionTableModel();
    private static final String MSG_ASEIS_REDUCES_AREA = "IMPORTANT NOTE - Section Aseismicity Factors have been applied as a reduction of area (as requested) in the table above; this will also influence the segment slip rates for any segments composed of more than one section (because the slip rates are weight-averaged according to section areas)";
    private static final String MSG_ASEIS_REDUCES_SLIPRATE = "IMPORTANT NOTE - Section Aseismicity Factors have been applied as a reduction of slip rate (as requested); keep this in mind when interpreting the segment slip rates (which for any segments composed of more than one section are a weight average by section areas)";
    private JSplitPane rightSplitPane = new JSplitPane(0);
    private JTextArea magAreasTextArea = new JTextArea();
    private JButton slipRateButton = new JButton("Plot Segment Slip Rates");
    private JButton slipRateAlongFaultButton = new JButton("Plot Slip Rate Along Fault");
    private JButton slipRateRatioButton = new JButton("Plot Normalized Slip-Rate Residuals - (Final_SR-Data_SR)/SR_Sigma");
    private JButton eventRateButton = new JButton("Plot Segment Event Rates");
    private JButton eventRateRatioButton = new JButton("Plot Normalized Event Rate Residuals - (Final_ER-Data_ER)/ER_Sigma");
    private static final DecimalFormat MAG_FORMAT = new DecimalFormat("0.00");
    private static final DecimalFormat SLIP_FORMAT = new DecimalFormat("0.000");
    private static final DecimalFormat EVENT_RATE_FORMAT = new DecimalFormat("0.00E0");
    private ArrayList<ArbitrarilyDiscretizedFunc> slipRatesList;
    private ArrayList<ArbitrarilyDiscretizedFunc> slipRatesAlongFaultList;
    private ArrayList<ArbitrarilyDiscretizedFunc> eventRatesList;
    private ArrayList<ArbitrarilyDiscretizedFunc> eventRatesRatioList;
    private ArrayList<ArbitrarilyDiscretizedFunc> slipRatesRatioList;
    private static final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 12.0f, Color.RED);
    private static final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK);
    private static final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.GREEN);
    private static final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 12.0f, Color.BLACK);
    private static final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.RED);
    private static final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.GRAY);
    private String xAxisLabel;
    private String yAxisLabel;
    private ArrayList<PlotCurveCharacterstics> plottingFeatures;
    private ArrayList<PlotCurveCharacterstics> slipRatesAlongFaultPlottingFeatures;
    private ArrayList<PlotCurveCharacterstics> segmentedSlipRatePlottingFeatures;
    private ArrayList<PlotCurveCharacterstics> unSegmentedSlipRatePlottingFeatures;
    private ArrayList<PlotCurveCharacterstics> eventRatesPlottingFeatures;
    private ArrayList<PlotCurveCharacterstics> eventRateRatioPlotFeatures;
    private ArrayList<PlotCurveCharacterstics> slipRateRatioPlotFeatures;
    private ArrayList<ArbitrarilyDiscretizedFunc> plottingFuncList;
    private boolean yLog = true;
    private ArrayList<EventRates> aFaultsFetcherEventRatesList;
    private String faultName;

    public SegmentDataPanel() {
        this.setLayout(new GridBagLayout());
        this.createGUI();
        this.slipRateButton.addActionListener(this);
        this.slipRateAlongFaultButton.addActionListener(this);
        this.eventRateButton.addActionListener(this);
        this.eventRateRatioButton.addActionListener(this);
        this.slipRateRatioButton.addActionListener(this);
        this.makePlottingFeaturesList();
    }

    public void setEventRatesList(ArrayList<EventRates> aFaultsFetcherEventRatesList) {
        this.aFaultsFetcherEventRatesList = aFaultsFetcherEventRatesList;
    }

    private void makePlottingFeaturesList() {
        this.segmentedSlipRatePlottingFeatures = new ArrayList();
        this.segmentedSlipRatePlottingFeatures.add(PLOT_CHAR1);
        this.segmentedSlipRatePlottingFeatures.add(PLOT_CHAR1);
        this.segmentedSlipRatePlottingFeatures.add(PLOT_CHAR1);
        this.segmentedSlipRatePlottingFeatures.add(PLOT_CHAR2);
        this.segmentedSlipRatePlottingFeatures.add(PLOT_CHAR3);
        this.unSegmentedSlipRatePlottingFeatures = new ArrayList();
        this.unSegmentedSlipRatePlottingFeatures.add(PLOT_CHAR1);
        this.unSegmentedSlipRatePlottingFeatures.add(PLOT_CHAR1);
        this.unSegmentedSlipRatePlottingFeatures.add(PLOT_CHAR1);
        this.unSegmentedSlipRatePlottingFeatures.add(PLOT_CHAR3);
        this.eventRatesPlottingFeatures = new ArrayList();
        this.eventRatesPlottingFeatures.add(PLOT_CHAR1);
        this.eventRatesPlottingFeatures.add(PLOT_CHAR1);
        this.eventRatesPlottingFeatures.add(PLOT_CHAR2);
        this.eventRatesPlottingFeatures.add(PLOT_CHAR3);
        this.eventRateRatioPlotFeatures = new ArrayList();
        this.eventRateRatioPlotFeatures.add(PLOT_CHAR1);
        this.slipRateRatioPlotFeatures = new ArrayList();
        this.slipRateRatioPlotFeatures.add(PLOT_CHAR1);
    }

    private void createGUI() {
        this.magAreasTextArea.setEditable(false);
        this.magAreasTextArea.setLineWrap(true);
        this.magAreasTextArea.setWrapStyleWord(true);
        JTable sectionDataTable = new JTable(this.faultSectionTableModel);
        sectionDataTable.setColumnSelectionAllowed(true);
        JSplitPane sectionDataSplitPane = new JSplitPane(0);
        sectionDataSplitPane.add((Component)new JScrollPane(sectionDataTable), "bottom");
        sectionDataSplitPane.add((Component)new JScrollPane(this.magAreasTextArea), "top");
        JTable segmentTable = new JTable(this.segmentTableModel);
        segmentTable.setColumnSelectionAllowed(true);
        this.rightSplitPane.add((Component)new JScrollPane(segmentTable), "top");
        this.rightSplitPane.add((Component)sectionDataSplitPane, "bottom");
        this.rightSplitPane.setDividerLocation(150);
        sectionDataSplitPane.setDividerLocation(200);
        this.add((Component)this.rightSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slipRateButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slipRateAlongFaultButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slipRateRatioButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.eventRateButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.eventRateRatioButton, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setFaultSegmentData(A_FaultSegmentedSourceGenerator segmentedSource, UnsegmentedSource unsegmentedSource, boolean isAseisReducesArea, ArrayList magAreaRelationships) {
        FaultSegmentData faultSegmentData = segmentedSource != null ? segmentedSource.getFaultSegmentData() : unsegmentedSource.getFaultSegmentData();
        this.faultName = faultSegmentData.getFaultName();
        this.setMagAndSlipsString(faultSegmentData, isAseisReducesArea, magAreaRelationships, segmentedSource, unsegmentedSource);
        this.segmentTableModel.setFaultData(faultSegmentData, segmentedSource, unsegmentedSource);
        this.segmentTableModel.fireTableDataChanged();
        if (faultSegmentData != null) {
            this.faultSectionTableModel.setFaultSectionData(faultSegmentData.getPrefFaultSectionDataList());
        } else {
            this.faultSectionTableModel.setFaultSectionData(null);
        }
        this.faultSectionTableModel.fireTableDataChanged();
        if (segmentedSource == null) {
            this.eventRateButton.setVisible(false);
            this.slipRateButton.setVisible(true);
            this.slipRateAlongFaultButton.setVisible(true);
            this.slipRateRatioButton.setVisible(true);
            this.eventRateRatioButton.setVisible(false);
            this.generateSlipRateFuncList(null, unsegmentedSource, faultSegmentData);
            this.generateSlipRateRatioFuncList(null, unsegmentedSource);
            this.generateSlipRateAlongFaultFuncList(null, unsegmentedSource);
        } else {
            this.eventRateButton.setVisible(true);
            this.slipRateButton.setVisible(true);
            this.slipRateAlongFaultButton.setVisible(false);
            this.slipRateRatioButton.setVisible(true);
            this.eventRateRatioButton.setVisible(true);
            this.generateSlipRateFuncList(segmentedSource, null, faultSegmentData);
            this.generateSlipRateRatioFuncList(segmentedSource, null);
            this.generateEventRateFuncList(segmentedSource, faultSegmentData);
            this.generateEventRateRatioFuncList(segmentedSource);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.slipRateButton) {
            this.xAxisLabel = "Segment Index";
            this.yAxisLabel = "Slip Rate (mm/yr)";
            this.plottingFeatures = this.slipRatesList.size() == 5 ? this.segmentedSlipRatePlottingFeatures : this.unSegmentedSlipRatePlottingFeatures;
            this.plottingFuncList = this.slipRatesList;
            this.yLog = true;
        } else if (src == this.slipRateAlongFaultButton) {
            this.xAxisLabel = "Fault Distance";
            this.yAxisLabel = "Slip Rate (mm/yr)";
            this.plottingFeatures = this.slipRatesAlongFaultPlottingFeatures;
            this.plottingFuncList = this.slipRatesAlongFaultList;
            this.yLog = false;
        } else if (src == this.eventRateButton) {
            this.xAxisLabel = "Segment Index";
            this.yAxisLabel = "Event Rates (1/years)";
            this.plottingFeatures = this.eventRatesPlottingFeatures;
            this.plottingFuncList = this.eventRatesList;
            this.yLog = true;
        } else if (src == this.eventRateRatioButton) {
            this.xAxisLabel = "Segment Index";
            this.yAxisLabel = " Normalized Event Rate Residuals - (Final_ER-Data_ER)/ER_Sigma";
            this.plottingFeatures = this.eventRateRatioPlotFeatures;
            this.plottingFuncList = this.eventRatesRatioList;
            this.yLog = false;
        } else if (src == this.slipRateRatioButton) {
            this.xAxisLabel = "Segment Index";
            this.yAxisLabel = " Normalized Slip-Rate Residuals - (Final_SR-Data_SR)/SR_Sigma";
            this.plottingFeatures = this.slipRateRatioPlotFeatures;
            this.plottingFuncList = this.slipRatesRatioList;
            this.yLog = false;
        }
        GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), this.faultName, this.getCurveFunctionList());
        graphWindow.setVisible(true);
    }

    private void generateSlipRateRatioFuncList(A_FaultSegmentedSourceGenerator segmentedSource, UnsegmentedSource unsegmentedSource) {
        ArbitrarilyDiscretizedFunc slipRateRatioFunc = new ArbitrarilyDiscretizedFunc();
        slipRateRatioFunc.setName("Normalized Slip-Rate Residuals - (Final_SR-Data_SR)/SR_Sigma");
        double[] normModResids = segmentedSource != null ? segmentedSource.getNormModSlipRateResids() : unsegmentedSource.getNormModSlipRateResids();
        for (int seg = 0; seg < normModResids.length; ++seg) {
            slipRateRatioFunc.set((double)seg + 1.0, normModResids[seg]);
        }
        this.slipRatesRatioList = new ArrayList();
        this.slipRatesRatioList.add(slipRateRatioFunc);
    }

    private void generateSlipRateFuncList(A_FaultSegmentedSourceGenerator segmentedSource, UnsegmentedSource unsegmentedSource, FaultSegmentData faultSegmentData) {
        ArbitrarilyDiscretizedFunc origSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        origSlipRateFunc.setName("Orig Slip Rate");
        ArbitrarilyDiscretizedFunc origMinSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        origMinSlipRateFunc.setName("Min Orig Slip Rate");
        ArbitrarilyDiscretizedFunc origMaxSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        origMaxSlipRateFunc.setName("Max Orig Slip Rate");
        ArbitrarilyDiscretizedFunc modSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        modSlipRateFunc.setName("Modified Slip Rate");
        ArbitrarilyDiscretizedFunc modMinSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        modMinSlipRateFunc.setName("Min Modified Slip Rate");
        ArbitrarilyDiscretizedFunc modMaxSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        modMaxSlipRateFunc.setName("Max Modified Slip Rate");
        ArbitrarilyDiscretizedFunc finalSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        finalSlipRateFunc.setName("Final Slip Rate");
        ArbitrarilyDiscretizedFunc aPrioriSlipRateFunc = new ArbitrarilyDiscretizedFunc();
        aPrioriSlipRateFunc.setName("A_Priori Slip Rate");
        double fraction = segmentedSource != null ? 1.0 - segmentedSource.getMoRateReduction() : 1.0 - unsegmentedSource.getMoRateReduction();
        for (int seg = 0; seg < faultSegmentData.getNumSegments(); ++seg) {
            double finalSlipRate;
            double origSlipRate = faultSegmentData.getSegmentSlipRate(seg) * 1000.0;
            double origSlipRateStdDev = faultSegmentData.getSegSlipRateStdDev(seg) * 1000.0;
            origSlipRateFunc.set((double)seg + 1.0, origSlipRate);
            origMinSlipRateFunc.set((double)seg + 1.0, origSlipRate - 2.0 * origSlipRateStdDev);
            origMaxSlipRateFunc.set((double)seg + 1.0, origSlipRate + 2.0 * origSlipRateStdDev);
            modSlipRateFunc.set((double)seg + 1.0, origSlipRate * fraction);
            modMinSlipRateFunc.set((double)seg + 1.0, (origSlipRate - 2.0 * origSlipRateStdDev) * fraction);
            modMaxSlipRateFunc.set((double)seg + 1.0, (origSlipRate + 2.0 * origSlipRateStdDev) * fraction);
            if (segmentedSource != null) {
                finalSlipRate = segmentedSource.getFinalSegSlipRate(seg);
                aPrioriSlipRateFunc.set((double)seg + 1.0, segmentedSource.get_aPrioriSegSlipRate(seg) * 1000.0);
            } else {
                finalSlipRate = unsegmentedSource.getFinalAveSegSlipRate(seg);
            }
            finalSlipRateFunc.set((double)seg + 1.0, finalSlipRate * 1000.0);
        }
        this.slipRatesList = new ArrayList();
        this.slipRatesList.add(modSlipRateFunc);
        this.slipRatesList.add(modMinSlipRateFunc);
        this.slipRatesList.add(modMaxSlipRateFunc);
        if (segmentedSource != null) {
            this.slipRatesList.add(aPrioriSlipRateFunc);
        }
        this.slipRatesList.add(finalSlipRateFunc);
    }

    private void generateSlipRateAlongFaultFuncList(A_FaultSegmentedSourceGenerator segmentedSource, UnsegmentedSource unsegmentedSource) {
        this.slipRatesAlongFaultList = new ArrayList();
        this.slipRatesAlongFaultPlottingFeatures = new ArrayList();
        this.slipRatesAlongFaultList.add(unsegmentedSource.getOrigSlipRateAlongFault());
        this.slipRatesAlongFaultPlottingFeatures.add(PLOT_CHAR5);
        this.slipRatesAlongFaultList.add(unsegmentedSource.getFinalSlipRateAlongFault());
        this.slipRatesAlongFaultPlottingFeatures.add(PLOT_CHAR2);
        ArrayList<ArbitrarilyDiscretizedFunc> magBasedFuncs = unsegmentedSource.getMagBasedFinalSlipRateListAlongFault();
        this.slipRatesAlongFaultList.addAll(magBasedFuncs);
        for (int i = 0; i < magBasedFuncs.size(); ++i) {
            this.slipRatesAlongFaultPlottingFeatures.add(PLOT_CHAR6);
        }
    }

    private void generateEventRateFuncList(A_FaultSegmentedSourceGenerator segmentedSource, FaultSegmentData faultSegmentData) {
        ArbitrarilyDiscretizedFunc origEventRateFunc = new ArbitrarilyDiscretizedFunc();
        origEventRateFunc.setName("Data Event Rate");
        ArbitrarilyDiscretizedFunc minEventRateFunc = new ArbitrarilyDiscretizedFunc();
        minEventRateFunc.setName("Min Event Rate");
        ArbitrarilyDiscretizedFunc maxEventRateFunc = new ArbitrarilyDiscretizedFunc();
        maxEventRateFunc.setName("Max Event Rate");
        ArbitrarilyDiscretizedFunc finalEventRateFunc = new ArbitrarilyDiscretizedFunc();
        finalEventRateFunc.setName("Final (Post-Inversion) Event Rate");
        ArbitrarilyDiscretizedFunc predEventRateFunc = new ArbitrarilyDiscretizedFunc();
        predEventRateFunc.setName("Predicted Event Rate from Apriori Rupture Rates");
        double smallVal = 0.1;
        int index = 0;
        for (int seg = 0; seg < faultSegmentData.getNumSegments(); ++seg) {
            index = seg + 1;
            ArrayList<SegRateConstraint> segRateConstraints = faultSegmentData.getSegRateConstraints(seg);
            for (int i = 0; i < segRateConstraints.size(); ++i) {
                SegRateConstraint segRateconstraint = segRateConstraints.get(i);
                origEventRateFunc.set((double)index + (double)i * smallVal, segRateconstraint.getMean());
                minEventRateFunc.set((double)index + (double)i * smallVal, segRateconstraint.getLower95Conf());
                maxEventRateFunc.set((double)index + (double)i * smallVal, segRateconstraint.getUpper95Conf());
            }
            double finalEventRate = segmentedSource.getFinalSegmentRate(seg);
            double predEventRate = segmentedSource.getSegRateFromAprioriRates(seg);
            predEventRateFunc.set((double)index, predEventRate);
            finalEventRateFunc.set((double)index, finalEventRate);
        }
        this.eventRatesList = new ArrayList();
        this.eventRatesList.add(minEventRateFunc);
        this.eventRatesList.add(maxEventRateFunc);
        this.eventRatesList.add(predEventRateFunc);
        this.eventRatesList.add(finalEventRateFunc);
    }

    private void generateEventRateRatioFuncList(A_FaultSegmentedSourceGenerator segmentedSource) {
        ArbitrarilyDiscretizedFunc eventRateRatioFunc = new ArbitrarilyDiscretizedFunc();
        eventRateRatioFunc.setName("Normalized Event Rate Residuals - (Final_ER-Data_ER)/ER_Sigma");
        double[] normResids = segmentedSource.getNormDataER_Resids();
        for (int seg = 0; seg < normResids.length; ++seg) {
            if (Double.isNaN(normResids[seg])) continue;
            eventRateRatioFunc.set((double)seg + 1.0, normResids[seg]);
        }
        this.eventRatesRatioList = new ArrayList();
        this.eventRatesRatioList.add(eventRateRatioFunc);
    }

    private void setMagAndSlipsString(FaultSegmentData segmetedFaultData, boolean isAseisReducesArea, ArrayList magAreaRelationships, A_FaultSegmentedSourceGenerator segmentedSource, UnsegmentedSource unsegmentedSource) {
        this.magAreasTextArea.setText("");
        if (segmetedFaultData == null) {
            return;
        }
        int numSegs = segmetedFaultData.getNumSegments();
        Object summaryString = "MAGS & AVE SLIPS IMPLIED BY M(A) RELATIONS\n------------------------------------------\n\n";
        for (int i = 0; i < magAreaRelationships.size(); ++i) {
            MagAreaRelationship magAreaRel = (MagAreaRelationship)magAreaRelationships.get(i);
            summaryString = (String)summaryString + "Segment  Mag       Ave-slip (m) for  (" + magAreaRel.getName() + ")\n";
            for (int j = 0; j < numSegs; ++j) {
                double mag = magAreaRel.getMedianMag(segmetedFaultData.getSegmentArea(j) / 1000000.0);
                double moment = MagUtils.magToMoment(mag);
                summaryString = (String)summaryString + (j + 1) + "              " + MAG_FORMAT.format(mag) + "      " + SLIP_FORMAT.format(FaultMomentCalc.getSlip(segmetedFaultData.getSegmentArea(j), moment)) + "\n";
            }
            double mag = magAreaRel.getMedianMag(segmetedFaultData.getTotalArea() / 1000000.0);
            double moment = MagUtils.magToMoment(mag);
            summaryString = (String)summaryString + "All            " + MAG_FORMAT.format(mag) + "      " + SLIP_FORMAT.format(FaultMomentCalc.getSlip(segmetedFaultData.getTotalArea(), moment)) + "\n\n";
        }
        String text = MSG_ASEIS_REDUCES_SLIPRATE;
        if (isAseisReducesArea) {
            text = MSG_ASEIS_REDUCES_AREA;
        }
        Object predError = "";
        if (segmentedSource != null) {
            predError = "Gen. Pred. Error = " + (float)segmentedSource.getGeneralizedPredictionError() + "\n";
            predError = (String)predError + "Slip Rate Error = " + (float)segmentedSource.getNormModSlipRateError() + "\n";
            predError = (String)predError + "Event Rate Error = " + (float)segmentedSource.getNormDataER_Error() + "\n";
            predError = (String)predError + "Non-norm A-Priori Model Error = " + (float)segmentedSource.getNonNormA_PrioriModelError() + "\n\n";
        }
        String rateConstraints = segmentedSource != null ? this.getRateConstraints(segmetedFaultData) : this.getUnsegmentedEventRates();
        this.magAreasTextArea.setText((String)predError + this.getLegend() + "\n\n" + text + "\n\n" + rateConstraints + "\n\n" + (String)summaryString);
        this.magAreasTextArea.setCaretPosition(0);
    }

    private String getUnsegmentedEventRates() {
        Object rateConstraintStr = "Event Rate Constraints for the Unsegmented Model \n---------------------------------------\n\n";
        rateConstraintStr = (String)rateConstraintStr + "Latitude\tLongitude\tRate(Obs)\tSigma(Obs)\t-95%\t95%\tPredRate\tNormResid\tPredObsRate\tNormResid\tSitename\n";
        int numEvents = this.aFaultsFetcherEventRatesList.size();
        for (int eventIndex = 0; eventIndex < numEvents; ++eventIndex) {
            EventRates eventRate = this.aFaultsFetcherEventRatesList.get(eventIndex);
            rateConstraintStr = (String)rateConstraintStr + (float)eventRate.getLatitude() + "\t" + (float)eventRate.getLongitude() + "\t" + EVENT_RATE_FORMAT.format(eventRate.getObsEventRate()) + "\t" + EVENT_RATE_FORMAT.format(eventRate.getObsSigma()) + "\t" + EVENT_RATE_FORMAT.format(eventRate.getLower95Conf()) + "\t" + EVENT_RATE_FORMAT.format(eventRate.getUpper95Conf()) + "\t" + EVENT_RATE_FORMAT.format(eventRate.getPredictedRate()) + "\t" + SLIP_FORMAT.format((eventRate.getPredictedRate() - eventRate.getObsEventRate()) / eventRate.getObsSigma()) + "\t" + EVENT_RATE_FORMAT.format(eventRate.getPredictedObsRate()) + "\t" + SLIP_FORMAT.format((eventRate.getPredictedObsRate() - eventRate.getObsEventRate()) / eventRate.getObsSigma()) + "\t" + eventRate.getSiteName() + "\n";
        }
        return rateConstraintStr;
    }

    private String getRateConstraints(FaultSegmentData segmetedFaultData) {
        Object rateConstraintStr = "Rate Constraints for the Segments \n---------------------------------\n\n";
        rateConstraintStr = (String)rateConstraintStr + "Seg\tRate\t\tSigma\t   -95%\t\t95%\n";
        int numSegs = segmetedFaultData.getNumSegments();
        for (int segIndex = 0; segIndex < numSegs; ++segIndex) {
            ArrayList<SegRateConstraint> segConstraintList = segmetedFaultData.getSegRateConstraints(segIndex);
            for (int i = 0; i < segConstraintList.size(); ++i) {
                rateConstraintStr = (String)rateConstraintStr + (segIndex + 1) + "\t" + (float)segConstraintList.get(i).getMean() + "\t\t" + (float)segConstraintList.get(i).getStdDevOfMean() + "\t   " + (float)segConstraintList.get(i).getLower95Conf() + "\t" + (float)segConstraintList.get(i).getUpper95Conf() + "\n";
            }
        }
        return rateConstraintStr;
    }

    private String getLegend() {
        Object legend = "Legend:\n";
        legend = (String)legend + "-------\n";
        legend = (String)legend + "Orig SR \t- segment slip rate (mm/yr)\n";
        legend = (String)legend + "\t (possibly reduced by aseis factor, but not by fract ABC removed)\n";
        legend = (String)legend + "SR Sigma\t- standard deviation of Orig SR\n";
        legend = (String)legend + "Final SR\t- Post-inversion segment slip rate\n";
        legend = (String)legend + "\t (reduced by aseis factor & fract ABC removed)\n";
        legend = (String)legend + "Area\t- sq km\n";
        legend = (String)legend + "\t (possibly reduced by aseis factor, but not by fract ABC removed)\n";
        legend = (String)legend + "Length\t- km\n";
        legend = (String)legend + "Mo Rate\t- Moment Rate (Newton-Meters/yr)\n";
        legend = (String)legend + "\t (reduced by aseis factor, but not by fract ABC removed)\n";
        legend = (String)legend + "Data ER\t- Mean Event Rate for segment (1/years) from Parsons/Dawson table\n";
        legend = (String)legend + "ER Sigma\t- Standard deviation of Mean Event Rate for segment (1/years) from Parsons/Dawson table\n";
        legend = (String)legend + "Pred ER\t- Segment mean Event Rate predicted from A Priori Rates\n";
        legend = (String)legend + "Final ER\t- Final (post inversion) segment mean Event Rate\n";
        return legend;
    }

    public ArrayList getCurveFunctionList() {
        return this.plottingFuncList;
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return this.yLog;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public ArrayList getPlottingFeatures() {
        return this.plottingFeatures;
    }

    public boolean isCustomAxis() {
        return false;
    }

    public double getUserMinX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMinY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }
}

