/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.geo.CubedGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultCubeAssociations;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_FaultPolygonBuilder;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;

public class NSHM23_FaultCubeAssociations
implements FaultCubeAssociations,
ArchivableModule {
    private static final boolean D = false;
    private List<? extends FaultSection> subSects;
    private CubedGriddedRegion cgr;
    private GriddedRegion griddedRegion;
    private double maxFaultNuclDist;
    private int[][] sectsAtCubes;
    private double[][] sectOrigDistWeightsAtCubes;
    private double[][] sectScaledDistWeightsAtCubes;
    private double[] totOrigDistWtsAtCubesForSectArray;
    private double[] totScaledDistWtsAtCubesForSectArray;
    private double[] fractSectsInRegion;
    private FaultCubeAssociations.CubeToGridNodeAggregator cubeGridAggregator;

    public NSHM23_FaultCubeAssociations(FaultSystemRupSet rupSet, CubedGriddedRegion cgr, double maxFaultNuclDist) {
        this(rupSet.getFaultSectionDataList(), cgr, maxFaultNuclDist);
    }

    public NSHM23_FaultCubeAssociations(List<? extends FaultSection> subSects, CubedGriddedRegion cgr, double maxFaultNuclDist) {
        NSHM23_FaultCubeAssociations.validateSubSects(subSects);
        this.subSects = subSects;
        this.cgr = cgr;
        this.maxFaultNuclDist = maxFaultNuclDist;
        this.griddedRegion = cgr.getGriddedRegion();
        this.cacheCubeSectMappings();
        this.cubeGridAggregator = new FaultCubeAssociations.CubeToGridNodeAggregator(this);
    }

    private static void validateSubSects(List<? extends FaultSection> subSects) {
        Preconditions.checkState((!subSects.isEmpty() ? 1 : 0) != 0, (Object)"No subsections supplied");
        for (int s = 0; s < subSects.size(); ++s) {
            Preconditions.checkState((subSects.get(s).getSectionId() == s ? 1 : 0) != 0, (Object)"Subsections not in order or not 0-indexed");
        }
    }

    @Override
    public CubedGriddedRegion getCubedGriddedRegion() {
        return this.cgr;
    }

    @Override
    public int[] getSectsAtCube(int cubeIndex) {
        return this.sectsAtCubes[cubeIndex];
    }

    @Override
    public double[] getScaledSectDistWeightsAtCube(int cubeIndex) {
        return this.sectScaledDistWeightsAtCubes[cubeIndex];
    }

    @Override
    public double getTotalScaledDistWtAtCubesForSect(int sectIndex) {
        return this.totScaledDistWtsAtCubesForSectArray[sectIndex];
    }

    @Override
    public double[] getOrigSectDistWeightsAtCube(int cubeIndex) {
        return this.sectOrigDistWeightsAtCubes[cubeIndex];
    }

    @Override
    public double getTotalOrigDistWtAtCubesForSect(int sectIndex) {
        return this.totOrigDistWtsAtCubesForSectArray[sectIndex];
    }

    @Override
    public double getSectionFractInRegion(int sectIndex) {
        return this.fractSectsInRegion[sectIndex];
    }

    @Override
    public String getName() {
        return "NSHM23 Fault Cube Associations";
    }

    @Override
    public Map<Integer, Double> getNodeExtents() {
        return this.cubeGridAggregator.getNodeExtents();
    }

    @Override
    public double getNodeFraction(int nodeIdx) {
        return this.cubeGridAggregator.getNodeFraction(nodeIdx);
    }

    @Override
    public Map<Integer, Double> getScaledNodeFractions(int sectIdx) {
        return this.cubeGridAggregator.getScaledNodeFractions(sectIdx);
    }

    @Override
    public Map<Integer, Double> getScaledSectFracsOnNode(int nodeIdx) {
        return this.cubeGridAggregator.getScaledSectFracsOnNode(nodeIdx);
    }

    @Override
    public Map<Integer, Double> getNodeFractions(int sectIdx) {
        return this.cubeGridAggregator.getNodeFractions(sectIdx);
    }

    @Override
    public Map<Integer, Double> getSectionFracsOnNode(int nodeIdx) {
        return this.cubeGridAggregator.getSectionFracsOnNode(nodeIdx);
    }

    @Override
    public GriddedRegion getRegion() {
        return this.griddedRegion;
    }

    @Override
    public Collection<Integer> sectIndices() {
        return this.cubeGridAggregator.sectIndices();
    }

    private void cacheCubeSectMappings() {
        ExecutorService exec = Executors.newFixedThreadPool(FaultSysTools.defaultNumThreads());
        Stopwatch watch = Stopwatch.createStarted();
        ArrayList<Future<SectCubeMapper>> futures = new ArrayList<Future<SectCubeMapper>>(this.subSects.size());
        for (int s = 0; s < this.subSects.size(); ++s) {
            futures.add(exec.submit(new SectCubeMapper(s)));
        }
        System.out.println("Waiting on " + futures.size() + " fault section to cube mapping futures");
        this.sectsAtCubes = new int[this.cgr.getNumCubes()][];
        double[][] sectDistsAtCubes = new double[this.cgr.getNumCubes()][];
        this.totOrigDistWtsAtCubesForSectArray = new double[this.subSects.size()];
        this.totScaledDistWtsAtCubesForSectArray = new double[this.subSects.size()];
        this.fractSectsInRegion = new double[this.subSects.size()];
        for (Future future : futures) {
            try {
                SectCubeMapper mapper = (SectCubeMapper)future.get();
                if (mapper == null) continue;
                for (int mappedCube : mapper.mappedCubeDistances.keySet()) {
                    float distance = mapper.mappedCubeDistances.get(mappedCube).floatValue();
                    if (this.sectsAtCubes[mappedCube] == null) {
                        this.sectsAtCubes[mappedCube] = new int[]{mapper.sectIndex};
                        sectDistsAtCubes[mappedCube] = new double[]{distance};
                        continue;
                    }
                    int prevLen = this.sectsAtCubes[mappedCube].length;
                    this.sectsAtCubes[mappedCube] = Arrays.copyOf(this.sectsAtCubes[mappedCube], prevLen + 1);
                    sectDistsAtCubes[mappedCube] = Arrays.copyOf(sectDistsAtCubes[mappedCube], prevLen + 1);
                    this.sectsAtCubes[mappedCube][prevLen] = mapper.sectIndex;
                    sectDistsAtCubes[mappedCube][prevLen] = distance;
                }
                this.totScaledDistWtsAtCubesForSectArray[mapper.sectIndex] = mapper.totWeight;
                this.totOrigDistWtsAtCubesForSectArray[mapper.sectIndex] = mapper.totWeight;
                this.fractSectsInRegion[mapper.sectIndex] = mapper.fractInRegion;
            }
            catch (InterruptedException | ExecutionException e) {
                exec.shutdown();
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        exec.shutdown();
        watch.stop();
        System.out.println("Took " + (float)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0f + " secs to map sections to cubes");
        watch.reset().start();
        this.sectOrigDistWeightsAtCubes = new double[this.cgr.getNumCubes()][];
        this.sectScaledDistWeightsAtCubes = new double[this.cgr.getNumCubes()][];
        for (int c = 0; c < this.cgr.getNumCubes(); ++c) {
            double[] scaledWeights;
            int[] nArray = this.sectsAtCubes[c];
            if (nArray == null) continue;
            double[] dists = sectDistsAtCubes[c];
            int numSect = nArray.length;
            double[] weights = new double[numSect];
            double wtSum = 0.0;
            for (int s = 0; s < numSect; ++s) {
                double dist = dists[s];
                weights[s] = this.getDistWt(dist);
                wtSum += weights[s];
            }
            if (wtSum > 1.0) {
                scaledWeights = new double[numSect];
                for (int s = 0; s < numSect; ++s) {
                    scaledWeights[s] = weights[s] / wtSum;
                    int n = nArray[s];
                    this.totScaledDistWtsAtCubesForSectArray[n] = this.totScaledDistWtsAtCubesForSectArray[n] + (scaledWeights[s] - weights[s]);
                }
            } else {
                scaledWeights = weights;
            }
            this.sectOrigDistWeightsAtCubes[c] = weights;
            this.sectScaledDistWeightsAtCubes[c] = scaledWeights;
        }
        watch.stop();
        System.out.println("Took " + (float)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0f + " secs to build cube/section weights");
    }

    public double getDistWt(double dist) {
        return (this.maxFaultNuclDist - dist) / this.maxFaultNuclDist;
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return FaultCubeAssociations.Precomputed.class;
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        new FaultCubeAssociations.Precomputed(this).writeToArchive(output, entryPrefix);
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        throw new IllegalStateException("Should be serialized back in as Precomputed");
    }

    @Override
    public int getNumCubes() {
        return this.cgr.getNumCubes();
    }

    private class SectCubeMapper
    implements Callable<SectCubeMapper> {
        private int sectIndex;
        private double totWeight;
        private Map<Integer, Float> mappedCubeDistances;
        private double fractInRegion;

        public SectCubeMapper(int sectIndex) {
            this.sectIndex = sectIndex;
        }

        @Override
        public SectCubeMapper call() throws Exception {
            FaultSection fltSection = NSHM23_FaultCubeAssociations.this.subSects.get(this.sectIndex);
            Region proxyReg = null;
            if (fltSection.isProxyFault()) {
                proxyReg = fltSection.getZonePolygon();
            }
            boolean skip = true;
            FaultTrace trace = fltSection.getFaultTrace();
            for (Location traceLoc : trace) {
                if (!NSHM23_FaultCubeAssociations.this.griddedRegion.contains(traceLoc)) continue;
                skip = false;
                break;
            }
            if (skip) {
                double regCheckDist = 2.0 * NSHM23_FaultCubeAssociations.this.maxFaultNuclDist + 2.0 * trace.getTraceLength();
                if (fltSection.getAveDip() != 90.0) {
                    regCheckDist += 2.0 * Math.cos(Math.toRadians(fltSection.getAveDip())) * fltSection.getAveLowerDepth();
                }
                for (Location traceLoc : trace) {
                    if (!(NSHM23_FaultCubeAssociations.this.griddedRegion.distanceToLocation(traceLoc) < regCheckDist)) continue;
                    skip = false;
                    break;
                }
                if (skip && proxyReg != null) {
                    for (Location gridLoc : NSHM23_FaultCubeAssociations.this.griddedRegion.getNodeList()) {
                        if (!(proxyReg.distanceToLocation(gridLoc) < regCheckDist)) continue;
                        skip = false;
                        break;
                    }
                }
                if (skip) {
                    return null;
                }
            }
            this.mappedCubeDistances = new HashMap<Integer, Float>();
            this.totWeight = 0.0;
            boolean aseisReducesArea = true;
            double depthDiscr = NSHM23_FaultCubeAssociations.this.cgr.getCubeDepthDiscr();
            ArrayList<Double> depths = new ArrayList<Double>();
            for (double depth = depthDiscr / 2.0; depth < NSHM23_FaultCubeAssociations.this.cgr.getMaxDepth(); depth += depthDiscr) {
                depths.add(depth);
            }
            if (proxyReg != null) {
                Location topRight = new Location(proxyReg.getMaxLat(), proxyReg.getMaxLon());
                Location botLeft = new Location(proxyReg.getMinLat(), proxyReg.getMinLon());
                topRight = LocationUtils.location(topRight, 0.7853981633974483, 2.0 * NSHM23_FaultCubeAssociations.this.maxFaultNuclDist);
                botLeft = LocationUtils.location(botLeft, 3.9269908169872414, 2.0 * NSHM23_FaultCubeAssociations.this.maxFaultNuclDist);
                Region bufferedPoly = new Region(botLeft, topRight);
                GriddedRegion griddedPolygonReg = new GriddedRegion(bufferedPoly, NSHM23_FaultCubeAssociations.this.cgr.getCubeLatLonSpacing(), NSHM23_FaultCubeAssociations.this.cgr.getCubeLocationForIndex(0));
                double upperDepth = aseisReducesArea ? fltSection.getReducedAveUpperDepth() : fltSection.getOrigAveUpperDepth();
                double lowerDepth = fltSection.getAveLowerDepth();
                for (int i = 0; i < griddedPolygonReg.getNumLocations(); ++i) {
                    Location loc = griddedPolygonReg.getLocation(i);
                    double horzDist = proxyReg.contains(loc) ? 0.0 : proxyReg.distanceToLocation(loc);
                    if (horzDist > NSHM23_FaultCubeAssociations.this.maxFaultNuclDist) continue;
                    Iterator iterator = depths.iterator();
                    while (iterator.hasNext()) {
                        double depth = (Double)iterator.next();
                        double vertDist = depth <= upperDepth ? upperDepth - depth : (depth >= lowerDepth ? depth - lowerDepth : 0.0);
                        double dist = vertDist == 0.0 ? horzDist : (horzDist == 0.0 ? vertDist : Math.hypot(horzDist, vertDist));
                        if (!(dist <= NSHM23_FaultCubeAssociations.this.maxFaultNuclDist)) continue;
                        this.totWeight += NSHM23_FaultCubeAssociations.this.getDistWt(dist);
                        int cubeIndex = NSHM23_FaultCubeAssociations.this.cgr.getCubeIndexForLocation(new Location(loc.getLatitude(), loc.getLongitude(), depth));
                        if (cubeIndex < 0) continue;
                        this.mappedCubeDistances.put(cubeIndex, Float.valueOf((float)dist));
                    }
                }
            } else {
                RuptureSurface sectSurf = fltSection.getFaultSurface(0.25, false, aseisReducesArea);
                Region fltPolygon = NSHM23_FaultPolygonBuilder.buildPoly(fltSection, sectSurf, aseisReducesArea, NSHM23_FaultCubeAssociations.this.maxFaultNuclDist);
                GriddedRegion griddedPolygonReg = new GriddedRegion(fltPolygon, NSHM23_FaultCubeAssociations.this.cgr.getCubeLatLonSpacing(), NSHM23_FaultCubeAssociations.this.cgr.getCubeLocationForIndex(0));
                double testWt = 0.0;
                for (int i = 0; i < griddedPolygonReg.getNumLocations(); ++i) {
                    Location loc = griddedPolygonReg.getLocation(i);
                    Iterator iterator = depths.iterator();
                    while (iterator.hasNext()) {
                        double depth = (Double)iterator.next();
                        Location loc2 = new Location(loc.getLatitude(), loc.getLongitude(), depth);
                        double dist = LocationUtils.distanceToSurfFast(loc2, sectSurf);
                        if (!(dist <= NSHM23_FaultCubeAssociations.this.maxFaultNuclDist)) continue;
                        this.totWeight += NSHM23_FaultCubeAssociations.this.getDistWt(dist);
                        int cubeIndex = NSHM23_FaultCubeAssociations.this.cgr.getCubeIndexForLocation(loc2);
                        if (cubeIndex < 0) continue;
                        this.mappedCubeDistances.put(cubeIndex, Float.valueOf((float)dist));
                        testWt += NSHM23_FaultCubeAssociations.this.getDistWt(dist);
                    }
                }
                this.fractInRegion = testWt / this.totWeight;
                if ((double)((float)this.fractInRegion) != 1.0) {
                    // empty if block
                }
            }
            if (this.mappedCubeDistances.isEmpty()) {
                return null;
            }
            return this;
        }
    }
}

