/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.CubedGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultCubeAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.NucleationRatePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SolMFDPlot;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_InvConfigFactory;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_AbstractGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_LogicTreeBranch;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.FocalMech;
import org.opensha.sha.util.TectonicRegionType;

public class NSHM23_SingleRegionGridSourceProvider
extends NSHM23_AbstractGridSourceProvider {
    static final boolean D = false;
    public static final double DEFAULT_MAX_FAULT_NUCL_DIST = 12.0;
    private CubedGriddedRegion cgr;
    private FaultCubeAssociations faultCubeassociations;
    private double[] spatialPDF;
    private FaultSystemSolution fss;
    private FaultSystemRupSet rupSet;
    private EvenlyDiscretizedFunc depthNuclProbHist;
    private GriddedRegion griddedRegion;
    private ModSectMinMags modMinMags;
    private IncrementalMagFreqDist totGriddedSeisMFD;
    private IncrementalMagFreqDist totalTrulyOffFaultMFD;
    private IncrementalMagFreqDist totalSupraSeisOnFaultMFD;
    private SummedMagFreqDist totalSubSeisOnFaultMFD;
    private SummedMagFreqDist[] subSeisOnFaultMFD_ForGridArray;
    private SummedMagFreqDist[] unassociatedMFD_ForGridArray;
    private IncrementalMagFreqDist[] longTermSupraSeisMFD_OnSectArray;
    private List<Map<Integer, double[]>> gridSectMappedAssocatedMFDs;
    private double[] fracStrikeSlip;
    private double[] fracNormal;
    private double[] fracReverse;
    private TectonicRegionType[] trts;
    private boolean preserveTotalMFD;

    public NSHM23_SingleRegionGridSourceProvider(FaultSystemSolution fss, FaultCubeAssociations faultCubeassociations, double[] spatialPDF, IncrementalMagFreqDist totGriddedSeisMFD, EvenlyDiscretizedFunc depthNuclProbHist, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, Map<TectonicRegionType, Region> trtRegions) {
        this(fss, faultCubeassociations, spatialPDF, totGriddedSeisMFD, true, depthNuclProbHist, fracStrikeSlip, fracNormal, fracReverse, trtRegions);
    }

    public NSHM23_SingleRegionGridSourceProvider(FaultSystemSolution fss, FaultCubeAssociations faultCubeassociations, double[] spatialPDF, IncrementalMagFreqDist totGriddedSeisMFD, boolean preserveTotalMFD, EvenlyDiscretizedFunc depthNuclProbHist, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, Map<TectonicRegionType, Region> trtRegions) {
        int i;
        this.fss = fss;
        this.faultCubeassociations = faultCubeassociations;
        this.preserveTotalMFD = preserveTotalMFD;
        this.cgr = faultCubeassociations.getCubedGriddedRegion();
        this.rupSet = fss.getRupSet();
        this.modMinMags = this.rupSet.getModule(ModSectMinMags.class);
        this.spatialPDF = spatialPDF;
        this.totGriddedSeisMFD = totGriddedSeisMFD;
        this.griddedRegion = this.cgr.getGriddedRegion();
        this.fracStrikeSlip = fracStrikeSlip;
        this.fracNormal = fracNormal;
        this.fracReverse = fracReverse;
        this.trts = new TectonicRegionType[this.griddedRegion.getNodeCount()];
        for (i = 0; i < this.trts.length; ++i) {
            this.trts[i] = TectonicRegionType.ACTIVE_SHALLOW;
        }
        if (trtRegions != null) {
            block1: for (i = 0; i < this.trts.length; ++i) {
                Location loc = this.griddedRegion.getLocation(i);
                for (TectonicRegionType trt : trtRegions.keySet()) {
                    if (!trtRegions.get(trt).contains(loc)) continue;
                    this.trts[i] = trt;
                    continue block1;
                }
            }
        }
        Preconditions.checkState((this.griddedRegion.getNodeCount() == spatialPDF.length ? 1 : 0) != 0, (String)"griddedRegion and spatialPDF have differe sizes: %s vs %s", (int)this.griddedRegion.getNodeCount(), (int)spatialPDF.length);
        Preconditions.checkState((fracStrikeSlip.length == spatialPDF.length ? 1 : 0) != 0);
        for (i = 0; i < fracStrikeSlip.length; ++i) {
            double sum = fracNormal[i] + fracStrikeSlip[i] + fracReverse[i];
            Preconditions.checkState((boolean)Precision.equals((double)1.0, (double)sum, (double)0.001));
        }
        double testSum = 0.0;
        for (Object val : (Object)spatialPDF) {
            testSum += val;
        }
        Preconditions.checkState((testSum < 1.001 && testSum > 0.999 ? 1 : 0) != 0, (String)"spatialPDF values must sum to 1.0; sum=%s", (Object)testSum);
        this.depthNuclProbHist = this.validateOrUpdateDepthDistr(depthNuclProbHist, this.cgr);
        long time = System.currentTimeMillis();
        this.computeLongTermSupraSeisMFD_OnSectArray();
        long runtime = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        this.computeOnAndOffFaultGriddedSeisMFDs();
        runtime = System.currentTimeMillis() - time;
    }

    private EvenlyDiscretizedFunc validateOrUpdateDepthDistr(EvenlyDiscretizedFunc depthNuclProbHist, CubedGriddedRegion cgr) {
        double testSum = depthNuclProbHist.calcSumOfY_Vals();
        Preconditions.checkState((testSum < 1.001 && testSum > 0.999 ? 1 : 0) != 0, (String)"depthNuclProbHist y-axis values must sum to 1.0; sum=%s", (Object)testSum);
        double cubeDiscr = cgr.getCubeDepthDiscr();
        int numCubes = cgr.getNumCubeDepths();
        double firstDepth = cgr.getCubeDepth(0);
        if ((float)depthNuclProbHist.getDelta() == (float)cubeDiscr && (float)firstDepth == (float)depthNuclProbHist.getMinX()) {
            if (numCubes == depthNuclProbHist.size()) {
                return depthNuclProbHist;
            }
            EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(firstDepth, numCubes, cubeDiscr);
            for (int i = 0; i < ret.size(); ++i) {
                if (i >= depthNuclProbHist.size()) {
                    System.err.println("WARNING: depth-nucleation probability histogram doesn't have a value at " + (float)ret.getX(i) + ", setting to 0");
                    continue;
                }
                ret.set(i, depthNuclProbHist.getY(i));
            }
            double weightBelow = 0.0;
            for (int i = ret.size(); i < depthNuclProbHist.size(); ++i) {
                weightBelow += depthNuclProbHist.getY(i);
            }
            if (weightBelow > 0.0) {
                System.err.println("WARNING: depth-nucleation probability histogram has values below CubedGriddedRegion with total weight=" + (float)weightBelow + ", ignoring those values and re-normalizing.");
                ret.scale(1.0 / ret.calcSumOfY_Vals());
            } else {
                testSum = ret.calcSumOfY_Vals();
                Preconditions.checkState((testSum < 1.001 && testSum > 0.999 ? 1 : 0) != 0, (String)"re-gridded depth-nucleation hist doesn't sum to 1? %s", (Object)testSum);
            }
            return ret;
        }
        throw new IllegalStateException("Supplied depth-nucleation probability histogram does not match CubedGriddedRegion gridding.");
    }

    @Override
    public FaultCubeAssociations getFaultCubeassociations() {
        return this.faultCubeassociations;
    }

    private SummedMagFreqDist initSummedMFD() {
        return new SummedMagFreqDist(this.totGriddedSeisMFD.getMinX(), this.totGriddedSeisMFD.size(), this.totGriddedSeisMFD.getDelta());
    }

    private IncrementalMagFreqDist initIncrMFD() {
        return new IncrementalMagFreqDist(this.totGriddedSeisMFD.getMinX(), this.totGriddedSeisMFD.size(), this.totGriddedSeisMFD.getDelta());
    }

    private void computeOnAndOffFaultGriddedSeisMFDs() {
        this.totalSubSeisOnFaultMFD = this.initSummedMFD();
        this.totalSubSeisOnFaultMFD.setName("totalSubSeisMFD");
        this.gridSectMappedAssocatedMFDs = new ArrayList<Map<Integer, double[]>>(this.griddedRegion.getNodeCount());
        for (int i = 0; i < this.griddedRegion.getNodeCount(); ++i) {
            this.gridSectMappedAssocatedMFDs.add(null);
        }
        this.subSeisOnFaultMFD_ForGridArray = new SummedMagFreqDist[this.spatialPDF.length];
        SummedMagFreqDist associatedSupraSeisMFD = this.preserveTotalMFD ? null : this.initSummedMFD();
        for (int c = 0; c < this.cgr.getNumCubes(); ++c) {
            SummedMagFreqDist mfd = this.getSubSeismoMFD_ForCube(c, true, associatedSupraSeisMFD);
            if (mfd == null) continue;
            this.totalSubSeisOnFaultMFD.addIncrementalMagFreqDist(mfd);
            int gridIndex = this.cgr.getRegionIndexForCubeIndex(c);
            if (this.subSeisOnFaultMFD_ForGridArray[gridIndex] == null) {
                this.subSeisOnFaultMFD_ForGridArray[gridIndex] = this.initSummedMFD();
            }
            this.subSeisOnFaultMFD_ForGridArray[gridIndex].addIncrementalMagFreqDist(mfd);
        }
        this.totalTrulyOffFaultMFD = this.initIncrMFD();
        this.totalTrulyOffFaultMFD.setName("totalTrulyOffFaultMFD");
        for (int i = 0; i < this.totGriddedSeisMFD.size(); ++i) {
            double rate = this.totGriddedSeisMFD.getY(i) - this.totalSubSeisOnFaultMFD.getY(i);
            if (!this.preserveTotalMFD) {
                double supraOverlapRate = associatedSupraSeisMFD.getY(i);
                Preconditions.checkState(((float)supraOverlapRate <= (float)rate ? 1 : 0) != 0, (String)"supra-overlap rate for M=%s is %s but total rate is %s?", (Object)this.totGriddedSeisMFD.getX(i), (Object)supraOverlapRate, (Object)rate);
                rate -= supraOverlapRate;
            }
            this.totalTrulyOffFaultMFD.set(i, rate);
        }
        this.unassociatedMFD_ForGridArray = new SummedMagFreqDist[this.spatialPDF.length];
        for (int gridIndex = 0; gridIndex < this.spatialPDF.length; ++gridIndex) {
            SummedMagFreqDist summedMFD = this.initSummedMFD();
            for (int c : this.cgr.getCubeIndicesForGridCell(gridIndex)) {
                summedMFD.addIncrementalMagFreqDist(this.getUnassociatedMFD_ForCube(c));
            }
            if (!(summedMFD.getTotalIncrRate() >= 1.0E-10)) continue;
            this.unassociatedMFD_ForGridArray[gridIndex] = summedMFD;
        }
    }

    private void computeLongTermSupraSeisMFD_OnSectArray() {
        SummedMagFreqDist mfd = this.initSummedMFD();
        this.longTermSupraSeisMFD_OnSectArray = new IncrementalMagFreqDist[this.rupSet.getNumSections()];
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            IncrementalMagFreqDist nuclMFD;
            this.longTermSupraSeisMFD_OnSectArray[s] = nuclMFD = this.fss.calcNucleationMFD_forSect(s, mfd.getMinX(), mfd.getMaxX(), mfd.size());
            mfd.addIncrementalMagFreqDist(nuclMFD);
        }
        mfd.setName("totalSupraSeisOnFaultMFD");
        this.totalSupraSeisOnFaultMFD = mfd;
    }

    private double minMagForSect(int sectIndex) {
        if (this.modMinMags == null) {
            return this.rupSet.getMinMagForSection(sectIndex);
        }
        return this.modMinMags.getMinMagForSection(sectIndex);
    }

    public SummedMagFreqDist getSubSeismoMFD_ForCube(int cubeIndex) {
        return this.getSubSeismoMFD_ForCube(cubeIndex, false, null);
    }

    private SummedMagFreqDist getSubSeismoMFD_ForCube(int cubeIndex, boolean trackAssociations, SummedMagFreqDist carvedOutMFD) {
        Map<Integer, double[]> gridAssocatedMFDs;
        double[] sectDistWeights = this.faultCubeassociations.getScaledSectDistWeightsAtCube(cubeIndex);
        if (sectDistWeights == null) {
            return null;
        }
        Preconditions.checkState(((float)StatUtils.sum((double[])sectDistWeights) <= 1.0f ? 1 : 0) != 0);
        SummedMagFreqDist subSeisMFD = this.initSummedMFD();
        int gridIndex = this.cgr.getRegionIndexForCubeIndex(cubeIndex);
        Preconditions.checkState((gridIndex < this.spatialPDF.length ? 1 : 0) != 0);
        int depIndex = this.cgr.getDepthIndexForCubeIndex(cubeIndex);
        int[] sects = this.faultCubeassociations.getSectsAtCube(cubeIndex);
        Map<Integer, double[]> map = gridAssocatedMFDs = trackAssociations ? this.gridSectMappedAssocatedMFDs.get(gridIndex) : null;
        if (trackAssociations && gridAssocatedMFDs == null) {
            gridAssocatedMFDs = new HashMap<Integer, double[]>(sects.length);
            this.gridSectMappedAssocatedMFDs.set(gridIndex, gridAssocatedMFDs);
        }
        for (int s = 0; s < sects.length; ++s) {
            int i;
            double[] gridAssoc;
            Preconditions.checkState((s < sectDistWeights.length ? 1 : 0) != 0);
            double wt = sectDistWeights[s] * this.spatialPDF[gridIndex] * this.depthNuclProbHist.getY(depIndex) / (double)(this.cgr.getNumCubesPerGridEdge() * this.cgr.getNumCubesPerGridEdge());
            double minMag = this.minMagForSect(sects[s]);
            int minMagIndex = this.totGriddedSeisMFD.getClosestXIndex(minMag);
            double[] dArray = gridAssoc = trackAssociations ? gridAssocatedMFDs.get(sects[s]) : null;
            if (trackAssociations && gridAssoc == null) {
                gridAssoc = new double[subSeisMFD.size()];
                gridAssocatedMFDs.put(sects[s], gridAssoc);
            }
            for (i = 0; i < minMagIndex; ++i) {
                double sectCubeRate = wt * this.totGriddedSeisMFD.getY(i);
                subSeisMFD.add(i, sectCubeRate);
                if (!trackAssociations) continue;
                int n = i;
                gridAssoc[n] = gridAssoc[n] + sectCubeRate;
            }
            if (carvedOutMFD == null) continue;
            for (i = minMagIndex; i < carvedOutMFD.size(); ++i) {
                carvedOutMFD.add(i, wt * this.totGriddedSeisMFD.getY(i));
            }
        }
        return subSeisMFD;
    }

    public SummedMagFreqDist getUnassociatedMFD_ForCube(int cubeIndex) {
        double scaleFactor = this.totGriddedSeisMFD.getY(0) / this.totalTrulyOffFaultMFD.getY(0);
        double[] sectDistWeights = this.faultCubeassociations.getScaledSectDistWeightsAtCube(cubeIndex);
        double wtSum = 0.0;
        if (sectDistWeights != null) {
            for (double weight : sectDistWeights) {
                wtSum += weight;
            }
        }
        SummedMagFreqDist trulyOffMFD = this.initSummedMFD();
        int gridIndex = this.cgr.getRegionIndexForCubeIndex(cubeIndex);
        int depIndex = this.cgr.getDepthIndexForCubeIndex(cubeIndex);
        double wt = (1.0 - wtSum) * scaleFactor * this.spatialPDF[gridIndex] * this.depthNuclProbHist.getY(depIndex) / (double)(this.cgr.getNumCubesPerGridEdge() * this.cgr.getNumCubesPerGridEdge());
        for (int i = 0; i < this.totalTrulyOffFaultMFD.size(); ++i) {
            trulyOffMFD.add(i, wt * this.totalTrulyOffFaultMFD.getY(i));
        }
        return trulyOffMFD;
    }

    public SummedMagFreqDist getGriddedSeisMFD_ForCube(int cubeIndex) {
        SummedMagFreqDist cubeMFD = this.initSummedMFD();
        SummedMagFreqDist mfd = this.getSubSeismoMFD_ForCube(cubeIndex);
        if (mfd != null) {
            cubeMFD.addIncrementalMagFreqDist(mfd);
        }
        if ((mfd = this.getUnassociatedMFD_ForCube(cubeIndex)) != null) {
            cubeMFD.addIncrementalMagFreqDist(mfd);
        }
        return cubeMFD;
    }

    public SummedMagFreqDist getSupraSeisMFD_ForCube(int cubeIndex) {
        double[] sectDistWeights = this.faultCubeassociations.getScaledSectDistWeightsAtCube(cubeIndex);
        if (sectDistWeights == null) {
            return null;
        }
        SummedMagFreqDist supraMFD = this.initSummedMFD();
        int[] sects = this.faultCubeassociations.getSectsAtCube(cubeIndex);
        for (int s = 0; s < sects.length; ++s) {
            double wt = sectDistWeights[s] / this.faultCubeassociations.getTotalScaledDistWtAtCubesForSect(sects[s]);
            IncrementalMagFreqDist mfd = this.longTermSupraSeisMFD_OnSectArray[sects[s]].deepClone();
            mfd.scale(wt);
            supraMFD.addIncrementalMagFreqDist(mfd);
        }
        return supraMFD;
    }

    public SummedMagFreqDist getTotalMFD_ForCube(int cubeIndex) {
        SummedMagFreqDist cubeMFD = this.initSummedMFD();
        SummedMagFreqDist mfd = this.getGriddedSeisMFD_ForCube(cubeIndex);
        if (mfd != null) {
            cubeMFD.addIncrementalMagFreqDist(mfd);
        }
        if ((mfd = this.getSupraSeisMFD_ForCube(cubeIndex)) != null) {
            cubeMFD.addIncrementalMagFreqDist(mfd);
        }
        return cubeMFD;
    }

    public GridSourceList convertToGridSourceList() {
        return this.convertToGridSourceList(Double.NEGATIVE_INFINITY);
    }

    public GridSourceList convertToGridSourceList(double minMag) {
        return this.convertToGridSourceList(minMag, new NSHM23_WUS_FiniteRuptureConverter());
    }

    public GridSourceList convertToGridSourceList(GridSourceList.FiniteRuptureConverter converter) {
        return this.convertToGridSourceList(Double.NEGATIVE_INFINITY, converter);
    }

    public GridSourceList convertToGridSourceList(double minMag, GridSourceList.FiniteRuptureConverter converter) {
        return new Converter(this, this.gridSectMappedAssocatedMFDs, minMag, converter, this.getRefMFD());
    }

    private IncrementalMagFreqDist getRefMFD() {
        return new IncrementalMagFreqDist(this.totGriddedSeisMFD.getMinX(), this.totGriddedSeisMFD.size(), this.totGriddedSeisMFD.getDelta());
    }

    @Override
    public SummedMagFreqDist getMFD_SubSeisOnFault(int gridIndex) {
        return this.subSeisOnFaultMFD_ForGridArray[gridIndex];
    }

    @Override
    public SummedMagFreqDist getMFD_Unassociated(int gridIndex) {
        return this.unassociatedMFD_ForGridArray[gridIndex];
    }

    public SummedMagFreqDist getTotalSubSeisOnFaultMFD() {
        return this.totalSubSeisOnFaultMFD;
    }

    public IncrementalMagFreqDist getTotalUnassociatedMFD() {
        return this.totalTrulyOffFaultMFD;
    }

    public IncrementalMagFreqDist getTotalSupraSeisOnFaultMFD() {
        return this.totalSupraSeisOnFaultMFD;
    }

    public IncrementalMagFreqDist getTotalGriddedSeisMFD() {
        return this.totGriddedSeisMFD;
    }

    @Override
    public double getFracStrikeSlip(int gridIndex) {
        return this.fracStrikeSlip[gridIndex];
    }

    @Override
    public double getFracReverse(int gridIndex) {
        return this.fracReverse[gridIndex];
    }

    @Override
    public double getFracNormal(int gridIndex) {
        return this.fracNormal[gridIndex];
    }

    @Override
    public GriddedRegion getGriddedRegion() {
        return this.griddedRegion;
    }

    @Override
    public void scaleAll(double[] valuesArray) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static void main(String[] args) throws IOException {
        FaultSystemSolution sol = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/nshm23/batch_inversions/2024_02_02-nshm23_branches-WUS_FM_v3/results_WUS_FM_v3_branch_averaged.zip"));
        sol.getRupSet().removeModuleInstances(FaultCubeAssociations.class);
        NSHM23_SingleRegionGridSourceProvider prov = (NSHM23_SingleRegionGridSourceProvider)NSHM23_InvConfigFactory.buildGridSourceProv(sol, NSHM23_LogicTreeBranch.AVERAGE_OFF_FAULT);
        sol.addModule(prov);
        ReportPageGen pageGen = new ReportPageGen(sol.getRupSet(), sol, "Solution", new File("/tmp/report"), List.of(new SolMFDPlot(), new NucleationRatePlot()));
        pageGen.setReplot(true);
        pageGen.generatePage();
        GridSourceList list1 = prov.convertToGridSourceList();
        sol.addModule(list1);
        pageGen = new ReportPageGen(sol.getRupSet(), sol, "Solution", new File("/tmp/report_list1"), List.of(new SolMFDPlot(), new NucleationRatePlot()));
        pageGen.setReplot(true);
        pageGen.generatePage();
        GridSourceList list2 = GridSourceList.convert(prov, sol.getRupSet().requireModule(FaultCubeAssociations.class), new NSHM23_WUS_FiniteRuptureConverter());
        sol.addModule(list2);
        pageGen = new ReportPageGen(sol.getRupSet(), sol, "Solution", new File("/tmp/report_list2"), List.of(new SolMFDPlot(), new NucleationRatePlot()));
        pageGen.setReplot(true);
        pageGen.generatePage();
        for (int gridIndex = 0; gridIndex < list1.getNumLocations(); ++gridIndex) {
            ArrayList<GridSourceList.GriddedRupture> rups1 = new ArrayList<GridSourceList.GriddedRupture>((Collection<GridSourceList.GriddedRupture>)list1.getRuptures(null, gridIndex));
            ArrayList<GridSourceList.GriddedRupture> rups2 = new ArrayList<GridSourceList.GriddedRupture>((Collection<GridSourceList.GriddedRupture>)list2.getRuptures(null, gridIndex));
            Collections.sort(rups1);
            Collections.sort(rups2);
            Preconditions.checkState((rups1.size() == rups2.size() ? 1 : 0) != 0);
            for (int i = 0; i < rups1.size(); ++i) {
                GridSourceList.GriddedRupture rup1 = (GridSourceList.GriddedRupture)rups1.get(i);
                GridSourceList.GriddedRupture rup2 = (GridSourceList.GriddedRupture)rups2.get(i);
                Preconditions.checkState((rup1.properties.magnitude == rup2.properties.magnitude ? 1 : 0) != 0);
                Preconditions.checkState(((float)rup1.rate == (float)rup2.rate ? 1 : 0) != 0);
                Preconditions.checkState(((float)rup1.properties.rake == (float)rup2.properties.rake ? 1 : 0) != 0);
                Preconditions.checkState((rup1.associatedSections == null == (rup2.associatedSections == null) ? 1 : 0) != 0);
                if (rup1.associatedSections == null) continue;
                Preconditions.checkState((rup2.associatedSections.length >= rup1.associatedSections.length ? 1 : 0) != 0);
                double fract1 = StatUtils.sum((double[])rup1.associatedSectionFracts);
                double fract2 = StatUtils.sum((double[])rup2.associatedSectionFracts);
                Preconditions.checkState((fract1 == fract2 ? 1 : 0) != 0);
            }
        }
    }

    @Override
    public TectonicRegionType getTectonicRegionType(int gridIndex) {
        return this.trts[gridIndex];
    }

    public static class NSHM23_WUS_FiniteRuptureConverter
    implements GridSourceList.FiniteRuptureConverter {
        private WC1994_MagLengthRelationship WC94 = new WC1994_MagLengthRelationship();

        @Override
        public GridSourceList.GriddedRupture buildFiniteRupture(int gridIndex, Location loc, double magnitude, double rate, FocalMech focalMech, TectonicRegionType trt, int[] associatedSections, double[] associatedSectionFracts, GridSourceList.GriddedRupturePropertiesCache cache) {
            double dipRad = Math.toRadians(focalMech.dip());
            double depth = (float)magnitude < 6.5f ? 5.0 : 1.0;
            double length = this.WC94.getMedianLength(magnitude);
            double aspectWidth = length / 1.5;
            double ddWidth = (14.0 - depth) / Math.sin(dipRad);
            ddWidth = Math.min(aspectWidth, ddWidth);
            double lower = depth + ddWidth * Math.sin(dipRad);
            GridSourceList.GriddedRuptureProperties props = cache.getCached(new GridSourceList.GriddedRuptureProperties(magnitude, focalMech.rake(), focalMech.dip(), Double.NaN, null, depth, lower, length, Double.NaN, Double.NaN, trt));
            return new GridSourceList.GriddedRupture(gridIndex, loc, props, rate, associatedSections, associatedSectionFracts);
        }
    }

    private static class Converter
    extends GridSourceList.DynamicallyBuilt {
        private MFDGridSourceProvider gridProv;
        private List<Map<Integer, double[]>> gridSectMappedAssocatedMFDs;
        private double minMag;
        private GridSourceList.FiniteRuptureConverter converter;

        public Converter(MFDGridSourceProvider gridProv, List<Map<Integer, double[]>> gridSectMappedAssocatedMFDs, double minMag, GridSourceList.FiniteRuptureConverter converter, IncrementalMagFreqDist refMFD) {
            super(gridProv.getTectonicRegionTypes(), gridProv.getGriddedRegion(), refMFD);
            this.gridProv = gridProv;
            this.gridSectMappedAssocatedMFDs = gridSectMappedAssocatedMFDs;
            this.minMag = minMag;
            this.converter = converter;
        }

        @Override
        public int getLocationIndexForSource(int sourceIndex) {
            return sourceIndex;
        }

        @Override
        public TectonicRegionType tectonicRegionTypeForSourceIndex(int sourceIndex) {
            return this.gridProv.getTectonicRegionType(sourceIndex);
        }

        @Override
        protected List<GridSourceList.GriddedRupture> buildRuptures(TectonicRegionType tectonicRegionType, int gridIndex) {
            double fractSS = this.gridProv.getFracStrikeSlip(gridIndex);
            double fractN = this.gridProv.getFracNormal(gridIndex);
            double fractR = this.gridProv.getFracReverse(gridIndex);
            IncrementalMagFreqDist mfd = this.gridProv.getMFD(tectonicRegionType, gridIndex);
            if (mfd == null) {
                return null;
            }
            GridSourceList.GriddedRupturePropertiesCache cache = new GridSourceList.GriddedRupturePropertiesCache();
            Location loc = this.gridProv.getLocation(gridIndex);
            Map<Integer, double[]> sectAssocs = this.gridSectMappedAssocatedMFDs.get(gridIndex);
            ArrayList<GridSourceList.GriddedRupture> ruptureList = new ArrayList<GridSourceList.GriddedRupture>();
            for (int m = 0; m < mfd.size(); ++m) {
                double mag = mfd.getX(m);
                double totRate = mfd.getY(m);
                if (totRate == 0.0 || (float)mag < (float)this.minMag) continue;
                double associatedRate = 0.0;
                int[] associatedSections = null;
                double[] associatedSectionFracts = null;
                if (sectAssocs != null) {
                    ArrayList<Integer> associatedSectionsList = new ArrayList<Integer>(sectAssocs.size());
                    ArrayList<Double> associatedSectionFractsList = new ArrayList<Double>(sectAssocs.size());
                    for (int sectID : sectAssocs.keySet()) {
                        double[] sectAssocRates = sectAssocs.get(sectID);
                        Preconditions.checkState((sectAssocRates.length == mfd.size() ? 1 : 0) != 0);
                        double sectAssocRate = sectAssocRates[m];
                        if (!(sectAssocRate > 0.0)) continue;
                        associatedRate += sectAssocRate;
                        associatedSectionsList.add(sectID);
                        associatedSectionFractsList.add(sectAssocRate / totRate);
                    }
                    if (!associatedSectionFractsList.isEmpty()) {
                        Preconditions.checkState(((float)associatedRate <= (float)totRate ? 1 : 0) != 0, (String)"Associated rate (%s) exceeds the total rate (%s) for gridIndex=%s, M=%s", (Object)associatedRate, (Object)totRate, (Object)gridIndex, (Object)mag);
                        associatedSections = Ints.toArray(associatedSectionsList);
                        associatedSectionFracts = Doubles.toArray(associatedSectionFractsList);
                    }
                }
                for (FocalMech mech : FocalMech.values()) {
                    double mechRate;
                    switch (mech) {
                        case STRIKE_SLIP: {
                            mechRate = totRate * fractSS;
                            break;
                        }
                        case NORMAL: {
                            mechRate = totRate * fractN;
                            break;
                        }
                        case REVERSE: {
                            mechRate = totRate * fractR;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (mechRate == 0.0) continue;
                    ruptureList.add(this.converter.buildFiniteRupture(gridIndex, loc, mag, mechRate, mech, tectonicRegionType, associatedSections, associatedSectionFracts, cache));
                }
            }
            return ruptureList;
        }

        @Override
        public double getFracStrikeSlip(int gridIndex) {
            return this.gridProv.getFracStrikeSlip(gridIndex);
        }

        @Override
        public double getFracReverse(int gridIndex) {
            return this.gridProv.getFracReverse(gridIndex);
        }

        @Override
        public double getFracNormal(int gridIndex) {
            return this.gridProv.getFracNormal(gridIndex);
        }

        @Override
        public int getNumSources() {
            return this.getNumLocations();
        }

        @Override
        public Set<Integer> getAssociatedGridIndexes(int sectionIndex) {
            Preconditions.checkState((boolean)(this.gridProv instanceof NSHM23_SingleRegionGridSourceProvider), (Object)"Method only supported when we have an NSHM23_SingleRegionGridSourceProvider instance");
            Map<Integer, Double> assoc = ((NSHM23_SingleRegionGridSourceProvider)this.gridProv).faultCubeassociations.getNodeFractions(sectionIndex);
            if (assoc == null || assoc.isEmpty()) {
                return Set.of();
            }
            return assoc.keySet();
        }

        @Override
        public AverageableModule.AveragingAccumulator<GridSourceProvider> averagingAccumulator() {
            return new ConverterAverager();
        }
    }

    private static class ConverterAverager
    implements AverageableModule.AveragingAccumulator<GridSourceProvider> {
        private AverageableModule.AveragingAccumulator<GridSourceProvider> mfdAverager = null;
        private List<Map<Integer, double[]>> gridSectMappedAssocatedMFDs;
        private IncrementalMagFreqDist refMFD = null;
        private double minMag;
        private GridSourceList.FiniteRuptureConverter converter;
        private double sumWeight = 0.0;

        private ConverterAverager() {
        }

        @Override
        public Class<GridSourceProvider> getType() {
            return GridSourceProvider.class;
        }

        @Override
        public void process(GridSourceProvider module, double relWeight) {
            Preconditions.checkState((boolean)(module instanceof Converter));
            Converter converter = (Converter)module;
            if (this.mfdAverager == null) {
                this.mfdAverager = converter.gridProv.averagingAccumulator();
                this.gridSectMappedAssocatedMFDs = new ArrayList<Map<Integer, double[]>>(converter.getNumLocations());
                for (int i = 0; i < converter.getNumLocations(); ++i) {
                    this.gridSectMappedAssocatedMFDs.add(null);
                }
                this.converter = converter.converter;
                this.minMag = converter.minMag;
            }
            IncrementalMagFreqDist refMFD = converter.getRefMFD();
            if (this.refMFD == null || refMFD.size() > this.refMFD.size()) {
                this.refMFD = refMFD;
            }
            this.mfdAverager.process(converter.gridProv, relWeight);
            for (int i = 0; i < converter.gridSectMappedAssocatedMFDs.size(); ++i) {
                Map<Integer, double[]> sectAssoc = converter.gridSectMappedAssocatedMFDs.get(i);
                if (sectAssoc == null) continue;
                Map<Integer, double[]> runningSectAssoc = this.gridSectMappedAssocatedMFDs.get(i);
                if (runningSectAssoc == null) {
                    runningSectAssoc = new HashMap<Integer, double[]>(sectAssoc.size());
                    this.gridSectMappedAssocatedMFDs.set(i, runningSectAssoc);
                }
                for (int sectIndex : sectAssoc.keySet()) {
                    double[] assoc = sectAssoc.get(sectIndex);
                    double[] running = runningSectAssoc.get(sectIndex);
                    if (running == null) {
                        running = new double[assoc.length];
                        runningSectAssoc.put(sectIndex, running);
                    } else if (running.length < assoc.length) {
                        running = Arrays.copyOf(running, assoc.length);
                        runningSectAssoc.put(sectIndex, running);
                    }
                    for (int j = 0; j < assoc.length; ++j) {
                        if (!(assoc[j] > 0.0)) continue;
                        running[j] = Math.fma(assoc[j], relWeight, running[j]);
                    }
                }
            }
            this.sumWeight += relWeight;
        }

        @Override
        public GridSourceProvider getAverage() {
            MFDGridSourceProvider mfdAvg = (MFDGridSourceProvider)this.mfdAverager.getAverage();
            for (int i = 0; i < this.gridSectMappedAssocatedMFDs.size(); ++i) {
                Map<Integer, double[]> sectAssoc = this.gridSectMappedAssocatedMFDs.get(i);
                if (sectAssoc == null) continue;
                for (int sectIndex : sectAssoc.keySet()) {
                    double[] assoc = sectAssoc.get(sectIndex);
                    if (assoc.length != this.refMFD.size()) {
                        assoc = Arrays.copyOf(assoc, this.refMFD.size());
                        sectAssoc.put(sectIndex, assoc);
                    }
                    for (int j = 0; j < assoc.length; ++j) {
                        if (!(assoc[j] > 0.0)) continue;
                        int n = j;
                        assoc[n] = assoc[n] / this.sumWeight;
                    }
                }
            }
            return new Converter(mfdAvg, this.gridSectMappedAssocatedMFDs, this.minMag, this.converter, this.refMFD);
        }
    }
}

