/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.MaxJumpDistModels;

public class HardDistCutoffJumpProbCalc
implements JumpProbabilityCalc.BinaryJumpProbabilityCalc,
JumpProbabilityCalc.DistDependentJumpProbabilityCalc {
    private double maxDist;

    public HardDistCutoffJumpProbCalc(double maxDist) {
        this.maxDist = maxDist;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return false;
    }

    @Override
    public String getName() {
        return "MaxDist=" + MaxJumpDistModels.oDF.format(this.maxDist) + "km";
    }

    @Override
    public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
        return (float)jump.distance <= (float)this.maxDist;
    }

    @Override
    public double calcJumpProbability(double distance) {
        if ((float)distance < (float)this.maxDist) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
        return this.calcJumpProbability(jump.distance);
    }
}

