/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.AbstractMinisectionDataRecord;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.MinisectionCreepRecord;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.MinisectionMappings;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.MinisectionSlipRecord;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import scratch.UCERF3.enumTreeBranches.FaultModels;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
@DoesNotAffect(value="indices.csv")
public enum NSHM23_DeformationModels implements RupSetDeformationModel
{
    GEOLOGIC("NSHM23 Geologic Deformation Model", "Geologic"){

        @Override
        protected double getWeight() {
            return ORIGINAL_WEIGHTS ? 0.2 : 0.26;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            return this.buildGeolMinis(faultModel, NSHM23_DeformationModels.GEOLOGIC_VERSION);
        }
    }
    ,
    EVANS("NSHM23 Evans Deformation Model", "Evans"){

        @Override
        protected double getWeight() {
            return ORIGINAL_WEIGHTS ? 0.1 : 0.02;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            return 2.loadGeodeticModel(faultModel, this, GEODETIC_INCLUDE_GHOST_TRANSIENT);
        }
    }
    ,
    POLLITZ("NSHM23 Pollitz Deformation Model", "Pollitz"){

        @Override
        protected double getWeight() {
            return ORIGINAL_WEIGHTS ? 0.2 : 0.08;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            return 3.loadGeodeticModel(faultModel, this, GEODETIC_INCLUDE_GHOST_TRANSIENT);
        }
    }
    ,
    SHEN_BIRD("NSHM23 Shen-Bird Deformation Model", "Shen-Bird"){

        @Override
        protected double getWeight() {
            return ORIGINAL_WEIGHTS ? 0.25 : 0.32;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            return 4.loadGeodeticModel(faultModel, this, GEODETIC_INCLUDE_GHOST_TRANSIENT);
        }
    }
    ,
    ZENG("NSHM23 Zeng Deformation Model", "Zeng"){

        @Override
        protected double getWeight() {
            return ORIGINAL_WEIGHTS ? 0.25 : 0.32;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            return 5.loadGeodeticModel(faultModel, this, GEODETIC_INCLUDE_GHOST_TRANSIENT);
        }
    }
    ,
    AVERAGE("NSHM23 Averaged Deformation Model", "AvgDM"){

        @Override
        public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
            double totWeight = 0.0;
            ArrayList<GeoJSONFaultSection> ret = null;
            double[] origSlipRates = null;
            double[] reducedSlipRates = null;
            double[] aseismicities = null;
            double[] slipRateStdDevs = null;
            double[] creepRates = null;
            boolean[] hasCreeps = null;
            FaultUtils.AngleAverager[] rakes = null;
            for (NSHM23_DeformationModels dm : 6.values()) {
                int s;
                FaultSection sect;
                if (dm == this || !(dm.getWeight() > 0.0)) continue;
                totWeight += dm.getWeight();
                List<? extends FaultSection> dmSects = dm.apply(faultModel, branch, fullSects, subSects);
                if (ret == null) {
                    ret = new ArrayList<GeoJSONFaultSection>();
                    Iterator<? extends FaultSection> iterator = dmSects.iterator();
                    while (iterator.hasNext()) {
                        FaultSection geoSect = sect = iterator.next();
                        ret.add(((GeoJSONFaultSection)geoSect).clone());
                    }
                    origSlipRates = new double[ret.size()];
                    reducedSlipRates = new double[ret.size()];
                    aseismicities = new double[ret.size()];
                    slipRateStdDevs = new double[ret.size()];
                    creepRates = new double[ret.size()];
                    hasCreeps = new boolean[ret.size()];
                    rakes = new FaultUtils.AngleAverager[ret.size()];
                    for (s = 0; s < rakes.length; ++s) {
                        rakes[s] = new FaultUtils.AngleAverager();
                    }
                }
                for (s = 0; s < dmSects.size(); ++s) {
                    sect = (GeoJSONFaultSection)dmSects.get(s);
                    int n = s;
                    origSlipRates[n] = origSlipRates[n] + dm.getWeight() * ((GeoJSONFaultSection)sect).getOrigAveSlipRate();
                    int n2 = s;
                    reducedSlipRates[n2] = reducedSlipRates[n2] + dm.getWeight() * sect.getReducedAveSlipRate();
                    int n3 = s;
                    aseismicities[n3] = aseismicities[n3] + dm.getWeight() * ((GeoJSONFaultSection)sect).getAseismicSlipFactor();
                    int n4 = s;
                    slipRateStdDevs[n4] = slipRateStdDevs[n4] + dm.getWeight() * ((GeoJSONFaultSection)sect).getOrigSlipRateStdDev();
                    double creepRate = ((GeoJSONFaultSection)sect).getProperty("CreepRate", Double.NaN);
                    if (Double.isFinite(creepRate)) {
                        int n5 = s;
                        creepRates[n5] = creepRates[n5] + dm.getWeight() * creepRate;
                        hasCreeps[s] = true;
                    }
                    rakes[s].add(((GeoJSONFaultSection)sect).getAveRake(), dm.getWeight());
                }
            }
            Preconditions.checkState((totWeight > 0.0 ? 1 : 0) != 0);
            for (int s = 0; s < ret.size(); ++s) {
                GeoJSONFaultSection subSect = (GeoJSONFaultSection)ret.get(s);
                void origSlipRate = origSlipRates[s] / totWeight;
                void reducedSlipRate = reducedSlipRates[s] / totWeight;
                double aseismicity = aseismicities[s] / totWeight;
                if (Math.abs((double)(aseismicity - CREEP_FRACT_DEFAULT)) < 0.001) {
                    aseismicity = CREEP_FRACT_DEFAULT;
                }
                void slipRateStdDev = slipRateStdDevs[s] / totWeight;
                double creepRate = hasCreeps[s] != false ? creepRates[s] / totWeight : Double.NaN;
                double rake = FaultUtils.getInRakeRange(rakes[s].getAverage());
                subSect.setAveSlipRate((double)origSlipRate);
                subSect.setSlipRateStdDev((double)slipRateStdDev);
                subSect.setAveRake(rake);
                if (Double.isFinite(creepRate)) {
                    subSect.setProperty("CreepRate", creepRate);
                } else {
                    subSect.getProperties().remove("CreepRate");
                }
                subSect.setAseismicSlipFactor(aseismicity);
                if (hasCreeps[s]) {
                    Preconditions.checkState(((float)origSlipRate >= (float)reducedSlipRate ? 1 : 0) != 0, (String)"%s. %s: hasCreeps=%s, origSlip=%s, reducedSlip=%s", (Object[])new Object[]{s, subSect.getSectionName(), hasCreeps[s], Float.valueOf((float)origSlipRate), Float.valueOf((float)reducedSlipRate)});
                    if ((float)origSlipRate == (float)reducedSlipRate) {
                        subSect.setCouplingCoeff(1.0);
                        continue;
                    }
                    subSect.setCouplingCoeff((double)(reducedSlipRate / origSlipRate));
                    continue;
                }
                Preconditions.checkArgument(((float)origSlipRate == (float)reducedSlipRate ? 1 : 0) != 0, (String)"%s. %s: hasCreeps=%s, origSlip=%s, reducedSlip=%s", (Object[])new Object[]{s, subSect.getSectionName(), hasCreeps[s], Float.valueOf((float)origSlipRate), Float.valueOf((float)reducedSlipRate)});
                subSect.setCouplingCoeff(1.0);
            }
            return ret;
        }

        @Override
        protected double getWeight() {
            return 0.0;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            ArrayList<Map<Integer, List<MinisectionSlipRecord>>> dmMaps = new ArrayList<Map<Integer, List<MinisectionSlipRecord>>>();
            ArrayList<Double> dmWeights = new ArrayList<Double>();
            for (NSHM23_DeformationModels dm : 6.values()) {
                if (dm == this || !(dm.getWeight() > 0.0)) continue;
                double weight = dm.getWeight();
                dmWeights.add(weight);
                Map<Integer, List<MinisectionSlipRecord>> dmMinis = dm.getMinisections(faultModel);
                dmMaps.add(dmMinis);
            }
            return 6.averageMinisections(dmMaps, dmWeights);
        }
    }
    ,
    MEDIAN("NSHM23 Median Deformation Model (Unweighted, Geol. Rakes)", "MedDM"){

        @Override
        protected double getWeight() {
            return 0.0;
        }

        @Override
        public Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel faultModel) throws IOException {
            return 7.loadGeodeticModel(faultModel, this, GEODETIC_INCLUDE_GHOST_TRANSIENT);
        }
    };

    public static boolean ORIGINAL_WEIGHTS;
    public static Double OUTLIER_SUB_YC;
    public static boolean OUTLIER_SUB_LOG;
    public static boolean OUTLIER_SUB_USE_BOUND;
    private static final String NSHM23_DM_PATH_PREFIX = "/data/erf/nshm23/def_models/";
    private static final String GEOLOGIC_VERSION = "v1p0";
    private static final String CREEP_DATE = "2022_08_17";
    public static boolean GEODETIC_INCLUDE_GHOST_TRANSIENT;
    private static final boolean DEFAULT_STD_DEV_USE_GEOLOGIC = true;
    private static final double DEFAULT_FRACT_SLIP_STD_DEV = 0.1;
    public static final double STD_DEV_FLOOR = 1.0E-4;
    public static double HARDCODED_FRACTIONAL_STD_DEV;
    public static double HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND;
    public static double ASEIS_CEILING;
    public static double CREEP_FRACT_DEFAULT;
    private static final Map<RupSetFaultModel, Map<Integer, GeoJSONFaultSection>> geologicSectsCache;
    private static final Map<String, Map<Integer, List<MinisectionSlipRecord>>> geodeticMinisectsCache;
    private String name;
    private String shortName;
    private static DecimalFormat pDF;
    public static final String ORIG_FRACT_STD_DEV_PROPERTY_NAME = "OrigFractStdDev";
    private static final Map<RupSetFaultModel, Map<Integer, List<MinisectionOutlierStatistics>>> minisectionOutlierStats;

    private static String getGeodeticDirForFM(RupSetFaultModel faultModel) {
        if (NSHM23_DeformationModels.sameFaultModel(faultModel, NSHM23_FaultModels.WUS_FM_v2) || NSHM23_DeformationModels.sameFaultModel(faultModel, NSHM23_FaultModels.WUS_FM_v3)) {
            return "fm_v2";
        }
        if (NSHM23_DeformationModels.sameFaultModel(faultModel, NSHM23_FaultModels.WUS_FM_v1p4)) {
            return "fm_v1p4";
        }
        System.err.println("Warning, returning most recent geodetic date for unknown fault model: " + faultModel.getName() + " of type " + faultModel.getClass().getName());
        return "2022_08_05";
    }

    private static boolean sameFaultModel(RupSetFaultModel model1, RupSetFaultModel model2) {
        return model1 == model2 || model1.getName().equals(model2.getName());
    }

    private NSHM23_DeformationModels(String name, String shortName) {
        this.name = name;
        this.shortName = shortName;
    }

    protected abstract double getWeight();

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.getWeight();
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApplicableTo(RupSetFaultModel faultModel) {
        return faultModel instanceof NSHM23_FaultModels;
    }

    public abstract Map<Integer, List<MinisectionSlipRecord>> getMinisections(RupSetFaultModel var1) throws IOException;

    @Override
    public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
        Map<Integer, List<MinisectionSlipRecord>> minis = this.getMinisections(faultModel);
        return this.buildDeformationModel(faultModel, minis, fullSects, subSects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, GeoJSONFaultSection> getGeolFullSects(RupSetFaultModel faultModel) throws IOException {
        Map<RupSetFaultModel, Map<Integer, GeoJSONFaultSection>> map = geologicSectsCache;
        synchronized (map) {
            if (!geologicSectsCache.containsKey(faultModel)) {
                GEOLOGIC.getMinisections(faultModel);
            }
            return geologicSectsCache.get(faultModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<? extends FaultSection> buildGeolFullSects(RupSetFaultModel faultModel, String version) throws IOException {
        String dmPath = "/data/erf/nshm23/def_models/geologic/" + version + "/NSHM23_GeologicDeformationModel.geojson";
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(dmPath)));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)dmPath);
        FeatureCollection defModel = FeatureCollection.read(dmReader);
        ArrayList<GeoJSONFaultSection> geoSects = new ArrayList<GeoJSONFaultSection>();
        for (FaultSection faultSection : faultModel.getFaultSections()) {
            if (faultSection instanceof GeoJSONFaultSection) {
                geoSects.add((GeoJSONFaultSection)faultSection);
                continue;
            }
            geoSects.add(new GeoJSONFaultSection(faultSection));
        }
        GeoJSONFaultReader.attachGeoDefModel(geoSects, defModel);
        Map<RupSetFaultModel, Map<Integer, GeoJSONFaultSection>> map = geologicSectsCache;
        synchronized (map) {
            Map<Integer, GeoJSONFaultSection> map2 = geologicSectsCache.get(faultModel);
            if (map2 == null) {
                HashMap<Integer, GeoJSONFaultSection> hashMap = new HashMap<Integer, GeoJSONFaultSection>();
                for (GeoJSONFaultSection sect : geoSects) {
                    hashMap.put(sect.getSectionId(), sect.clone());
                }
                geologicSectsCache.put(faultModel, hashMap);
            }
        }
        return geoSects;
    }

    protected Map<Integer, List<MinisectionSlipRecord>> buildGeolMinis(RupSetFaultModel faultModel, String version) throws IOException {
        if (!this.isApplicableTo(faultModel)) {
            System.err.println("WARNING: Using a nonstandard fault model of type '" + faultModel.getClass().getName() + "', which may not work: " + faultModel.getName());
            Preconditions.checkState((!(faultModel instanceof FaultModels) ? 1 : 0) != 0, (Object)"You passed in UCERF3 by mistake!");
        }
        List<? extends FaultSection> geoSects = NSHM23_DeformationModels.buildGeolFullSects(faultModel, version);
        HashMap<Integer, GeoJSONFaultSection> geoSectsMap = new HashMap<Integer, GeoJSONFaultSection>();
        for (FaultSection faultSection : geoSects) {
            geoSectsMap.put(faultSection.getSectionId(), (GeoJSONFaultSection)faultSection);
        }
        return NSHM23_DeformationModels.geoSectsToMinis(geoSectsMap);
    }

    private static Map<Integer, List<MinisectionSlipRecord>> geoSectsToMinis(Map<Integer, GeoJSONFaultSection> geoSects) {
        HashMap<Integer, List<MinisectionSlipRecord>> ret = new HashMap<Integer, List<MinisectionSlipRecord>>(geoSects.size());
        for (Integer faultID : geoSects.keySet()) {
            ArrayList<MinisectionSlipRecord> minis = new ArrayList<MinisectionSlipRecord>();
            GeoJSONFaultSection sect = geoSects.get(faultID);
            double slip = sect.getOrigAveSlipRate();
            double rake = sect.getAveRake();
            double slipSD = sect.getOrigSlipRateStdDev();
            FaultTrace trace = sect.getFaultTrace();
            int numMinis = trace.size() - 1;
            for (int i = 0; i < numMinis; ++i) {
                minis.add(new MinisectionSlipRecord(faultID, i, (Location)trace.get(i), (Location)trace.get(i + 1), rake, slip, slipSD));
            }
            ret.put(faultID, minis);
        }
        return ret;
    }

    protected static synchronized Map<Integer, List<MinisectionSlipRecord>> loadGeodeticModel(RupSetFaultModel fm, NSHM23_DeformationModels dm, boolean includeGhostCorrection) throws IOException {
        String fmDirName = NSHM23_DeformationModels.getGeodeticDirForFM(fm);
        Preconditions.checkNotNull((Object)fmDirName, (String)"No geodetic files found for fault model %s of type %s", (Object)fm, (Object)fm.getClass().getName());
        String dmPath = "/data/erf/nshm23/def_models/geodetic/" + fmDirName + "/" + dm.name();
        dmPath = includeGhostCorrection ? dmPath + "-include_ghost_corr.txt" : dmPath + "-no_ghost_corr.txt";
        Map<Integer, List<MinisectionSlipRecord>> dmRecords = geodeticMinisectsCache.get(dmPath);
        if (dmRecords == null) {
            dmRecords = NSHM23_DeformationModels.loadGeodeticModel(dmPath);
            geodeticMinisectsCache.put(dmPath, dmRecords);
        }
        return new HashMap<Integer, List<MinisectionSlipRecord>>(dmRecords);
    }

    private static Map<Integer, List<MinisectionSlipRecord>> loadGeodeticModel(String path) throws IOException {
        System.out.println("Reading deformation model: " + path);
        InputStream stream = NSHM23_DeformationModels.class.getResourceAsStream(path);
        Preconditions.checkNotNull((Object)stream, (String)"Deformation model file not found: %s", (Object)path);
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(stream));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)path);
        return MinisectionSlipRecord.readMinisectionsFile(dmReader);
    }

    private List<? extends FaultSection> buildDeformationModel(RupSetFaultModel faultModel, Map<Integer, List<MinisectionSlipRecord>> dmRecords, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
        MinisectionMappings mappings = new MinisectionMappings(fullSects, subSects);
        Map<Integer, FaultSection> sectsByID = faultModel.getFaultSectionIDMap();
        for (Integer sectID : sectsByID.keySet()) {
            if (dmRecords.containsKey(sectID)) continue;
            System.err.println("WARNING: " + this.name + " is missing data for fault " + sectID + ". " + sectsByID.get(sectID).getSectionName());
        }
        for (Integer parentID : new ArrayList<Integer>(dmRecords.keySet())) {
            if (mappings.areMinisectionDataForParentValid(parentID, dmRecords.get(parentID), true)) continue;
            FaultSection parentSect = sectsByID.get(parentID);
            if (parentSect == null) {
                System.err.println("WARNING: " + this.name() + " removing data for unkown fault with ID=" + parentID);
            } else {
                System.err.println("WARNING: " + this.name() + " does not contain valid data for fault " + parentID + ". " + sectsByID.get(parentID).getSectionName() + ", setting slip rate to 0.");
            }
            dmRecords.remove(parentID);
        }
        dmRecords = this.applyOutlierSubstitution(faultModel, dmRecords);
        mappings.mapDefModelMinisToSubSects(dmRecords);
        return this.applyCreepModel(mappings, this.applyStdDevDefaults(faultModel, subSects));
    }

    public List<? extends FaultSection> applyStdDevDefaults(final RupSetFaultModel faultModel, List<? extends FaultSection> subSects) throws IOException {
        System.out.println("Checking slip rate standard deviations for " + this.name());
        Function<FaultSection, Double> fallbackStdDevFunc = null;
        if (!NSHM23_DeformationModels.isHardcodedFractionalStdDev()) {
            fallbackStdDevFunc = new Function<FaultSection, Double>(){
                private Map<Integer, GeoJSONFaultSection> geoSects = null;
                final /* synthetic */ NSHM23_DeformationModels this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public synchronized Double apply(FaultSection sect) {
                    if (this.geoSects == null) {
                        try {
                            this.geoSects = NSHM23_DeformationModels.getGeolFullSects(faultModel);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                    }
                    FaultSection geoSect = this.geoSects.get(sect.getParentSectionId());
                    Preconditions.checkNotNull((Object)geoSect, (String)"No geologic section found with parent=%s, name=%s", (int)sect.getParentSectionId(), (Object)sect.getParentSectionName());
                    return geoSect.getOrigSlipRateStdDev();
                }
            };
        }
        NSHM23_DeformationModels.applyStdDevDefaults(subSects, fallbackStdDevFunc, "Geologic");
        return subSects;
    }

    public static boolean isHardcodedFractionalStdDev() {
        return HARDCODED_FRACTIONAL_STD_DEV > 0.0;
    }

    public static void applyStdDevDefaults(List<? extends FaultSection> subSects) {
        NSHM23_DeformationModels.applyStdDevDefaults(subSects, null, null);
    }

    public static void applyStdDevDefaults(List<? extends FaultSection> subSects, Function<FaultSection, Double> fallbackStdDevFunc, String fallbackName) {
        if (NSHM23_DeformationModels.isHardcodedFractionalStdDev()) {
            System.out.println("Overriding deformation model slip rates std devs and using hardcoded fractional value: " + HARDCODED_FRACTIONAL_STD_DEV);
            Preconditions.checkState((!(HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND > 0.0) ? 1 : 0) != 0, (Object)"Can't supply both hardcoded fractional std dev, and a fractional upper bound");
        }
        int numZeroSlips = 0;
        int numFallback = 0;
        int numFractDefault = 0;
        int numFloor = 0;
        for (FaultSection faultSection : subSects) {
            double stdDev;
            double slipRate = faultSection.getOrigAveSlipRate();
            Preconditions.checkState((Double.isFinite(slipRate) && slipRate >= 0.0 ? 1 : 0) != 0, (String)"Bad slip rate for %s. %s: %s", (Object)faultSection.getSectionId(), (Object)faultSection.getSectionName(), (Object)slipRate);
            if ((float)slipRate == 0.0f) {
                ++numZeroSlips;
            }
            if (faultSection instanceof GeoJSONFaultSection && slipRate > 0.0) {
                double origStdDev = faultSection.getOrigSlipRateStdDev();
                ((GeoJSONFaultSection)faultSection).setProperty(ORIG_FRACT_STD_DEV_PROPERTY_NAME, origStdDev / slipRate);
            }
            if (NSHM23_DeformationModels.isHardcodedFractionalStdDev()) {
                stdDev = HARDCODED_FRACTIONAL_STD_DEV * slipRate;
            } else {
                stdDev = faultSection.getOrigSlipRateStdDev();
                if (!Double.isFinite(stdDev)) {
                    stdDev = 0.0;
                }
                if (HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND > 0.0) {
                    double floorSD = HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND * slipRate;
                    if ((float)stdDev <= 0.0f || floorSD < stdDev) {
                        stdDev = floorSD;
                    }
                }
                if ((float)stdDev <= 0.0f) {
                    double fallback;
                    if (fallbackStdDevFunc != null && (float)(fallback = fallbackStdDevFunc.apply(faultSection).doubleValue()) > 0.0f) {
                        stdDev = fallback;
                        ++numFallback;
                    }
                    if ((float)stdDev <= 0.0f) {
                        stdDev = slipRate * 0.1;
                        ++numFractDefault;
                    }
                }
            }
            if ((float)stdDev < 1.0E-4f) {
                stdDev = 1.0E-4;
                ++numFloor;
            }
            faultSection.setSlipRateStdDev(stdDev);
        }
        if (numZeroSlips > 0) {
            System.err.println("WARNING: " + numZeroSlips + "/" + subSects.size() + " (" + pDF.format((double)numZeroSlips / (double)subSects.size()) + ") subsection slip rates are 0");
        }
        if (numFallback > 0) {
            System.err.println("WARNING: Set " + numFallback + "/" + subSects.size() + " (" + pDF.format((double)numFallback / (double)subSects.size()) + ") subsection slip rate standard deviations to fallback values (" + fallbackName + ")");
        }
        if (numFractDefault > 0) {
            System.err.println("WARNING: Set " + numFractDefault + "/" + subSects.size() + " (" + pDF.format((double)numFractDefault / (double)subSects.size()) + ") subsection slip rate standard deviations to the default: 0.1 x slipRate");
        }
        if (numFloor > 0) {
            System.err.println("WARNING: Set " + numFloor + "/" + subSects.size() + " (" + pDF.format((double)numFloor / (double)subSects.size()) + ") subsection slip rate standard deviations to the floor value of 1.0E-4 (mm/yr)");
        }
    }

    public List<? extends FaultSection> applyCreepModel(MinisectionMappings mappings, List<? extends FaultSection> subSects) throws IOException {
        String creepPath = "/data/erf/nshm23/def_models/creep/2022_08_17/" + this.name() + ".csv";
        System.out.println("Applying creep model to " + this.name() + " from " + creepPath);
        Map<Integer, List<MinisectionCreepRecord>> creepData = NSHM23_DeformationModels.loadCreepData(creepPath, mappings);
        for (Integer parentID : new ArrayList<Integer>(creepData.keySet())) {
            List<MinisectionCreepRecord> records = creepData.get(parentID);
            int numMissing = 0;
            for (int i = 0; i < records.size(); ++i) {
                if (records.get(i) != null) continue;
                ++numMissing;
                records.set(i, new MinisectionCreepRecord(parentID, i, null, null, 0.0));
            }
            if (numMissing > 0) {
                System.err.println("WARNING: " + this.name() + " is missing creep data for " + numMissing + "/" + records.size() + " minisections on " + parentID + ", assuming creep rate is [" + (float)CREEP_FRACT_DEFAULT + " x slip_rate] on those minisections");
            }
            if (mappings.areMinisectionDataForParentValid(parentID, records, true)) continue;
            if (!mappings.hasParent(parentID)) {
                System.err.println("WARNING: " + this.name() + " removing creep data for unkown fault with ID=" + parentID);
            } else {
                System.err.println("WARNING: " + this.name() + " does not contain valid creep data for fault " + parentID + ", setting creep to default");
            }
            creepData.remove(parentID);
        }
        int numCreepDefault = 0;
        int numNonzeroData = 0;
        int numAboveCeiling = 0;
        DataUtils.MinMaxAveTracker creepFractTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker aseisTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker couplingTrack = new DataUtils.MinMaxAveTracker();
        for (int s = 0; s < subSects.size(); ++s) {
            double creepRate;
            FaultSection subSect = subSects.get(s);
            int parentID = subSect.getParentSectionId();
            if (creepData.containsKey(parentID)) {
                List<MinisectionCreepRecord> records = creepData.get(parentID);
                ArrayList<Double> values = new ArrayList<Double>(records.size());
                boolean allDefault = true;
                for (MinisectionCreepRecord record : records) {
                    double recordVal;
                    if (record == null) {
                        recordVal = CREEP_FRACT_DEFAULT * subSect.getOrigAveSlipRate();
                    } else {
                        recordVal = record.creepRate;
                        allDefault = false;
                    }
                    values.add(recordVal);
                }
                if (allDefault) {
                    creepRate = Double.NaN;
                    ++numCreepDefault;
                } else {
                    creepRate = mappings.getAssociationScaledAverage(s, values);
                    Preconditions.checkState((boolean)(subSect instanceof GeoJSONFaultSection));
                    ((GeoJSONFaultSection)subSect).setProperty("CreepRate", creepRate);
                    if (creepRate > 0.0) {
                        ++numNonzeroData;
                    }
                }
            } else {
                creepRate = Double.NaN;
                ++numCreepDefault;
            }
            this.applyCreepData(subSect, creepRate, creepFractTrack, aseisTrack, couplingTrack);
            if (!(subSect.getCouplingCoeff() < 1.0)) continue;
            ++numAboveCeiling;
        }
        System.out.println("Done applying creep data, stats:");
        System.out.println("\t" + numCreepDefault + "/" + subSects.size() + " (" + pDF.format((double)numCreepDefault / (double)subSects.size()) + ") subsections set to default creep reduction of " + (float)CREEP_FRACT_DEFAULT);
        System.out.println("\t" + numNonzeroData + "/" + subSects.size() + " (" + pDF.format((double)numNonzeroData / (double)subSects.size()) + ") subsections had supplied creep rates >0");
        System.out.println("\t" + numAboveCeiling + "/" + subSects.size() + " (" + pDF.format((double)numAboveCeiling / (double)subSects.size()) + ") subsections had creep rates above the aseismicity ceiling, >" + (float)ASEIS_CEILING);
        System.out.println("\tCreep reduction range: [" + (float)creepFractTrack.getMin() + "," + (float)creepFractTrack.getMax() + "], avg=" + (float)creepFractTrack.getAverage());
        System.out.println("\tAseismicity range: [" + (float)aseisTrack.getMin() + "," + (float)aseisTrack.getMax() + "], avg=" + (float)aseisTrack.getAverage());
        System.out.println("\tCoupling coefficient range: [" + (float)couplingTrack.getMin() + "," + (float)couplingTrack.getMax() + "], avg=" + (float)couplingTrack.getAverage());
        return subSects;
    }

    protected void applyCreepData(FaultSection subSect, double creepRate) {
        this.applyCreepData(subSect, creepRate, null, null, null);
    }

    private void applyCreepData(FaultSection subSect, double creepRate, DataUtils.MinMaxAveTracker creepFractTrack, DataUtils.MinMaxAveTracker aseisTrack, DataUtils.MinMaxAveTracker couplingTrack) {
        double coupling;
        double aseis;
        double creepFract;
        int s = subSect.getSectionId();
        String subSectName = subSect.getSectionName();
        if (Double.isFinite(creepRate)) {
            if (creepRate < 0.0) {
                creepRate = 0.0;
                System.err.println("WARNING: Setting negative creep rate (" + (float)creepRate + ") to 0 for " + this.name() + ", " + subSect.getSectionId() + ". " + subSect.getName());
            }
            Preconditions.checkState((creepRate >= 0.0 ? 1 : 0) != 0, (String)"Bad creep rate for %s. %s", (int)s, (Object)subSectName);
            double slipRate = subSect.getOrigAveSlipRate();
            if (slipRate == 0.0) {
                creepFract = 0.0;
            } else {
                if (creepRate > slipRate) {
                    System.err.println("WARNING: creep rate is greater than slip rate for section " + s + ". " + subSectName + ": " + (float)creepRate + " > " + (float)slipRate);
                    creepRate = slipRate;
                }
                creepFract = creepRate / slipRate;
            }
        } else {
            creepFract = CREEP_FRACT_DEFAULT;
        }
        if (creepFract < ASEIS_CEILING) {
            aseis = creepFract;
            coupling = 1.0;
        } else {
            aseis = ASEIS_CEILING;
            coupling = 1.0 - 1.0 / (1.0 - ASEIS_CEILING) * (creepFract - ASEIS_CEILING);
        }
        Preconditions.checkState((aseis >= 0.0 && aseis <= ASEIS_CEILING ? 1 : 0) != 0, (String)"Bad computed aseismicity value (%s) from creepFract=%s, aseisCeiling=%s", (Object)aseis, (Object)creepFract, (Object)ASEIS_CEILING);
        Preconditions.checkState((coupling >= 0.0 && coupling <= 1.0 ? 1 : 0) != 0, (String)"Bad computed coupling coefficient (%s) from creepFract=%s, aseisCeiling=%s", (Object)coupling, (Object)creepFract, (Object)ASEIS_CEILING);
        if (creepFractTrack != null) {
            creepFractTrack.addValue(creepFract);
        }
        if (aseisTrack != null) {
            aseisTrack.addValue(aseis);
        }
        if (couplingTrack != null) {
            couplingTrack.addValue(coupling);
        }
        subSect.setAseismicSlipFactor(aseis);
        subSect.setCouplingCoeff(coupling);
    }

    private static Map<Integer, List<MinisectionCreepRecord>> loadCreepData(String creepPath, MinisectionMappings mappings) throws IOException {
        CSVFile<String> csv;
        try {
            csv = CSVFile.readStream(NSHM23_DeformationModels.class.getResourceAsStream(creepPath), true);
        }
        catch (IOException e) {
            System.err.println("ERROR: couldn't load creep data from " + creepPath);
            throw e;
        }
        HashMap<Integer, List<MinisectionCreepRecord>> ret = new HashMap<Integer, List<MinisectionCreepRecord>>();
        int numNegative = 0;
        for (int row = 0; row < csv.getNumRows(); ++row) {
            int parentID = csv.getInt(row, 0);
            int minisectionID = csv.getInt(row, 1);
            double creepRate = csv.getDouble(row, 2);
            Preconditions.checkState((boolean)Double.isFinite(creepRate), (String)"Bad creepRate=%s for minisections=%s.%s", (Object)creepRate, (Object)parentID, (Object)minisectionID);
            if ((float)creepRate < 0.0f) {
                ++numNegative;
            }
            Location startLoc = null;
            Location endLoc = null;
            ArrayList<MinisectionCreepRecord> parentRecs = (ArrayList<MinisectionCreepRecord>)ret.get(parentID);
            int numMinisections = mappings.getNumMinisectionsForParent(parentID);
            if (parentRecs == null) {
                parentRecs = new ArrayList<MinisectionCreepRecord>(numMinisections);
                for (int i = 0; i < numMinisections; ++i) {
                    parentRecs.add(null);
                }
                ret.put(parentID, parentRecs);
            }
            Preconditions.checkState((minisectionID <= numMinisections ? 1 : 0) != 0, (String)"Fault %s should have %s minisections, but encountered one with ID=%s", (Object)parentID, (Object)numMinisections, (Object)minisectionID);
            parentRecs.set(--minisectionID, new MinisectionCreepRecord(parentID, minisectionID, startLoc, endLoc, creepRate));
        }
        if (numNegative > 0) {
            System.err.println("WARNING: " + numNegative + " negative minisection creep values in " + creepPath);
        }
        return ret;
    }

    private static synchronized Map<Integer, List<MinisectionOutlierStatistics>> calcOutlierStats(RupSetFaultModel fm) throws IOException {
        Map<Integer, List<MinisectionOutlierStatistics>> madMap = minisectionOutlierStats.get(fm);
        if (madMap != null) {
            return madMap;
        }
        Map<Integer, FaultSection> fmSectsByID = fm.getFaultSectionIDMap();
        ArrayList<Map<Integer, List<MinisectionSlipRecord>>> dmMinisectionRecords = new ArrayList<Map<Integer, List<MinisectionSlipRecord>>>();
        Set<Integer> keys = null;
        for (NSHM23_DeformationModels dm : NSHM23_DeformationModels.values()) {
            Map<Integer, List<MinisectionSlipRecord>> dmRecs;
            if (dm.getWeight() == 0.0 || dm == MEDIAN || dm == AVERAGE) continue;
            if (dm == GEOLOGIC) {
                Map<Integer, GeoJSONFaultSection> geoSects = NSHM23_DeformationModels.getGeolFullSects(fm);
                dmRecs = NSHM23_DeformationModels.geoSectsToMinis(geoSects);
            } else {
                dmRecs = NSHM23_DeformationModels.loadGeodeticModel(fm, dm, GEODETIC_INCLUDE_GHOST_TRANSIENT);
                for (Integer id : new ArrayList<Integer>(dmRecs.keySet())) {
                    if (fmSectsByID.containsKey(id)) continue;
                    dmRecs.remove(id);
                }
            }
            if (keys == null) {
                keys = dmRecs.keySet();
            } else {
                Preconditions.checkState((boolean)keys.equals(dmRecs.keySet()), (String)"Keys mismatch, first size=%s, %s size=%s", (Object)keys.size(), (Object)dm.name(), (Object)dmRecs.keySet().size());
            }
            dmMinisectionRecords.add(dmRecs);
        }
        madMap = new HashMap<Integer, List<MinisectionOutlierStatistics>>(keys.size());
        double[] slips = new double[dmMinisectionRecords.size()];
        double[] deviations = new double[dmMinisectionRecords.size()];
        for (Integer faultID : keys) {
            List refRecs = (List)((Map)dmMinisectionRecords.get(0)).get(faultID);
            int numMinis = refRecs.size();
            ArrayList<MinisectionOutlierStatistics> stats = new ArrayList<MinisectionOutlierStatistics>(numMinis);
            for (int i = 0; i < numMinis; ++i) {
                for (int j = 0; j < slips.length; ++j) {
                    slips[j] = ((MinisectionSlipRecord)((List)((Map)dmMinisectionRecords.get((int)j)).get((Object)faultID)).get((int)i)).slipRate;
                }
                double median = DataUtils.median(slips);
                for (int j = 0; j < slips.length; ++j) {
                    deviations[j] = Math.abs(slips[j] - median);
                }
                double mad = DataUtils.median(deviations);
                for (int j = 0; j < slips.length; ++j) {
                    if (slips[j] == 0.0 || median == 0.0) {
                        if (slips[j] == 0.0 && median == 0.0) {
                            deviations[j] = 0.0;
                            continue;
                        }
                        deviations[j] = Double.POSITIVE_INFINITY;
                        continue;
                    }
                    deviations[j] = Math.abs(Math.log(slips[j]) - Math.log(median));
                }
                double logMAD = DataUtils.median(deviations);
                MinisectionSlipRecord refRec = (MinisectionSlipRecord)refRecs.get(i);
                stats.add(new MinisectionOutlierStatistics(faultID, i, refRec.startLoc, refRec.endLoc, median, mad, logMAD));
            }
            madMap.put(faultID, stats);
        }
        return madMap;
    }

    private Map<Integer, List<MinisectionSlipRecord>> applyOutlierSubstitution(RupSetFaultModel fm, Map<Integer, List<MinisectionSlipRecord>> dmRecs) throws IOException {
        if (OUTLIER_SUB_YC == null || OUTLIER_SUB_YC <= 0.0) {
            return dmRecs;
        }
        double yc = OUTLIER_SUB_YC;
        boolean log = OUTLIER_SUB_LOG;
        return NSHM23_DeformationModels.applyOutlierSubstitution(fm, dmRecs, yc, log);
    }

    public static Map<Integer, List<MinisectionSlipRecord>> applyOutlierSubstitution(RupSetFaultModel fm, Map<Integer, List<MinisectionSlipRecord>> dmRecs, double yc, boolean log) throws IOException {
        Map<Integer, List<MinisectionOutlierStatistics>> outlierStats = NSHM23_DeformationModels.calcOutlierStats(fm);
        HashMap<Integer, List<MinisectionSlipRecord>> ret = new HashMap<Integer, List<MinisectionSlipRecord>>(dmRecs.size());
        int numSlipSubs = 0;
        int numMinis = 0;
        for (Integer faultID : dmRecs.keySet()) {
            List<MinisectionSlipRecord> records = dmRecs.get(faultID);
            List<MinisectionOutlierStatistics> stats = outlierStats.get(faultID);
            Preconditions.checkNotNull(stats, (String)"No outlier stats for %s?", (Object)faultID);
            Preconditions.checkState((stats.size() == records.size() ? 1 : 0) != 0, (String)"Have %s minisections for %s, but %s outlier records", (Object)records.size(), (Object)faultID, (Object)stats.size());
            ArrayList<MinisectionSlipRecord> modRecords = new ArrayList<MinisectionSlipRecord>(records.size());
            for (int i = 0; i < records.size(); ++i) {
                double slipMAD;
                double slipMedian;
                double slipRate;
                MinisectionSlipRecord rec = records.get(i);
                MinisectionOutlierStatistics stat = stats.get(i);
                if (log) {
                    slipRate = Math.log(rec.slipRate);
                    slipMedian = Math.log(stat.slipMedian);
                    slipMAD = stat.logSlipMAD;
                } else {
                    slipRate = rec.slipRate;
                    slipMedian = stat.slipMedian;
                    slipMAD = stat.slipMAD;
                }
                double y = 0.6745 * (slipRate - slipMedian) / slipMAD;
                if (Math.abs(y) > yc) {
                    double revised;
                    if (OUTLIER_SUB_USE_BOUND) {
                        y = y > 0.0 ? yc : -yc;
                        revised = slipMAD * y / 0.6745 + slipMedian;
                        revised = log ? Math.exp(revised) : Math.max(0.0, revised);
                    } else {
                        revised = stat.slipMedian;
                    }
                    rec = new MinisectionSlipRecord(faultID, i, rec.startLoc, rec.endLoc, rec.rake, revised, rec.slipRateStdDev);
                    ++numSlipSubs;
                }
                modRecords.add(rec);
                ++numMinis;
            }
            ret.put(faultID, modRecords);
        }
        System.out.println("Substituted " + numSlipSubs + "/" + numMinis + " (" + pDF.format((double)numSlipSubs / (double)numMinis) + ") outlier slip rates with median, Yc=" + (float)yc);
        return ret;
    }

    public static Map<Integer, List<MinisectionSlipRecord>> averageMinisections(List<Map<Integer, List<MinisectionSlipRecord>>> dmMaps, List<Double> dmWeights) {
        HashSet<Integer> ids = null;
        double totWeight = 0.0;
        for (int i = 0; i < dmMaps.size(); ++i) {
            Map<Integer, List<MinisectionSlipRecord>> dmMinis = dmMaps.get(i);
            totWeight += dmWeights.get(i).doubleValue();
            if (ids == null) {
                ids = new HashSet<Integer>(dmMinis.keySet());
                continue;
            }
            ids.retainAll(dmMinis.keySet());
        }
        HashMap<Integer, List<MinisectionSlipRecord>> ret = new HashMap<Integer, List<MinisectionSlipRecord>>();
        for (Integer id : ids) {
            List<MinisectionSlipRecord> refRecs = dmMaps.get(0).get(id);
            ArrayList<MinisectionSlipRecord> avgRecs = new ArrayList<MinisectionSlipRecord>(refRecs.size());
            for (int i = 0; i < refRecs.size(); ++i) {
                MinisectionSlipRecord refRec = refRecs.get(i);
                double avgSlip = 0.0;
                double avgSlipSD = 0.0;
                FaultUtils.AngleAverager rakeAverager = new FaultUtils.AngleAverager();
                for (int j = 0; j < dmMaps.size(); ++j) {
                    MinisectionSlipRecord rec = dmMaps.get(j).get(id).get(i);
                    double weight = dmWeights.get(j);
                    avgSlip += weight * rec.slipRate;
                    avgSlipSD += weight * rec.slipRateStdDev;
                    rakeAverager.add(rec.rake, weight);
                }
                double avgRake = rakeAverager.getAverage();
                avgRecs.add(new MinisectionSlipRecord(id, i, refRec.startLoc, refRec.endLoc, avgRake, avgSlip /= totWeight, avgSlipSD /= totWeight));
            }
            ret.put(id, avgRecs);
        }
        return ret;
    }

    private static void checkForNegativeAndHighCreep(NSHM23_FaultModels fm) throws IOException {
        ArrayList dms;
        HashMap<NSHM23_DeformationModels, Map<Object, Object>> dmSlipRecs = new HashMap<NSHM23_DeformationModels, Map<Object, Object>>();
        HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionCreepRecord>>> dmCreepRecs = new HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionCreepRecord>>>();
        List<? extends FaultSection> geoSects = NSHM23_DeformationModels.buildGeolFullSects(fm, GEOLOGIC_VERSION);
        List<FaultSection> subSects = SubSectionBuilder.buildSubSects(geoSects);
        MinisectionMappings mappings = new MinisectionMappings(geoSects, subSects);
        for (NSHM23_DeformationModels nSHM23_DeformationModels : NSHM23_DeformationModels.values()) {
            if (!nSHM23_DeformationModels.isApplicableTo(fm) || !(nSHM23_DeformationModels.getWeight() > 0.0)) continue;
            if (nSHM23_DeformationModels == GEOLOGIC) {
                HashMap fakeRecs = new HashMap();
                for (FaultSection faultSection : geoSects) {
                    int parentID = faultSection.getSectionId();
                    FaultTrace trace = faultSection.getFaultTrace();
                    ArrayList<MinisectionSlipRecord> recs = new ArrayList<MinisectionSlipRecord>(trace.size() - 1);
                    for (int i = 1; i < trace.size(); ++i) {
                        Location loc1 = (Location)trace.get(i - 1);
                        Location loc2 = (Location)trace.get(i);
                        recs.add(new MinisectionSlipRecord(parentID, i, loc1, loc2, faultSection.getAveRake(), faultSection.getOrigAveSlipRate(), faultSection.getOrigSlipRateStdDev()));
                    }
                    fakeRecs.put(parentID, recs);
                }
                dmSlipRecs.put(nSHM23_DeformationModels, fakeRecs);
            } else {
                String dmPath = "/data/erf/nshm23/def_models/geodetic/" + NSHM23_DeformationModels.getGeodeticDirForFM(fm) + "/" + nSHM23_DeformationModels.name();
                dmPath = GEODETIC_INCLUDE_GHOST_TRANSIENT ? dmPath + "-include_ghost_corr.txt" : dmPath + "-no_ghost_corr.txt";
                dmSlipRecs.put(nSHM23_DeformationModels, NSHM23_DeformationModels.loadGeodeticModel(dmPath));
            }
            String creepPath = "/data/erf/nshm23/def_models/creep/2022_08_17/" + nSHM23_DeformationModels.name() + ".csv";
            dmCreepRecs.put(nSHM23_DeformationModels, NSHM23_DeformationModels.loadCreepData(creepPath, mappings));
        }
        HashMap creepBelowZeroes = new HashMap();
        HashMap creepAboveSlips = new HashMap();
        for (FaultSection faultSection : geoSects) {
            String name = faultSection.getSectionId() + ". " + faultSection.getSectionName();
            for (NSHM23_DeformationModels dm : NSHM23_DeformationModels.values()) {
                List creepRecs;
                if (!dmSlipRecs.containsKey(dm) || (creepRecs = (List)((Map)dmCreepRecs.get(dm)).get(faultSection.getSectionId())) == null) continue;
                List slipRecs = (List)((Map)dmSlipRecs.get(dm)).get(faultSection.getSectionId());
                Preconditions.checkState((creepRecs.size() == slipRecs.size() ? 1 : 0) != 0);
                for (int i = 0; i < slipRecs.size(); ++i) {
                    MinisectionSlipRecord slip = (MinisectionSlipRecord)slipRecs.get(i);
                    MinisectionCreepRecord creep = (MinisectionCreepRecord)creepRecs.get(i);
                    if (creep == null) continue;
                    if (creep.creepRate < 0.0) {
                        if (!creepBelowZeroes.containsKey(name)) {
                            creepBelowZeroes.put((CallSite)((Object)name), new HashSet());
                        }
                        ((HashSet)creepBelowZeroes.get(name)).add(dm);
                    }
                    if (!((float)creep.creepRate > (float)slip.slipRate)) continue;
                    if (!creepAboveSlips.containsKey(name)) {
                        creepAboveSlips.put((CallSite)((Object)name), new HashSet());
                    }
                    ((HashSet)creepAboveSlips.get(name)).add(dm);
                }
            }
        }
        if (!creepBelowZeroes.isEmpty()) {
            System.out.println("Faults with creep rates < 0:");
            for (String string : creepBelowZeroes.keySet()) {
                dms = new ArrayList((Collection)creepBelowZeroes.get(string));
                Collections.sort(dms);
                System.out.print("\t" + string + ":\t");
                for (int i = 0; i < dms.size(); ++i) {
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(((NSHM23_DeformationModels)dms.get(i)).name());
                }
                System.out.println();
            }
        }
        if (!creepAboveSlips.isEmpty()) {
            System.out.println("Faults with creep rates > slip rates:");
            for (String string : creepAboveSlips.keySet()) {
                dms = new ArrayList((Collection)creepAboveSlips.get(string));
                Collections.sort(dms);
                System.out.print("\t" + string + ":\t");
                for (int i = 0; i < dms.size(); ++i) {
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(((NSHM23_DeformationModels)dms.get(i)).name());
                }
                System.out.println();
            }
        }
    }

    private static void writeMedianDM(File outputDir) throws IOException {
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v2;
        List<? extends FaultSection> geoSects = NSHM23_DeformationModels.buildGeolFullSects(fm, GEOLOGIC_VERSION);
        geoSects = new ArrayList<FaultSection>(geoSects);
        geoSects.sort((Comparator<? extends FaultSection>)new Comparator<FaultSection>(){

            @Override
            public int compare(FaultSection o1, FaultSection o2) {
                return Integer.compare(o1.getSectionId(), o2.getSectionId());
            }
        });
        HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionSlipRecord>>> geodeticRecords = new HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionSlipRecord>>>();
        HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionCreepRecord>>> creepRecords = new HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionCreepRecord>>>();
        NSHM23_DeformationModels[] models = new NSHM23_DeformationModels[]{GEOLOGIC, EVANS, POLLITZ, SHEN_BIRD, ZENG};
        MinisectionMappings mappings = new MinisectionMappings(geoSects, GEOLOGIC.build(fm, null));
        for (NSHM23_DeformationModels model : models) {
            if (model != GEOLOGIC) {
                String fmDirName = NSHM23_DeformationModels.getGeodeticDirForFM(fm);
                String dmPath = "/data/erf/nshm23/def_models/geodetic/" + fmDirName + "/" + model.name() + "-include_ghost_corr.txt";
                geodeticRecords.put(model, NSHM23_DeformationModels.loadGeodeticModel(dmPath));
            }
            String creepPath = "/data/erf/nshm23/def_models/creep/2022_08_17/" + model.name() + ".csv";
            creepRecords.put(model, NSHM23_DeformationModels.loadCreepData(creepPath, mappings));
        }
        FileWriter dmFW = new FileWriter(new File(outputDir, "MEDIAN-include_ghost_corr.txt"));
        dmFW.write("#FaultID\tMinisectionID\tStartLat\tStartLon\tEndLat\tEndLon\tRake\tSlipRate(mm/y)\tStdDev\n");
        CSVFile<String> creepCSV = new CSVFile<String>(true);
        for (int i = 0; i < geoSects.size(); ++i) {
            FaultSection sect = geoSects.get(i);
            int sectID = sect.getSectionId();
            double geoSlip = sect.getOrigAveSlipRate();
            double geoSD = sect.getOrigSlipRateStdDev();
            double geoRake = sect.getAveRake();
            FaultTrace trace = sect.getFaultTrace();
            for (int mini = 0; mini < mappings.getNumMinisectionsForParent(sect.getSectionId()); ++mini) {
                String line = sect.getSectionId() + "\t" + (mini + 1);
                Location p1 = (Location)trace.get(mini);
                Location p2 = (Location)trace.get(mini + 1);
                line = line + "\t" + (float)p1.getLatitude() + "\t" + (float)p1.getLongitude();
                line = line + "\t" + (float)p2.getLatitude() + "\t" + (float)p2.getLongitude();
                line = line + "\t" + (float)geoRake;
                double[] slips = new double[models.length];
                double[] creepFracts = new double[slips.length];
                boolean hasCreep = false;
                for (int m = 0; m < models.length; ++m) {
                    MinisectionCreepRecord miniCreep;
                    slips[m] = models[m] == GEOLOGIC ? geoSlip : ((MinisectionSlipRecord)((List)((Map)geodeticRecords.get((Object)models[m])).get((Object)Integer.valueOf((int)sectID))).get((int)mini)).slipRate;
                    List sectCreeps = (List)((Map)creepRecords.get(models[m])).get(sectID);
                    if (sectCreeps == null || (miniCreep = (MinisectionCreepRecord)sectCreeps.get(mini)) == null) continue;
                    hasCreep = true;
                    creepFracts[m] = Math.min(1.0, miniCreep.creepRate / slips[m]);
                }
                double medianSlip = DataUtils.median(slips);
                line = line + "\t" + (float)medianSlip;
                line = line + "\t" + (float)geoSD;
                if (hasCreep) {
                    double medianCreepFract = DataUtils.median(creepFracts);
                    creepCSV.addLine("" + sectID, "" + (mini + 1), "" + (float)(medianCreepFract * medianSlip));
                }
                dmFW.write(line + "\n");
            }
        }
        dmFW.close();
        creepCSV.writeToFile(new File(outputDir, "MEDIAN.csv"));
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMinisectionCSV(File outputFile) throws IOException {
        void var8_10;
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v2;
        List<? extends FaultSection> geoSects = NSHM23_DeformationModels.buildGeolFullSects(fm, GEOLOGIC_VERSION);
        geoSects = new ArrayList<FaultSection>(geoSects);
        geoSects.sort((Comparator<? extends FaultSection>)new Comparator<FaultSection>(){

            @Override
            public int compare(FaultSection o1, FaultSection o2) {
                return Integer.compare(o1.getSectionId(), o2.getSectionId());
            }
        });
        NSHM23_DeformationModels[] geodeticModels = new NSHM23_DeformationModels[]{EVANS, POLLITZ, SHEN_BIRD, ZENG, MEDIAN};
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<String> header = new ArrayList<String>(List.of("Section ID", "Section Name", "Minisection ID", "Start Lat", "Start Lon", "End Lat", "End Lon", "Geologic Slip Rate (mm/yr)", "Geologic Lower Bound (mm/yr)", "Geologic Upper Bound (mm/yr)", "Geologic Rake"));
        NSHM23_DeformationModels[] nSHM23_DeformationModelsArray = geodeticModels;
        int n = nSHM23_DeformationModelsArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            NSHM23_DeformationModels dm = nSHM23_DeformationModelsArray[var8_10];
            header.add(dm.getShortName() + " Slip Rate (mm/yr)");
            header.add(dm.getShortName() + " Rake");
            ++var8_10;
        }
        csv.addLine((List<String>)header);
        HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionSlipRecord>>> geodeticRecords = new HashMap<NSHM23_DeformationModels, Map<Integer, List<MinisectionSlipRecord>>>();
        for (NSHM23_DeformationModels model : geodeticModels) {
            String fmDirName = NSHM23_DeformationModels.getGeodeticDirForFM(fm);
            String dmPath = "/data/erf/nshm23/def_models/geodetic/" + fmDirName + "/" + model.name() + "-include_ghost_corr.txt";
            geodeticRecords.put(model, NSHM23_DeformationModels.loadGeodeticModel(dmPath));
        }
        for (FaultSection faultSection : geoSects) {
            GeoJSONFaultSection geoSect = (GeoJSONFaultSection)faultSection;
            FaultTrace trace = faultSection.getFaultTrace();
            int numMinis = trace.size() - 1;
            for (int i = 0; i < numMinis; ++i) {
                ArrayList<Object> line = new ArrayList<Object>(header.size());
                line.add("" + faultSection.getSectionId());
                line.add(faultSection.getSectionName());
                line.add("" + (i + 1));
                Location l1 = (Location)trace.get(i);
                Location l2 = (Location)trace.get(i + 1);
                line.add("" + (float)l1.getLatitude());
                line.add("" + (float)l1.getLongitude());
                line.add("" + (float)l2.getLatitude());
                line.add("" + (float)l2.getLongitude());
                line.add("" + (float)faultSection.getOrigAveSlipRate());
                line.add("" + geoSect.getProperty("LowRate", Double.NaN).floatValue());
                line.add("" + geoSect.getProperty("HighRate", Double.NaN).floatValue());
                line.add("" + (float)geoSect.getAveRake());
                for (NSHM23_DeformationModels dm : geodeticModels) {
                    List recs = (List)((Map)geodeticRecords.get(dm)).get(faultSection.getSectionId());
                    MinisectionSlipRecord rec = (MinisectionSlipRecord)recs.get(i);
                    line.add("" + (float)rec.slipRate);
                    line.add("" + (float)rec.rake);
                }
                csv.addLine((List<String>)line);
            }
        }
        csv.writeToFile(outputFile);
    }

    private static void printSlipRateSubSectBelow10Stats() throws IOException {
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v2;
        ArrayList<NSHM23_DeformationModels> dms = new ArrayList<NSHM23_DeformationModels>();
        ArrayList<List<FaultSection>> dmSects = new ArrayList<List<FaultSection>>();
        for (NSHM23_DeformationModels dm : NSHM23_DeformationModels.values()) {
            if (dm.getWeight() == 0.0 && dm != AVERAGE) continue;
            List<FaultSection> sects = dm.build(fm, null);
            dms.add(dm);
            dmSects.add(sects);
        }
        for (int d = 0; d < dms.size(); ++d) {
            NSHM23_DeformationModels dm = (NSHM23_DeformationModels)dms.get(d);
            List sects = (List)dmSects.get(d);
            int numBelow10 = 0;
            DataUtils.MinMaxAveTracker below10SlipTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker allSlipTrack = new DataUtils.MinMaxAveTracker();
            for (FaultSection sect : sects) {
                GeoJSONFaultSection geoSect = (GeoJSONFaultSection)sect;
                double origFract = geoSect.getProperty(ORIG_FRACT_STD_DEV_PROPERTY_NAME, Double.NaN);
                if (origFract > 0.0 && origFract < 0.1) {
                    ++numBelow10;
                    below10SlipTrack.addValue(sect.getOrigAveSlipRate());
                }
                allSlipTrack.addValue(sect.getOrigAveSlipRate());
            }
            System.out.println(dm.name);
            System.out.println("\t" + numBelow10 + "/" + sects.size() + " (" + pDF.format((double)numBelow10 / (double)sects.size()) + ") sections have uncert <10%");
            System.out.println("\tOverall average slip rate: " + (float)allSlipTrack.getAverage() + " (mm/yr)");
            System.out.println("\tUncert <10% aerage slip rate: " + (float)below10SlipTrack.getAverage() + " (mm/yr)");
        }
    }

    private static void printSlipRateCOVStats() throws IOException {
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v2;
        Map<Integer, FaultSection> sectsMap = fm.getFaultSectionIDMap();
        for (NSHM23_DeformationModels dm : NSHM23_DeformationModels.values()) {
            if (dm.getWeight() == 0.0 && dm != AVERAGE) continue;
            Map<Integer, List<MinisectionSlipRecord>> minis = dm.getMinisections(fm);
            double areaWeightedAvg = 0.0;
            double sumArea = 0.0;
            double momentWeightedAvg = 0.0;
            double sumMoment = 0.0;
            double momentWeightedAbove10Avg = 0.0;
            double sumMomentAbove10 = 0.0;
            for (Integer sectID : sectsMap.keySet()) {
                FaultSection sect = sectsMap.get(sectID);
                double ddw = sect.getOrigDownDipWidth() * 1000.0;
                List<MinisectionSlipRecord> recs = minis.get(sectID);
                if (recs == null) continue;
                for (MinisectionSlipRecord rec : recs) {
                    double slipCOV = Math.max(1.0E-4, rec.slipRateStdDev) / rec.slipRate;
                    if (!Double.isFinite(slipCOV) || !(slipCOV > 0.0)) continue;
                    double len = LocationUtils.horzDistanceFast(rec.startLoc, rec.endLoc) * 1000.0;
                    double area = len * ddw;
                    double moRate = FaultMomentCalc.getMoment(area, rec.slipRate * 0.001);
                    areaWeightedAvg += area * slipCOV;
                    sumArea += area;
                    momentWeightedAvg += moRate * slipCOV;
                    sumMoment += moRate;
                    if (!(rec.slipRate >= 10.0)) continue;
                    momentWeightedAbove10Avg += moRate * slipCOV;
                    sumMomentAbove10 += moRate;
                }
            }
            System.out.println(dm.shortName + " COV stats:");
            System.out.println("\tArea weighted: " + (areaWeightedAvg /= sumArea));
            System.out.println("\tMoment-rate weighted: " + (momentWeightedAvg /= sumMoment));
            System.out.println("\tMoment-rate weighted (min 10 mm/yr): " + (momentWeightedAbove10Avg /= sumMomentAbove10));
        }
    }

    public static void main(String[] args) throws IOException {
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v2;
        List<? extends FaultSection> geoFull = NSHM23_DeformationModels.buildGeolFullSects(fm, GEOLOGIC_VERSION);
        GeoJSONFaultReader.writeFaultSections(new File("/tmp/" + GEOLOGIC.getFilePrefix() + "_sects.geojson"), geoFull);
        for (NSHM23_DeformationModels dm : NSHM23_DeformationModels.values()) {
            if (!dm.isApplicableTo(fm)) continue;
            System.out.println("************************");
            System.out.println("Building " + dm.name);
            List<FaultSection> subSects = dm.build(fm, null);
            GeoJSONFaultReader.writeFaultSections(new File("/tmp/" + dm.getFilePrefix() + "_sub_sects.geojson"), subSects);
            System.err.flush();
            System.out.flush();
            System.out.println("************************");
        }
        NSHM23_DeformationModels.writeMinisectionCSV(new File("/tmp/nshm23_def_model_minisections.csv"));
        NSHM23_DeformationModels.printSlipRateCOVStats();
        NSHM23_DeformationModels.printSlipRateSubSectBelow10Stats();
    }

    static {
        ORIGINAL_WEIGHTS = false;
        OUTLIER_SUB_YC = null;
        OUTLIER_SUB_LOG = false;
        OUTLIER_SUB_USE_BOUND = false;
        GEODETIC_INCLUDE_GHOST_TRANSIENT = true;
        HARDCODED_FRACTIONAL_STD_DEV = 0.0;
        HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND = 0.1;
        ASEIS_CEILING = 0.4;
        CREEP_FRACT_DEFAULT = 0.1;
        geologicSectsCache = new HashMap<RupSetFaultModel, Map<Integer, GeoJSONFaultSection>>();
        geodeticMinisectsCache = new HashMap<String, Map<Integer, List<MinisectionSlipRecord>>>();
        pDF = new DecimalFormat("0.00%");
        minisectionOutlierStats = new HashMap<RupSetFaultModel, Map<Integer, List<MinisectionOutlierStatistics>>>();
    }

    private static class MinisectionOutlierStatistics
    extends AbstractMinisectionDataRecord {
        private final double slipMedian;
        private final double slipMAD;
        private final double logSlipMAD;

        public MinisectionOutlierStatistics(int parentID, int minisectionID, Location startLoc, Location endLoc, double slipMedian, double slipMAD, double logSlipMAD) {
            super(parentID, minisectionID, startLoc, endLoc);
            this.slipMedian = slipMedian;
            this.slipMAD = slipMAD;
            this.logSlipMAD = logSlipMAD;
        }
    }
}

