/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_InvConfigFactory;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum NSHM23_RegionalSeismicity implements LogicTreeNode
{
    PREFFERRED("Preffered Seismicity Rate", "PrefSeis", 0.74){

        @Override
        public IncrementalMagFreqDist build(NSHM23_RegionLoader.SeismicityRegions region, EvenlyDiscretizedFunc refMFD, double mMax) {
            if (NSHM23_RegionalSeismicity.hasRegion(region)) {
                double rate = NSHM23_RegionalSeismicity.loadRate(region, 0);
                double b = NSHM23_RegionalSeismicity.loadBVal(region, 0);
                return NSHM23_RegionalSeismicity.gr(refMFD, mMax, rate, b);
            }
            return null;
        }
    }
    ,
    LOW("Lower Seismicity Bound (p2.5)", "LowSeis", 0.13){

        @Override
        public IncrementalMagFreqDist build(NSHM23_RegionLoader.SeismicityRegions region, EvenlyDiscretizedFunc refMFD, double mMax) {
            if (NSHM23_RegionalSeismicity.hasRegion(region)) {
                double rate = NSHM23_RegionalSeismicity.loadRate(region, 1);
                double b = NSHM23_RegionalSeismicity.loadBVal(region, 1);
                return NSHM23_RegionalSeismicity.adjustForCrossover(NSHM23_RegionalSeismicity.gr(refMFD, mMax, rate, b), true, region, mMax);
            }
            return null;
        }
    }
    ,
    HIGH("Upper Seismicity Bound (p97.5)", "HighSeis", 0.13){

        @Override
        public IncrementalMagFreqDist build(NSHM23_RegionLoader.SeismicityRegions region, EvenlyDiscretizedFunc refMFD, double mMax) {
            if (NSHM23_RegionalSeismicity.hasRegion(region)) {
                double rate = NSHM23_RegionalSeismicity.loadRate(region, 2);
                double b = NSHM23_RegionalSeismicity.loadBVal(region, 2);
                return NSHM23_RegionalSeismicity.adjustForCrossover(NSHM23_RegionalSeismicity.gr(refMFD, mMax, rate, b), false, region, mMax);
            }
            return null;
        }
    };

    public static String RATE_FILE_NAME;
    private static final String NSHM23_RATES_PATH_PREFIX = "/data/erf/nshm23/seismicity/rates/";
    private static Map<String, double[]> ratesMap;
    private static Map<String, double[]> bValsMap;
    private static final UncertaintyBoundType BOUND_TYPE;
    private String name;
    private String shortName;
    private double weight;
    private static final DecimalFormat oDF;

    public static synchronized void clearCache() {
        ratesMap = null;
        bValsMap = null;
    }

    private static synchronized void checkLoadRates() {
        if (ratesMap == null) {
            CSVFile<String> csv;
            HashMap<String, double[]> ratesMap = new HashMap<String, double[]>();
            HashMap<String, double[]> bValsMap = new HashMap<String, double[]>();
            String resource = NSHM23_RATES_PATH_PREFIX + RATE_FILE_NAME;
            System.out.println("Loading spatial seismicity PDF from: " + resource);
            InputStream is = NSHM23_SeisSmoothingAlgorithms.class.getResourceAsStream(resource);
            Preconditions.checkNotNull((Object)is, (String)"Spatial seismicity PDF not found: %s", (Object)resource);
            try {
                csv = CSVFile.readStream(is, true);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            for (int row = 1; row < csv.getNumRows(); ++row) {
                int col = 0;
                String name = csv.get(row, col++);
                double prefVal = csv.getDouble(row, col++);
                double prefB = csv.getDouble(row, col++);
                double lowerVal = csv.getDouble(row, col++);
                double lowerB = csv.getDouble(row, col++);
                double upperVal = csv.getDouble(row, col++);
                double upperB = csv.getDouble(row, col++);
                ratesMap.put(name, new double[]{prefVal, lowerVal, upperVal});
                bValsMap.put(name, new double[]{prefB, lowerB, upperB});
            }
            NSHM23_RegionalSeismicity.bValsMap = bValsMap;
            NSHM23_RegionalSeismicity.ratesMap = ratesMap;
        }
    }

    private static boolean hasRegion(NSHM23_RegionLoader.SeismicityRegions region) {
        NSHM23_RegionalSeismicity.checkLoadRates();
        return ratesMap.containsKey(region.name());
    }

    private static double loadRate(NSHM23_RegionLoader.SeismicityRegions region, int index) {
        NSHM23_RegionalSeismicity.checkLoadRates();
        return ratesMap.get(region.name())[index];
    }

    private static double loadBVal(NSHM23_RegionLoader.SeismicityRegions region, int index) {
        NSHM23_RegionalSeismicity.checkLoadRates();
        return bValsMap.get(region.name())[index];
    }

    private static IncrementalMagFreqDist adjustForCrossover(GutenbergRichterMagFreqDist gr, boolean lower, NSHM23_RegionLoader.SeismicityRegions region, double mMax) {
        IncrementalMagFreqDist pref = PREFFERRED.build(region, gr, mMax);
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(gr.getMinX(), gr.getMaxX(), gr.size());
        boolean anyOutside = false;
        for (int i = 0; i < gr.size(); ++i) {
            double prefY = pref.getY(i);
            double myY = gr.getY(i);
            if (lower && myY > prefY || !lower && myY < prefY) {
                anyOutside = true;
                ret.set(i, prefY);
                continue;
            }
            ret.set(i, myY);
        }
        if (anyOutside) {
            ret.setName(gr.getName());
            return ret;
        }
        return gr;
    }

    private NSHM23_RegionalSeismicity(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    public abstract IncrementalMagFreqDist build(NSHM23_RegionLoader.SeismicityRegions var1, EvenlyDiscretizedFunc var2, double var3);

    public static UncertainBoundedIncrMagFreqDist getBounded(NSHM23_RegionLoader.SeismicityRegions region, EvenlyDiscretizedFunc refMFD, double mMax) {
        IncrementalMagFreqDist upper = HIGH.build(region, refMFD, mMax);
        IncrementalMagFreqDist lower = LOW.build(region, refMFD, mMax);
        IncrementalMagFreqDist pref = PREFFERRED.build(region, refMFD, mMax);
        if (pref == null) {
            return null;
        }
        UncertainBoundedIncrMagFreqDist bounded = new UncertainBoundedIncrMagFreqDist(pref, lower, upper, BOUND_TYPE);
        bounded.setName(pref.getName());
        bounded.setBoundName(NSHM23_RegionalSeismicity.getBoundName(lower, upper));
        return bounded;
    }

    static String getBoundName(IncrementalMagFreqDist lower, IncrementalMagFreqDist upper) {
        Object boundName = BOUND_TYPE.toString();
        double lowerN5 = lower.getCumRateDistWithOffset().getInterpolatedY(5.0);
        double upperN5 = upper.getCumRateDistWithOffset().getInterpolatedY(5.0);
        boundName = (String)boundName + ": N5\u2208[" + oDF.format(lowerN5) + "," + oDF.format(upperN5) + "]";
        return boundName;
    }

    public static UncertainBoundedIncrMagFreqDist getRemapped(Region region, NSHM23_DeclusteringAlgorithms declustering, NSHM23_SeisSmoothingAlgorithms smoothing, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        List<NSHM23_RegionLoader.SeismicityRegions> seisRegions = NSHM23_InvConfigFactory.getSeismicityRegions(region);
        Preconditions.checkState((!seisRegions.isEmpty() ? 1 : 0) != 0);
        IncrementalMagFreqDist upper = null;
        IncrementalMagFreqDist lower = null;
        IncrementalMagFreqDist pref = null;
        double sumTotalN = 0.0;
        double sumFractN = 0.0;
        for (NSHM23_RegionLoader.SeismicityRegions seisRegion : seisRegions) {
            double prefVal;
            int i;
            GriddedGeoDataSet pdf = smoothing.loadXYZ(seisRegion, declustering);
            double fractN = 0.0;
            for (int i2 = 0; i2 < pdf.size(); ++i2) {
                if (!region.contains(pdf.getLocation(i2))) continue;
                fractN += pdf.get(i2);
            }
            if (fractN == 0.0) continue;
            sumTotalN += 1.0;
            sumFractN += fractN;
            IncrementalMagFreqDist myPref = PREFFERRED.build(seisRegion, refMFD, mMax);
            myPref.scale(fractN);
            IncrementalMagFreqDist myUpper = HIGH.build(seisRegion, refMFD, mMax);
            myUpper.scale(fractN);
            IncrementalMagFreqDist myLower = LOW.build(seisRegion, refMFD, mMax);
            myLower.scale(fractN);
            for (i = 0; i < refMFD.size(); ++i) {
                prefVal = myPref.getY(i);
                if (!(prefVal > 0.0)) continue;
                double origUpper = myUpper.getY(i);
                double origLower = myLower.getY(i);
                double upperRatio = origUpper / prefVal;
                double lowerRatio = origLower / prefVal;
                myUpper.set(i, prefVal * (upperRatio *= 1.0 / Math.sqrt(fractN)));
                myLower.set(i, prefVal * (lowerRatio /= 1.0 / Math.sqrt(fractN)));
            }
            if (upper == null) {
                upper = myUpper;
                lower = myLower;
                pref = myPref;
                continue;
            }
            for (i = 0; i < refMFD.size(); ++i) {
                prefVal = myPref.getY(i);
                if (!(prefVal > 0.0)) continue;
                upper.add(i, myUpper.getY(i));
                lower.add(i, myLower.getY(i));
                pref.add(i, myPref.getY(i));
            }
        }
        Preconditions.checkNotNull(pref);
        double prefN5 = pref.getCumRateDistWithOffset().getInterpolatedY(5.0);
        String name = "Remmapped Observed [pdfFractN=" + oDF.format(sumFractN / sumTotalN) + ", N5=" + oDF.format(prefN5) + "]";
        UncertainBoundedIncrMagFreqDist ret = new UncertainBoundedIncrMagFreqDist(pref, lower, upper, BOUND_TYPE);
        ret.setName(name);
        ret.setBoundName(NSHM23_RegionalSeismicity.getBoundName(lower, upper));
        return ret;
    }

    private static GutenbergRichterMagFreqDist gr(EvenlyDiscretizedFunc refMFD, double mMax, double rateM5, double bVal) {
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        gr.setAllButTotCumRate(refMFD.getX(0), refMFD.getX(refMFD.getClosestXIndex(mMax - 0.001)), 1.0E16, bVal);
        gr.scaleToCumRate(refMFD.getClosestXIndex(5.001), rateM5);
        gr.setName("Total Observed [b=" + oDF.format(bVal) + ", N5=" + oDF.format(rateM5) + "]");
        return gr;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.getShortName();
    }

    public static void main(String[] args) throws IOException {
        double mMax = 7.6;
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(mMax);
        for (NSHM23_RegionLoader.SeismicityRegions seismicityRegions : NSHM23_RegionLoader.SeismicityRegions.values()) {
            IncrementalMagFreqDist pref = PREFFERRED.build(seismicityRegions, refMFD, mMax);
            IncrementalMagFreqDist low = LOW.build(seismicityRegions, refMFD, mMax);
            IncrementalMagFreqDist high = HIGH.build(seismicityRegions, refMFD, mMax);
            System.out.println(seismicityRegions);
            for (int i = 0; i < refMFD.size() && !(refMFD.getX(i) > (double)refMFD.getClosestXIndex(mMax)); ++i) {
                System.out.println((float)refMFD.getX(i) + "\t" + (float)pref.getY(i) + "\t[" + (float)low.getY(i) + "," + (float)high.getY(i) + "]");
            }
            System.out.println();
        }
        for (Enum enum_ : NSHM23_RegionLoader.AnalysisRegions.values()) {
            UncertainBoundedIncrMagFreqDist remapped = NSHM23_RegionalSeismicity.getRemapped(enum_.load(), NSHM23_DeclusteringAlgorithms.AVERAGE, NSHM23_SeisSmoothingAlgorithms.AVERAGE, refMFD, mMax);
            System.out.println(remapped);
        }
    }

    static {
        RATE_FILE_NAME = "rates_2023_06_21.csv";
        BOUND_TYPE = UncertaintyBoundType.CONF_95;
        oDF = new DecimalFormat("0.##");
    }
}

