/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv")})
@Affects.Affected(value={@Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum NSHM23_ScalingRelationships implements RupSetScalingRelationship
{
    LOGA_C4p3("LogA+4.3, From Moment", "LogA+4.3", "LogA_C4p3"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return Math.log10(area *= 1.0E-6) + 4.3;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return ORIGINAL_DRAFT_RELS ? 0.0 : 1.0;
        }
    }
    ,
    LOGA_C4p2("LogA+4.2, From Moment", "LogA+4.2", "LogA_C4p2"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return Math.log10(area *= 1.0E-6) + 4.2;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }
    }
    ,
    LOGA_C4p1("LogA+4.1, From Moment", "LogA+4.1", "LogA_C4p1"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return Math.log10(area *= 1.0E-6) + 4.1;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }
    }
    ,
    WIDTH_LIMITED("Width Limited, From Moment", "WdthLmtd", "WdthLmtd"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            width = origWidth;
            double beta = 7.4;
            double C = 3.98;
            double upperMiddleTerm = Math.max(1.0, Math.sqrt((area *= 1.0E-6) / ((width *= 0.001) * width)));
            double lowerMiddleTerm = 0.5 * (1.0 + Math.max(1.0, area / (width * width * beta)));
            return Math.log10(area) + 0.6666666666666666 * Math.log10(upperMiddleTerm / lowerMiddleTerm) + C;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }
    }
    ,
    LOGA_C4p2_SQRT_LEN("LogA+4.2, Sqrt Length", "LogA+4.2, SqrtLen", "LogA_C4p2_SqrtLen"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return LOGA_C4p2.getMag(area, length, width, origWidth, aveRake);
        }

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            if (SURFACE_SLIP_HARDCODED_W) {
                width = 15000.0;
            }
            double C6 = 5.69E-5;
            return C6 * Math.sqrt(length * width);
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }
    }
    ,
    LOGA_C4p1_SQRT_LEN("LogA+4.1, Sqrt Length", "LogA+4.1, SqrtLen", "LogA_C4p1_SqrtLen"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return LOGA_C4p1.getMag(area, length, width, origWidth, aveRake);
        }

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            return LOGA_C4p2_SQRT_LEN.getAveSlip(area, length, width, origWidth, aveRake);
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return ORIGINAL_DRAFT_RELS ? 1.0 : 0.0;
        }
    }
    ,
    WIDTH_LIMITED_CSD("Width Limited, Constant Stress Drop", "WdthLmtd, CSD", "WdthLmtdCSD"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return WIDTH_LIMITED.getMag(area, length, width, origWidth, aveRake);
        }

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            if (SURFACE_SLIP_HARDCODED_W) {
                width = 15000.0;
            }
            double deltaSigma = 4540000.0;
            return deltaSigma / 3.0E10 * 1.0 / (7.0 / (3.0 * length) + 1.0 / (2.0 * width));
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }
    }
    ,
    AVERAGE("NSHM23 Average", "NSHM23-Avg", "NSHM23_Avg"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            double sum = 0.0;
            double sumWeights = 0.0;
            for (NSHM23_ScalingRelationships scale : 8.values()) {
                double weight = scale.getNodeWeight(null);
                if (!(weight > 0.0) || scale == this) continue;
                sum += scale.getMag(area, length, width, origWidth, aveRake) * weight;
                sumWeights += weight;
            }
            return sum / sumWeights;
        }

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double sum = 0.0;
            double sumWeights = 0.0;
            for (NSHM23_ScalingRelationships scale : 8.values()) {
                double weight = scale.getNodeWeight(null);
                if (!(weight > 0.0) || scale == this) continue;
                sum += scale.getAveSlip(area, length, width, origWidth, aveRake) * weight;
                sumWeights += weight;
            }
            return sum / sumWeights;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 0.0;
        }
    };

    public static boolean SURFACE_SLIP_HARDCODED_W;
    public static boolean ORIGINAL_DRAFT_RELS;
    private String name;
    private String shortName;
    private String filePrefix;

    private NSHM23_ScalingRelationships(String name, String shortName, String filePrefix) {
        this.name = name;
        this.shortName = shortName;
        this.filePrefix = filePrefix;
    }

    @Override
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
        double mag = this.getMag(area, length, width, origWidth, aveRake);
        double moment = MagUtils.magToMoment(mag);
        return FaultMomentCalc.getSlip(area, moment);
    }

    @Override
    public abstract double getMag(double var1, double var3, double var5, double var7, double var9);

    static {
        SURFACE_SLIP_HARDCODED_W = true;
        ORIGINAL_DRAFT_RELS = false;
    }
}

