/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_ConstraintBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.data.NSHM23_WasatchSegmentationData;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.HardDistCutoffJumpProbCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupsThroughCreepingSectBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SectionSupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalFaultModels;
import org.opensha.sha.faultSurface.FaultSection;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum NSHM23_SegmentationModels implements SegmentationModelBranchNode,
RupsThroughCreepingSectBranchNode
{
    NONE("None", "None", 0.1){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return null;
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            return false;
        }
    }
    ,
    LOW("Low Segmentation", "Low", 0.2, 4.0, 3.0, 0.75, 0.75){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return NSHM23_SegmentationModels.buildModel(rupSet, this.shawR0, this.shawShift, this.wasatchProb, this.creepingProb, Double.NaN, false);
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            return false;
        }
    }
    ,
    MID("Middle Segmentation", "Middle", 0.3, 3.0, 2.0, 0.5, 0.5){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return NSHM23_SegmentationModels.buildModel(rupSet, this.shawR0, this.shawShift, this.wasatchProb, this.creepingProb, Double.NaN, false);
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            return false;
        }
    }
    ,
    HIGH("High Segmentation", "High", 0.3, 2.0, 1.0, 0.25, 0.25){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return NSHM23_SegmentationModels.buildModel(rupSet, this.shawR0, this.shawShift, this.wasatchProb, this.creepingProb, Double.NaN, false);
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            return true;
        }
    }
    ,
    CLASSIC("Classic", "Classic", 0.1, 2.0, 1.0, 0.0, 0.0){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            Preconditions.checkNotNull((Object)rupSet, (Object)"Can only build classic segmentation model when we have a rupture set");
            return NSHM23_SegmentationModels.buildModel(rupSet, this.shawR0, this.shawShift, this.wasatchProb, this.creepingProb, Double.NaN, true);
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            return true;
        }
    }
    ,
    CLASSIC_FULL("Classic Full Section", "FullClassic", 0.0, 2.0, 1.0, 0.0, 0.0){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return CLASSIC.getModel(rupSet, branch);
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            return CLASSIC.isExcludeRupturesThroughCreepingSect();
        }
    }
    ,
    AVERAGE("NSHM23 Average Segmentation", "AvgSeg", 0.0, Double.NaN, Double.NaN, 0.475, 0.475){

        @Override
        public JumpProbabilityCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            final ArrayList<JumpProbabilityCalc> models = new ArrayList<JumpProbabilityCalc>();
            final ArrayList<Double> weights = new ArrayList<Double>();
            double tempWeight = 0.0;
            for (NSHM23_SegmentationModels segModel : 7.values()) {
                if (segModel == this || !(segModel.weight > 0.0)) continue;
                models.add(segModel.getModel(rupSet, branch));
                weights.add(segModel.weight);
                tempWeight += segModel.weight;
            }
            final double totWeight = tempWeight;
            return new JumpProbabilityCalc(){
                final /* synthetic */ 7 this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean isDirectional(boolean splayed) {
                    for (JumpProbabilityCalc model : models) {
                        if (!model.isDirectional(splayed)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getName() {
                    return "NSHM23 Average";
                }

                @Override
                public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
                    double ret = 0.0;
                    boolean allOne = true;
                    boolean allZero = true;
                    for (int i = 0; i < models.size(); ++i) {
                        JumpProbabilityCalc model = (JumpProbabilityCalc)models.get(i);
                        double weight = (Double)weights.get(i);
                        if (model == null) {
                            ret += 1.0 * weight;
                            allZero = false;
                            continue;
                        }
                        double modelProb = model.calcJumpProbability(fullRupture, jump, false);
                        allOne = allOne && modelProb == 1.0;
                        allZero = allZero && modelProb == 0.0;
                        ret += modelProb * weight;
                    }
                    if (allOne) {
                        return 1.0;
                    }
                    if (allZero) {
                        return 0.0;
                    }
                    return ret / totWeight;
                }
            };
        }

        @Override
        public boolean isExcludeRupturesThroughCreepingSect() {
            double weightInclude = 0.0;
            double weightExclude = 0.0;
            for (NSHM23_SegmentationModels segModel : 7.values()) {
                if (segModel == this || !(segModel.weight > 0.0)) continue;
                if (segModel.isExcludeRupturesThroughCreepingSect()) {
                    weightExclude += segModel.weight;
                    continue;
                }
                weightInclude += segModel.weight;
            }
            return weightExclude > weightInclude;
        }
    };

    private String name;
    private String shortName;
    private double weight;
    protected double shawR0;
    protected double shawShift;
    protected double creepingProb;
    protected double wasatchProb;
    public static boolean LIMIT_MAX_LENGTHS;
    public static double SINGLE_MAX_LENGTH_LIMIT;

    private NSHM23_SegmentationModels(String name, String shortName, double weight) {
        this(name, shortName, weight, Double.NaN, Double.NaN, 1.0, 1.0);
    }

    private NSHM23_SegmentationModels(String name, String shortName, double weight, double shawR0, double shawShift, double creepingProb, double wasatchProb) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
        this.shawR0 = shawR0;
        this.shawShift = shawShift;
        this.creepingProb = creepingProb;
        this.wasatchProb = wasatchProb;
    }

    @Override
    public abstract JumpProbabilityCalc getModel(FaultSystemRupSet var1, LogicTreeBranch<?> var2);

    private static JumpProbabilityCalc buildModel(FaultSystemRupSet rupSet, double shawR0, double shawShift, double wasatchProb, double creepingProb, double hardCutoff, boolean namedFaultsOnly) {
        JumpProbabilityCalc model = null;
        if (Double.isFinite(hardCutoff)) {
            model = new HardDistCutoffJumpProbCalc(hardCutoff);
        }
        if (Double.isFinite(shawR0)) {
            Shaw07JumpDistProb shawModel = shawShift > 0.0 ? Shaw07JumpDistProb.forHorzOffset(1.0, shawR0, shawShift) : new Shaw07JumpDistProb(1.0, shawR0);
            model = model == null ? shawModel : new JumpProbabilityCalc.Minimum(model, shawModel);
        }
        if (rupSet != null) {
            JumpProbabilityCalc.HardcodedJumpProb wasatch;
            int creepingParentID;
            if (creepingProb < 1.0 && (creepingParentID = NSHM23_ConstraintBuilder.findCreepingSection(rupSet)) >= 0) {
                JumpProbabilityCalc creepModel = creepingProb == 0.0 ? new CreepingSectionBinaryJumpExcludeModel(creepingParentID) : new CreepingSectionJumpSegModel(creepingParentID, creepingProb);
                model = model == null ? creepModel : new JumpProbabilityCalc.Minimum(model, creepModel);
            }
            if ((wasatch = NSHM23_WasatchSegmentationData.build(rupSet, wasatchProb)) != null) {
                model = model == null ? wasatch : new JumpProbabilityCalc.Minimum(model, wasatch);
            }
            if (namedFaultsOnly) {
                NamedFaults namedFaults = rupSet.getModule(NamedFaults.class);
                if (namedFaults == null) {
                    return new JumpProbabilityCalc.NoJumps();
                }
                NamedFaultSegmentationModel namedFaultsModel = new NamedFaultSegmentationModel(namedFaults);
                model = model == null ? namedFaultsModel : (model instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc ? new JumpProbabilityCalc.LogicalAnd(new JumpProbabilityCalc.BinaryJumpProbabilityCalc[]{model, namedFaultsModel}) : new JumpProbabilityCalc.Minimum(model, namedFaultsModel));
            }
        }
        return model;
    }

    public double getShawR0() {
        return this.shawR0;
    }

    public double getShawShift() {
        return this.shawShift;
    }

    public double getCreepingSectPassthrough() {
        return this.creepingProb;
    }

    public double getWasatchPassthrough() {
        return this.wasatchProb;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.shortName.replace("R\u2080=", "R0_");
    }

    public double getMaxRuptureLength() {
        if (LIMIT_MAX_LENGTHS) {
            if (Double.isFinite(SINGLE_MAX_LENGTH_LIMIT) && SINGLE_MAX_LENGTH_LIMIT > 0.0) {
                return SINGLE_MAX_LENGTH_LIMIT;
            }
            switch (this.ordinal()) {
                case 0: {
                    return Double.POSITIVE_INFINITY;
                }
                case 1: {
                    return 800.0;
                }
                case 2: {
                    return 700.0;
                }
                case 3: {
                    return 600.0;
                }
                case 4: {
                    return 500.0;
                }
                case 5: {
                    return CLASSIC.getMaxRuptureLength();
                }
                case 6: {
                    return MID.getMaxRuptureLength();
                }
            }
            throw new IllegalStateException();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        double maxRupLength;
        int creepingSectID;
        ArrayList<RuptureProbabilityCalc.BinaryRuptureProbabilityCalc> exclusions = new ArrayList<RuptureProbabilityCalc.BinaryRuptureProbabilityCalc>();
        RuptureProbabilityCalc.BinaryRuptureProbabilityCalc primaryExclusion = SegmentationModelBranchNode.super.getExclusionModel(rupSet, branch);
        if (primaryExclusion != null) {
            exclusions.add(primaryExclusion);
        }
        if (this.isExcludeRupturesThroughCreepingSect() && (creepingSectID = NSHM23_ConstraintBuilder.findCreepingSection(rupSet)) >= 0) {
            exclusions.add(new ExcludeRupsThroughCreepingSegmentationModel(creepingSectID));
        }
        if (this == CLASSIC_FULL) {
            exclusions.add(new FullSectionsSegmentationModel(rupSet));
        }
        if (this == CLASSIC && branch.hasValue(SectionSupraSeisBValues.class) && (branch.hasValue(SupraSeisBValues.B_0p0) || branch.requireValue(SectionSupraSeisBValues.class).getB() == 0.0)) {
            boolean excludeProxies;
            boolean excludeNamed;
            if (branch.hasValue(PRVI25_CrustalFaultModels.class)) {
                excludeNamed = false;
                excludeProxies = true;
            } else {
                excludeNamed = rupSet.hasModule(NamedFaults.class);
                excludeProxies = false;
            }
            exclusions.add(new FullSectionsSegmentationModel(rupSet, excludeNamed, excludeProxies));
        }
        if ((maxRupLength = this.getMaxRuptureLength()) > 0.0 && Double.isFinite(maxRupLength)) {
            exclusions.add(new MaxLengthSegmentationModel(maxRupLength));
        }
        if (exclusions.isEmpty()) {
            return null;
        }
        if (exclusions.size() == 1) {
            return (RuptureProbabilityCalc.BinaryRuptureProbabilityCalc)exclusions.get(0);
        }
        System.out.println("Combining " + exclusions.size() + " segmentation exclusion models");
        return new RuptureProbabilityCalc.LogicalAnd(exclusions.toArray(new RuptureProbabilityCalc.BinaryRuptureProbabilityCalc[0]));
    }

    static {
        LIMIT_MAX_LENGTHS = true;
        SINGLE_MAX_LENGTH_LIMIT = Double.NaN;
    }

    public static class CreepingSectionBinaryJumpExcludeModel
    implements JumpProbabilityCalc.BinaryJumpProbabilityCalc {
        private int creepingParentID;

        public CreepingSectionBinaryJumpExcludeModel(int creepingParentID) {
            this.creepingParentID = creepingParentID;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Exclude Creeping Section Jumps";
        }

        @Override
        public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            return jump.fromCluster.parentSectionID != this.creepingParentID && jump.toCluster.parentSectionID != this.creepingParentID;
        }
    }

    public static class CreepingSectionJumpSegModel
    implements JumpProbabilityCalc {
        private int creepingParentID;
        private double prob;

        public CreepingSectionJumpSegModel(int creepingParentID, double prob) {
            this.creepingParentID = creepingParentID;
            this.prob = prob;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Creeping Section Jump P\u2264" + (float)this.prob;
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            if (jump.fromCluster.parentSectionID == this.creepingParentID || jump.toCluster.parentSectionID == this.creepingParentID) {
                return this.prob;
            }
            return 1.0;
        }
    }

    public static class NamedFaultSegmentationModel
    implements JumpProbabilityCalc.BinaryJumpProbabilityCalc {
        private NamedFaults namedFaults;

        public NamedFaultSegmentationModel(NamedFaults namedFaults) {
            this.namedFaults = namedFaults;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Named Fault Segmentation";
        }

        @Override
        public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            String faultName1 = this.namedFaults.getFaultName(jump.fromCluster.parentSectionID);
            String faultName2 = this.namedFaults.getFaultName(jump.toCluster.parentSectionID);
            if (faultName1 == null || faultName2 == null) {
                return false;
            }
            return faultName1.equals(faultName2);
        }
    }

    public static class ExcludeRupsThroughCreepingSegmentationModel
    implements RuptureProbabilityCalc.BinaryRuptureProbabilityCalc {
        private int creepingParentID;

        public ExcludeRupsThroughCreepingSegmentationModel(int creepingParentID) {
            this.creepingParentID = creepingParentID;
        }

        @Override
        public String getName() {
            return "Exclude Ruptures Through Creeping";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return splayed;
        }

        @Override
        public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            return !NSHM23_ConstraintBuilder.isRupThroughCreeping(this.creepingParentID, fullRupture);
        }
    }

    public static class FullSectionsSegmentationModel
    implements RuptureProbabilityCalc.BinaryRuptureProbabilityCalc {
        private Map<Integer, List<FaultSection>> parentSectsMap;
        private boolean excludeNamed;
        private NamedFaults namedFaults;
        private boolean excludeProxies;

        public FullSectionsSegmentationModel(FaultSystemRupSet rupSet) {
            this(rupSet, false);
        }

        public FullSectionsSegmentationModel(FaultSystemRupSet rupSet, boolean excludeNamed) {
            this(rupSet, excludeNamed, false);
        }

        public FullSectionsSegmentationModel(FaultSystemRupSet rupSet, boolean excludeNamed, boolean excludeProxies) {
            this(rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId())), excludeNamed, excludeProxies, rupSet.getModule(NamedFaults.class));
        }

        public FullSectionsSegmentationModel(Map<Integer, List<FaultSection>> parentSectsMap, boolean excludeNamed, boolean excludeProxies, NamedFaults namedFaults) {
            this.parentSectsMap = parentSectsMap;
            this.excludeNamed = excludeNamed;
            this.excludeProxies = excludeProxies;
            if (excludeNamed) {
                Preconditions.checkNotNull((Object)namedFaults, (Object)"excludeNamed == true but NamedFaults are null");
            }
            this.namedFaults = namedFaults;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Full Section Segmentation";
        }

        @Override
        public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            for (FaultSubsectionCluster cluster : fullRupture.getClustersIterable()) {
                if (this.excludeNamed && this.namedFaults.getFaultName(cluster.parentSectionID) != null || this.excludeProxies && cluster.startSect.isProxyFault()) continue;
                List<FaultSection> fullCluster = this.parentSectsMap.get(cluster.parentSectionID);
                Preconditions.checkNotNull(fullCluster);
                Preconditions.checkState((fullCluster.size() >= cluster.subSects.size() ? 1 : 0) != 0);
                if (fullCluster.size() == cluster.subSects.size()) continue;
                return false;
            }
            return true;
        }
    }

    public static class MaxLengthSegmentationModel
    implements RuptureProbabilityCalc.BinaryRuptureProbabilityCalc {
        private double maxLen;
        private ConcurrentMap<FaultSection, Double> sectLenCache;

        public MaxLengthSegmentationModel(double maxLen) {
            this.maxLen = maxLen;
            this.sectLenCache = new ConcurrentHashMap<FaultSection, Double>();
        }

        @Override
        public String getName() {
            return "Rupture Len <=" + (float)this.maxLen + "km";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            if (fullRupture.getTotalNumJumps() == 0) {
                return true;
            }
            double len = 0.0;
            for (FaultSubsectionCluster cluster : fullRupture.getClustersIterable()) {
                for (FaultSection sect : cluster.subSects) {
                    Double sectLen = (Double)this.sectLenCache.get(sect);
                    if (sectLen == null) {
                        sectLen = sect.getFaultTrace().getTraceLength();
                        this.sectLenCache.putIfAbsent(sect, sectLen);
                    }
                    len += sectLen.doubleValue();
                }
            }
            return !((float)len > (float)this.maxLen);
        }
    }
}

