/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ConnectivityClusters;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ConnectivityCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum NSHM23_SingleStates implements LogicTreeNode
{
    CA("California"){

        @Override
        public Region loadRegion() throws IOException {
            return NSHM23_RegionLoader.AnalysisRegions.CONUS_U3_RELM.load();
        }
    }
    ,
    NV("Nevada"),
    OR("Oregon"),
    WA("Washington"),
    WY("Wyoming"),
    ID("Idaho"),
    MT("Montana"),
    UT("Utah"),
    CO("Colorado"),
    NM("New Mexico"),
    AZ("Arizona"),
    TX("Texas");

    public static boolean INCLUDE_SECONDARY;
    private String stateName;

    private NSHM23_SingleStates(String stateName) {
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    @Override
    public String getShortName() {
        return "Only" + this.name();
    }

    @Override
    public String getName() {
        return this.stateName + " Only";
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return 0.0;
    }

    @Override
    public String getFilePrefix() {
        return this.name() + "_only";
    }

    private List<Integer> getStateSectionIDs(List<? extends FaultSection> sects) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (FaultSection faultSection : sects) {
            Preconditions.checkState((boolean)(faultSection instanceof GeoJSONFaultSection));
            GeoJSONFaultSection geoSect = (GeoJSONFaultSection)faultSection;
            if (!this.contains(geoSect)) continue;
            ids.add(faultSection.getSectionId());
        }
        Preconditions.checkState((!ids.isEmpty() ? 1 : 0) != 0, (String)"None of the %s sections match state: %s", (int)sects.size(), (Object)this.name());
        return ids;
    }

    public boolean contains(GeoJSONFaultSection geoSect) {
        String primary = geoSect.getProperty("PrimState", null);
        String secState = geoSect.getProperty("SecState", null);
        String myName = this.name();
        return myName.equals(primary) || INCLUDE_SECONDARY && myName.equals(secState);
    }

    public FaultSystemRupSet getRuptureSubSet(FaultSystemRupSet rupSet) {
        ConnectivityClusters clusters = rupSet.getModule(ConnectivityClusters.class);
        if (clusters == null) {
            clusters = ConnectivityClusters.build(rupSet);
        }
        List<Integer> stateIDs = this.getStateSectionIDs(rupSet.getFaultSectionDataList());
        HashSet<Integer> allClusterSectIDs = new HashSet<Integer>(stateIDs);
        for (ConnectivityCluster cluster : clusters) {
            boolean contains = false;
            for (int sectID : stateIDs) {
                if (!cluster.containsSect(sectID)) continue;
                contains = true;
                break;
            }
            if (!contains) continue;
            allClusterSectIDs.addAll(cluster.getSectIDs());
        }
        return rupSet.getForSectionSubSet(allClusterSectIDs);
    }

    public Region loadRegion() throws IOException {
        XY_DataSet[] outlines = PoliticalBoundariesData.loadUSState(this.getStateName());
        Region[] regions = new Region[outlines.length];
        for (int i = 0; i < outlines.length; ++i) {
            XY_DataSet outline = outlines[i];
            LocationList border = new LocationList();
            for (Point2D pt : outline) {
                border.add(new Location(pt.getY(), pt.getX()));
            }
            regions[i] = new Region(border, BorderType.MERCATOR_LINEAR);
        }
        Object largest = null;
        if (outlines.length == 1) {
            largest = regions[0];
        } else {
            double largestArea = 0.0;
            for (Region region : regions) {
                double area = region.getExtent();
                if (!(area > largestArea)) continue;
                largestArea = area;
                largest = region;
            }
        }
        return largest;
    }

    public static void main(String[] args) throws IOException {
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v2;
        NSHM23_SingleStates state = UT;
        List<? extends FaultSection> allSects = fm.getFaultSections();
        ArrayList<GeoJSONFaultSection> stateSects = new ArrayList<GeoJSONFaultSection>();
        for (FaultSection faultSection : allSects) {
            Preconditions.checkState((boolean)(faultSection instanceof GeoJSONFaultSection));
            GeoJSONFaultSection geoSect = (GeoJSONFaultSection)faultSection;
            if (!state.contains(geoSect)) continue;
            stateSects.add(geoSect);
        }
        GeoJSONFaultReader.writeFaultSections(new File("/tmp/" + fm.getFilePrefix() + "_" + state.getFilePrefix() + ".geojson"), stateSects);
    }

    static {
        INCLUDE_SECONDARY = true;
    }
}

