/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import java.util.List;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.RuptureSets;
import org.opensha.sha.faultSurface.FaultSection;

@DoesNotAffect(value="fault_sections.geojson")
@Affects.Affected(value={@Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum RupturePlausibilityModels implements LogicTreeNode
{
    AZIMUTHAL("Simple Azimuthal", "Azimuthal", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            return new RuptureSets.SimpleAzimuthalRupSetConfig(subSects, scale);
        }
    }
    ,
    AZIMUTHAL_REDUCED("Simple Azimuthal, Reduced", "AzRed", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            RuptureSets.SimpleAzimuthalRupSetConfig config = new RuptureSets.SimpleAzimuthalRupSetConfig(subSects, scale);
            config.setAdaptiveSectFract(0.1f);
            return config;
        }
    }
    ,
    SEGMENTED("Fully Segmented", "FullSeg", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            RuptureSets.FullySegmentedRupSetConfig config = new RuptureSets.FullySegmentedRupSetConfig(subSects, scale);
            config.setMinSectsPerParent(2);
            return config;
        }
    }
    ,
    UCERF3("UCERF3", "U3", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            return new RuptureSets.U3RupSetConfig(subSects, scale);
        }
    }
    ,
    UCERF3_REDUCED("UCERF3 Reduced", "U3Red", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            RuptureSets.U3RupSetConfig config = new RuptureSets.U3RupSetConfig(subSects, scale);
            config.setAdaptiveSectFract(0.1f);
            return config;
        }
    }
    ,
    COULOMB("Coulomb", "Coulomb", 1.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            return new RuptureSets.CoulombRupSetConfig(subSects, null, scale);
        }
    }
    ,
    COULOMB_5km("Coulomb 5km", "Coulomb5km", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            RuptureSets.CoulombRupSetConfig config = new RuptureSets.CoulombRupSetConfig(subSects, null, scale);
            config.setMaxJumpDist(5.0);
            return config;
        }
    }
    ,
    SIMPLE_SUBDUCTION("Simple Subduction", "Subduction", 0.0){

        @Override
        public RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            RuptureSets.SimpleSubductionRupSetConfig config = new RuptureSets.SimpleSubductionRupSetConfig(subSects, scale);
            return config;
        }
    };

    private String name;
    private String shortName;
    private double weight;

    private RupturePlausibilityModels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    public abstract RuptureSets.RupSetConfig getConfig(List<? extends FaultSection> var1, RupSetScalingRelationship var2);

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.shortName + "RupSet";
    }
}

