/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018;

import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv")})
@Affects.Affected(value={@Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum NSHM18_ScalingRels implements LogicTreeNode,
RupSetScalingRelationship
{
    WC94_ML("Wells & Coppersmith (1994) M-L", "WC94 W-L", 1.0){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double mag;
            WC1994_MagLengthRelationship wC1994_MagLengthRelationship = wc94;
            synchronized (wC1994_MagLengthRelationship) {
                mag = wc94.getMedianMag(length * 0.001);
            }
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            double len = area / origWidth;
            WC1994_MagLengthRelationship wC1994_MagLengthRelationship = wc94;
            synchronized (wC1994_MagLengthRelationship) {
                return wc94.getMedianMag(len * 0.001);
            }
        }
    };

    private static WC1994_MagLengthRelationship wc94;
    private String name;
    private String shortName;
    private double weight;

    private NSHM18_ScalingRels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public abstract double getAveSlip(double var1, double var3, double var5, double var7, double var9);

    @Override
    public abstract double getMag(double var1, double var3, double var5, double var7, double var9);

    static {
        wc94 = new WC1994_MagLengthRelationship();
    }
}

