/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ui.RectangleAnchor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018.NSHM18_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018.NSHM18_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class SpecialCases {
    static final String BASE_PATH = "/data/erf/nshm18/special_cases";
    static final String ACTIVITY_PROB_PATH = "/data/erf/nshm18/special_cases/activity-probability.json";
    private static Map<Integer, ActivityProbRecord> activityProbabilities;
    static final String RECURRENCE_RATE_PATH = "/data/erf/nshm18/special_cases/recurrence-rate.json";
    private static Map<Integer, RecurrenceRateRecord> recurrenceRates;
    static final String HISTORIC_MAX_MAG_PATH = "/data/erf/nshm18/special_cases/historic-max-magnitude.json";
    static final String REGIONAL_MAX_MAG_PATH = "/data/erf/nshm18/special_cases/regional-max-magnitude.json";
    private static Map<Integer, MaxMagRecord> histMaxMags;
    private static Map<Integer, MaxMagRecord> regMaxMags;
    static final String ZONE_PATH = "/data/erf/nshm18/special_cases/zones";
    static final String[] ZONE_FILENAMES;
    private static List<Feature> zones;

    public static synchronized Map<Integer, ActivityProbRecord> getActivityProbabilities() {
        if (activityProbabilities != null) {
            return Collections.unmodifiableMap(activityProbabilities);
        }
        HashMap<Integer, ActivityProbRecord> activityProbabilities = new HashMap<Integer, ActivityProbRecord>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream(ACTIVITY_PROB_PATH)));
        Preconditions.checkNotNull((Object)reader, (String)"File not found: %s", (Object)ACTIVITY_PROB_PATH);
        Gson gson = new GsonBuilder().create();
        List recs = (List)gson.fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{ActivityProbRecord.class}).getType());
        for (ActivityProbRecord rec : recs) {
            activityProbabilities.put(rec.id, rec);
        }
        SpecialCases.activityProbabilities = activityProbabilities;
        return Collections.unmodifiableMap(activityProbabilities);
    }

    public static synchronized Map<Integer, RecurrenceRateRecord> getRecurrenceRates() {
        if (recurrenceRates != null) {
            return Collections.unmodifiableMap(recurrenceRates);
        }
        HashMap<Integer, RecurrenceRateRecord> recurrenceRates = new HashMap<Integer, RecurrenceRateRecord>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream(RECURRENCE_RATE_PATH)));
        Preconditions.checkNotNull((Object)reader, (String)"File not found: %s", (Object)RECURRENCE_RATE_PATH);
        Gson gson = new GsonBuilder().create();
        List recs = (List)gson.fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{RecurrenceRateRecord.class}).getType());
        for (RecurrenceRateRecord rec : recs) {
            recurrenceRates.put(rec.id, rec);
        }
        SpecialCases.recurrenceRates = recurrenceRates;
        return Collections.unmodifiableMap(recurrenceRates);
    }

    public static synchronized Map<Integer, MaxMagRecord> getHistoricMaxMags() {
        if (histMaxMags == null) {
            histMaxMags = SpecialCases.loadMaxMags(HISTORIC_MAX_MAG_PATH);
        }
        return Collections.unmodifiableMap(histMaxMags);
    }

    public static synchronized Map<Integer, MaxMagRecord> getRegionalMaxMags() {
        if (regMaxMags == null) {
            regMaxMags = SpecialCases.loadMaxMags(REGIONAL_MAX_MAG_PATH);
        }
        return Collections.unmodifiableMap(regMaxMags);
    }

    private static Map<Integer, MaxMagRecord> loadMaxMags(String path) {
        HashMap<Integer, MaxMagRecord> mags = new HashMap<Integer, MaxMagRecord>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream(path)));
        Preconditions.checkNotNull((Object)reader, (String)"File not found: %s", (Object)path);
        Gson gson = new GsonBuilder().create();
        List recs = (List)gson.fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{MaxMagRecord.class}).getType());
        for (MaxMagRecord rec : recs) {
            mags.put(rec.id, rec);
        }
        return mags;
    }

    public static synchronized List<Feature> getZones() throws IOException {
        if (zones == null) {
            ArrayList<Feature> zones = new ArrayList<Feature>();
            for (String filename : ZONE_FILENAMES) {
                zones.add(Feature.read(new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream("/data/erf/nshm18/special_cases/zones/" + filename)))));
            }
            SpecialCases.zones = zones;
        }
        return Collections.unmodifiableList(zones);
    }

    public static void plotSpecialCases(File outputDir, String prefix, Region plotReg) throws IOException {
        List<? extends FaultSection> fullSects = NSHM18_FaultModels.NSHM18_WUS_PlusU3_FM_3p1.getFaultSections();
        Map<Integer, ActivityProbRecord> activityProbs = SpecialCases.getActivityProbabilities();
        Map<Integer, RecurrenceRateRecord> recurrenceRates = SpecialCases.getRecurrenceRates();
        Map<Integer, MaxMagRecord> histMaxMags = SpecialCases.getHistoricMaxMags();
        Map<Integer, MaxMagRecord> regMaxMags = SpecialCases.getRegionalMaxMags();
        List<Feature> zones = SpecialCases.getZones();
        Color activityColor = Color.CYAN;
        Color recurrenceColor = Color.RED;
        Color histMagColor = Color.GREEN;
        Color regMagColor = Color.BLUE;
        ArrayList<FaultSection> modSects = new ArrayList<FaultSection>();
        ArrayList<Color> colors = new ArrayList<Color>();
        HashSet<Integer> mapped = new HashSet<Integer>();
        for (FaultSection faultSection : fullSects) {
            int id = faultSection.getSectionId();
            String name = faultSection.getSectionName();
            FaultSection faultSection2 = faultSection.clone();
            faultSection2.setSectionId(modSects.size());
            faultSection2.setParentSectionId(id);
            modSects.add(faultSection2);
            Object color = null;
            String type = null;
            if (activityProbs.containsKey(id)) {
                color = activityColor;
                type = "Activity";
            }
            if (histMaxMags.containsKey(id)) {
                if (type != null) {
                    System.err.println("WARNING: multiple mappings for " + id + ". " + name + ". Overriding " + type + " with historical max mag");
                }
                type = "Historical max mag";
                color = histMagColor;
            }
            if (regMaxMags.containsKey(id)) {
                if (type != null) {
                    System.err.println("WARNING: multiple mappings for " + id + ". " + name + ". Overriding " + type + " with regional max mag");
                }
                type = "Regional max mag";
                color = regMagColor;
            }
            if (recurrenceRates.containsKey(id)) {
                if (type != null) {
                    System.err.println("WARNING: multiple mappings for " + id + ". " + name + ". Overriding " + type + " with recurrence rate");
                }
                type = "Recurrence rate";
                color = recurrenceColor;
            }
            if (color != null) {
                mapped.add(id);
            }
            colors.add((Color)color);
        }
        for (ActivityProbRecord activityProbRecord : activityProbs.values()) {
            if (mapped.contains(activityProbRecord.id)) continue;
            System.err.println("WARNING: no activity probability mapping found for " + activityProbRecord.id + ". " + activityProbRecord.name);
        }
        for (RecurrenceRateRecord recurrenceRateRecord : recurrenceRates.values()) {
            if (mapped.contains(recurrenceRateRecord.id)) continue;
            System.err.println("WARNING: no recurrence rate mapping found for " + recurrenceRateRecord.id + ". " + recurrenceRateRecord.name);
        }
        for (MaxMagRecord maxMagRecord : histMaxMags.values()) {
            if (mapped.contains(maxMagRecord.id)) continue;
            System.err.println("WARNING: no hist max mag mapping found for " + maxMagRecord.id + ". " + maxMagRecord.name);
        }
        for (MaxMagRecord maxMagRecord : regMaxMags.values()) {
            if (mapped.contains(maxMagRecord.id)) continue;
            System.err.println("WARNING: no regional max mag mapping found for " + maxMagRecord.id + ". " + maxMagRecord.name);
        }
        RupSetMapMaker mapMaker = new RupSetMapMaker(modSects, plotReg);
        ArrayList<PlotCurveCharacterstics> arrayList = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<String> legendItems = new ArrayList<String>();
        legendItems.add("Activity Probability");
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, activityColor));
        legendItems.add("Recurrence Rate");
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, recurrenceColor));
        legendItems.add("Historical Max. Mag.");
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, histMagColor));
        legendItems.add("Regional Max. Mag.");
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, regMagColor));
        legendItems.add("Zone Source");
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        mapMaker.setCustomLegendItems(legendItems, arrayList);
        mapMaker.setLegendInset(RectangleAnchor.BOTTOM_LEFT);
        mapMaker.setSkipNaNs(true);
        mapMaker.plotSectColors(colors);
        ArrayList<Region> zoneRegions = new ArrayList<Region>();
        for (Feature feature : zones) {
            zoneRegions.add(Region.fromFeature(feature));
        }
        mapMaker.plotInsetRegions(zoneRegions, new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK), Color.GRAY, 0.1);
        mapMaker.plot(outputDir, prefix, "NSHM18 Special Cases");
        int numSpecial = 0;
        int numZoneOverlap = 0;
        int numOutsideCA = 0;
        int numEither = 0;
        Set<Integer> u3IDs = FaultModels.FM3_1.getFaultSectionIDMap().keySet();
        for (FaultSection faultSection : fullSects) {
            if (mapped.contains(faultSection.getSectionId())) {
                ++numSpecial;
            }
            if (u3IDs.contains(faultSection.getSectionId())) continue;
            ++numOutsideCA;
            boolean contained = false;
            for (Region reg : zoneRegions) {
                for (Location loc : faultSection.getFaultTrace()) {
                    if (!reg.contains(loc)) continue;
                    contained = true;
                }
            }
            if (contained) {
                ++numZoneOverlap;
            }
            if (!contained && !mapped.contains(faultSection.getSectionId())) continue;
            ++numEither;
        }
        DecimalFormat pDF = new DecimalFormat("0.0%");
        System.out.println(numSpecial + "/" + numOutsideCA + " (" + pDF.format((double)numSpecial / (double)numOutsideCA) + ") non-U3 faults are special cases");
        System.out.println(numZoneOverlap + "/" + numOutsideCA + " (" + pDF.format((double)numZoneOverlap / (double)numOutsideCA) + ") non-U3 faults lie in zone polygons");
        System.out.println(numEither + "/" + numOutsideCA + " (" + pDF.format((double)numEither / (double)numOutsideCA) + ") non-U3 faults are either special cases or lie in zone polygons");
    }

    public static void main(String[] args) throws IOException {
        SpecialCases.plotSpecialCases(new File("/tmp"), "nshm18_special_cases", NSHM23_RegionLoader.loadFullConterminousWUS());
    }

    static {
        ZONE_FILENAMES = new String[]{"charlevoix.geojson", "crittenden-co.geojson", "local.geojson", "narrow.geojson", "neokinema-wa-or.geojson", "river-picks.geojson", "shear-3.geojson", "wabash.geojson", "commerce-lineament.geojson", "eastern-rift-margin-n.geojson", "marianna.geojson", "neokinema-nv-ca.geojson", "regional.geojson", "shear-2.geojson", "shear-4.geojson"};
    }

    public static class ActivityProbRecord {
        int id;
        String name;
        String state;
        Double probability;
    }

    public static class RecurrenceRateRecord {
        int id;
        String name;
        String state;
        Double rate;
    }

    public static class MaxMagRecord {
        int id;
        String name;
        String state;
        Double magnitude;
    }
}

