/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

class SlipRateAllowedRupsFinder {
    SlipRateAllowedRupsFinder() {
    }

    static BitSet calcAllowedRuptures(FaultSystemRupSet rupSet, boolean[] zeroRateSects, BitSet externalSubset, int maxAllowedZeroRateSects) {
        Preconditions.checkArgument((maxAllowedZeroRateSects >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((zeroRateSects.length == rupSet.getNumSections() ? 1 : 0) != 0);
        BitSet allowedRups = new BitSet(rupSet.getNumRuptures());
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
            if (externalSubset != null && !externalSubset.get(rupIndex)) continue;
            int rupZeroSectCount = 0;
            for (int sect : rupSet.getSectionsIndicesForRup(rupIndex)) {
                if (!zeroRateSects[sect]) continue;
                ++rupZeroSectCount;
            }
            boolean allowed = false;
            if (rupZeroSectCount <= maxAllowedZeroRateSects) {
                allowed = true;
                if (rupZeroSectCount > 0) {
                    ClusterRupture rup = cRups.get(rupIndex);
                    for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                        boolean clusterNonZero = false;
                        for (FaultSection sect : cluster.subSects) {
                            clusterNonZero |= !zeroRateSects[sect.getSectionId()];
                        }
                        if (clusterNonZero) continue;
                        allowed = false;
                        break;
                    }
                    if (!allowed) continue;
                    ArrayList<FaultSubsectionCluster> endClusters = new ArrayList<FaultSubsectionCluster>(2 + rup.getTotalNumSplays());
                    endClusters.add(rup.clusters[0].reversed());
                    if (rup.singleStrand) {
                        endClusters.add(rup.clusters[rup.clusters.length - 1]);
                    } else {
                        SlipRateAllowedRupsFinder.findEndsRecursive(rup.getTreeNavigator(), rup.clusters[0], endClusters);
                    }
                    for (FaultSubsectionCluster endCluster : endClusters) {
                        int numSects = endCluster.subSects.size();
                        int endID = ((FaultSection)endCluster.subSects.get(numSects - 1)).getSectionId();
                        if (!zeroRateSects[endID] || numSects <= 2) continue;
                        allowed = false;
                    }
                } else {
                    allowed = true;
                }
            }
            if (!allowed) continue;
            allowedRups.set(rupIndex);
        }
        return allowedRups;
    }

    private static void findEndsRecursive(RuptureTreeNavigator nav, FaultSubsectionCluster curCluster, List<FaultSubsectionCluster> ends) {
        Collection<FaultSubsectionCluster> descendants = nav.getDescendants(curCluster);
        if (descendants.isEmpty()) {
            ends.add(curCluster);
        } else {
            for (FaultSubsectionCluster dest : descendants) {
                SlipRateAllowedRupsFinder.findEndsRecursive(nav, dest, ends);
            }
        }
    }
}

