/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBValuePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SolMFDPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SectionSupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SlipRateAllowedRupsFinder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SegmentationImpliedSectNuclMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.ThresholdAveragingSectNuclMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SparseGutenbergRichterSolver;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;

public class SupraSeisBValInversionTargetMFDs
extends InversionTargetMFDs.Precomputed {
    public static final boolean D = false;
    public static SubSeisMoRateReduction SUB_SEIS_MO_RATE_REDUCTION_DEFAULT = SubSeisMoRateReduction.NONE;
    public static final DoubleUnaryOperator MAG_DEP_REL_STD_DEV_DEFAULT = M -> 0.1;
    public static final boolean APPLY_DEF_MODEL_UNCERTAINTIES_DEFAULT = true;
    public static final boolean SPARSE_GR_DEFAULT = true;
    public static boolean SPARSE_GR_DONT_SPREAD_SINGLE_TO_MULTI = true;
    public static final boolean ADD_SECT_COUNT_UNCERTAINTIES_DEFAULT = false;
    public static final boolean USE_CREEP_REDUCED_SLIP_STD_DEVS_DEFAULT = false;
    public static final int MAX_NUM_ZERO_SLIP_SECTS_PER_RUP = 1;
    private static final DecimalFormat twoDigits = new DecimalFormat("0.00");
    private double supraSeisBValue;
    private double[] sectSpecificBValues;
    private double supraSeisMagCorner;
    private double[] sectSpecificMagCorners;
    private List<UncertainIncrMagFreqDist> supraSeismoOnFaultMFDs;
    private SectSlipRates sectSlipRates;
    private List<BitSet> sectRupUtilizations;

    private SupraSeisBValInversionTargetMFDs(FaultSystemRupSet rupSet, double supraSeisBValue, double[] sectSpecificBValues, IncrementalMagFreqDist totalRegionalMFD, UncertainIncrMagFreqDist onFaultSupraSeisMFD, IncrementalMagFreqDist onFaultSubSeisMFD, List<UncertainIncrMagFreqDist> mfdConstraints, SubSeismoOnFaultMFDs subSeismoOnFaultMFDs, List<UncertainIncrMagFreqDist> supraSeismoOnFaultMFDs, SectSlipRates sectSlipRates, List<BitSet> sectRupUtilizations, double supraSeisMagCorner, double[] sectSpecificMagCorners) {
        super(rupSet, totalRegionalMFD, onFaultSupraSeisMFD, onFaultSubSeisMFD, null, mfdConstraints, subSeismoOnFaultMFDs, supraSeismoOnFaultMFDs);
        if (sectSpecificBValues == null) {
            this.supraSeisBValue = supraSeisBValue;
        } else {
            this.sectSpecificBValues = sectSpecificBValues;
            Preconditions.checkState((rupSet == null || sectSpecificBValues.length == rupSet.getNumSections() ? 1 : 0) != 0);
            this.supraSeisBValue = Double.isFinite(supraSeisBValue) ? supraSeisBValue : StatUtils.mean((double[])sectSpecificBValues);
        }
        this.supraSeisMagCorner = supraSeisMagCorner;
        this.sectSpecificMagCorners = sectSpecificMagCorners;
        this.supraSeismoOnFaultMFDs = supraSeismoOnFaultMFDs;
        this.sectSlipRates = sectSlipRates;
        this.sectRupUtilizations = sectRupUtilizations;
    }

    public SectSlipRates getSectSlipRates() {
        return this.sectSlipRates;
    }

    public double getSupraSeisBValue() {
        return this.supraSeisBValue;
    }

    public double[] getSectSpecificBValues() {
        return this.sectSpecificBValues;
    }

    public List<UncertainIncrMagFreqDist> getOnFaultSupraSeisNucleationMFDs() {
        return this.supraSeismoOnFaultMFDs;
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return InversionTargetMFDs.Precomputed.class;
    }

    public List<Integer> getRupturesForSect(int sectIndex) {
        BitSet utilization = this.sectRupUtilizations.get(sectIndex);
        ArrayList<Integer> rups = new ArrayList<Integer>();
        int r = utilization.nextSetBit(0);
        while (r >= 0) {
            rups.add(r);
            r = utilization.nextSetBit(r + 1);
        }
        return rups;
    }

    @Override
    public AverageableModule.AveragingAccumulator<InversionTargetMFDs> averagingAccumulator() {
        return null;
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/data/kevin/nshm23/def_models/NSHM23_v1p4/GEOLOGIC.zip"));
        InversionTargetMFDs origTargets = rupSet.getModule(InversionTargetMFDs.class);
        SectSlipRates origSlips = rupSet.getModule(SectSlipRates.class);
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, (Region)new CaliforniaRegions.RELM_TESTING());
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
        rupSet = FaultSystemRupSet.buildFromExisting(rupSet).forScalingRelationship(NSHM23_ScalingRelationships.AVERAGE).build();
        double b = 0.5;
        Builder builder = new Builder(rupSet, b);
        builder.sparseGR(true);
        builder.magDepDefaultRelStdDev(M -> 0.05 * Math.max(1.0, Math.pow(10.0, b * 0.5 * (M - 6.0))));
        builder.applyDefModelUncertainties(true);
        builder.addSectCountUncertainties(false);
        builder.totalTargetMFD(rupSet.requireModule(InversionTargetMFDs.class).getTotalRegionalMFD());
        builder.subSeisMoRateReduction(SubSeisMoRateReduction.SUB_SEIS_B_1);
        JumpProbabilityCalc segModel = NSHM23_SegmentationModels.HIGH.getModel(rupSet, rupSet.getModule(LogicTreeBranch.class));
        builder.adjustTargetsForData(new ThresholdAveragingSectNuclMFD_Estimator.RelGRWorstJumpProb(segModel, 100, true));
        SupraSeisBValInversionTargetMFDs target = builder.build();
        rupSet.addModule(target);
        SectSlipRates modSlipRates = rupSet.getModule(SectSlipRates.class);
        double[] sectFractSupras = new double[rupSet.getNumSections()];
        double[] u3FractSupra = new double[rupSet.getNumSections()];
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker u3track = new DataUtils.MinMaxAveTracker();
        for (int s = 0; s < u3FractSupra.length; ++s) {
            double creepReduced = rupSet.getFaultSectionData(s).getReducedAveSlipRate() * 0.001;
            u3FractSupra[s] = origSlips.getSlipRate(s) / creepReduced;
            sectFractSupras[s] = modSlipRates.getSlipRate(s) / creepReduced;
            track.addValue(sectFractSupras[s]);
            u3track.addValue(u3FractSupra[s]);
        }
        System.out.println("My fracts: " + String.valueOf(track));
        System.out.println("U3 fracts: " + String.valueOf(u3track));
        mapMaker.plotSectScalars(sectFractSupras, cpt, "New Fraction of Moment Supra-Seismogenic");
        File outputDir = new File("/tmp");
        mapMaker.plot(outputDir, "supra_seis_fracts", " ");
        mapMaker.plotSectScalars(u3FractSupra, cpt, "U3 Fraction of Moment Supra-Seismogenic");
        mapMaker.plot(outputDir, "supra_seis_fracts_u3", " ");
        SolMFDPlot plot = new SolMFDPlot();
        File mfdOutput = new File(outputDir, "test_target_mfds");
        Preconditions.checkState((mfdOutput.exists() || mfdOutput.mkdir() ? 1 : 0) != 0);
        plot.writePlot(rupSet, null, "Test Model", mfdOutput);
        if (builder.targetAdjDataConstraints != null && !builder.targetAdjDataConstraints.isEmpty() && (builder.targetAdjDataConstraints.get(0) instanceof SegmentationImpliedSectNuclMFD_Estimator || builder.targetAdjDataConstraints.get(0) instanceof ThresholdAveragingSectNuclMFD_Estimator) || builder.rupSubSet != null) {
            int[] debugSects = new int[]{4412};
            builder.clearTargetAdjustments();
            SupraSeisBValInversionTargetMFDs targetNoSeg = builder.build();
            SupraSeisBValInversionTargetMFDs targetOrigGR = null;
            if (builder.sparseGR) {
                builder.sparseGR(false);
                targetOrigGR = builder.build();
            }
            for (int debugSect : debugSects) {
                IncrementalMagFreqDist improbSupraMFD = target.supraSeismoOnFaultMFDs.get(debugSect);
                IncrementalMagFreqDist origSupraMFD = targetNoSeg.supraSeismoOnFaultMFDs.get(debugSect);
                ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                if (targetOrigGR != null) {
                    builder.sparseGR(false);
                    IncrementalMagFreqDist origGR = targetOrigGR.supraSeismoOnFaultMFDs.get(debugSect);
                    funcs.add(origGR);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
                }
                SupraSeisBValInversionTargetMFDs.annotateNuclMFD(origSupraMFD, debugSect, "Original Supra-Seis", rupSet);
                funcs.add(origSupraMFD);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
                SupraSeisBValInversionTargetMFDs.annotateNuclMFD(improbSupraMFD, debugSect, "Modified Supra-Seis", rupSet);
                funcs.add(improbSupraMFD);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
                double minX = Double.POSITIVE_INFINITY;
                double maxX = 0.0;
                double minY = Double.POSITIVE_INFINITY;
                double maxY = 0.0;
                for (IncrementalMagFreqDist func : funcs) {
                    for (Point2D pt : func) {
                        if (!(pt.getY() > 0.0)) continue;
                        minX = Math.min(minX, pt.getX());
                        minY = Math.min(minY, pt.getY());
                        maxX = Math.max(maxX, pt.getX());
                        maxY = Math.max(maxY, pt.getY());
                    }
                }
                minX -= 0.5 * origSupraMFD.getDelta();
                maxX += 0.5 * origSupraMFD.getDelta();
                minY = Math.pow(10.0, Math.floor(Math.log10(minY)));
                maxY = Math.pow(10.0, Math.ceil(Math.log10(maxY)));
                PlotSpec spec = new PlotSpec(funcs, chars, rupSet.getFaultSectionData(debugSect).getName(), "Mag", "Supra Rate");
                GraphWindow gw = new GraphWindow(spec);
                gw.setYLog(true);
                gw.setAxisRange(minX, maxX, minY, maxY);
                gw.setDefaultCloseOperation(3);
            }
        }
    }

    private static void annotateNuclMFD(IncrementalMagFreqDist mfd, int sectIndex, String name, FaultSystemRupSet rupSet) {
        mfd.setName(name);
        double totRate = mfd.calcSumOfY_Vals();
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = Double.NEGATIVE_INFINITY;
        for (Point2D pt : mfd) {
            if (!(pt.getY() > 0.0)) continue;
            minMag = Math.min(minMag, pt.getX());
            maxMag = Math.max(maxMag, pt.getX());
        }
        double equivB = SectBValuePlot.estBValue(minMag, maxMag, totRate, mfd.getTotalMomentRate());
        String info = "Total Nucleation Rate: " + (float)totRate + "\n\tb-value: " + (float)equivB;
        int[] rupCounts = new int[mfd.size()];
        double[] avgBinAreas = new double[mfd.size()];
        for (int rupIndex : rupSet.getRupturesForSection(sectIndex)) {
            int magIndex = mfd.getClosestXIndex(rupSet.getMagForRup(rupIndex));
            if (!(mfd.getY(magIndex) > 0.0)) continue;
            int n = magIndex;
            rupCounts[n] = rupCounts[n] + 1;
            int n2 = magIndex;
            avgBinAreas[n2] = avgBinAreas[n2] + rupSet.getAreaForRup(rupIndex);
        }
        int minMagIndex = mfd.getClosestXIndex(minMag);
        int maxMagIndex = mfd.getClosestXIndex(maxMag);
        double[] nuclToParticScalars = new double[mfd.size()];
        double sectArea = rupSet.getAreaForSection(sectIndex);
        for (int m = 0; m < rupCounts.length; ++m) {
            if (rupCounts[m] <= 0) continue;
            int n = m;
            avgBinAreas[n] = avgBinAreas[n] / (double)rupCounts[m];
            nuclToParticScalars[m] = avgBinAreas[m] / sectArea;
        }
        IncrementalMagFreqDist particMFD = new IncrementalMagFreqDist(mfd.getMinX(), mfd.size(), mfd.getDelta());
        for (int m = 0; m < rupCounts.length; ++m) {
            if (rupCounts[m] <= 0) continue;
            particMFD.set(m, mfd.getY(m) * nuclToParticScalars[m]);
        }
        totRate = particMFD.calcSumOfY_Vals();
        equivB = SectBValuePlot.estBValue(minMag, maxMag, totRate, particMFD.getTotalMomentRate());
        info = info + "\nTotal Participation Rate: " + (float)totRate + "\n\tb-value: " + (float)equivB;
        mfd.setInfo(info);
    }

    public static class Builder {
        private FaultSystemRupSet rupSet;
        private double supraSeisBValue;
        private double[] sectSpecificBValues;
        private double supraSeisMagCorner;
        private double[] sectSpecificMagCorners;
        private IncrementalMagFreqDist totalTargetMFD;
        private SubSeisMoRateReduction subSeisMoRateReduction = SUB_SEIS_MO_RATE_REDUCTION_DEFAULT;
        private DoubleUnaryOperator magDepRelStdDev = MAG_DEP_REL_STD_DEV_DEFAULT;
        private boolean applyDefModelUncertainties = true;
        private boolean sparseGR = true;
        private boolean addSectCountUncertainties = false;
        private boolean useCreepReducedSlipStdDevs = false;
        private int maxNumZeroSlipSectsPerRup = 1;
        private double slipStdDevFloor = 0.0;
        private BitSet rupSubSet;
        private List<SectNucleationMFD_Estimator> targetAdjDataConstraints;
        private List<? extends SectNucleationMFD_Estimator> uncertAdjDataConstraints;
        private UncertaintyBoundType uncertAdjDataTargetBound;
        private List<Region> constrainedRegions;
        private static final boolean DEF_MOD_SUM_VARIANCES = true;

        public Builder(FaultSystemRupSet rupSet, SectionSupraSeisBValues bValues) {
            this.rupSet = rupSet;
            this.sectSpecificBValues = bValues.getSectBValues(rupSet);
            this.supraSeisBValue = this.sectSpecificBValues == null ? bValues.getB() : Double.NaN;
        }

        public Builder(FaultSystemRupSet rupSet, double supraSeisBValue) {
            this.rupSet = rupSet;
            this.supraSeisBValue = supraSeisBValue;
        }

        public Builder(FaultSystemRupSet rupSet, double[] sectSpecificBValues) {
            this.rupSet = rupSet;
            this.supraSeisBValue = Double.NaN;
            this.sectSpecificBValues = sectSpecificBValues;
        }

        public Builder subSeisMoRateReduction(SubSeisMoRateReduction subSeisMoRateReduction) {
            this.subSeisMoRateReduction = subSeisMoRateReduction;
            return this;
        }

        public Builder constantDefaultRelStdDev(double relStdDev) {
            this.magDepRelStdDev = M -> relStdDev;
            return this;
        }

        public Builder magDepDefaultRelStdDev(DoubleUnaryOperator magDepRelStdDevv) {
            this.magDepRelStdDev = magDepRelStdDevv;
            return this;
        }

        public Builder applyDefModelUncertainties(boolean applyDefModelUncertainties) {
            this.applyDefModelUncertainties = applyDefModelUncertainties;
            return this;
        }

        public Builder addSectCountUncertainties(boolean addSectCountUncertainties) {
            this.addSectCountUncertainties = addSectCountUncertainties;
            return this;
        }

        public Builder sparseGR(boolean sparseGR) {
            this.sparseGR = sparseGR;
            return this;
        }

        public Builder useCreepReducedSlipStdDevs(boolean useCreepReducedSlipStdDevs) {
            this.useCreepReducedSlipStdDevs = useCreepReducedSlipStdDevs;
            return this;
        }

        public Builder maxNumZeroSlipSectsPerRup(int maxNumZeroSlipSectsPerRup) {
            Preconditions.checkArgument((maxNumZeroSlipSectsPerRup >= 0 ? 1 : 0) != 0);
            this.maxNumZeroSlipSectsPerRup = maxNumZeroSlipSectsPerRup;
            return this;
        }

        public Builder slipStdDevFloor(double slipStdDevFloor) {
            this.slipStdDevFloor = slipStdDevFloor;
            return this;
        }

        public Builder forBinaryRupProbModel(RuptureProbabilityCalc.BinaryRuptureProbabilityCalc binaryRupProb) {
            return this.forBinaryRupProbModel(binaryRupProb, true);
        }

        public Builder forBinaryRupProbModel(RuptureProbabilityCalc.BinaryRuptureProbabilityCalc binaryRupProb, boolean replaceExisting) {
            BitSet rupSubSet = new BitSet(this.rupSet.getNumRuptures());
            ClusterRuptures cRups = this.rupSet.requireModule(ClusterRuptures.class);
            System.out.println("Processing " + this.rupSet.getNumRuptures() + " ruptures for binary rupture probability calculation");
            for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
                ClusterRupture rup = cRups.get(r);
                if (!binaryRupProb.isRupAllowed(rup, false)) continue;
                rupSubSet.set(r);
            }
            return this.forRupSubSet(rupSubSet, replaceExisting);
        }

        public Builder forRupSubSet(BitSet rupSubSet) {
            return this.forRupSubSet(rupSubSet, true);
        }

        public Builder forRupSubSet(BitSet rupSubSet, boolean replaceExisting) {
            if (!replaceExisting && rupSubSet != null && this.rupSubSet != null) {
                this.rupSubSet.and(rupSubSet);
            } else {
                this.rupSubSet = rupSubSet;
            }
            return this;
        }

        public Builder adjustTargetsForData(SectNucleationMFD_Estimator dataConstraint) {
            if (this.targetAdjDataConstraints == null) {
                this.targetAdjDataConstraints = new ArrayList<SectNucleationMFD_Estimator>();
            }
            this.targetAdjDataConstraints.add(dataConstraint);
            return this;
        }

        public Builder clearTargetAdjustments() {
            this.targetAdjDataConstraints = null;
            return this;
        }

        public Builder expandUncertaintiesForData(List<? extends SectNucleationMFD_Estimator> dataConstraints, UncertaintyBoundType boundType) {
            this.uncertAdjDataConstraints = dataConstraints;
            this.uncertAdjDataTargetBound = boundType;
            return this;
        }

        public Builder totalTargetMFD(IncrementalMagFreqDist totalTargetMFD) {
            this.totalTargetMFD = totalTargetMFD;
            return this;
        }

        public Builder supraSeisMagCorner(double magCorner) {
            this.supraSeisMagCorner = magCorner;
            this.sectSpecificMagCorners = null;
            return this;
        }

        public Builder sectSpecificMagCorner(double[] magCorners) {
            this.supraSeisMagCorner = Double.NaN;
            this.sectSpecificMagCorners = magCorners;
            return this;
        }

        public SectSlipRates buildSlipRatesOnly() {
            return this.build((boolean)true).sectSlipRates;
        }

        public SupraSeisBValInversionTargetMFDs build() {
            return this.build(false);
        }

        /*
         * WARNING - void declaration
         */
        private SupraSeisBValInversionTargetMFDs build(boolean slipOnly) {
            void var16_30;
            SubSeismoOnFaultMFDs subSeismoMFDs;
            SummedMagFreqDist totalOnFaultSub;
            String bString;
            IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(this.rupSet);
            int NUM_MAG = refMFD.size();
            if (this.sectSpecificBValues == null) {
                bString = "b=" + (float)this.supraSeisBValue;
            } else {
                DataUtils.MinMaxAveTracker bStats = new DataUtils.MinMaxAveTracker();
                for (double b : this.sectSpecificBValues) {
                    bStats.addValue(b);
                }
                bString = "section-specific b (avg=" + twoDigits.format(bStats.getAverage()) + ", range=[" + twoDigits.format(bStats.getMin()) + ", " + twoDigits.format(bStats.getMax()) + "], N=" + this.sectSpecificBValues.length + ")";
            }
            System.out.println("Building SupraSeisBValInversionTargetMFDs with " + bString + ", slipOnly=" + slipOnly + ", total MFD range: [0.05," + (float)refMFD.getMaxX() + "] for maxMag=" + this.rupSet.getMaxMag());
            ModSectMinMags minMags = this.rupSet.getModule(ModSectMinMags.class);
            int numSects = this.rupSet.getNumSections();
            BitSet zeroRateAllowed = null;
            BitSet highDMZeroRateAllowed = null;
            if (this.maxNumZeroSlipSectsPerRup < Integer.MAX_VALUE) {
                boolean[] zeroRateSects = new boolean[this.rupSet.getNumSections()];
                boolean[] highDMZeroRateSects = this.applyDefModelUncertainties ? new boolean[zeroRateSects.length] : null;
                int numZeroSects = 0;
                for (int s = 0; s < zeroRateSects.length; ++s) {
                    double d;
                    FaultSection sect = this.rupSet.getFaultSectionData(s);
                    double slipRate = sect.getReducedAveSlipRate();
                    double d2 = d = this.useCreepReducedSlipStdDevs ? sect.getReducedSlipRateStdDev() : sect.getOrigSlipRateStdDev();
                    if (slipRate != 0.0) continue;
                    ++numZeroSects;
                    zeroRateSects[s] = true;
                    if ((!this.applyDefModelUncertainties || !Double.isNaN(d)) && d != 0.0) continue;
                    highDMZeroRateSects[s] = true;
                }
                zeroRateAllowed = SlipRateAllowedRupsFinder.calcAllowedRuptures(this.rupSet, zeroRateSects, this.rupSubSet, this.maxNumZeroSlipSectsPerRup);
                if (this.applyDefModelUncertainties) {
                    highDMZeroRateAllowed = SlipRateAllowedRupsFinder.calcAllowedRuptures(this.rupSet, highDMZeroRateSects, this.rupSubSet, this.maxNumZeroSlipSectsPerRup);
                }
            }
            ExecutorService exec = null;
            if (this.targetAdjDataConstraints != null || this.uncertAdjDataConstraints != null) {
                exec = Executors.newFixedThreadPool(FaultSysTools.defaultNumThreads());
            }
            SectMFDCalculator calc = new SectMFDCalculator();
            calc.calc(exec, refMFD, minMags, zeroRateAllowed, slipOnly, 0.0);
            if (this.subSeisMoRateReduction != SubSeisMoRateReduction.FROM_INPUT_SLIP_RATES) {
                this.rupSet.addModule(calc.sectSlipRates);
            }
            if (slipOnly) {
                return new SupraSeisBValInversionTargetMFDs(this.rupSet, this.supraSeisBValue, this.sectSpecificBValues, null, null, null, null, null, null, calc.sectSlipRates, null, Double.NaN, null);
            }
            SectMFDCalculator dmLowerCalc = null;
            SectMFDCalculator dmUpperCalc = null;
            if (this.applyDefModelUncertainties) {
                System.out.println("Re-calculating MFDs using low slip rates");
                dmLowerCalc = new SectMFDCalculator();
                dmLowerCalc.calc(exec, refMFD, minMags, zeroRateAllowed, false, -1.0);
                System.out.println("Re-calculating MFDs using high slip rates");
                dmUpperCalc = new SectMFDCalculator();
                dmUpperCalc.calc(exec, refMFD, minMags, highDMZeroRateAllowed, false, 1.0);
                System.out.println("Done with DM high/low MFD estimation");
            }
            ArrayList<EvenlyDiscretizedFunc> defModMFDStdDevs = null;
            if (this.applyDefModelUncertainties) {
                defModMFDStdDevs = new ArrayList<EvenlyDiscretizedFunc>();
                for (int s = 0; s < numSects; ++s) {
                    EvenlyDiscretizedFunc defModStdDevs = null;
                    if (calc.slipRateStdDevs[s] > 0.0) {
                        IncrementalMagFreqDist incrementalMagFreqDist = dmUpperCalc.sectSupraSeisMFDs.get(s);
                        IncrementalMagFreqDist incrementalMagFreqDist2 = dmLowerCalc.sectSupraSeisMFDs.get(s);
                        defModStdDevs = new EvenlyDiscretizedFunc(0.05, NUM_MAG, 0.1);
                        for (int i = 0; i < NUM_MAG; ++i) {
                            double upper = incrementalMagFreqDist.getY(i);
                            if (upper == 0.0) continue;
                            double lower = incrementalMagFreqDist2.getY(i);
                            double sd = (upper - lower) / 2.0;
                            defModStdDevs.set(i, sd);
                        }
                    }
                    defModMFDStdDevs.add(defModStdDevs);
                }
            }
            ArrayList<IncrementalMagFreqDist> dataImpliedSectSupraSeisMFDs = null;
            if (this.uncertAdjDataConstraints != null) {
                Preconditions.checkNotNull((Object)((Object)this.uncertAdjDataTargetBound));
                dataImpliedSectSupraSeisMFDs = new ArrayList<IncrementalMagFreqDist>();
                for (int s = 0; s < numSects; ++s) {
                    dataImpliedSectSupraSeisMFDs.add(null);
                }
                for (SectNucleationMFD_Estimator sectNucleationMFD_Estimator : this.uncertAdjDataConstraints) {
                    sectNucleationMFD_Estimator.init(this.rupSet, calc.sectSupraSeisMFDs, calc.targetSupraMoRates, calc.slipRates, calc.slipRateStdDevs, calc.sectRupUtilizations, calc.sectMinMagIndexes, calc.sectMaxMagIndexes, calc.sectRupInBinCounts, refMFD);
                }
                List<Future<DataEstCallable>> futures = this.estimateSectNuclMFDs(this.uncertAdjDataConstraints, calc.slipRates, calc.slipRateStdDevs, calc.targetSupraMoRates, calc.sectRupUtilizations, calc.sectSupraSeisMFDs, exec);
                for (Future<DataEstCallable> future : futures) {
                    DataEstCallable call;
                    try {
                        call = future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    int sectID = call.sect.getSectionId();
                    Preconditions.checkState((dataImpliedSectSupraSeisMFDs.get(sectID) == null ? 1 : 0) != 0);
                    dataImpliedSectSupraSeisMFDs.set(sectID, call.impliedMFD);
                }
                System.out.println("Done with data estimation.");
            }
            UncertainIncrMagFreqDist totalOnFaultSupra = this.calcRegionalSupraTarget(refMFD, null, calc.sectSupraSeisMFDs, defModMFDStdDevs, dataImpliedSectSupraSeisMFDs);
            if (this.constrainedRegions != null) {
                Preconditions.checkState((!this.constrainedRegions.isEmpty() ? 1 : 0) != 0, (Object)"Empty region list supplied");
                ArrayList<UncertainIncrMagFreqDist> arrayList = new ArrayList<UncertainIncrMagFreqDist>();
                for (Region region : this.constrainedRegions) {
                    arrayList.add(this.calcRegionalSupraTarget(refMFD, region, calc.sectSupraSeisMFDs, defModMFDStdDevs, dataImpliedSectSupraSeisMFDs));
                }
            } else {
                List<UncertainIncrMagFreqDist> list = List.of(totalOnFaultSupra);
            }
            ArrayList<UncertainIncrMagFreqDist> arrayList = new ArrayList<UncertainIncrMagFreqDist>();
            for (int s = 0; s < numSects; ++s) {
                IncrementalMagFreqDist impliedMFD;
                EvenlyDiscretizedFunc defModStdDevs;
                IncrementalMagFreqDist sectSupraMFD = calc.sectSupraSeisMFDs.get(s);
                EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(0.05, sectSupraMFD.size(), 0.1);
                for (int i = 0; i < stdDevs.size(); ++i) {
                    stdDevs.set(i, sectSupraMFD.getY(i) * this.magDepRelStdDev.applyAsDouble(stdDevs.getX(i)));
                }
                if (this.applyDefModelUncertainties && (defModStdDevs = (EvenlyDiscretizedFunc)defModMFDStdDevs.get(s)) != null) {
                    for (int i = 0; i < stdDevs.size(); ++i) {
                        stdDevs.set(i, Math.max(stdDevs.getY(i), defModStdDevs.getY(i)));
                    }
                }
                UncertainIncrMagFreqDist uncertainSectSupraMFD = new UncertainIncrMagFreqDist(sectSupraMFD, stdDevs);
                if (dataImpliedSectSupraSeisMFDs != null && (impliedMFD = (IncrementalMagFreqDist)dataImpliedSectSupraSeisMFDs.get(s)) != null) {
                    uncertainSectSupraMFD = this.adjustForDataImpliedBounds(uncertainSectSupraMFD, impliedMFD, false);
                }
                arrayList.add(uncertainSectSupraMFD);
            }
            if (this.subSeisMoRateReduction == SubSeisMoRateReduction.NONE) {
                totalOnFaultSub = null;
                subSeismoMFDs = null;
            } else {
                totalOnFaultSub = new SummedMagFreqDist(0.05, refMFD.size(), 0.1);
                for (IncrementalMagFreqDist subSeisMFD : calc.sectSubSeisMFDs) {
                    totalOnFaultSub.addIncrementalMagFreqDist(subSeisMFD);
                }
                subSeismoMFDs = new SubSeismoOnFaultMFDs(calc.sectSubSeisMFDs);
            }
            if (exec != null) {
                exec.shutdown();
            }
            return new SupraSeisBValInversionTargetMFDs(this.rupSet, this.supraSeisBValue, this.sectSpecificBValues, this.totalTargetMFD, totalOnFaultSupra, totalOnFaultSub, (List<UncertainIncrMagFreqDist>)var16_30, subSeismoMFDs, arrayList, calc.sectSlipRates, calc.sectRupUtilizations, this.supraSeisMagCorner, this.sectSpecificMagCorners);
        }

        public List<Future<DataEstCallable>> estimateSectNuclMFDs(List<? extends SectNucleationMFD_Estimator> estimators, double[] slipRates, double[] slipRateStdDevs, double[] targetSupraMoRates, List<BitSet> sectRupUtilizations, List<IncrementalMagFreqDist> sectSupraSeisMFDs, ExecutorService exec) {
            ArrayList<Future<DataEstCallable>> futures = new ArrayList<Future<DataEstCallable>>();
            for (int s = 0; s < slipRates.length; ++s) {
                FaultSection sect = this.rupSet.getFaultSectionData(s);
                if (targetSupraMoRates[s] == 0.0 || slipRates[s] == 0.0) continue;
                ArrayList<SectNucleationMFD_Estimator> constraints = new ArrayList<SectNucleationMFD_Estimator>();
                for (SectNucleationMFD_Estimator sectNucleationMFD_Estimator : estimators) {
                    if (!sectNucleationMFD_Estimator.appliesTo(sect)) continue;
                    constraints.add(sectNucleationMFD_Estimator);
                }
                if (constraints.isEmpty()) continue;
                double relDefModStdDev = slipRateStdDevs[s] / slipRates[s];
                double supraMoRate = targetSupraMoRates[s];
                IncrementalMagFreqDist supraSeisMFD = sectSupraSeisMFDs.get(s);
                ArrayList<Integer> rups = new ArrayList<Integer>();
                ArrayList<Double> mags = new ArrayList<Double>();
                this.fillInRupsAndMags(sectRupUtilizations.get(s), rups, mags);
                UncertainDataConstraint moRateBounds = new UncertainDataConstraint(null, supraMoRate, new Uncertainty(supraMoRate * relDefModStdDev));
                futures.add(exec.submit(new DataEstCallable(sect, constraints, supraSeisMFD, mags, rups, moRateBounds)));
            }
            System.out.println("Waiting on " + futures.size() + " data estimation futures...");
            return futures;
        }

        private void fillInRupsAndMags(BitSet utilization, List<Integer> rups, List<Double> mags) {
            int r = utilization.nextSetBit(0);
            while (r >= 0) {
                if (rups != null) {
                    rups.add(r);
                }
                if (mags != null) {
                    mags.add(this.rupSet.getMagForRup(r));
                }
                r = utilization.nextSetBit(r + 1);
            }
        }

        private UncertainIncrMagFreqDist calcRegionalSupraTarget(EvenlyDiscretizedFunc refMFD, Region region, List<IncrementalMagFreqDist> sectSupraSeisMFDs, List<EvenlyDiscretizedFunc> defModMFDStdDevs, List<IncrementalMagFreqDist> dataImpliedSectSupraSeisMFDs) {
            IncrementalMagFreqDist sumMFD = new IncrementalMagFreqDist(0.05, refMFD.size(), 0.1);
            double[] binCounts = new double[refMFD.size()];
            sumMFD.setRegion(region);
            double[] fractSectsInRegion = null;
            if (region != null) {
                fractSectsInRegion = this.rupSet.getFractSectsInsideRegion(region, false);
            }
            for (int s = 0; s < sectSupraSeisMFDs.size(); ++s) {
                double scale;
                double d = scale = fractSectsInRegion == null ? 1.0 : fractSectsInRegion[s];
                if (!(scale > 0.0)) continue;
                IncrementalMagFreqDist supraMFD = sectSupraSeisMFDs.get(s);
                Preconditions.checkState(((float)supraMFD.getMinX() == 0.05f ? 1 : 0) != 0);
                Preconditions.checkState(((float)supraMFD.getDelta() == 0.1f ? 1 : 0) != 0);
                for (int i = 0; i < supraMFD.size(); ++i) {
                    double rate = supraMFD.getY(i);
                    if (!(rate > 0.0)) continue;
                    int n = i;
                    binCounts[n] = binCounts[n] + 1.0;
                    sumMFD.add(i, rate);
                }
            }
            EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(0.05, refMFD.size(), 0.1);
            if (defModMFDStdDevs != null) {
                Preconditions.checkState((defModMFDStdDevs.size() == sectSupraSeisMFDs.size() ? 1 : 0) != 0);
                for (int s = 0; s < defModMFDStdDevs.size(); ++s) {
                    double scale;
                    EvenlyDiscretizedFunc dmStdDevs = defModMFDStdDevs.get(s);
                    double d = scale = fractSectsInRegion == null ? 1.0 : fractSectsInRegion[s];
                    if (!(scale > 0.0) || dmStdDevs == null) continue;
                    for (int i = 0; i < dmStdDevs.size(); ++i) {
                        stdDevs.add(i, Math.pow(dmStdDevs.getY(i), 2.0));
                    }
                }
                for (int i = 0; i < refMFD.size(); ++i) {
                    stdDevs.set(i, Math.sqrt(stdDevs.getY(i)));
                }
            }
            for (int i = 0; i < refMFD.size(); ++i) {
                stdDevs.set(i, Math.max(stdDevs.getY(i), sumMFD.getY(i) * this.magDepRelStdDev.applyAsDouble(stdDevs.getX(i))));
            }
            if (this.addSectCountUncertainties) {
                double refNum = fractSectsInRegion == null ? (double)sectSupraSeisMFDs.size() : StatUtils.sum((double[])fractSectsInRegion);
                System.out.println("Re-weighting target MFD to account for section participation uncertainties.");
                double max = StatUtils.max((double[])binCounts);
                System.out.println("\tMax section participation: " + (float)max);
                System.out.println("\tReference section participation: " + (float)refNum);
                for (int i = 0; i < binCounts.length; ++i) {
                    double rate = sumMFD.getY(i);
                    if (binCounts[i] == 0.0 || rate == 0.0) continue;
                    double relStdDev = Math.sqrt(refNum) / Math.sqrt(binCounts[i]);
                    double origStdDev = stdDevs.getY(i);
                    double origRel = origStdDev / rate;
                    stdDevs.set(i, origStdDev * relStdDev);
                }
            }
            UncertainIncrMagFreqDist uncertainMFD = new UncertainIncrMagFreqDist(sumMFD, stdDevs);
            if (dataImpliedSectSupraSeisMFDs != null) {
                Preconditions.checkState((dataImpliedSectSupraSeisMFDs.size() == sectSupraSeisMFDs.size() ? 1 : 0) != 0);
                IncrementalMagFreqDist sumImpliedMFD = new IncrementalMagFreqDist(0.05, refMFD.size(), 0.1);
                IncrementalMagFreqDist sumLowerMFD = new IncrementalMagFreqDist(0.05, refMFD.size(), 0.1);
                IncrementalMagFreqDist sumUpperMFD = new IncrementalMagFreqDist(0.05, refMFD.size(), 0.1);
                for (int s = 0; s < dataImpliedSectSupraSeisMFDs.size(); ++s) {
                    int i;
                    double scale;
                    double d = scale = fractSectsInRegion == null ? 1.0 : fractSectsInRegion[s];
                    if (!(scale > 0.0)) continue;
                    IncrementalMagFreqDist impliedMFD = dataImpliedSectSupraSeisMFDs.get(s);
                    if (impliedMFD == null) {
                        impliedMFD = sectSupraSeisMFDs.get(s);
                    }
                    Preconditions.checkState(((float)impliedMFD.getMinX() == 0.05f ? 1 : 0) != 0, (String)"Min mag mismatch: %s != %s", (Object)Float.valueOf((float)impliedMFD.getMinX()), (Object)Float.valueOf(0.05f));
                    Preconditions.checkState(((float)impliedMFD.getDelta() == 0.1f ? 1 : 0) != 0, (String)"Delta mismatch: %s != %s", (Object)Float.valueOf((float)impliedMFD.getDelta()), (Object)Float.valueOf(0.1f));
                    for (i = 0; i < impliedMFD.size(); ++i) {
                        sumImpliedMFD.add(i, impliedMFD.getY(i));
                    }
                    if (impliedMFD instanceof UncertainBoundedIncrMagFreqDist) {
                        UncertainBoundedIncrMagFreqDist bounded = (UncertainBoundedIncrMagFreqDist)impliedMFD;
                        for (int i2 = 0; i2 < impliedMFD.size(); ++i2) {
                            sumLowerMFD.add(i2, bounded.getLowerY(i2));
                            sumUpperMFD.add(i2, bounded.getUpperY(i2));
                        }
                        continue;
                    }
                    for (i = 0; i < impliedMFD.size(); ++i) {
                        double rate = impliedMFD.getY(i);
                        sumLowerMFD.add(i, rate);
                        sumUpperMFD.add(i, rate);
                    }
                }
                UncertainBoundedIncrMagFreqDist impliedMFD = new UncertainBoundedIncrMagFreqDist(sumImpliedMFD, sumLowerMFD, sumUpperMFD, this.uncertAdjDataTargetBound);
                System.out.println("Adjusting regional MFD to match data bounds");
                uncertainMFD = this.adjustForDataImpliedBounds(uncertainMFD, impliedMFD, false);
            }
            return uncertainMFD;
        }

        private UncertainBoundedIncrMagFreqDist adjustForDataImpliedBounds(UncertainIncrMagFreqDist mfd, IncrementalMagFreqDist impliedMFD, boolean verbose) {
            Preconditions.checkState((mfd.size() == impliedMFD.size() ? 1 : 0) != 0);
            Preconditions.checkState(((float)mfd.getMinX() == (float)impliedMFD.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState(((float)mfd.getDelta() == (float)impliedMFD.getDelta() ? 1 : 0) != 0);
            UncertainBoundedIncrMagFreqDist boundedImplied = null;
            if (impliedMFD instanceof UncertainBoundedIncrMagFreqDist) {
                boundedImplied = (UncertainBoundedIncrMagFreqDist)impliedMFD;
            } else if (impliedMFD instanceof UncertainIncrMagFreqDist) {
                boundedImplied = ((UncertainIncrMagFreqDist)impliedMFD).estimateBounds(this.uncertAdjDataTargetBound);
            }
            EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.size(), mfd.getDelta());
            UncertainBoundedIncrMagFreqDist boundedInput = mfd.estimateBounds(UncertaintyBoundType.ONE_SIGMA);
            IncrementalMagFreqDist lower = boundedInput.getLower();
            IncrementalMagFreqDist upper = boundedInput.getUpper();
            EvenlyDiscretizedFunc inputStdDevs = boundedInput.getStdDevs();
            DataUtils.MinMaxAveTracker stdDevTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker relStdDevTrack = new DataUtils.MinMaxAveTracker();
            for (int i = 0; i < mfd.size(); ++i) {
                if (mfd.getY(i) == 0.0) continue;
                double mag = mfd.getX(i);
                double rate = mfd.getY(i);
                double[] dataRates = boundedImplied == null ? new double[]{impliedMFD.getY(i)} : new double[]{impliedMFD.getY(i), boundedImplied.getLowerY(i), boundedImplied.getUpperY(i)};
                double minImpliedStdDev = Double.POSITIVE_INFINITY;
                double closestData = Double.NaN;
                for (double dataRate : dataRates) {
                    double diff = Math.abs(dataRate - rate);
                    double impliedStdDev = this.uncertAdjDataTargetBound.estimateStdDev(rate - diff, rate + diff);
                    if (!(impliedStdDev < minImpliedStdDev)) continue;
                    minImpliedStdDev = impliedStdDev;
                    closestData = dataRate;
                }
                if (closestData > rate) {
                    upper.set(i, Math.max(upper.getY(i), rate + minImpliedStdDev));
                } else {
                    lower.set(i, Math.max(0.0, Math.min(lower.getY(i), rate - minImpliedStdDev)));
                }
                double relStdDev = minImpliedStdDev / rate;
                if (verbose) {
                    System.out.println("\tM=" + (float)mag + "\trate=" + (float)rate + "\tdataRate=" + (float)dataRates[0] + "\tdataBounds=[" + (float)dataRates[1] + "," + (float)dataRates[2] + "]\timplStdDev=" + minImpliedStdDev + "\timplRelStdDev=" + (float)relStdDev);
                }
                stdDevTrack.addValue(minImpliedStdDev);
                relStdDevTrack.addValue(relStdDev);
                stdDevs.set(i, Math.max(minImpliedStdDev, inputStdDevs.getY(i)));
            }
            return new UncertainBoundedIncrMagFreqDist(mfd, lower, upper, UncertaintyBoundType.ONE_SIGMA, stdDevs);
        }

        private class SectMFDCalculator {
            private double[] slipRates;
            private double[] slipRateStdDevs;
            private double[] targetMoRates;
            private double[] targetSupraMoRates;
            private double[] sectFractSupras;
            private List<BitSet> sectRupUtilizations;
            private DataUtils.MinMaxAveTracker fractSuprasTrack;
            private List<IncrementalMagFreqDist> sectSubSeisMFDs;
            private List<IncrementalMagFreqDist> sectSupraSeisMFDs;
            private int[][] sectRupInBinCounts;
            private int[] sectMinMagIndexes;
            private int[] sectMaxMagIndexes;
            SectSlipRates sectSlipRates;

            private SectMFDCalculator() {
            }

            public void calc(ExecutorService exec, EvenlyDiscretizedFunc refMFD, ModSectMinMags minMags, BitSet zeroRateAllowed, boolean slipOnly, double slipAddStdScalar) {
                int numSects = Builder.this.rupSet.getNumSections();
                int NUM_MAG = refMFD.size();
                this.slipRates = new double[numSects];
                this.slipRateStdDevs = new double[numSects];
                this.targetMoRates = new double[numSects];
                this.targetSupraMoRates = new double[numSects];
                this.sectFractSupras = new double[numSects];
                this.sectRupUtilizations = new ArrayList<BitSet>();
                this.fractSuprasTrack = new DataUtils.MinMaxAveTracker();
                this.sectSubSeisMFDs = new ArrayList<IncrementalMagFreqDist>();
                this.sectSupraSeisMFDs = new ArrayList<IncrementalMagFreqDist>();
                this.sectRupInBinCounts = new int[numSects][refMFD.size()];
                this.sectMinMagIndexes = new int[numSects];
                this.sectMaxMagIndexes = new int[numSects];
                if (Builder.this.sectSpecificBValues != null) {
                    Preconditions.checkState((Builder.this.sectSpecificBValues.length == Builder.this.rupSet.getNumSections() ? 1 : 0) != 0);
                }
                for (int s = 0; s < numSects; ++s) {
                    IncrementalMagFreqDist subSeisMFD;
                    IncrementalMagFreqDist supraSeisMFD;
                    double fractSupra;
                    double subMoRate;
                    double supraMoRate;
                    IncrementalMagFreqDist supraGR_shape;
                    int maxMagIndex;
                    int minMagIndex;
                    FaultSection sect = Builder.this.rupSet.getFaultSectionData(s);
                    int parentID = sect.getParentSectionId();
                    double supraSeisBValue = Builder.this.sectSpecificBValues == null ? Builder.this.supraSeisBValue : Builder.this.sectSpecificBValues[s];
                    Preconditions.checkState((boolean)Double.isFinite(supraSeisBValue), (String)"Bad b=%s for section %s. %s", (Object)supraSeisBValue, (Object)s, (Object)sect.getSectionName());
                    double creepReducedSlipRate = sect.getReducedAveSlipRate() * 0.001;
                    double creepReducedSlipRateStdDev = Builder.this.useCreepReducedSlipStdDevs ? sect.getReducedSlipRateStdDev() * 0.001 : sect.getOrigSlipRateStdDev() * 0.001;
                    Preconditions.checkState((boolean)Double.isFinite(creepReducedSlipRate), (String)"Bad slip rate for %s. %s: %s", (Object)s, (Object)sect.getSectionName(), (Object)creepReducedSlipRate);
                    if (slipAddStdScalar != 0.0) {
                        creepReducedSlipRate += slipAddStdScalar * creepReducedSlipRateStdDev;
                    }
                    double area = Builder.this.rupSet.getAreaForSection(s);
                    double targetMoRate = FaultMomentCalc.getMoment(area, creepReducedSlipRate);
                    double sectMinMag = Builder.this.rupSet.getMinMagForSection(s);
                    if (minMags != null) {
                        sectMinMag = Math.max(sectMinMag, minMags.getMinMagForSection(s));
                    }
                    ArrayList<Double> mags = new ArrayList<Double>();
                    ArrayList<Integer> rups = new ArrayList<Integer>();
                    double minAbove = Double.POSITIVE_INFINITY;
                    double sectMaxMag = Double.NEGATIVE_INFINITY;
                    double sectMaxSingleFaultMag = Double.NEGATIVE_INFINITY;
                    BitSet utilization = new BitSet(Builder.this.rupSet.getNumRuptures());
                    int numMinMagExcluded = 0;
                    int numSubsetExcluded = 0;
                    int numZeroRateExcluded = 0;
                    for (int r : Builder.this.rupSet.getRupturesForSection(s)) {
                        double mag = Builder.this.rupSet.getMagForRup(r);
                        if (minMags == null || !minMags.isBelowSectMinMag(s, mag, refMFD)) {
                            if (Builder.this.rupSubSet != null && !Builder.this.rupSubSet.get(r)) {
                                ++numSubsetExcluded;
                                continue;
                            }
                            if (zeroRateAllowed != null && !zeroRateAllowed.get(r)) {
                                ++numZeroRateExcluded;
                                continue;
                            }
                            minAbove = Math.min(mag, minAbove);
                            sectMaxMag = Math.max(sectMaxMag, mag);
                            mags.add(mag);
                            rups.add(r);
                            utilization.set(r);
                            int[] nArray = this.sectRupInBinCounts[s];
                            int n = refMFD.getClosestXIndex(mag);
                            nArray[n] = nArray[n] + 1;
                            boolean singleFault = true;
                            for (int rupSect : Builder.this.rupSet.getSectionsIndicesForRup(r)) {
                                if (Builder.this.rupSet.getFaultSectionData(rupSect).getParentSectionId() == parentID) continue;
                                singleFault = false;
                                break;
                            }
                            if (!singleFault) continue;
                            sectMaxSingleFaultMag = Math.max(sectMaxSingleFaultMag, mag);
                            continue;
                        }
                        ++numMinMagExcluded;
                    }
                    this.sectRupUtilizations.add(utilization);
                    if (rups.isEmpty()) {
                        if (creepReducedSlipRate > 0.0 && slipAddStdScalar == 0.0) {
                            System.err.println("WARNING: Section " + s + " has no ruptures: " + sect.getName() + "; exclusions: " + numMinMagExcluded + " for minMag=" + (float)sectMinMag + ", " + numSubsetExcluded + " for rupture subset, " + numZeroRateExcluded + " for using zero-rate subsections");
                        }
                        maxMagIndex = minMagIndex = refMFD.getClosestXIndex(sectMinMag);
                        supraGR_shape = new IncrementalMagFreqDist((double)minMagIndex, 1, refMFD.getDelta());
                    } else {
                        double magCorner;
                        sectMinMag = minAbove;
                        minMagIndex = refMFD.getClosestXIndex(sectMinMag);
                        maxMagIndex = refMFD.getClosestXIndex(sectMaxMag);
                        double d = magCorner = Builder.this.sectSpecificMagCorners == null ? Builder.this.supraSeisMagCorner : Builder.this.sectSpecificMagCorners[s];
                        if (minMagIndex == maxMagIndex) {
                            magCorner = Double.NaN;
                        }
                        if (magCorner > 0.0) {
                            supraGR_shape = new TaperedGR_MagFreqDist(refMFD.getX(minMagIndex), 1 + maxMagIndex - minMagIndex, refMFD.getDelta());
                            ((TaperedGR_MagFreqDist)supraGR_shape).setAllButTotCumRate(supraGR_shape.getMinX(), magCorner, 1.0E16, supraSeisBValue);
                        } else {
                            supraGR_shape = new GutenbergRichterMagFreqDist(refMFD.getX(minMagIndex), 1 + maxMagIndex - minMagIndex, refMFD.getDelta(), 1.0E16, supraSeisBValue);
                        }
                        if (Builder.this.sparseGR) {
                            int singleBin;
                            List<Double> groupBinEdges = null;
                            if (SPARSE_GR_DONT_SPREAD_SINGLE_TO_MULTI && Double.isFinite(sectMaxSingleFaultMag) && (singleBin = refMFD.getClosestXIndex(sectMaxSingleFaultMag)) < maxMagIndex) {
                                double binEdge = refMFD.getX(singleBin) + 0.5 * refMFD.getDelta();
                                groupBinEdges = List.of(Double.valueOf(binEdge));
                            }
                            supraGR_shape = SparseGutenbergRichterSolver.getEquivGR(supraGR_shape, mags, groupBinEdges, true, supraGR_shape.getTotalMomentRate(), supraSeisBValue, magCorner);
                            SparseGutenbergRichterSolver.D = false;
                        }
                        Preconditions.checkState((supraGR_shape.calcSumOfY_Vals() > 0.0 ? 1 : 0) != 0, (String)"Bad supraGR shape:\n%s", (Object)supraGR_shape);
                    }
                    this.sectMinMagIndexes[s] = minMagIndex;
                    this.sectMaxMagIndexes[s] = maxMagIndex;
                    if (targetMoRate == 0.0) {
                        supraMoRate = 0.0;
                        subMoRate = 0.0;
                        fractSupra = 1.0;
                        supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        subSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        this.slipRates[s] = creepReducedSlipRate;
                        this.slipRateStdDevs[s] = creepReducedSlipRateStdDev;
                    } else if (rups.isEmpty()) {
                        supraMoRate = 0.0;
                        subMoRate = targetMoRate;
                        fractSupra = 0.0;
                        supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        double subB = Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SUB_SEIS_B_1 ? 1.0 : supraSeisBValue;
                        GutenbergRichterMagFreqDist grToMin = new GutenbergRichterMagFreqDist(refMFD.getMinX(), minMagIndex, refMFD.getDelta(), targetMoRate, subB);
                        subSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (int i = 0; i < grToMin.size(); ++i) {
                            subSeisMFD.set(i, grToMin.getY(i));
                        }
                        this.slipRates[s] = 0.0;
                        this.slipRateStdDevs[s] = creepReducedSlipRateStdDev;
                    } else if (Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.FROM_INPUT_SLIP_RATES) {
                        SectSlipRates inputSlipRates = Builder.this.rupSet.requireModule(SectSlipRates.class);
                        double supraSlipRate = inputSlipRates.getSlipRate(s);
                        double supraSlipStdDev = inputSlipRates.getSlipRateStdDev(s);
                        fractSupra = supraSlipRate / creepReducedSlipRate;
                        Preconditions.checkState((fractSupra > 0.0 && fractSupra <= 1.0 ? 1 : 0) != 0);
                        supraMoRate = targetMoRate * fractSupra;
                        subMoRate = targetMoRate - supraMoRate;
                        supraGR_shape.scaleToTotalMomentRate(supraMoRate);
                        supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (int i = 0; i < supraGR_shape.size(); ++i) {
                            supraSeisMFD.set(i + minMagIndex, supraGR_shape.getY(i));
                        }
                        GutenbergRichterMagFreqDist subGR = new GutenbergRichterMagFreqDist(refMFD.getX(0), minMagIndex, 0.1, subMoRate, supraSeisBValue);
                        subSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (int i = 0; i < subGR.size(); ++i) {
                            subSeisMFD.set(i, subGR.getY(i));
                        }
                        this.slipRates[s] = supraSlipRate;
                        this.slipRateStdDevs[s] = supraSlipStdDev;
                    } else if (Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.NONE) {
                        supraMoRate = targetMoRate;
                        subMoRate = 0.0;
                        fractSupra = 1.0;
                        subSeisMFD = null;
                        supraGR_shape.scaleToTotalMomentRate(supraMoRate);
                        supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (int i = 0; i < supraGR_shape.size(); ++i) {
                            supraSeisMFD.set(i + minMagIndex, supraGR_shape.getY(i));
                        }
                        this.slipRates[s] = creepReducedSlipRate * fractSupra;
                        this.slipRateStdDevs[s] = creepReducedSlipRateStdDev * fractSupra;
                    } else if (Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SUB_SEIS_B_1 || Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SYSTEM_AVG_SUB_B_1) {
                        int i;
                        GutenbergRichterMagFreqDist fullSupraB = new GutenbergRichterMagFreqDist(0.05, maxMagIndex + 1, 0.1, targetMoRate, supraSeisBValue);
                        IncrementalMagFreqDist sectFullMFD = new IncrementalMagFreqDist(0.05, maxMagIndex + 1, 0.1);
                        for (int i2 = 0; i2 < fullSupraB.size(); ++i2) {
                            sectFullMFD.set(i2, fullSupraB.getY(i2));
                        }
                        GutenbergRichterMagFreqDist fullSubB = new GutenbergRichterMagFreqDist(0.05, maxMagIndex + 1, 0.1, targetMoRate, 1.0);
                        double targetFirstSupra = fullSupraB.getY(minMagIndex);
                        double subFirstSupra = fullSubB.getY(minMagIndex);
                        for (i = 0; i < minMagIndex; ++i) {
                            double targetRatio = fullSubB.getY(i) / subFirstSupra;
                            sectFullMFD.set(i, targetFirstSupra * targetRatio);
                        }
                        sectFullMFD.scaleToTotalMomentRate(targetMoRate);
                        subSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (i = 0; i < minMagIndex; ++i) {
                            subSeisMFD.set(i, sectFullMFD.getY(i));
                        }
                        subMoRate = subSeisMFD.getTotalMomentRate();
                        supraMoRate = targetMoRate - subMoRate;
                        supraGR_shape.scaleToTotalMomentRate(supraMoRate);
                        supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (i = 0; i < supraGR_shape.size(); ++i) {
                            supraSeisMFD.set(i + minMagIndex, supraGR_shape.getY(i));
                        }
                        fractSupra = supraMoRate / targetMoRate;
                        this.slipRates[s] = creepReducedSlipRate * fractSupra;
                        this.slipRateStdDevs[s] = creepReducedSlipRateStdDev * fractSupra;
                    } else if (Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SUPRA_B_TO_M6p5) {
                        int sixFiveIndex = refMFD.getClosestXIndex(6.501);
                        if (minMagIndex <= sixFiveIndex) {
                            supraMoRate = targetMoRate;
                            subMoRate = 0.0;
                            fractSupra = 1.0;
                            subSeisMFD = null;
                            supraGR_shape.scaleToTotalMomentRate(supraMoRate);
                            supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                            for (int i = 0; i < supraGR_shape.size(); ++i) {
                                supraSeisMFD.set(i + minMagIndex, supraGR_shape.getY(i));
                            }
                            this.slipRates[s] = creepReducedSlipRate * fractSupra;
                            this.slipRateStdDevs[s] = creepReducedSlipRateStdDev * fractSupra;
                        } else {
                            int i;
                            GutenbergRichterMagFreqDist sectFullMFD = new GutenbergRichterMagFreqDist(0.05, maxMagIndex + 1, 0.1);
                            sectFullMFD.setAllButTotCumRate(refMFD.getX(sixFiveIndex), refMFD.getX(maxMagIndex), targetMoRate, supraSeisBValue);
                            subSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                            for (i = sixFiveIndex; i < minMagIndex; ++i) {
                                subSeisMFD.set(i, sectFullMFD.getY(i));
                            }
                            subMoRate = subSeisMFD.getTotalMomentRate();
                            supraMoRate = targetMoRate - subMoRate;
                            fractSupra = supraMoRate / targetMoRate;
                            supraGR_shape.scaleToTotalMomentRate(supraMoRate);
                            supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                            for (i = 0; i < supraGR_shape.size(); ++i) {
                                supraSeisMFD.set(i + minMagIndex, supraGR_shape.getY(i));
                            }
                            this.slipRates[s] = creepReducedSlipRate * fractSupra;
                            this.slipRateStdDevs[s] = creepReducedSlipRateStdDev * fractSupra;
                        }
                    } else {
                        int i;
                        Preconditions.checkState((Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.FAULT_SPECIFIC_IMPLIED_FROM_SUPRA_B || Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SYSTEM_AVG_IMPLIED_FROM_SUPRA_B ? 1 : 0) != 0);
                        GutenbergRichterMagFreqDist sectFullMFD = new GutenbergRichterMagFreqDist(0.05, maxMagIndex + 1, 0.1, targetMoRate, supraSeisBValue);
                        subSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (i = 0; i < minMagIndex; ++i) {
                            subSeisMFD.set(i, sectFullMFD.getY(i));
                        }
                        subMoRate = subSeisMFD.getTotalMomentRate();
                        supraMoRate = targetMoRate - subMoRate;
                        fractSupra = supraMoRate / targetMoRate;
                        supraGR_shape.scaleToTotalMomentRate(supraMoRate);
                        supraSeisMFD = new IncrementalMagFreqDist(0.05, NUM_MAG, 0.1);
                        for (i = 0; i < supraGR_shape.size(); ++i) {
                            supraSeisMFD.set(i + minMagIndex, supraGR_shape.getY(i));
                        }
                        this.slipRates[s] = creepReducedSlipRate * fractSupra;
                        this.slipRateStdDevs[s] = creepReducedSlipRateStdDev * fractSupra;
                    }
                    this.slipRateStdDevs[s] = Math.max(this.slipRateStdDevs[s], Builder.this.slipStdDevFloor * 0.001);
                    double targetMoRateTest = supraMoRate + subMoRate;
                    Preconditions.checkState(((float)targetMoRateTest == (float)targetMoRate ? 1 : 0) != 0, (String)"Partitioned moment rate doesn't equal input for sect %s. %s: %s != %s", (Object)s, (Object)sect.getSectionName(), (Object)Float.valueOf((float)targetMoRate), (Object)Float.valueOf((float)targetMoRateTest));
                    this.targetMoRates[s] = targetMoRate;
                    this.targetSupraMoRates[s] = supraMoRate;
                    this.fractSuprasTrack.addValue(fractSupra);
                    this.sectFractSupras[s] = fractSupra;
                    this.sectSubSeisMFDs.add(subSeisMFD);
                    this.sectSupraSeisMFDs.add(supraSeisMFD);
                }
                if (slipAddStdScalar == 0.0) {
                    System.out.println("Fraction supra-seismogenic stats: " + String.valueOf(this.fractSuprasTrack));
                    System.out.println("Fault moments: total=" + (float)StatUtils.sum((double[])this.targetMoRates) + "\tsupra=" + (float)StatUtils.sum((double[])this.targetSupraMoRates));
                }
                if (Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SYSTEM_AVG_IMPLIED_FROM_SUPRA_B || Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.SYSTEM_AVG_SUB_B_1) {
                    double sumSupraMo = StatUtils.sum((double[])this.targetSupraMoRates);
                    double sumTotMo = StatUtils.sum((double[])this.targetMoRates);
                    double avgSupraSeis = sumSupraMo / sumTotMo;
                    if (slipAddStdScalar == 0.0) {
                        System.out.println("Re-scaling section MFDs to match system-wide supra-seismogenic fract=" + (float)avgSupraSeis);
                    }
                    for (int s = 0; s < numSects; ++s) {
                        if (this.slipRates[s] == 0.0 || this.sectFractSupras[s] == 0.0 || this.targetMoRates[s] == 0.0 || this.targetSupraMoRates[s] == 0.0) continue;
                        this.slipRates[s] = this.slipRates[s] * avgSupraSeis / this.sectFractSupras[s];
                        this.slipRateStdDevs[s] = this.slipRateStdDevs[s] * avgSupraSeis / this.sectFractSupras[s];
                        this.targetSupraMoRates[s] = this.targetMoRates[s] * avgSupraSeis;
                        double targetSubSeis = this.targetMoRates[s] - this.targetSupraMoRates[s];
                        this.sectFractSupras[s] = avgSupraSeis;
                        this.sectSubSeisMFDs.get(s).scaleToTotalMomentRate(targetSubSeis);
                        this.sectSupraSeisMFDs.get(s).scaleToTotalMomentRate(this.targetSupraMoRates[s]);
                    }
                }
                this.sectSlipRates = Builder.this.subSeisMoRateReduction == SubSeisMoRateReduction.FROM_INPUT_SLIP_RATES ? Builder.this.rupSet.requireModule(SectSlipRates.class) : SectSlipRates.precomputed(Builder.this.rupSet, this.slipRates, this.slipRateStdDevs);
                if (slipOnly) {
                    return;
                }
                if (Builder.this.targetAdjDataConstraints != null && !Builder.this.targetAdjDataConstraints.isEmpty()) {
                    for (SectNucleationMFD_Estimator estimator : Builder.this.targetAdjDataConstraints) {
                        Stopwatch watch = Stopwatch.createStarted();
                        estimator.init(Builder.this.rupSet, this.sectSupraSeisMFDs, this.targetSupraMoRates, this.slipRates, this.slipRateStdDevs, this.sectRupUtilizations, this.sectMinMagIndexes, this.sectMaxMagIndexes, this.sectRupInBinCounts, refMFD);
                        List<Future<DataEstCallable>> futures = Builder.this.estimateSectNuclMFDs(List.of(estimator), this.slipRates, this.slipRateStdDevs, this.targetSupraMoRates, this.sectRupUtilizations, this.sectSupraSeisMFDs, exec);
                        for (Future<DataEstCallable> future : futures) {
                            DataEstCallable call;
                            try {
                                call = future.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                e.printStackTrace();
                                throw ExceptionUtils.asRuntimeException(e);
                            }
                            this.sectSupraSeisMFDs.set(call.sect.getSectionId(), call.impliedMFD);
                        }
                        System.out.println("Done with " + futures.size() + " estimation futures in " + (float)((double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0) + " s");
                    }
                }
            }
        }

        private class DataEstCallable
        implements Callable<DataEstCallable> {
            private FaultSection sect;
            private List<SectNucleationMFD_Estimator> constraints;
            private IncrementalMagFreqDist supraSeisMFD;
            private List<Double> mags;
            private List<Integer> rups;
            private UncertainDataConstraint moRateBounds;
            private IncrementalMagFreqDist impliedMFD;

            public DataEstCallable(FaultSection sect, List<SectNucleationMFD_Estimator> constraints, IncrementalMagFreqDist supraSeisMFD, List<Double> mags, List<Integer> rups, UncertainDataConstraint moRateBounds) {
                this.sect = sect;
                this.constraints = constraints;
                this.supraSeisMFD = supraSeisMFD;
                this.mags = mags;
                this.rups = rups;
                this.moRateBounds = moRateBounds;
            }

            @Override
            public DataEstCallable call() throws Exception {
                ArrayList<IncrementalMagFreqDist> impliedMFDs = new ArrayList<IncrementalMagFreqDist>();
                for (SectNucleationMFD_Estimator constraint : this.constraints) {
                    IncrementalMagFreqDist implied = constraint.estimateNuclMFD(this.sect, this.supraSeisMFD, this.rups, this.mags, this.moRateBounds, Builder.this.sparseGR);
                    Preconditions.checkState(((float)implied.getMinX() == 0.05f ? 1 : 0) != 0);
                    Preconditions.checkState(((float)implied.getDelta() == 0.1f ? 1 : 0) != 0);
                    impliedMFDs.add(implied);
                }
                if (impliedMFDs.size() > 1) {
                    IncrementalMagFreqDist meanMFD = new IncrementalMagFreqDist(0.05, ((IncrementalMagFreqDist)impliedMFDs.get(0)).size(), 0.1);
                    AbstractDiscretizedFunc upperMFD = null;
                    AbstractDiscretizedFunc lowerMFD = null;
                    UncertaintyBoundType boundType = UncertaintyBoundType.ONE_SIGMA;
                    int numBounded = 0;
                    for (IncrementalMagFreqDist mfd : impliedMFDs) {
                        Preconditions.checkState((mfd.size() == meanMFD.size() ? 1 : 0) != 0);
                        for (int i = 0; i < meanMFD.size(); ++i) {
                            if (!(mfd.getY(i) > 0.0)) continue;
                            meanMFD.add(i, mfd.getY(i));
                        }
                        if (!(mfd instanceof UncertainIncrMagFreqDist)) continue;
                        if (upperMFD == null) {
                            upperMFD = new IncrementalMagFreqDist(0.05, meanMFD.size(), 0.1);
                            lowerMFD = new IncrementalMagFreqDist(0.05, meanMFD.size(), 0.1);
                        }
                        UncertainBoundedIncrMagFreqDist bounded = ((UncertainIncrMagFreqDist)mfd).estimateBounds(boundType);
                        ++numBounded;
                        for (int i = 0; i < meanMFD.size(); ++i) {
                            ((EvenlyDiscretizedFunc)upperMFD).add(i, bounded.getUpperY(i));
                            ((EvenlyDiscretizedFunc)lowerMFD).add(i, bounded.getLowerY(i));
                        }
                    }
                    meanMFD.scale(1.0 / (double)impliedMFDs.size());
                    if (upperMFD != null) {
                        upperMFD.scale(1.0 / (double)numBounded);
                        lowerMFD.scale(1.0 / (double)numBounded);
                        for (int i = 0; i < meanMFD.size(); ++i) {
                            ((EvenlyDiscretizedFunc)upperMFD).set(i, Math.max(((EvenlyDiscretizedFunc)upperMFD).getY(i), meanMFD.getY(i)));
                            ((EvenlyDiscretizedFunc)lowerMFD).set(i, Math.max(0.0, Math.min(((EvenlyDiscretizedFunc)lowerMFD).getY(i), meanMFD.getY(i))));
                        }
                        meanMFD = new UncertainBoundedIncrMagFreqDist(meanMFD, (IncrementalMagFreqDist)lowerMFD, (IncrementalMagFreqDist)upperMFD, boundType);
                    }
                    this.impliedMFD = meanMFD;
                } else {
                    this.impliedMFD = (IncrementalMagFreqDist)impliedMFDs.get(0);
                }
                return this;
            }
        }
    }

    public static enum SubSeisMoRateReduction {
        FAULT_SPECIFIC_IMPLIED_FROM_SUPRA_B,
        SUB_SEIS_B_1,
        SYSTEM_AVG_IMPLIED_FROM_SUPRA_B,
        SYSTEM_AVG_SUB_B_1,
        FROM_INPUT_SLIP_RATES,
        SUPRA_B_TO_M6p5,
        NONE;

    }

    public static class SupraBAverager
    extends InversionTargetMFDs.Averager {
        private boolean allSupra = true;
        private double weightedBValSum = 0.0;
        private double[] weightedSectSpecificBValsSum;
        private double weightedMagCorner = 0.0;
        private double[] weightedSectSpecificMagCornerSum;
        private AverageableModule.AveragingAccumulator<SectSlipRates> slipAvg;
        private List<BitSet> sectRupUtilizations;

        @Override
        public void process(InversionTargetMFDs module, double relWeight) {
            boolean first = this.totWeight == 0.0;
            super.process(module, relWeight);
            boolean bl = this.allSupra = this.allSupra && module instanceof SupraSeisBValInversionTargetMFDs;
            if (this.allSupra) {
                int s;
                int i;
                SupraSeisBValInversionTargetMFDs mfds = (SupraSeisBValInversionTargetMFDs)module;
                this.weightedBValSum += relWeight * mfds.supraSeisBValue;
                this.weightedMagCorner += relWeight * mfds.supraSeisMagCorner;
                if (mfds.sectSpecificBValues != null) {
                    if (this.weightedSectSpecificBValsSum == null) {
                        if (first) {
                            this.weightedSectSpecificBValsSum = new double[mfds.sectSpecificBValues.length];
                        } else {
                            this.weightedSectSpecificBValsSum = new double[mfds.sectSpecificBValues.length];
                            for (i = 0; i < this.weightedSectSpecificBValsSum.length; ++i) {
                                this.weightedSectSpecificBValsSum[i] = this.weightedBValSum;
                            }
                        }
                    }
                    Preconditions.checkState((this.weightedSectSpecificBValsSum.length == mfds.sectSpecificBValues.length ? 1 : 0) != 0);
                    for (s = 0; s < this.weightedSectSpecificBValsSum.length; ++s) {
                        int n = s;
                        this.weightedSectSpecificBValsSum[n] = this.weightedSectSpecificBValsSum[n] + relWeight * mfds.sectSpecificBValues[s];
                    }
                } else if (this.weightedSectSpecificBValsSum != null) {
                    for (i = 0; i < this.weightedSectSpecificBValsSum.length; ++i) {
                        this.weightedSectSpecificBValsSum[i] = relWeight * mfds.supraSeisBValue;
                    }
                }
                if (mfds.sectSpecificMagCorners != null) {
                    if (this.weightedSectSpecificMagCornerSum == null) {
                        if (first) {
                            this.weightedSectSpecificMagCornerSum = new double[mfds.sectSpecificMagCorners.length];
                        } else {
                            this.weightedSectSpecificMagCornerSum = new double[mfds.sectSpecificMagCorners.length];
                            for (i = 0; i < this.weightedSectSpecificMagCornerSum.length; ++i) {
                                this.weightedSectSpecificMagCornerSum[i] = this.weightedMagCorner;
                            }
                        }
                    }
                    Preconditions.checkState((this.weightedSectSpecificMagCornerSum.length == mfds.sectSpecificMagCorners.length ? 1 : 0) != 0);
                    for (s = 0; s < this.weightedSectSpecificMagCornerSum.length; ++s) {
                        int n = s;
                        this.weightedSectSpecificMagCornerSum[n] = this.weightedSectSpecificMagCornerSum[n] + relWeight * mfds.sectSpecificMagCorners[s];
                    }
                } else if (this.weightedSectSpecificMagCornerSum != null) {
                    for (i = 0; i < this.weightedSectSpecificBValsSum.length; ++i) {
                        this.weightedSectSpecificBValsSum[i] = relWeight * mfds.supraSeisMagCorner;
                    }
                }
                if (this.slipAvg == null) {
                    this.slipAvg = mfds.sectSlipRates.averagingAccumulator();
                    Preconditions.checkNotNull(this.slipAvg);
                    this.sectRupUtilizations = new ArrayList<BitSet>();
                    ModuleContainer rupSet = mfds.getParent();
                    for (int s2 = 0; s2 < ((FaultSystemRupSet)rupSet).getNumSections(); ++s2) {
                        this.sectRupUtilizations.add(new BitSet(((FaultSystemRupSet)rupSet).getNumRuptures()));
                    }
                }
                this.slipAvg.process(mfds.sectSlipRates, relWeight);
                for (int s3 = 0; s3 < this.sectRupUtilizations.size(); ++s3) {
                    this.sectRupUtilizations.get(s3).or(mfds.sectRupUtilizations.get(s3));
                }
            }
        }

        @Override
        public InversionTargetMFDs getAverage() {
            InversionTargetMFDs average = super.getAverage();
            if (this.allSupra) {
                average = this.doGetSupraSeisAverageInstance(average);
            }
            return average;
        }

        public SupraSeisBValInversionTargetMFDs getSupraSeisAverageInstance() {
            Preconditions.checkState((boolean)this.allSupra, (Object)"Not all processed target MFDs were averagable SupraSeisBValInversionTargetMFDs instances");
            return this.doGetSupraSeisAverageInstance(super.getAverage());
        }

        /*
         * WARNING - void declaration
         */
        private SupraSeisBValInversionTargetMFDs doGetSupraSeisAverageInstance(InversionTargetMFDs average) {
            void var11_14;
            double supraSeisBValue = this.weightedBValSum / this.totWeight;
            IncrementalMagFreqDist totalRegionalMFD = average.getTotalRegionalMFD();
            UncertainIncrMagFreqDist onFaultSupraSeisMFD = (UncertainIncrMagFreqDist)average.getTotalOnFaultSupraSeisMFD();
            IncrementalMagFreqDist onFaultSubSeisMFD = average.getTotalOnFaultSubSeisMFD();
            ArrayList<UncertainIncrMagFreqDist> mfdConstraints = new ArrayList<UncertainIncrMagFreqDist>();
            for (IncrementalMagFreqDist incrementalMagFreqDist : average.getMFD_Constraints()) {
                Preconditions.checkState((boolean)(incrementalMagFreqDist instanceof UncertainIncrMagFreqDist));
                mfdConstraints.add((UncertainIncrMagFreqDist)incrementalMagFreqDist);
            }
            SubSeismoOnFaultMFDs subSeismoOnFaultMFDs = average.getOnFaultSubSeisMFDs();
            ArrayList<UncertainIncrMagFreqDist> arrayList = new ArrayList<UncertainIncrMagFreqDist>();
            for (IncrementalMagFreqDist incrementalMagFreqDist : average.getOnFaultSupraSeisNucleationMFDs()) {
                Preconditions.checkState((boolean)(incrementalMagFreqDist instanceof UncertainIncrMagFreqDist));
                arrayList.add((UncertainIncrMagFreqDist)incrementalMagFreqDist);
            }
            SectSlipRates sectSlipRates = this.slipAvg.getAverage();
            Object var11_12 = null;
            if (this.weightedSectSpecificBValsSum != null) {
                double[] dArray = new double[this.weightedSectSpecificBValsSum.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.weightedSectSpecificBValsSum[i] / this.totWeight;
                }
            }
            double magCorner = this.weightedMagCorner / this.totWeight;
            double[] sectSpecificMagCorners = null;
            if (this.weightedSectSpecificMagCornerSum != null) {
                sectSpecificMagCorners = new double[this.weightedSectSpecificMagCornerSum.length];
                for (int i = 0; i < sectSpecificMagCorners.length; ++i) {
                    sectSpecificMagCorners[i] = this.weightedSectSpecificMagCornerSum[i] / this.totWeight;
                }
            }
            return new SupraSeisBValInversionTargetMFDs(null, supraSeisBValue, (double[])var11_14, totalRegionalMFD, onFaultSupraSeisMFD, onFaultSubSeisMFD, mfdConstraints, subSeismoOnFaultMFDs, arrayList, sectSlipRates, this.sectRupUtilizations, magCorner, sectSpecificMagCorners);
        }
    }
}

