/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.inversion.UCERF3InversionInputGenerator;

public class APrioriSectNuclEstimator
extends SectNucleationMFD_Estimator {
    private FaultSystemRupSet rupSet;
    private HashSet<Integer> rupIndexes;
    private UncertainDataConstraint totalRate;
    private HashSet<Integer> sectIDs;

    public APrioriSectNuclEstimator(FaultSystemRupSet rupSet, Collection<Integer> rupIndexes, double totalRate, double rateStdDev) {
        this(rupSet, rupIndexes, new UncertainDataConstraint("APriori", totalRate, new Uncertainty(rateStdDev)));
    }

    public APrioriSectNuclEstimator(FaultSystemRupSet rupSet, Collection<Integer> rupIndexes, UncertainDataConstraint totalRate) {
        this.rupSet = rupSet;
        this.rupIndexes = new HashSet<Integer>(rupIndexes);
        this.totalRate = totalRate;
        this.sectIDs = new HashSet();
        for (int rupIndex : rupIndexes) {
            this.sectIDs.addAll(rupSet.getSectionsIndicesForRup(rupIndex));
        }
    }

    @Override
    public boolean appliesTo(FaultSection sect) {
        return this.sectIDs.contains(sect.getSectionId());
    }

    @Override
    public IncrementalMagFreqDist estimateNuclMFD(FaultSection sect, IncrementalMagFreqDist curSectSupraSeisMFD, List<Integer> availableRupIndexes, List<Double> availableRupMags, UncertainDataConstraint sectMomentRate, boolean sparseGR) {
        Preconditions.checkState((boolean)this.appliesTo(sect));
        IncrementalMagFreqDist bestEst = new IncrementalMagFreqDist(curSectSupraSeisMFD.getMinX(), curSectSupraSeisMFD.size(), curSectSupraSeisMFD.getDelta());
        IncrementalMagFreqDist lowerEst = new IncrementalMagFreqDist(curSectSupraSeisMFD.getMinX(), curSectSupraSeisMFD.size(), curSectSupraSeisMFD.getDelta());
        IncrementalMagFreqDist upperEst = new IncrementalMagFreqDist(curSectSupraSeisMFD.getMinX(), curSectSupraSeisMFD.size(), curSectSupraSeisMFD.getDelta());
        double sectArea = this.rupSet.getAreaForSection(sect.getSectionId());
        BoundedUncertainty oneSigma = this.totalRate.estimateUncertaintyBounds(UncertaintyBoundType.ONE_SIGMA);
        double inputMoRate = curSectSupraSeisMFD.getTotalMomentRate();
        ArrayList<Integer> myLeftoverRups = new ArrayList<Integer>();
        ArrayList<Double> myLeftoverMags = new ArrayList<Double>();
        int[] origRupsPerBin = new int[curSectSupraSeisMFD.size()];
        int[] leftoverRupsPerBin = new int[curSectSupraSeisMFD.size()];
        for (int r = 0; r < availableRupIndexes.size(); ++r) {
            int index;
            int rupIndex = availableRupIndexes.get(r);
            double mag = availableRupMags.get(r);
            int n = index = curSectSupraSeisMFD.getClosestXIndex(mag);
            origRupsPerBin[n] = origRupsPerBin[n] + 1;
            if (this.rupIndexes.contains(rupIndex)) continue;
            myLeftoverRups.add(rupIndex);
            myLeftoverMags.add(mag);
            int n2 = index;
            leftoverRupsPerBin[n2] = leftoverRupsPerBin[n2] + 1;
        }
        for (int i = 0; i < 3; ++i) {
            int j;
            IncrementalMagFreqDist mfd;
            double totalRate;
            if (i == 0) {
                totalRate = oneSigma.lowerBound;
                mfd = lowerEst;
            } else if (i == 1) {
                totalRate = this.totalRate.bestEstimate;
                mfd = bestEst;
            } else {
                totalRate = oneSigma.upperBound;
                mfd = upperEst;
            }
            double rateEach = totalRate / (double)this.rupIndexes.size();
            for (int rupIndex : this.rupIndexes) {
                if (!this.rupSet.getSectionsIndicesForRup(rupIndex).contains(sect.getSectionId())) continue;
                double nuclRate = rateEach * sectArea / this.rupSet.getAreaForRup(rupIndex);
                mfd.add(mfd.getClosestXIndex(this.rupSet.getMagForRup(rupIndex)), nuclRate);
            }
            double impliedMoRate = mfd.getTotalMomentRate();
            if (!(impliedMoRate < inputMoRate)) continue;
            double extraMoment = inputMoRate - impliedMoRate;
            IncrementalMagFreqDist extraMFD = curSectSupraSeisMFD.deepClone();
            for (j = 0; j < extraMFD.size(); ++j) {
                if (leftoverRupsPerBin[j] == 0) {
                    extraMFD.set(j, 0.0);
                    continue;
                }
                if (leftoverRupsPerBin[j] >= origRupsPerBin[j]) continue;
                extraMFD.set(j, extraMFD.getY(j) * (double)leftoverRupsPerBin[j] / (double)origRupsPerBin[j]);
            }
            extraMFD.scaleToTotalMomentRate(extraMoment);
            for (j = 0; j < extraMFD.size(); ++j) {
                mfd.add(j, extraMFD.getY(j));
            }
        }
        return this.getBounded(UncertaintyBoundType.ONE_SIGMA, bestEst, lowerEst, upperEst);
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/data/kevin/markdown/inversions/fm3_1_u3ref_uniform_reproduce_ucerf3.zip"));
        APrioriSectNuclEstimator estimator = new APrioriSectNuclEstimator(rupSet, UCERF3InversionInputGenerator.findParkfieldRups(rupSet), 0.04, 0.004);
    }
}

