/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.timeDependence;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.GeoJSON_Type;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;

public class DOLE_SubsectionMapper {
    public static final String REL_PATH = "/data/erf/nshm23/date_of_last_event/2025_07_07";
    public static final String PALEO_DOLE_PATH = "/data/erf/nshm23/date_of_last_event/2025_07_07/PaleoDOLE_v1.2.geojson";
    public static final String HIST_PATH = "/data/erf/nshm23/date_of_last_event/2025_07_07/HistDOLE_v1.1.geojson";
    private static final String YEAR_PROP_NAME = "CalYear";
    private static final Comparator<PaleoDOLE_Data> PALEO_DATE_COMPARATOR = new Comparator<PaleoDOLE_Data>(){

        @Override
        public int compare(PaleoDOLE_Data o1, PaleoDOLE_Data o2) {
            return Integer.compare(o1.year, o2.year);
        }
    };
    private static final double MAX_DIST_TOL = 20.0;
    private static final Comparator<HistoricalRupture> HIST_RUP_DATE_COMPARATOR = new Comparator<HistoricalRupture>(){

        @Override
        public int compare(HistoricalRupture o1, HistoricalRupture o2) {
            return Integer.compare(o1.year, o2.year);
        }
    };

    private static final FeatureCollection loadGeoJSON(String path) throws IOException {
        BufferedReader bRead = new BufferedReader(new InputStreamReader(DOLE_SubsectionMapper.class.getResourceAsStream(path)));
        return FeatureCollection.read(bRead);
    }

    public static List<PaleoDOLE_Data> loadPaleoDOLE() throws IOException {
        FeatureCollection features = DOLE_SubsectionMapper.loadGeoJSON(PALEO_DOLE_PATH);
        ArrayList<PaleoDOLE_Data> ret = new ArrayList<PaleoDOLE_Data>(features.features.size());
        for (Feature feature : features) {
            if (feature.geometry == null) {
                System.err.println("WARNING: skipping feature with null geometry! " + feature.toCompactJSON());
                continue;
            }
            ret.add(new PaleoDOLE_Data(feature));
        }
        return ret;
    }

    public static List<HistoricalRupture> loadHistRups() throws IOException {
        FeatureCollection features = DOLE_SubsectionMapper.loadGeoJSON(HIST_PATH);
        ArrayList<HistoricalRupture> ret = new ArrayList<HistoricalRupture>(features.features.size());
        for (Feature feature : features) {
            if (feature.geometry == null) {
                System.err.println("WARNING: skipping feature with null geometry! " + feature.toCompactJSON());
                continue;
            }
            ret.add(new HistoricalRupture(feature));
        }
        return ret;
    }

    public static String mapDOLE(List<? extends FaultSection> subSects, PaleoMappingAlgorithm mappingType, boolean verbose) throws IOException {
        return DOLE_SubsectionMapper.mapDOLE(subSects, DOLE_SubsectionMapper.loadHistRups(), DOLE_SubsectionMapper.loadPaleoDOLE(), mappingType, verbose);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mapDOLE(List<? extends FaultSection> subSects, List<HistoricalRupture> histRups, List<PaleoDOLE_Data> paleoData, PaleoMappingAlgorithm mappingType, boolean verbose) {
        ArrayList<Region> regionList;
        if (verbose) {
            System.out.println("\nMapping DOLE data");
        }
        for (FaultSection faultSection : subSects) {
            faultSection.setDateOfLastEvent(Long.MIN_VALUE);
        }
        Map<Integer, List<FaultSection>> subsectListForParentID_Map = subSects.stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        Map<Integer, List<HistoricalRupture>> map = histRups.stream().collect(Collectors.groupingBy(D -> D.faultID));
        Map<Integer, List<PaleoDOLE_Data>> paleoDataListForParentID_Map = paleoData.stream().collect(Collectors.groupingBy(D -> D.faultID));
        HashSet<Integer> allDOLE_ParentIDs = new HashSet<Integer>();
        allDOLE_ParentIDs.addAll(map.keySet());
        allDOLE_ParentIDs.addAll(paleoDataListForParentID_Map.keySet());
        ArrayList<AbstractDOLE_Data> allDOLE_DataList = new ArrayList<AbstractDOLE_Data>();
        allDOLE_DataList.addAll(paleoData);
        allDOLE_DataList.addAll(histRups);
        HashMap<Integer, String> doleParentNamesMap = new HashMap<Integer, String>();
        for (AbstractDOLE_Data abstractDOLE_Data : allDOLE_DataList) {
            if (doleParentNamesMap.containsKey(abstractDOLE_Data.faultID)) continue;
            doleParentNamesMap.put(abstractDOLE_Data.faultID, abstractDOLE_Data.faultName);
        }
        Object nameProblemString = "";
        Iterator iterator = allDOLE_ParentIDs.iterator();
        while (true) {
            double[] mappedDists;
            MappingType[] mappingTypes;
            AbstractDOLE_Data[] abstractDOLE_DataArray;
            List<FaultSection> subsectListForParentList;
            block76: {
                ArrayList<LocationList> sectTraceLocs;
                List<PaleoDOLE_Data> paleoDataList;
                block74: {
                    List<HistoricalRupture> histRupList;
                    block75: {
                        block73: {
                            if (!iterator.hasNext()) break block73;
                            int parentID = (Integer)iterator.next();
                            subsectListForParentList = subsectListForParentID_Map.get(parentID);
                            if (subsectListForParentList == null) {
                                if (!verbose) continue;
                                DOLE_SubsectionMapper.writeWarning("no parent section found with DOLE faultID=" + parentID + " and name='" + (String)doleParentNamesMap.get(parentID) + "', skipping DOLE mapping; perhaps a different branch?");
                                continue;
                            }
                            String parSectName = subsectListForParentList.get(0).getParentSectionName();
                            if (verbose) {
                                System.out.println("--- " + parentID + ", " + parSectName + " ---");
                            }
                            paleoDataList = paleoDataListForParentID_Map.get(parentID);
                            histRupList = map.get(parentID);
                            if (paleoDataList != null) {
                                for (PaleoDOLE_Data paleoDOLE_Data : paleoDataList) {
                                    if (paleoDOLE_Data.faultName.equals(parSectName)) continue;
                                    if (verbose) {
                                        DOLE_SubsectionMapper.writeWarning(paleoDOLE_Data.faultName + " != " + parSectName);
                                    }
                                    nameProblemString = (String)nameProblemString + "\t" + paleoDOLE_Data.faultName + "\tvs\t" + parSectName + "\n";
                                }
                            }
                            if (histRupList != null) {
                                for (HistoricalRupture historicalRupture : histRupList) {
                                    if (historicalRupture.faultName.equals(parSectName)) continue;
                                    if (verbose) {
                                        DOLE_SubsectionMapper.writeWarning(historicalRupture.faultName + " != " + parSectName);
                                    }
                                    nameProblemString = (String)nameProblemString + "\t" + historicalRupture.faultName + "\tvs\t" + parSectName + "\n";
                                }
                            }
                            sectTraceLocs = new ArrayList<LocationList>();
                            for (FaultSection sect : subsectListForParentList) {
                                LocationList locs = new LocationList();
                                locs.addAll(sect.getFaultTrace());
                                locs.addAll(FaultUtils.resampleTrace(sect.getFaultTrace(), 20));
                                sectTraceLocs.add(locs);
                            }
                            abstractDOLE_DataArray = new AbstractDOLE_Data[subsectListForParentList.size()];
                            mappingTypes = new MappingType[subsectListForParentList.size()];
                            mappedDists = new double[subsectListForParentList.size()];
                            if (histRupList == null) break block74;
                            if (histRupList.size() > 1) {
                                Collections.sort(histRupList, HIST_RUP_DATE_COMPARATOR);
                            }
                            if (!verbose) break block75;
                            System.out.println("Mapping " + histRupList.size() + " HISTORICAL RUPTURE" + (histRupList.size() == 1 ? "" : "s"));
                            break block75;
                        }
                        String string = "";
                        regionList = new ArrayList<Region>();
                        try {
                            regionList.add(NSHM23_RegionLoader.SeismicityRegions.CONUS_WEST.load());
                            regionList.add(NSHM23_RegionLoader.SeismicityRegions.CONUS_EAST.load());
                            regionList.add(NSHM23_RegionLoader.AnalysisRegions.ALASKA.load());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    for (int i = 0; i < histRupList.size(); ++i) {
                        HistoricalRupture rup = histRupList.get(i);
                        if (verbose) {
                            System.out.println("\t" + rup.year + ", " + rup.eventID);
                        }
                        double[] startSectDists = new double[subsectListForParentList.size()];
                        int startSect = DOLE_SubsectionMapper.getClosestSect(subsectListForParentList, sectTraceLocs, rup.trace.first(), startSectDists, rup.year, rup.eventID);
                        double[] endSectDists = new double[subsectListForParentList.size()];
                        int endSect = DOLE_SubsectionMapper.getClosestSect(subsectListForParentList, sectTraceLocs, rup.trace.last(), endSectDists, rup.year, rup.eventID);
                        if (startSect > endSect) {
                            int tmp = startSect;
                            startSect = endSect;
                            endSect = tmp;
                            double[] tmpDists = startSectDists;
                            startSectDists = endSectDists;
                            endSectDists = tmpDists;
                        }
                        if (startSect < subsectListForParentList.size() - 1 && (float)startSectDists[startSect] == (float)startSectDists[startSect + 1]) {
                            ++startSect;
                        }
                        if (endSect > 0 && (float)endSectDists[endSect] == (float)endSectDists[endSect - 1]) {
                            --endSect;
                        }
                        if (verbose) {
                            System.out.println("\t\tFrom sect " + startSect + " (" + (float)startSectDists[startSect] + " km) to " + endSect + " (" + (float)endSectDists[endSect] + " km)");
                        }
                        for (int s = startSect; s <= endSect; ++s) {
                            abstractDOLE_DataArray[s] = rup;
                            mappingTypes[s] = MappingType.HISTORICAL_RUP;
                        }
                    }
                }
                if (paleoDataList == null) break block76;
                if (paleoDataList.size() > 1) {
                    Collections.sort(paleoDataList, PALEO_DATE_COMPARATOR);
                }
                if (verbose) {
                    System.out.println("Mapping " + paleoDataList.size() + " PALEO " + (paleoDataList.size() == 1 ? "datum" : "data"));
                }
                int[] closestSects = new int[paleoDataList.size()];
                for (int i = 0; i < paleoDataList.size(); ++i) {
                    int s;
                    int startIndex;
                    int closestSect2;
                    int closestSect;
                    double[] sectDists;
                    PaleoDOLE_Data paleo;
                    block79: {
                        int n;
                        int[] tmpDists;
                        block78: {
                            block77: {
                                int[] testMapIndexes;
                                block72: {
                                    paleo = paleoDataList.get(i);
                                    if (verbose) {
                                        System.out.println("\t" + paleo.year + ", " + paleo.siteName + ", " + paleo.reference);
                                    }
                                    sectDists = new double[subsectListForParentList.size()];
                                    closestSects[i] = DOLE_SubsectionMapper.getClosestSect(subsectListForParentList, sectTraceLocs, paleo.location, sectDists, paleo.year, paleo.siteName);
                                    closestSect = closestSects[i];
                                    closestSect2 = -1;
                                    if (closestSect > 0 && (float)sectDists[closestSect] == (float)sectDists[closestSect - 1]) {
                                        closestSect2 = closestSect--;
                                    } else if (closestSect < subsectListForParentList.size() - 1 && (float)sectDists[closestSect] == (float)sectDists[closestSect + 1]) {
                                        closestSect2 = closestSect + 1;
                                    }
                                    if (mappingTypes[closestSect] == MappingType.HISTORICAL_RUP) {
                                        if (closestSect2 >= 0 && mappingTypes[closestSect2] != MappingType.HISTORICAL_RUP) {
                                            closestSect = closestSect2;
                                            closestSect2 = -1;
                                            break block72;
                                        } else {
                                            if (!verbose) continue;
                                            HistoricalRupture rup = (HistoricalRupture)abstractDOLE_DataArray[closestSect];
                                            System.out.println("\t\tClosest subsection (" + closestSect + ") is already mapped to a historical rupture: " + rup.year + ", " + rup.eventID + "; skipping");
                                            continue;
                                        }
                                    }
                                    if (closestSect2 >= 0 && mappingTypes[closestSect2] == MappingType.HISTORICAL_RUP) {
                                        closestSect2 = -1;
                                    }
                                }
                                if (mappingType != PaleoMappingAlgorithm.CLOSEST_SECT && mappingType != PaleoMappingAlgorithm.NEIGHBORING_SECTS && subsectListForParentList.size() != 1) break block77;
                                abstractDOLE_DataArray[closestSect] = paleo;
                                mappingTypes[closestSect] = MappingType.PALEO_CLOSEST_SECT;
                                mappedDists[closestSect] = sectDists[closestSect];
                                if (verbose) {
                                    System.out.println("\t\tMapping closest subsection: " + closestSect + ": " + (float)sectDists[closestSect] + " km");
                                }
                                if (closestSect2 >= 0) {
                                    abstractDOLE_DataArray[closestSect2] = paleo;
                                    mappingTypes[closestSect2] = MappingType.PALEO_CLOSEST_SECT;
                                    mappedDists[closestSect2] = sectDists[closestSect];
                                    if (verbose) {
                                        System.out.println("\t\tAlso mapping equally-close subsection: " + closestSect2 + ": " + (float)sectDists[closestSect2] + " km");
                                    }
                                }
                                if (subsectListForParentList.size() <= 1 || mappingType != PaleoMappingAlgorithm.NEIGHBORING_SECTS || closestSect2 >= 0) continue;
                                tmpDists = testMapIndexes = new int[]{closestSect - 1, closestSect + 1};
                                n = tmpDists.length;
                                break block78;
                            }
                            if (mappingType != PaleoMappingAlgorithm.FULL_PARENT) {
                                throw new IllegalStateException("Unexpected mapping type: " + String.valueOf((Object)mappingType));
                            }
                            s = startIndex = closestSect;
                            break block79;
                        }
                        for (int j = 0; j < n; ++j) {
                            int index = tmpDists[j];
                            if (index < 0 || index >= subsectListForParentList.size()) continue;
                            if (abstractDOLE_DataArray[index] == null || mappingTypes[index] == MappingType.PALEO_NEIGHBORING_SECT) {
                                abstractDOLE_DataArray[index] = paleo;
                                mappingTypes[index] = MappingType.PALEO_NEIGHBORING_SECT;
                                mappedDists[index] = sectDists[index];
                                if (!verbose) continue;
                                System.out.println("\t\tMapping neighboring subsection: " + index + ": " + (float)sectDists[index] + " km");
                                continue;
                            }
                            if (!verbose) continue;
                            System.out.println("\t\tWon't map " + index + ", already directly mapped: " + String.valueOf((Object)mappingTypes[index]));
                        }
                        continue;
                    }
                    while (--s >= 0 && mappingTypes[s] != MappingType.HISTORICAL_RUP) {
                        startIndex = s;
                    }
                    int endIndex = closestSect2 >= 0 ? closestSect2 : closestSect;
                    int s2 = endIndex + 1;
                    while (s2 < subsectListForParentList.size() && mappingTypes[s2] != MappingType.HISTORICAL_RUP) {
                        endIndex = s2++;
                    }
                    if (i == 0) {
                        if (verbose) {
                            System.out.println("\t\tMaping full parent where no hist rup");
                        }
                    } else {
                        abstractDOLE_DataArray[closestSect] = paleo;
                        mappedDists[closestSect] = sectDists[closestSect];
                        mappingTypes[closestSect] = MappingType.PALEO_CLOSEST_SECT;
                        if (verbose) {
                            System.out.println("\t\tMapping closest subsection: " + closestSect + ": " + (float)sectDists[closestSect] + " km");
                        }
                        if (closestSect2 >= 0) {
                            abstractDOLE_DataArray[closestSect2] = paleo;
                            mappingTypes[closestSect2] = MappingType.PALEO_CLOSEST_SECT;
                            mappedDists[closestSect2] = sectDists[closestSect];
                            if (verbose) {
                                System.out.println("\t\tAlso mapping equally-close subsection: " + closestSect2 + ": " + (float)sectDists[closestSect2] + " km");
                            }
                        }
                        for (s2 = startIndex; s2 <= endIndex; ++s2) {
                            double myDist = sectDists[s2];
                            if (s2 == closestSect || s2 == closestSect2 || !(myDist < mappedDists[s2])) continue;
                            if (verbose) {
                                System.out.println("\t\tAlso mapping " + s2 + " as it's closer to this (" + paleo.year + ", " + (float)myDist + " km) than the prior (" + abstractDOLE_DataArray[s2].year + ", " + (float)mappedDists[s2] + " km)");
                            }
                            abstractDOLE_DataArray[s2] = paleo;
                            mappedDists[s2] = sectDists[s2];
                            mappingTypes[s2] = MappingType.PALEO_NEIGHBORING_SECT;
                        }
                        continue;
                    }
                    for (s2 = startIndex; s2 <= endIndex; ++s2) {
                        abstractDOLE_DataArray[s2] = paleo;
                        mappedDists[s2] = sectDists[s2];
                        mappingTypes[s2] = s2 == closestSect || s2 == closestSect2 ? MappingType.PALEO_CLOSEST_SECT : MappingType.PALEO_NEIGHBORING_SECT;
                    }
                }
            }
            if (verbose) {
                System.out.println("Final mappings:");
            }
            for (int s = 0; s < abstractDOLE_DataArray.length; ++s) {
                if (verbose) {
                    if (abstractDOLE_DataArray[s] == null) {
                        System.out.println("\t" + s + ". (none)");
                    } else if (abstractDOLE_DataArray[s] instanceof PaleoDOLE_Data) {
                        System.out.println("\t" + s + ". " + abstractDOLE_DataArray[s].year + ", " + String.valueOf((Object)mappingTypes[s]) + ", " + ((PaleoDOLE_Data)abstractDOLE_DataArray[s]).siteName + ", " + (float)mappedDists[s] + " km");
                    } else {
                        System.out.println("\t" + s + ". " + abstractDOLE_DataArray[s].year + ", " + String.valueOf((Object)mappingTypes[s]) + ", " + ((HistoricalRupture)abstractDOLE_DataArray[s]).eventID);
                    }
                }
                if (abstractDOLE_DataArray[s] == null) continue;
                FaultSection sect = subsectListForParentList.get(s);
                sect.setDateOfLastEvent(abstractDOLE_DataArray[s].epochMillis);
                abstractDOLE_DataArray[s].addMapedSection(sect, mappingTypes[s]);
            }
            if (!verbose) continue;
            System.out.println("----------------------------------");
        }
        int numRegions = regionList.size();
        double minLon = 0.0;
        int regionIndex = 0;
        while (true) {
            Iterator<Object> iterator2;
            void var12_16;
            if (regionIndex < numRegions) {
                if (regionList != null) {
                    String string = (String)var12_16 + "\n***************  " + ((Region)regionList.get(regionIndex)).getName() + "  ***************\n";
                } else {
                    String string = (String)var12_16 + "\n***************  ALL REGIONS  ***************\n";
                }
                iterator2 = allDOLE_DataList.iterator();
            } else {
                void var12_27;
                String string4 = (String)var12_16 + "\n* DOLE filter region mappings (ID, numSubsectsMapped, Flt Name, Type, Paleo Name, Year, Location):";
                string4 = string4 + "\n* (NA = no such parent section; X = Paleo data overidden; Location is first trace pt for hist rups)";
                string4 = string4 + "\n\nName inconisistancies between DOLE and parent fault sections:\n";
                string4 = string4 + (String)nameProblemString;
                if (minLon < -180.0) {
                    String string5 = string4 + "\n\nWARNING: one or locations have lon<-180 so mapping may incorrect\n";
                }
                if (verbose) {
                    System.out.println((String)var12_27);
                }
                return var12_27;
            }
            while (iterator2.hasNext()) {
                void var12_20;
                AbstractDOLE_Data abstractDOLE_Data = (AbstractDOLE_Data)iterator2.next();
                Location loc = null;
                String type = "";
                String doleName = "";
                int numSectsMapped = abstractDOLE_Data.getMappedSubSects().size();
                if (abstractDOLE_Data instanceof HistoricalRupture) {
                    loc = (Location)((HistoricalRupture)abstractDOLE_Data).trace.get(0);
                    type = "HistoricalRupture";
                    doleName = ((HistoricalRupture)abstractDOLE_Data).eventID;
                    for (Location l : ((HistoricalRupture)abstractDOLE_Data).trace) {
                        if (!(minLon > l.getLongitude())) continue;
                        minLon = l.getLongitude();
                    }
                } else if (abstractDOLE_Data instanceof PaleoDOLE_Data) {
                    loc = ((PaleoDOLE_Data)abstractDOLE_Data).location;
                    type = "PaleoDOLE_Data";
                    doleName = ((PaleoDOLE_Data)abstractDOLE_Data).siteName;
                    if (minLon > loc.getLongitude()) {
                        minLon = loc.getLongitude();
                    }
                }
                String numSectMappedString = Integer.toString(numSectsMapped);
                if (numSectsMapped == 0) {
                    numSectMappedString = subsectListForParentID_Map.get(abstractDOLE_Data.faultID) == null ? "NA" : "X";
                }
                if (regionList != null && !((Region)regionList.get(regionIndex)).contains(loc)) continue;
                String string = (String)var12_20 + abstractDOLE_Data.faultID + "\t" + numSectMappedString + "\t" + abstractDOLE_Data.faultName + "\t" + type + "\t" + doleName + "\t" + abstractDOLE_Data.year + "\t" + loc.toString() + "\n";
            }
            ++regionIndex;
        }
    }

    private static int getClosestSect(List<FaultSection> sects, List<LocationList> sectTraces, Location loc, double[] distsToFillIn, int year, String id) {
        Preconditions.checkState((sects.size() == sectTraces.size() ? 1 : 0) != 0);
        double minDist = Double.POSITIVE_INFINITY;
        int closestIndex = -1;
        for (int s = 0; s < sects.size(); ++s) {
            double sectDist = Double.POSITIVE_INFINITY;
            for (Location testLoc : sectTraces.get(s)) {
                sectDist = Math.min(sectDist, LocationUtils.horzDistanceFast(loc, testLoc));
            }
            if (sectDist < minDist) {
                minDist = sectDist;
                closestIndex = s;
            }
            if (distsToFillIn == null) continue;
            distsToFillIn[s] = sectDist;
        }
        Preconditions.checkState((minDist < 20.0 ? 1 : 0) != 0, (String)"Closest section on %s. %s was %s km away from DOLE record: %s,  %s", (Object[])new Object[]{sects.get(0).getParentSectionId(), sects.get(0).getParentSectionName(), Float.valueOf((float)minDist), year, id});
        return closestIndex;
    }

    private static void writeWarning(String warning) {
        System.out.flush();
        System.err.println("WARNING: " + warning);
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] args) throws IOException {
        List<FaultSection> subSects = NSHM23_DeformationModels.GEOLOGIC.build(NSHM23_FaultModels.WUS_FM_v3);
        System.out.println("Loading Paleo DOLE data");
        List<PaleoDOLE_Data> paleoData = DOLE_SubsectionMapper.loadPaleoDOLE();
        System.out.println("Loading Historical Rupture data");
        List<HistoricalRupture> histRupData = DOLE_SubsectionMapper.loadHistRups();
        DOLE_SubsectionMapper.mapDOLE(subSects, histRupData, paleoData, PaleoMappingAlgorithm.CLOSEST_SECT, true);
    }

    public static class PaleoDOLE_Data
    extends AbstractDOLE_Data {
        public final Location location;
        public final String siteName;
        public final String reference;

        public PaleoDOLE_Data(Feature feature) {
            super(feature);
            Preconditions.checkNotNull((Object)feature, (Object)"Feature is null?");
            Preconditions.checkNotNull((Object)feature.geometry, (Object)"Feature geometry is null?");
            Preconditions.checkState((feature.geometry.type == GeoJSON_Type.Point ? 1 : 0) != 0, (String)"Geometry is of unexpected type: %s", (Object)((Object)feature.geometry.type));
            this.location = ((Geometry.Point)feature.geometry).point;
            this.siteName = feature.properties.getString("SiteName");
            this.reference = feature.properties.getString("Reference");
        }
    }

    public static class HistoricalRupture
    extends AbstractDOLE_Data {
        public final LocationList trace;
        public final String eventID;

        public HistoricalRupture(Feature feature) {
            super(feature);
            Preconditions.checkNotNull((Object)feature, (Object)"Feature is null?");
            Preconditions.checkNotNull((Object)feature.geometry, (Object)"Feature geometry is null?");
            if (feature.geometry.type == GeoJSON_Type.LineString) {
                this.trace = ((Geometry.LineString)feature.geometry).line;
            } else if (feature.geometry.type == GeoJSON_Type.MultiLineString) {
                Geometry.MultiLineString mls = (Geometry.MultiLineString)feature.geometry;
                Preconditions.checkState((mls.lines.size() == 1 ? 1 : 0) != 0, (Object)"MultiLineString only supported if it contains a single LineString");
                this.trace = (LocationList)mls.lines.get(0);
            } else {
                throw new IllegalStateException("Geometry is of unexpected type: " + String.valueOf((Object)feature.geometry.type));
            }
            this.eventID = feature.properties.getString("ComCatID");
        }
    }

    public static enum PaleoMappingAlgorithm {
        FULL_PARENT("Full Parent Paleo Mapping"),
        CLOSEST_SECT("Closest Section Paleo Mapping"),
        NEIGHBORING_SECTS("Neighboring Sections Paleo Mapping");

        private String name;

        private PaleoMappingAlgorithm(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class AbstractDOLE_Data {
        public final int year;
        public final long epochMillis;
        public final int faultID;
        public final String faultName;
        public final Feature feature;
        private List<FaultSection> mappedSubSects;
        private List<MappingType> mappedTypes;

        public AbstractDOLE_Data(Feature feature) {
            this.feature = feature;
            this.year = feature.properties.getInt(DOLE_SubsectionMapper.YEAR_PROP_NAME, Integer.MIN_VALUE);
            Preconditions.checkState((this.year > Integer.MIN_VALUE ? 1 : 0) != 0, (String)"%s property is missing or malformatted: %s", (Object)DOLE_SubsectionMapper.YEAR_PROP_NAME, feature.properties.get(DOLE_SubsectionMapper.YEAR_PROP_NAME));
            this.epochMillis = new GregorianCalendar(this.year, 0, 1).getTimeInMillis();
            int nshm_hazID = feature.properties.getInt("NSHMhazID", -1);
            this.faultID = nshm_hazID >= 0 ? nshm_hazID : feature.properties.getInt("FaultID", -1);
            Preconditions.checkState((this.faultID >= 0 ? 1 : 0) != 0, (String)"FaultID is missing or malformatted: %s", feature.properties.get("FaultID"));
            this.faultName = feature.properties.getString("FaultName");
            this.mappedSubSects = new ArrayList<FaultSection>();
            this.mappedTypes = new ArrayList<MappingType>();
        }

        public void addMapedSection(FaultSection sect, MappingType type) {
            this.mappedSubSects.add(sect);
            this.mappedTypes.add(type);
        }

        public List<FaultSection> getMappedSubSects() {
            return this.mappedSubSects;
        }

        public List<MappingType> getMappedTypes() {
            return this.mappedTypes;
        }
    }

    public static enum MappingType {
        HISTORICAL_RUP,
        PALEO_CLOSEST_SECT,
        PALEO_NEIGHBORING_SECT;

    }
}

