/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.erf;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.NSHM25_Downloader;

public class NSHM25_PRVI_BranchAveragedERF
extends BaseFaultSystemSolutionERF {
    private static final String MODEL = "2025_PRVI_NSHM_Fault-System_Solution";
    public static final String NAME = "NSHM25-PRVI Branch Avg ERF";
    private static final boolean D = false;
    private NSHM25_Downloader downloader;

    public NSHM25_PRVI_BranchAveragedERF() {
        this(null);
    }

    public NSHM25_PRVI_BranchAveragedERF(File storeDir) {
        this.downloader = storeDir == null ? new NSHM25_Downloader() : new NSHM25_Downloader(storeDir);
        this.setName(NAME);
    }

    @Override
    protected void createParamList() {
        super.createParamList();
        if (this.adjustableParams.containsParameter("Solution Input File")) {
            this.adjustableParams.removeParameter(this.fileParam);
        }
    }

    private void fetchSolution() {
        ((CompletableFuture)this.downloader.updateFile(MODEL).thenAccept(solFile -> {
            try {
                if (solFile == null || !solFile.exists()) {
                    JOptionPane.showMessageDialog(null, "Failed to download 2025_PRVI_NSHM_Fault-System_Solution. Verify internet connection and restart. Server may be down.", "NSHM25_PRVI_BranchAveragedERF", 0);
                } else {
                    FaultSystemSolution sol = FaultSystemSolution.load(solFile);
                    this.setSolution(sol);
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
        })).join();
    }

    @Override
    public void updateForecast() {
        if (this.getSolution() == null) {
            this.fetchSolution();
        }
        super.updateForecast();
    }

    public static void main(String[] args) {
        new NSHM25_PRVI_BranchAveragedERF().updateForecast();
    }
}

