/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateModel;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionCaribbeanSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionMuertosSeismicityRate;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;

public class SeismicityRateFileLoader {
    private static final DecimalFormat oDF = new DecimalFormat("0.##");
    private static final String MMAX_FIELD_NAME = "Mmax";
    private static final String M1_FIELD_NAME = "M1";
    private static final String N_QUANTILES_FIELD_NAME = "n quantiles";
    private static final String N_MAGNITUDES_FIELD_NAME = "n magnitudes";
    private static final double MEAN_QUANT_FLAG = 2.0;

    public static IncrementalMagFreqDist buildIncrementalMFD(RateRecord record, EvenlyDiscretizedFunc refMFD, double mMax) {
        return SeismicityRateFileLoader.buildIncrementalMFD(record, refMFD, mMax, Double.NaN);
    }

    public static IncrementalMagFreqDist buildIncrementalMFD(RateRecord record, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) {
        Preconditions.checkNotNull((Object)record, (Object)"Record is null");
        if (record instanceof PureGR) {
            return SeismicityRateFileLoader.buildIncrementalMFD((PureGR)record, refMFD, mMax, magCorner);
        }
        Preconditions.checkState((!Double.isFinite(magCorner) || magCorner <= 0.0 ? 1 : 0) != 0, (Object)"Can only set magCorner for PureGR records");
        if (record instanceof Exact) {
            return SeismicityRateFileLoader.buildIncrementalMFD((Exact)record, refMFD, mMax);
        }
        if (record instanceof Direct) {
            return SeismicityRateFileLoader.buildIncrementalMFD((Direct)record, refMFD, mMax);
        }
        throw new IllegalStateException("Record is of unexpected type: " + String.valueOf(record.getClass()));
    }

    public static IncrementalMagFreqDist buildIncrementalMFD(PureGR grRecord, EvenlyDiscretizedFunc refMFD, double mMax) {
        return SeismicityRateFileLoader.buildIncrementalMFD(grRecord, refMFD, mMax);
    }

    public static IncrementalMagFreqDist buildIncrementalMFD(PureGR grRecord, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) {
        Preconditions.checkState((mMax - 0.001 < refMFD.getMaxX() + 0.5 * refMFD.getDelta() ? 1 : 0) != 0, (String)"Reference incremental MFD doesn't have a bin for mMax=%s", (Object)mMax);
        if (Double.isFinite(magCorner) && magCorner > 0.0) {
            double mag;
            TaperedGR_MagFreqDist taperGR = new TaperedGR_MagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
            taperGR.setAllButTotCumRate(refMFD.getX(0), magCorner, 1.0E16, grRecord.b);
            IncrementalMagFreqDist gr = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
            for (int i = 0; i < gr.size() && !((float)(mag = gr.getX(i)) > (float)mMax); ++i) {
                gr.set(i, taperGR.getY(i));
            }
            gr.scaleToCumRate(refMFD.getClosestXIndex(grRecord.M1 + 0.001), grRecord.rateAboveM1);
            gr.setName("Total Observed [b=" + oDF.format(grRecord.b) + ", N" + oDF.format(grRecord.M1) + "=" + oDF.format(grRecord.rateAboveM1) + ", Mcorner=" + oDF.format(magCorner) + "]");
            return gr;
        }
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        gr.setAllButTotCumRate(refMFD.getX(0), refMFD.getX(refMFD.getClosestXIndex(mMax - 0.001)), 1.0E16, grRecord.b);
        gr.scaleToCumRate(refMFD.getClosestXIndex(grRecord.M1 + 0.001), grRecord.rateAboveM1);
        gr.setName("Total Observed [b=" + oDF.format(grRecord.b) + ", N" + oDF.format(grRecord.M1) + "=" + oDF.format(grRecord.rateAboveM1) + "]");
        return gr;
    }

    public static IncrementalMagFreqDist buildIncrementalMFD(Exact exactRecord, EvenlyDiscretizedFunc refMFD, double mMax) {
        double delta = refMFD.getDelta();
        Preconditions.checkState(((float)exactRecord.cumulativeDist.getDelta() == (float)delta ? 1 : 0) != 0, (String)"MFD spacing mismatch between reference (%s) and data (%s)", (Object)Float.valueOf((float)delta), (Object)Float.valueOf((float)exactRecord.cumulativeDist.getDelta()));
        Preconditions.checkState((mMax - 0.001 < refMFD.getMaxX() + 0.5 * refMFD.getDelta() ? 1 : 0) != 0, (String)"Reference incremental MFD doesn't have a bin for mMax=%s", (Object)mMax);
        Preconditions.checkState(((float)mMax < (float)exactRecord.cumulativeDist.getMaxX() ? 1 : 0) != 0, (String)"Data cumulative MFD doesn't have a bin for mMax=%s", (Object)mMax);
        double mMinData = exactRecord.cumulativeDist.getMinX();
        double mMinIncr = refMFD.getMinX();
        Preconditions.checkState((mMinIncr > mMinData ? 1 : 0) != 0, (String)"Reference MFD Mmin=%s must be > data cumulative Mmin=%s", (Object)mMinIncr, (Object)mMinData);
        double minIncrLowerEdge = mMinIncr - 0.5 * delta;
        double mMinMatchingData = exactRecord.cumulativeDist.getX(exactRecord.cumulativeDist.getClosestXIndex(minIncrLowerEdge));
        Preconditions.checkState(((float)mMinMatchingData == (float)minIncrLowerEdge ? 1 : 0) != 0, (String)"Discretization mismatch; incremental should be offset by a half bin from the cumulative. e.g.,incremental min value at %s representing bin [%s, %s]; cumulative should have a bin a %s, but closest is %s", (Object[])new Object[]{Float.valueOf((float)mMinIncr), Float.valueOf((float)minIncrLowerEdge), Float.valueOf((float)(mMinIncr + 0.5 * delta)), Float.valueOf((float)minIncrLowerEdge), Float.valueOf((float)mMinMatchingData)});
        int mMaxRefBin = refMFD.getClosestXIndex(mMax - 0.001);
        int dataBin0 = exactRecord.cumulativeDist.getClosestXIndex(mMinIncr - 0.01);
        IncrementalMagFreqDist incr = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), delta);
        for (int i = 0; i <= mMaxRefBin; ++i) {
            int cmlI = dataBin0 + i;
            Preconditions.checkState((cmlI < exactRecord.cumulativeDist.size() ? 1 : 0) != 0);
            double binStart = exactRecord.cumulativeDist.getY(cmlI);
            double binEnd = cmlI + 1 == exactRecord.cumulativeDist.size() ? 0.0 : exactRecord.cumulativeDist.getY(cmlI + 1);
            Preconditions.checkState((binStart >= binEnd ? 1 : 0) != 0);
            incr.set(i, binStart - binEnd);
        }
        int incrM1index = incr.getClosestXIndex(exactRecord.M1 + 0.001);
        double incrAboveM1 = incr.getCumRate(incrM1index);
        double scalar = exactRecord.rateAboveM1 / incrAboveM1;
        incr.scale(scalar);
        return incr;
    }

    public static IncrementalMagFreqDist buildIncrementalMFD(Direct directRecord, EvenlyDiscretizedFunc refMFD, double mMax) {
        double delta = refMFD.getDelta();
        Preconditions.checkState(((float)directRecord.incrementalDist.getDelta() == (float)delta ? 1 : 0) != 0, (String)"MFD spacing mismatch between reference (%s) and data (%s)", (Object)Float.valueOf((float)delta), (Object)Float.valueOf((float)directRecord.incrementalDist.getDelta()));
        Preconditions.checkState((mMax - 0.001 < refMFD.getMaxX() + 0.5 * refMFD.getDelta() ? 1 : 0) != 0, (String)"Reference incremental MFD doesn't have a bin for mMax=%s", (Object)mMax);
        Preconditions.checkState(((float)mMax <= (float)directRecord.incrementalDist.getMaxX() ? 1 : 0) != 0, (String)"Data cumulative MFD doesn't have a bin for mMax=%s", (Object)mMax);
        double mMinData = directRecord.incrementalDist.getMinX();
        double mMinIncr = refMFD.getMinX();
        Preconditions.checkState(((float)mMinIncr >= (float)mMinData ? 1 : 0) != 0, (String)"Reference MFD Mmin=%s must be >= data Mmin=%s", (Object)mMinIncr, (Object)mMinData);
        double mMinMatchingData = directRecord.incrementalDist.getX(directRecord.incrementalDist.getClosestXIndex(mMinIncr));
        Preconditions.checkState(((float)mMinMatchingData == (float)mMinIncr ? 1 : 0) != 0, (String)"Discretization mismatch at mMin, %s != %s", (Object)Float.valueOf((float)mMinIncr), (Object)Float.valueOf((float)mMinMatchingData));
        int mMaxRefBin = refMFD.getClosestXIndex(mMax - 0.001);
        int dataBin0 = directRecord.incrementalDist.getClosestXIndex(mMinIncr);
        IncrementalMagFreqDist incr = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), delta);
        for (int i = 0; i <= mMaxRefBin; ++i) {
            int dataI = dataBin0 + i;
            Preconditions.checkState((dataI < directRecord.incrementalDist.size() ? 1 : 0) != 0);
            double dataX = directRecord.incrementalDist.getX(dataI);
            double retX = incr.getX(i);
            Preconditions.checkState((boolean)Precision.equals((double)dataX, (double)retX, (double)0.01));
            incr.set(i, directRecord.incrementalDist.getY(dataI));
        }
        return incr;
    }

    public static List<? extends RateRecord> loadRecords(CSVFile<String> csv, RateType type) {
        if (type == RateType.EXACT) {
            return SeismicityRateFileLoader.loadExactBranches(csv);
        }
        if (type == RateType.DIRECT) {
            return SeismicityRateFileLoader.loadDirectBranches(csv);
        }
        return SeismicityRateFileLoader.loadPureGR_branches(csv, type);
    }

    private static List<PureGR> loadPureGR_branches(CSVFile<String> csv, RateType type) {
        Double M1 = null;
        Double Mmax = null;
        for (int row = 0; row < csv.getNumRows(); ++row) {
            String col1 = csv.get(row, 0);
            if (col1 == null || col1.isBlank()) continue;
            col1 = col1.trim();
            if (M1 == null && col1.equals(M1_FIELD_NAME)) {
                M1 = csv.getDouble(row, 1);
            }
            if (Mmax == null && col1.equals(MMAX_FIELD_NAME)) {
                Mmax = csv.getDouble(row, 1);
            }
            if (!col1.equals(type.fileHeading)) continue;
            Preconditions.checkNotNull((Object)M1, (String)"'%s' not found before reading quantiles", (Object)M1_FIELD_NAME);
            Preconditions.checkNotNull((Object)Mmax, (String)"'%s' not found before reading quantiles", (Object)MMAX_FIELD_NAME);
            Integer nQuantiles = null;
            while (++row < csv.getNumRows()) {
                col1 = csv.get(row, 0);
                if (col1 == null || col1.isBlank() || !(col1 = col1.trim()).equals(N_QUANTILES_FIELD_NAME)) continue;
                nQuantiles = csv.getInt(row, 1);
                ++row;
                break;
            }
            Preconditions.checkNotNull(nQuantiles, (String)"Expected to find '%s' before reading quantiles", (Object)N_QUANTILES_FIELD_NAME);
            ++row;
            ArrayList<PureGR> ret = new ArrayList<PureGR>(nQuantiles);
            for (int i = 0; i < nQuantiles; ++i) {
                Preconditions.checkState((row < csv.getNumRows() ? 1 : 0) != 0, (String)"Ran out of rows befor reaching nQuantiles=%s", (Object)nQuantiles);
                double quantile = csv.getDouble(row, 0);
                double rate = csv.getDouble(row, 1);
                double b = csv.getDouble(row, 2);
                boolean mean = (float)quantile == 2.0f;
                ret.add(new PureGR(type, M1, Mmax, rate, b, mean ? Double.NaN : quantile, mean));
                ++row;
            }
            return ret;
        }
        throw new IllegalStateException("Never found '" + type.fileHeading + "'");
    }

    public static List<Exact> loadExactBranches(CSVFile<String> csv) {
        Double M1 = null;
        for (int row = 0; row < csv.getNumRows(); ++row) {
            String col1 = csv.get(row, 0);
            if (col1 == null || col1.isBlank()) continue;
            col1 = col1.trim();
            if (M1 == null && col1.equals(M1_FIELD_NAME)) {
                M1 = csv.getDouble(row, 1);
            }
            if (!col1.equals(RateType.EXACT.fileHeading)) continue;
            Preconditions.checkNotNull(M1, (String)"'%s' not found before reading quantiles", (Object)M1_FIELD_NAME);
            Integer nQuantiles = null;
            while (++row < csv.getNumRows()) {
                col1 = csv.get(row, 0);
                if (col1 == null || col1.isBlank() || !(col1 = col1.trim()).equals(N_QUANTILES_FIELD_NAME)) continue;
                nQuantiles = csv.getInt(row, 1);
                break;
            }
            Preconditions.checkNotNull(nQuantiles, (String)"Expected to find '%s' before reading exact distributions", (Object)N_QUANTILES_FIELD_NAME);
            Integer nMagnitudes = null;
            while (++row < csv.getNumRows()) {
                col1 = csv.get(row, 0);
                if (col1 == null || col1.isBlank() || !(col1 = col1.trim()).equals(N_MAGNITUDES_FIELD_NAME)) continue;
                nMagnitudes = csv.getInt(row, 1);
                ++row;
                break;
            }
            Preconditions.checkNotNull(nMagnitudes, (String)"Expected to find '%s' before reading exact distributions", (Object)N_MAGNITUDES_FIELD_NAME);
            ++row;
            double[] quantiles = new double[nQuantiles.intValue()];
            for (int n = 0; n < nQuantiles; ++n) {
                quantiles[n] = csv.getDouble(row, n + 1);
            }
            double mag1 = csv.getDouble(++row, 0);
            double mag2 = csv.getDouble(row + 1, 0);
            Preconditions.checkState((mag2 > mag1 ? 1 : 0) != 0);
            double delta = mag2 - mag1;
            EvenlyDiscretizedFunc[] funcs = new EvenlyDiscretizedFunc[nQuantiles.intValue()];
            for (int i = 0; i < nQuantiles; ++i) {
                funcs[i] = new EvenlyDiscretizedFunc(mag1, nMagnitudes, delta);
            }
            for (int m = 0; m < nMagnitudes; ++m) {
                Preconditions.checkState((row < csv.getNumRows() ? 1 : 0) != 0, (String)"Ran out of rows befor reaching nMagnitudes=%s", (Object)nMagnitudes);
                double mag = funcs[0].getX(m);
                double csvMag = csv.getDouble(row, 0);
                Preconditions.checkState(((float)mag == (float)csvMag ? 1 : 0) != 0, (String)"Expected m=%s at index %s, have %s", (Object)mag, (Object)m, (Object)csvMag);
                for (int n = 0; n < nQuantiles; ++n) {
                    double val = csv.getDouble(row, n + 1);
                    Preconditions.checkState((val >= 0.0 ? 1 : 0) != 0);
                    funcs[n].set(m, val);
                }
                ++row;
            }
            ArrayList<Exact> ret = new ArrayList<Exact>(nQuantiles);
            for (int n = 0; n < nQuantiles; ++n) {
                boolean mean = (float)quantiles[n] == 2.0f;
                ret.add(new Exact(M1, funcs[n], mean ? Double.NaN : quantiles[n], mean));
            }
            return ret;
        }
        throw new IllegalStateException("Never found '" + RateType.EXACT.fileHeading + "'");
    }

    public static List<Direct> loadDirectBranches(CSVFile<String> csv) {
        String M1_FIELD_NAME = "minmag:";
        Double M1 = null;
        Double duration = null;
        Integer nQuantiles = null;
        Integer nMagnitudes = null;
        for (int row = 0; row < csv.getNumRows(); ++row) {
            String col1 = csv.get(row, 0);
            if (col1 == null || col1.isBlank()) continue;
            col1 = col1.trim();
            if (duration == null && col1.equalsIgnoreCase("duration:")) {
                duration = csv.getDouble(row, 1);
            }
            if (M1 == null && col1.equals(M1_FIELD_NAME)) {
                M1 = csv.getDouble(row, 1);
            }
            if (col1.equals(N_QUANTILES_FIELD_NAME)) {
                nQuantiles = csv.getInt(row, 1);
            }
            if (col1.equals(N_MAGNITUDES_FIELD_NAME)) {
                nMagnitudes = csv.getInt(row, 1);
            }
            if (!col1.equals("M") || !csv.get(row, 1).trim().equals("Nobs")) continue;
            Preconditions.checkNotNull((Object)M1, (String)"'%s' not found before reading quantiles", (Object)M1_FIELD_NAME);
            double[] quantiles = new double[nQuantiles.intValue()];
            for (int i = 0; i < nQuantiles; ++i) {
                quantiles[i] = csv.getDouble(row, i + 2);
            }
            Preconditions.checkNotNull((Object)nMagnitudes, (String)"Expected to find '%s' before reading exact distributions", (Object)N_MAGNITUDES_FIELD_NAME);
            double mag1 = csv.getDouble(++row, 0);
            double mag2 = csv.getDouble(row + 1, 0);
            Preconditions.checkState((mag2 > mag1 ? 1 : 0) != 0);
            double delta = mag2 - mag1;
            EvenlyDiscretizedFunc[] cmlFuncs = new EvenlyDiscretizedFunc[nQuantiles.intValue()];
            EvenlyDiscretizedFunc[] incrFuncs = new EvenlyDiscretizedFunc[nQuantiles.intValue()];
            for (int i = 0; i < nQuantiles; ++i) {
                cmlFuncs[i] = new EvenlyDiscretizedFunc(mag1, nMagnitudes, delta);
                incrFuncs[i] = new EvenlyDiscretizedFunc(mag1 + 0.5 * delta, nMagnitudes, delta);
            }
            double maxObsIncrMag = 0.0;
            double maxObsCmlMag = 0.0;
            double nObs0 = Double.NaN;
            for (int m = 0; m < nMagnitudes; ++m) {
                double incrObs;
                Preconditions.checkState((row < csv.getNumRows() ? 1 : 0) != 0, (String)"Ran out of rows befor reaching nMagnitudes=%s", (Object)nMagnitudes);
                double mag = cmlFuncs[0].getX(m);
                double csvMag = csv.getDouble(row, 0);
                Preconditions.checkState(((float)mag == (float)csvMag ? 1 : 0) != 0, (String)"Expected m=%s at index %s, have %s", (Object)mag, (Object)m, (Object)csvMag);
                double cmlObs = csv.getDouble(row, 1);
                if (m == 0) {
                    nObs0 = cmlObs;
                }
                if (cmlObs > 0.0) {
                    maxObsCmlMag = mag;
                }
                if ((incrObs = csv.getDouble(row, 2 + nQuantiles)) > 0.0) {
                    maxObsIncrMag = mag;
                }
                for (int n = 0; n < nQuantiles; ++n) {
                    double cmlVal = csv.getDouble(row, n + 2);
                    cmlFuncs[n].set(m, cmlVal);
                    double incrVal = csv.getDouble(row, n + 3 + nQuantiles);
                    incrFuncs[n].set(m, incrVal);
                }
                ++row;
            }
            ArrayList<Direct> ret = new ArrayList<Direct>(nQuantiles);
            for (int n = 0; n < nQuantiles; ++n) {
                boolean mean = (float)quantiles[n] == 2.0f;
                ret.add(new Direct(M1, incrFuncs[n], cmlFuncs[n], maxObsIncrMag, maxObsCmlMag, nObs0, mean ? Double.NaN : quantiles[n], mean));
            }
            return ret;
        }
        throw new IllegalStateException("Never found '" + RateType.EXACT.fileHeading + "'");
    }

    public static <E extends RateRecord> E locateQuantile(List<E> records, double quantile) {
        for (RateRecord record : records) {
            if ((float)record.quantile != (float)quantile) continue;
            return (E)record;
        }
        throw new IllegalStateException("No record found for quantile: " + (float)quantile);
    }

    public static <E extends RateRecord> E locateMean(List<E> records) {
        for (RateRecord record : records) {
            if (!record.mean) continue;
            return (E)record;
        }
        throw new IllegalStateException("No mean record found");
    }

    public static void main(String[] args) throws IOException {
        String directPrefix = "/data/erf/prvi25/seismicity/rates/directrates_2025_05_08/directrates-PRVI ";
        PRVI25_SeismicityRateEpoch epoch = PRVI25_SeismicityRateEpoch.DEFAULT;
        for (boolean m5 : new boolean[]{true, false}) {
            String yearSuffix = m5 ? "-Full-1973-2024.csv" : "-Full-1900-2024.csv";
            CSVFile<String> outCSV = new CSVFile<String>(false);
            if (m5) {
                outCSV.addLine("Region", "Direct M>5", "Direct M>5 (p2.5)", "Direct M>5 (p97.5)", "Rate Model M>5", "Rate Model M>5 (p2.5)", "Rate Model M>5 (p97.5)");
            } else {
                outCSV.addLine("Region", "Direct M>6", "Direct M>6 (p2.5)", "Direct M>6 (p97.5)", "Rate Model M>6", "Rate Model M>6 (p2.5)", "Rate Model M>6 (p97.5)");
            }
            double mag = m5 ? 5.0 : 6.0;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<SeismicityRateModel> rateModels = new ArrayList<SeismicityRateModel>();
            ArrayList<SeismicityRateModel> grRateModels = new ArrayList<SeismicityRateModel>();
            names.add("Crustal");
            rateModels.add(PRVI25_CrustalSeismicityRate.loadRateModel(epoch, RateType.EXACT));
            grRateModels.add(PRVI25_CrustalSeismicityRate.loadRateModel(epoch, RateType.M1_TO_MMAX));
            names.add("CAR Intraslab");
            rateModels.add(PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, RateType.EXACT, true));
            grRateModels.add(PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, RateType.M1_TO_MMAX, true));
            names.add("CAR Interface");
            rateModels.add(PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, RateType.EXACT, false));
            grRateModels.add(PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, RateType.M1_TO_MMAX, false));
            names.add("MUE Intraslab");
            rateModels.add(PRVI25_SubductionMuertosSeismicityRate.loadRateModel(epoch, RateType.EXACT, true));
            grRateModels.add(PRVI25_SubductionMuertosSeismicityRate.loadRateModel(epoch, RateType.M1_TO_MMAX, true));
            names.add("MUE Interface");
            rateModels.add(PRVI25_SubductionMuertosSeismicityRate.loadRateModel(epoch, RateType.EXACT, false));
            grRateModels.add(PRVI25_SubductionMuertosSeismicityRate.loadRateModel(epoch, RateType.M1_TO_MMAX, false));
            names.add("Union");
            rateModels.add(null);
            grRateModels.add(null);
            double sumDirect = 0.0;
            double sumModelRate = 0.0;
            for (int i = 0; i < names.size(); ++i) {
                String name = (String)names.get(i);
                SeismicityRateModel rateModel = (SeismicityRateModel)rateModels.get(i);
                SeismicityRateModel grRateModel = (SeismicityRateModel)grRateModels.get(i);
                String csvName = directPrefix + name + yearSuffix;
                InputStream is = SeismicityRateFileLoader.class.getResourceAsStream(csvName);
                Preconditions.checkNotNull((Object)is, (String)"InputStream could not be found: %s", (Object)csvName);
                List<Direct> directs = SeismicityRateFileLoader.loadDirectBranches(CSVFile.readStream(is, false));
                ArrayList<Object> line = new ArrayList<Object>();
                line.add((String)names.get(i));
                System.out.println((String)names.get(i) + ", M" + (float)mag);
                if (m5) {
                    System.out.println("direct M>5:\t" + SeismicityRateFileLoader.locateMean(directs).cumulativeDist.getY(5.0));
                } else {
                    System.out.println("direct M>6:\t" + SeismicityRateFileLoader.locateMean(directs).cumulativeDist.getY(6.0));
                }
                double directRate = SeismicityRateFileLoader.getWithinTol(SeismicityRateFileLoader.locateMean(directs).cumulativeDist, mag, 0.001);
                double directLowerRate = SeismicityRateFileLoader.getWithinTol(SeismicityRateFileLoader.locateQuantile(directs, (double)0.025).cumulativeDist, mag, 0.001);
                double directUpperRate = SeismicityRateFileLoader.getWithinTol(SeismicityRateFileLoader.locateQuantile(directs, (double)0.975).cumulativeDist, mag, 0.001);
                line.add("" + (float)directRate);
                line.add("" + (float)directLowerRate);
                line.add("" + (float)directUpperRate);
                if (rateModel != null) {
                    double modelRate = SeismicityRateFileLoader.getWithinTol(((Exact)rateModel.getMeanRecord()).cumulativeDist, mag, 0.001);
                    sumDirect += directRate;
                    sumModelRate += modelRate;
                    line.add("" + (float)modelRate);
                    line.add("" + (float)SeismicityRateFileLoader.getWithinTol(((Exact)rateModel.getLowerRecord()).cumulativeDist, mag, 0.001));
                    line.add("" + (float)SeismicityRateFileLoader.getWithinTol(((Exact)rateModel.getUpperRecord()).cumulativeDist, mag, 0.001));
                    if (m5) {
                        PureGR grMean = (PureGR)grRateModel.getMeanRecord();
                        System.out.println("preferred M>5:\t" + (float)grMean.rateAboveM1 + ";\tb=" + (float)grMean.b);
                        PureGR grLow = (PureGR)grRateModel.getLowerRecord();
                        PureGR grHigh = (PureGR)grRateModel.getUpperRecord();
                        System.out.println("lower M>5:\t" + (float)grLow.rateAboveM1 + ";\tb=" + (float)grLow.b);
                        System.out.println("upper M>5:\t" + (float)grHigh.rateAboveM1 + ";\tb=" + (float)grHigh.b);
                    }
                } else {
                    line.add("");
                    line.add("");
                    line.add("");
                }
                outCSV.addLine((List<String>)line);
            }
            ArrayList<Object> line = new ArrayList<Object>();
            line.add("Sum");
            line.add("" + (float)sumDirect);
            line.add("");
            line.add("");
            line.add("" + (float)sumModelRate);
            line.add("");
            line.add("");
            outCSV.addLine((List<String>)line);
            if (m5) {
                outCSV.writeToFile(new File("/tmp/rate_comp_m5.csv"));
                continue;
            }
            outCSV.writeToFile(new File("/tmp/rate_comp_m6.csv"));
        }
    }

    private static double getWithinTol(EvenlyDiscretizedFunc func, double x, double tol) {
        int closestIndex = func.getClosestXIndex(x);
        double closestX = func.getX(closestIndex);
        Preconditions.checkState((boolean)Precision.equals((double)x, (double)closestX, (double)tol), (String)"%s != %s", (Object)Float.valueOf((float)x), (Object)Float.valueOf((float)closestX));
        return func.getY(closestIndex);
    }

    public static abstract class RateRecord {
        public final RateType type;
        public final double M1;
        public final double rateAboveM1;
        public final double quantile;
        public final boolean mean;

        private RateRecord(RateType type, double M1, double rateAboveM1, double quantile, boolean mean) {
            this.type = type;
            this.M1 = M1;
            this.rateAboveM1 = rateAboveM1;
            Preconditions.checkState((mean || quantile >= 0.0 && quantile <= 1.0 ? 1 : 0) != 0, (String)"Bad quantile: %s", (Object)quantile);
            this.quantile = quantile;
            this.mean = mean;
        }

        public abstract RateRecord getScaled(double var1);
    }

    public static class PureGR
    extends RateRecord {
        public final double Mmax;
        public final double b;

        private PureGR(RateType type, double M1, double Mmax, double rateAboveM1, double b, double quantile, boolean mean) {
            super(type, M1, rateAboveM1, quantile, mean);
            this.Mmax = Mmax;
            this.b = b;
        }

        public String toString() {
            return "PureGR [M1=" + (float)this.M1 + ", Mmax=" + (float)this.Mmax + ", rateAboveM1=" + (float)this.rateAboveM1 + ", b=" + (float)this.b + ", quantile=" + (float)this.quantile + ", mean=" + this.mean + "]";
        }

        @Override
        public PureGR getScaled(double scalar) {
            return new PureGR(this.type, this.M1, this.Mmax, this.rateAboveM1 * scalar, this.b, this.quantile, this.mean);
        }
    }

    public static class Exact
    extends RateRecord {
        public final EvenlyDiscretizedFunc cumulativeDist;

        private Exact(double M1, EvenlyDiscretizedFunc cumulativeDist, double quantile, boolean mean) {
            super(RateType.EXACT, M1, cumulativeDist.getY(cumulativeDist.getClosestXIndex(M1)), quantile, mean);
            this.cumulativeDist = cumulativeDist;
        }

        @Override
        public Exact getScaled(double scalar) {
            EvenlyDiscretizedFunc scaledDist = this.cumulativeDist.deepClone();
            scaledDist.scale(scalar);
            return new Exact(this.M1, scaledDist, this.quantile, this.mean);
        }
    }

    public static class Direct
    extends RateRecord {
        public final EvenlyDiscretizedFunc incrementalDist;
        public final EvenlyDiscretizedFunc cumulativeDist;
        public final double maxObsIncrMag;
        public final double maxObsCmlMag;
        public final double nObs;

        private Direct(double M1, EvenlyDiscretizedFunc incrementalDist, EvenlyDiscretizedFunc cumulativeDist, double maxObsIncrMag, double maxObsCmlMag, double nObs, double quantile, boolean mean) {
            super(RateType.DIRECT, M1, cumulativeDist.getY(cumulativeDist.getClosestXIndex(M1)), quantile, mean);
            this.incrementalDist = incrementalDist;
            this.cumulativeDist = cumulativeDist;
            this.maxObsIncrMag = maxObsIncrMag;
            this.maxObsCmlMag = maxObsCmlMag;
            this.nObs = nObs;
        }

        @Override
        public Direct getScaled(double scalar) {
            EvenlyDiscretizedFunc scaledIncr = this.incrementalDist.deepClone();
            EvenlyDiscretizedFunc scaledCml = this.cumulativeDist.deepClone();
            scaledIncr.scale(scalar);
            scaledCml.scale(scalar);
            return new Direct(this.M1, scaledIncr, scaledCml, this.maxObsIncrMag, this.maxObsCmlMag, this.nObs * scalar, this.quantile, this.mean);
        }
    }

    public static enum RateType {
        M1("M1 Branches"),
        M1_TO_MMAX("M1-Mmax Branches"),
        EXACT("Exact Branches"),
        DIRECT("Direct Rate Branches");

        private final String fileHeading;

        private RateType(String fileHeading) {
            this.fileHeading = fileHeading;
        }

        public String toString() {
            return this.fileHeading;
        }
    }
}

